/***************************************************************************
                          cpalette.cpp  -  description
                             -------------------
    begin                : Wed Apr 25 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cpalette.h"
#include "cpalette.moc"
#include "query.h"
extern QPixmap loadIcon(QString nam);

static const char *Hintergi[] = {
"25 15 3 1",
". c #000080",
"a c #8b8b8b",
"# c #ffffff",
".........................",
".........................",
".....###############.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....###############.....",
".........................",
"........................."};

static const char *Hinterg[] = {
"25 15 3 1",
"# c #000000",
"a c #8b8b8b",
". c #ffffff",
".........................",
".........................",
".....###############.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....#aaaaaaaaaaaaa#.....",
".....###############.....",
".........................",
"........................."};

static const char *Inhalti[] = {
"25 15 2 1",
". c #000080",
"# c #ffffff",
".........................",
".........................",
".....###############.....",
".....#.............#.....",
".....#......#......#.....",
".....#......#......#.....",
".....#.....#.#.....#.....",
".....#.....#.#.....#.....",
".....#....#####....#.....",
".....#....#...#....#.....",
".....#...###.###...#.....",
".....#.............#.....",
".....###############.....",
".........................",
"........................."};

static const char *Inhaltn[] = {
"25 15 2 1",
"# c #000000",
". c #ffffff",
".........................",
".........................",
".....###############.....",
".....#.............#.....",
".....#......#......#.....",
".....#......#......#.....",
".....#.....#.#.....#.....",
".....#.....#.#.....#.....",
".....#....#####....#.....",
".....#....#...#....#.....",
".....#...###.###...#.....",
".....#.............#.....",
".....###############.....",
".........................",
"........................."};

Cpalette::Cpalette(QWidget* parent,  const char* name, bool modal, WFlags fl)
        : QDialog( parent, name, modal, fl )
{
	setName("Cfloat");
	resize(150,214);
  setCaption(tr("Colors"));
 	setIcon(loadIcon("AppIcon.xpm"));
  setMinimumSize(QSize(150,214));
  setMaximumSize(QSize(150,214));
  Inhalt = new IconTButton(this, 1, 1, QPixmap(Inhaltn), QPixmap(Inhalti));
  Innen = new IconTButton(this, 27, 1, QPixmap(Hinterg), QPixmap(Hintergi));
  Innen->setOn(true);
  Mode = 2;
	ListBox1 = new QListBox(this, "ListBox1");
  ListBox1->setGeometry(QRect(0,21,148,192));
  ShaMenu = new QPopupMenu();
	ShaMenu->insertItem(tr("Other..."));
	ShaMenu->insertItem("0 %");
	ShaMenu->insertItem("10 %");
	ShaMenu->insertItem("20 %");
	ShaMenu->insertItem("30 %");
	ShaMenu->insertItem("40 %");
	ShaMenu->insertItem("50 %");
	ShaMenu->insertItem("60 %");
	ShaMenu->insertItem("70 %");
	ShaMenu->insertItem("80 %");
	ShaMenu->insertItem("90 %");
	ShaMenu->insertItem("100 %");
  PM1 = new IconMenuButton(this, 55, 3, ShaMenu);
  Stext = new QLabel(this, "Label1");
  Stext->setGeometry(QRect(70,1,54,13));
  Stext->setText("100 %");
  QFont _font = QFont(Stext->font());
  _font.setPointSize(9);
  Stext->setFont(_font);
  QPalette pal;
  QColorGroup cg;
  cg.setColor( QColorGroup::Foreground, black );
  cg.setColor( QColorGroup::Button, QColor( 211, 211, 211) );
  cg.setColor( QColorGroup::Light, white );
  cg.setColor( QColorGroup::Midlight, QColor( 233, 233, 233) );
  cg.setColor( QColorGroup::Dark, QColor( 105, 105, 105) );
  cg.setColor( QColorGroup::Mid, QColor( 140, 140, 140) );
  cg.setColor( QColorGroup::Text, black );
  cg.setColor( QColorGroup::BrightText, QColor( 236, 236, 236) );
  cg.setColor( QColorGroup::ButtonText, black );
  cg.setColor( QColorGroup::Base, white );
  cg.setColor( QColorGroup::Background, white );
  cg.setColor( QColorGroup::Shadow, black );
  cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
  cg.setColor( QColorGroup::HighlightedText, white );
  pal.setActive( cg );
  cg.setColor( QColorGroup::Foreground, black );
  cg.setColor( QColorGroup::Button, QColor( 211, 211, 211) );
  cg.setColor( QColorGroup::Light, white );
  cg.setColor( QColorGroup::Midlight, QColor( 242, 242, 242) );
  cg.setColor( QColorGroup::Dark, QColor( 105, 105, 105) );
  cg.setColor( QColorGroup::Mid, QColor( 140, 140, 140) );
  cg.setColor( QColorGroup::Text, black );
  cg.setColor( QColorGroup::BrightText, QColor( 236, 236, 236) );
  cg.setColor( QColorGroup::ButtonText, black );
  cg.setColor( QColorGroup::Base, white );
  cg.setColor( QColorGroup::Background, white );
  cg.setColor( QColorGroup::Shadow, black );
  cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
  cg.setColor( QColorGroup::HighlightedText, white );
  pal.setInactive( cg );
  cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
  cg.setColor( QColorGroup::Button, QColor( 211, 211, 211) );
  cg.setColor( QColorGroup::Light, white );
  cg.setColor( QColorGroup::Midlight, QColor( 242, 242, 242) );
  cg.setColor( QColorGroup::Dark, QColor( 105, 105, 105) );
  cg.setColor( QColorGroup::Mid, QColor( 140, 140, 140) );
  cg.setColor( QColorGroup::Text, black );
  cg.setColor( QColorGroup::BrightText, QColor( 236, 236, 236) );
  cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
  cg.setColor( QColorGroup::Base, white );
  cg.setColor( QColorGroup::Background, white );
  cg.setColor( QColorGroup::Shadow, black );
  cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
  cg.setColor( QColorGroup::HighlightedText, white );
  pal.setDisabled( cg );
  Stext->setPalette( pal );
  connect(Inhalt, SIGNAL(clicked()), this, SLOT(InhaltButton()));
  connect(Innen, SIGNAL(clicked()), this, SLOT(InnenButton()));
  connect(ListBox1, SIGNAL(clicked(QListBoxItem*)), this, SLOT(selFarbe(QListBoxItem*)));
  connect(ShaMenu, SIGNAL(activated(int)), this, SLOT(setActShade(int)));
}
Cpalette::~Cpalette(){
}

void Cpalette::paintEvent(QPaintEvent *)
{	
	QPainter p;
	p.begin(this);
	p.setPen(black);
  p.setBrush(white);
  p.drawRect(0, 0, 210, 17);
  p.drawLine(26, 0, 26, 16);
  p.drawLine(52, 0, 52, 16);
	p.end();
}

void Cpalette::closeEvent(QCloseEvent *ce)
{	
	emit Schliessen();
	ce->accept();
}

void Cpalette::InhaltButton()
{
	if (Inhalt->isOn())
		{
		Mode = 1;
		Innen->setOn(false);
		}
	emit QueryItem();
}

void Cpalette::InnenButton()
{
	if (Innen->isOn())
		{
		Mode = 2;
		Inhalt->setOn(false);
		}
	emit QueryItem();
}

void Cpalette::SetColors(CListe farben)
{
	Farbliste.clear();
	Farbliste = farben;
	updateCList();
}	

void Cpalette::updateCList()
{
	ListBox1->clear();
	CListe::Iterator it;
	QPixmap pm = QPixmap(30, 15);
	ListBox1->insertItem(tr("None"));
	for (it = Farbliste.begin(); it != Farbliste.end(); ++it)
		{
		pm.fill(Farbliste[it.key()].getRGBColor());
		ListBox1->insertItem(pm, it.key());
		}
	ListBox1->setSelected(ListBox1->currentItem(), false);
}

void Cpalette::selFarbe(QListBoxItem *c)
{
    if (c == NULL) { return; }
    sFarbe = c->text();
    switch (Mode)
    	{
    	case 1:
    		emit NewPen(sFarbe);
    		break;
    	case 2:
    		emit NewBrush(sFarbe);
    		break;
    	}
}	

void Cpalette::updateBoxS(QString Farbe)
{
	CListe::Iterator it;
	int c = 0;
	if (Farbe != "None")
		{
		c++;
		for (it = Farbliste.begin(); it != Farbliste.end(); ++it)
			{
			if (it.key() == Farbe)
				break;
			c++;
			}
		}
	ListBox1->setCurrentItem(c);
}

void Cpalette::setActFarben(QString p, QString b, int shp, int shb)
{
	switch (Mode)
		{
		case 1:
			if ((shp % 10) == 0)
				{
				SetMen(shp/10+1);
				}
			else
				{
				SetMen(0);
				Stext->setText(QString::number(shp)+" %");
				}
			updateBoxS(p);
			break;
		case 2:
			if ((shb % 10) == 0)
				{
				SetMen(shb/10+1);
				}
			else
				{
				SetMen(0);
				Stext->setText(QString::number(shb)+" %");
				}
			updateBoxS(b);
			break;
		}
}

int Cpalette::SetMen(int c)
{
	int b = 0;
	uint a;
	for (a = 0; a < ShaMenu->count(); a++)
		{
		ShaMenu->setItemChecked(ShaMenu->idAt(a), false);
		}
	ShaMenu->setItemChecked(ShaMenu->idAt(c), true);
	if (c > 0)
		{
		b = (c-1) * 10;
		}
	Stext->setText(QString::number(b)+" %");
	return b;
}

void Cpalette::setActShade(int id)
{
	QString antw;
	bool ok = FALSE;
	int c = ShaMenu->indexOf(id);
	int b = SetMen(c);
	if (c == 0)
		{
    Query* dia = new Query(this, "New", 1, 0, "Shade:", "Shade");
    if (dia->exec())
    	{
			c = dia->Answer->text().toInt(&ok);
			if (ok)
				{
				b = c;
				Stext->setText(dia->Answer->text()+" %");
				}
			delete dia;
      }
     else
     	{
     	delete dia;
     	return;
     	}
		}
	switch (Mode)
		{
    	case 1:
    		emit NewPenShade(b);
    		break;
    	case 2:
    		emit NewBrushShade(b);
    		break;
		}
}
