;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/pscribe.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 26 22:15:36 2001                          */
;*    Last change :  Wed Jan 16 11:42:47 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The Scribe fontifier.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_pscribe
   
   (import  __scribeapi_param
	    __scribeapi_ast)
   
   (eval    (export scribe))
   
   (export  (scribe ::bstring)))

;*---------------------------------------------------------------------*/
;*    Scribe stamps                                                    */
;*---------------------------------------------------------------------*/
(define *keyword* (gensym))
(define *define* (gensym))
(define *module* (gensym))

;*---------------------------------------------------------------------*/
;*    Scribe keywords                                                  */
;*---------------------------------------------------------------------*/
(for-each (lambda (symbol)
	     (putprop! symbol *keyword* #t))
	  '(set! if let cond case begin letrec let*
		 lambda export extern class generic inline
		 static import foreign type with-access instantiate
		 duplicate labels try unwind-protect
		 bind-exit match-case match-lambda pragma widen! shrink!
		 wide-class profile profile/gc 
		 regular-grammar lalr-grammar
		 bold it emph tt color ref index underline
		 figure center pre flush hrule linebreak
		 image kbd code var samp sc))

(for-each (lambda (symbol)
	     (putprop! symbol *define* #t))
	  '(define define-markup))

(for-each (lambda (symbol)
	     (putprop! symbol *module* #t))
	  '(document chapter section subsection subsubsection paragraph
		     margin table-of-contents itemize description enumerate
		     table tr td th item prgm author list footnote print-index
		     sc bold it emph item style))

;*---------------------------------------------------------------------*/
;*    *color* ...                                                      */
;*---------------------------------------------------------------------*/
(define *color* '())
(define *paren-color-armed* #f)

;*---------------------------------------------------------------------*/
;*    scribe ...                                                       */
;*---------------------------------------------------------------------*/
(define (scribe obj)
   (parse-scribe (open-input-string obj)))

;*---------------------------------------------------------------------*/
;*    parse-scribe port ...                                            */
;*---------------------------------------------------------------------*/
(define (parse-scribe port::input-port)
   (let ((g (regular-grammar ()
	       ((bol (: "%%" (* all)))
		;; a text inclusion
		(set! *paren-color-armed* #f)
		(with-input-from-string (the-substring 2 (the-length))
		   (lambda ()
		      (let* ((file (read))
			     (def (read))
			     (start (read))
			     (stop (read)))
			 (append (scribe-from-file file def start stop)
				 (ignore))))))
	       ((: (or ";" "\\;") (in "*;") (* all))
		;; italic comments
		(set! *paren-color-armed* #f)
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#ffa600" (it ,str))
			     `(it ,str))
			 (ignore))))
	       ((: ";" (out #\; #\*) (* all))
		;; plain comments
		(set! *paren-color-armed* #f)
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((: #\\ (* (in #\space #\tab)) ";" (out #\; #\*) (* all))
		;; plain comments
		(set! *paren-color-armed* #f)
		(let ((str (the-substring 1 (the-length))))
		   (cons str (ignore))))
	       ((+ #\Space)
		;; separators
		(set! *paren-color-armed* #f)
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((in "[]")
		;; brackets
		(set! *paren-color-armed* #f)
		(if *scribe-prgm-color*
		    (let* ((str (the-string))
			   (cstr `(color :fg "red" (bold ,str))))
		       (cons cstr (ignore)))))
	       ((+ #\()
		;; open parenthesis
		(let ((str (the-string)))
		   (set! *paren-color-armed* #t)
		   (if (pair? *color*)
		       (let ((par (if *scribe-prgm-color*
				      `(color :fg ,(car *color*) (bold ,str))
				      str)))
			  (cons par (ignore)))
		       (cons str (ignore)))))
	       (#\)
		;; close parenthesis
		(let ((str (the-string)))
		   (set! *paren-color-armed* #f)
		   (if (pair? *color*)
		       (let ((color (car *color*)))
			  (set! *color* (cdr *color*))
			  (cons (if *scribe-prgm-color*
				    `(color :fg ,color (bold ,str))
				    str)
				(ignore)))
		       (cons str (ignore)))))
	       (#\Tab
		(set! *paren-color-armed* #f)
		(cons (make-string 8 #\space) (ignore)))
	       ((+ (out #\; #\Space #\Tab #\( #\) #\[ #\] #\: #\" #\Newline))
		;; keywords
		(let* ((string (the-string))
		       (symbol (the-symbol)))
		   (cond
		      ((and *paren-color-armed* (getprop symbol *keyword*))
		       (set! *paren-color-armed* #f)
		       (cons `(bold ,string)
			     (ignore)))
		      ((getprop symbol *define*)
		       (set! *color* (cons "#6959cf" *color*))
		       (set! *paren-color-armed* #f)
		       (let ((kwd (if *scribe-prgm-color*
				      `(color :fg "#6959cf" (bold ,string))
				      string)))
			  (cons kwd (ignore))))
		      ((and *paren-color-armed* (getprop symbol *module*))
		       (set! *paren-color-armed* #f)
		       (cons (if *scribe-prgm-color*
				 `(color :fg "#1919af" (bold ,string))
				 `(bold ,string))
			     (ignore)))
		      ((and *paren-color-armed* (pair? *color*))
		       (let ((id (if *scribe-prgm-color*
				      `(color :fg
					      ,(car *color*)
					      (bold ,string))
				      string)))
			  (if (not *paren-color-armed*)
			      (set! *color* (cdr *color*)))
			  (cons id (ignore))))
		      (else
		       (cons string (ignore))))))
	       ((+ #\Newline)
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((or (: "\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\"")
		    (: "#\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\""))
		;; strings
		(set! *paren-color-armed* #f)
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "red" ,str)
			     str)
			 (ignore))))
	       ((: (or "::" ":")
		   (+ (out #\; #\Newline #\Space #\Tab #\( #\) #\:)))
		;; type and keywords annotations
		(set! *paren-color-armed* #f)
		(let ((string (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#00cf00" (bold ,string))
			     `(it ,string))
			 (ignore))))
	       ((+ (or #\: #\; #\"))
		(set! *paren-color-armed* #f)
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((: #\# #\\ (+ (out " \n\t")))
		;; characters
		(set! *paren-color-armed* #f)
		(let ((str (the-string)))
		   (cons str (ignore))))
	       (else
		(let ((c (the-failure)))
		   (if (eof-object? c)
		       '()
		       (error "prgm(scribe)" "Unexpected character" c)))))))
      (read/rp g port)))

;*---------------------------------------------------------------------*/
;*    scribe-from-file ...                                             */
;*---------------------------------------------------------------------*/
(define (scribe-from-file file def start stop)
   (cond
      ((and (not def) (not start) (not stop))
       ;; the whole file
       (if (file-exists? file)
	   (let ((p (open-input-file file)))
	      (if (input-port? p)
		  (parse-scribe p)
		  (error "prgm(scribe)" "Can't open file" file)))
	   (error "prgm(scribe)" "Can't find file" file)))
      (def
       (multiple-value-bind (start stop)
	  (scribe-definition-search file (cond
					    ((symbol? def)
					     def)
					    ((string? def)
					     (string->symbol def))
					    (else
					     (error "prgm(scribe)"
						    "Illegal definition"
						    def))))
	  (scribe-from-file-lines file start stop)))
      ((or start stop)
       (scribe-from-file-lines file start stop))
      (else
       '())))

;*---------------------------------------------------------------------*/
;*    scribe-from-file-lines ...                                       */
;*---------------------------------------------------------------------*/
(define (scribe-from-file-lines file start stop)
   (define (scribe-lines lines)
      (scribe (with-output-to-string (lambda () (map display lines)))))
   (let* ((start (if (fixnum? start)
		     start
		     1))
	  (stop (if (fixnum? stop)
		    stop
		    -1))
	  (port (open-input-file/line file start)))
      (unwind-protect
	 (let loop ((line (read-line port))
		    (lines '())
		    (lnum start))
	    (cond
	       ((and (> stop 0) (> lnum stop))
		(scribe-lines (cdr (reverse! lines))))
	       ((eof-object? line)
		(if (=fx stop -1)
		    (scribe-lines (cdr (reverse! lines)))
		    (error "prgm(scribe)" "File too short" file)))
	       (else
		(loop (read-line port)
		      (cons* (untabify line) #"\n" lines)
		      (+fx lnum 1)))))
	 (close-input-port port))))

;*---------------------------------------------------------------------*/
;*    untabify ...                                                     */
;*---------------------------------------------------------------------*/
(define (untabify obj)
   ;; count the number of #\tab
   (let ((len (string-length obj))
	 (tabl 8))
      (let loop ((i 0)
		 (nl 0))
	 (cond
	    ((=fx i len)
	     (if (=fx nl len)
		 obj
		 ;; allocates a new string and fill it
		 (let ((new (make-string nl)))
		    (let loop ((r 0)
			       (w 0))
		       (cond
			  ((=fx r len)
			   new)
			  ((char=? (string-ref obj r) #\tab)
			   (let ((q (/fx r tabl)))
			      (let liip ((num (-fx (*fx tabl (+fx 1 q)) r))
					 (w w))
				 (if (=fx num 0)
				     (loop (+fx r 1) w)
				     (begin
					(string-set! new w #\space)
					(liip (-fx num 1) (+fx w 1)))))))
			  (else
			   (string-set! new w (string-ref obj r))
			   (loop (+fx r 1) (+fx w 1))))))))
	    ((char=? (string-ref obj i) #\tab)
	     (let* ((q (/fx i tabl))
		    (n (-fx (*fx tabl (+fx 1 q)) i)))
		(loop (+fx i 1) (+fx nl n))))
	    (else
	     (loop (+fx i 1) (+fx nl 1)))))))

;*---------------------------------------------------------------------*/
;*    open-input-file/line ...                                         */
;*---------------------------------------------------------------------*/
(define (open-input-file/line::input-port file line-num)
   (let ((iport (open-input-file file)))
      (if (not (input-port? iport))
	  (error "prgm(scribe)" "Can't open file for input" file)
	  (if (=fx line-num 1)
	      iport
	      (let loop ((line (read-line iport))
			 (lnum 2))
		 (cond
		    ((eof-object? line)
		     (error "prgm(scribe)"
			    "File too short"
			    (list file line-num lnum)))
		    ((>fx lnum line-num)
		     (error "prgm(scribe)"
			    "Illegal file num"
			    (list file line-num lnum)))
		    ((=fx lnum line-num)
		     iport)
		    (else
		     (loop (read-line iport) (+fx lnum 1)))))))))

;*---------------------------------------------------------------------*/
;*    scribe-definition-search ...                                     */
;*    -------------------------------------------------------------    */
;*    This function seek a Scribe definition. If it finds it it        */
;*    returns two value the starting line number of the definition     */
;*    and the stop line.                                               */
;*---------------------------------------------------------------------*/
(define (scribe-definition-search file-name def)
   (reader-reset!)
   (let ((iport (open-input-file file-name)))
      (if (not (input-port? iport))
	  (error "prgm(scribe)" "Can't open file for input" file-name)
	  (unwind-protect
	     (let loop ((exp (read iport #t)))
		(if (not (eof-object? exp))
		    (match-case exp
		       ((begin . ?rest)
			(loop (read iport #t)))
		       (((or define define-inline define-generic
			     define-method define-macro define-expander)
			 (?fun . ?-) . ?-)
			(if (eq? def fun)
			    (values (line-number exp)
				    (reader-current-line-number))
			    (loop (read iport #f))))
		       (((or define define-struct) (and (? symbol?) ?var) . ?-)
			(if (eq? var def)
			    (values (line-number exp)
				    (reader-current-line-number))
			    (loop (read iport #t))))
		       (else
			(loop (read iport #t))))
		    (values #f #f)))
	     (close-input-port iport)))))

;*---------------------------------------------------------------------*/
;*    reader-current-line-number ...                                   */
;*    -------------------------------------------------------------    */
;*    This is a gross hack but to get the current reader line number   */
;*    we build a dummy expression that we read.                        */
;*---------------------------------------------------------------------*/
(define (reader-current-line-number)
   (let* ((port (open-input-string "(9)"))
	  (exp  (read port #t)))
      (close-input-port port)
      (line-number exp)))

;*---------------------------------------------------------------------*/
;*    line-number ...                                                  */
;*---------------------------------------------------------------------*/
(define (line-number expr)
   (and (epair? expr)
	(match-case (cer expr)
	   ((at ?- ?pos ?line)
	    line))))

