;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/container.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Oct 15 07:52:08 2001                          */
;*    Last change :  Sat Dec  8 06:42:29 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    A generic function that sets the `owner/ownee' relationships.    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_container
   
   (import __scribeapi_ast)
   
   (export (set-parent! ::%container)))

;*---------------------------------------------------------------------*/
;*    set-parent! ...                                                  */
;*---------------------------------------------------------------------*/
(define (set-parent! container)
   (for-each (lambda (child) (container-set! child container))
	     (%container-body container))
   (with-access::%container container (children)
      (set! children (reverse! children)))
   container)

;*---------------------------------------------------------------------*/
;*    container-set! ::obj ...                                         */
;*---------------------------------------------------------------------*/
(define-generic (container-set! child container::%container)
   (if (pair? child)
       (begin
	  (container-set! (car child) container)
	  (container-set! (cdr child) container))
       #unspecified))

;*---------------------------------------------------------------------*/
;*    container-set! ::%text ...                                       */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%text container::%container)
   (container-set! (%text-body child) container))

;*---------------------------------------------------------------------*/
;*    container-set! ::%block ...                                      */
;*    -------------------------------------------------------------    */
;*    Mark the block and the children of the block.                    */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%block container::%container)
   (with-access::%block child (parent
			       body
			       tmp-footnotes-list
			       tmp-marks-list)
      (with-access::%container container (children)
	 (set! children (cons child children)))
      (set! parent container)
      (cond
	 ((%document? container)
	  ;; move on the marks
	  (let ((mark-table (%document-mark-table container)))
	     (for-each (lambda (lbl)
			  (hashtable-put! mark-table
					  (%mark-id lbl)
					  lbl))
		       tmp-marks-list)
	     (set! tmp-marks-list '()))
	  ;; move on the footnotes
	  (with-access::%document container (footnotes)
	     (set! footnotes (append tmp-footnotes-list footnotes))))
	 ((%chapter? container)
	  ;; move on the marks
	  (%block-tmp-marks-list-set!
	      container
	      (append tmp-marks-list (%block-tmp-marks-list container)))
	  ;; move on the footnotes
	  (with-access::%chapter container (footnotes)
	     (set! footnotes (append tmp-footnotes-list footnotes))))
	 (else
	  ;; move on the marks
	  (%block-tmp-marks-list-set!
	   container
	   (append tmp-marks-list (%block-tmp-marks-list container)))
	  ;; move on the footnotes
	  (%block-tmp-footnotes-list-set!
	   container
	   (append tmp-footnotes-list (%block-tmp-footnotes-list container)))
	  (set! tmp-footnotes-list '())))))

;*---------------------------------------------------------------------*/
;*    container-set! ::%chapter ...                                    */
;*    -------------------------------------------------------------    */
;*    A chapter is different than a block. For a chapter we don't      */
;*    traverse the children that have already been marked.             */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%chapter container::%container)
   (with-access::%chapter child (parent body tmp-marks-list)
      (with-access::%container container (children)
	 (set! children (cons child children)))
      (set! parent container)
      ;; we have to transfer marks to the document
      (let ((mark-table (%document-mark-table container)))
	 (for-each (lambda (lbl)
		      (hashtable-put! mark-table
				      (%mark-id lbl)
				      lbl))
		   tmp-marks-list)
	 (set! tmp-marks-list '()))))

;*---------------------------------------------------------------------*/
;*    container-set! ::%mark ...                                       */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%mark container::%container)
   (with-access::%anchor child (parent)
      (set! parent container)
      (cond
	 ((%block? container)
	  (with-access::%block container (tmp-marks-list)
	     (set! tmp-marks-list (cons child tmp-marks-list))))
	 ((%document? container)
	  (hashtable-put! (%document-mark-table container)
			  (%mark-id child)
			  child))
	 (else
	  (error "container-set!"
		 "Illegal `mark' container"
		 (find-runtime-type container))))))

;*---------------------------------------------------------------------*/
;*    container-set! ::%figure ...                                     */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%figure container::%container)
   (container-set! (%figure-legend child) container)
   (container-set! (%figure-body child) container)
   (call-next-method))

;*---------------------------------------------------------------------*/
;*    container-set! ::%footnote ...                                   */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%footnote container::%container)
   (with-access::%footnote child (parent)
      (set! parent container)
      (cond
	 ((%chapter? container)
	  (with-access::%chapter container (footnotes)
	     (set! footnotes (cons child footnotes))))
	 ((%block? container)
	  (with-access::%block container (tmp-footnotes-list)
	     (set! tmp-footnotes-list (cons child tmp-footnotes-list))))
	 ((%document? container)
	  (with-access::%document container (footnotes)
	     (set! footnotes (cons child footnotes))))
	 (else
	  (error "container-set!"
		 "Illegal `footnote' container"
		 (find-runtime-type container))))))
      
;*---------------------------------------------------------------------*/
;*    container-set! ::%list ...                                       */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%list container::%container)
   (container-set! (%list-items child) container))

;*---------------------------------------------------------------------*/
;*    container-set! ::%table ...                                      */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%table container::%container)
   (container-set! (%table-rows child) container))

;*---------------------------------------------------------------------*/
;*    container-set! ::%table-row ...                                  */
;*---------------------------------------------------------------------*/
(define-method (container-set! child::%table-row container::%container)
   (container-set! (%table-row-cells child) container))
