/*  Sclient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *		  1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include "sclient.h"

/* Initialize the list of keys */
gchar *keys[] = {"F1", "F2", "F3", "F4", "F5",
	         "F6", "F7", "F8", "F9", "F10", NULL};

int main(int argc, char **argv) {
    
    mud=g_malloc(sizeof(sclient)+1);
    mud->hist=g_malloc(sizeof(struct sclient_history)+1);
    mud->hist->size=0;
    mud->hist->max=20;
    mud->hist->cur=0;
    mud->hist->pos=0;
    mud->hist->cyclic=1;
    mud->hist->list=g_malloc(sizeof(gpointer)*(mud->hist->max+1));
    mud->disp_font_name="fixed";
    mud->lines=0;
    mud->maxlines = 300 * 70;	// This will be an option

    gtk_set_locale ();
    gtk_init (&argc, &argv);
    gdk_init (&argc, &argv);

    /* load the stuff that needs to be loaded before the GUI comes up! */
    load_misc_prefs();

    /* Spawn the Graphical User Interface */
    load_macro();
    mud->window = spawn_gui();
    init_colors();
    load_font();
    load_wizard();
    load_prefs();
    load_aliases();
    load_triggers();

    hist_add(""); /* Needed to get rid of a blank line in history list */

    mud->curr_color=prefs.DefaultColor;

    gtk_widget_show(mud->window);
	
    gdk_window_set_background(GTK_TEXT(mud->text)->text_area,
			      &(prefs.BackgroundColor));

    gtk_main();
	
    return 0;
}			
