;;; Test driver checking functions.

;* Copyright (c) 1989-1993 Hewlett-Packard Development Company, L.P.
;*		All Rights Reserved

;* Permission is hereby granted, free of charge, to any person obtaining a
;* copy of this software and associated documentation files (the "Software"),
;* to deal in the Software without restriction, including without limitation
;* the rights to use, copy, modify, merge, publish, distribute, sublicense,
;* and/or sell copies of the Software, and to permit persons to whom the
;* Software is furnished to do so, subject to the following conditions:
;* 
;* The above copyright notice and this permission notice shall be included in
;* all copies or substantial portions of the Software.
;* 
;* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
;* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
;* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
;* DEALINGS IN THE SOFTWARE.

(module testchk)

(define TEST-ERRORS 0)

(define *ACCURACY* 1.0e-7)

(define (CHK test result expected)
    (unless (or (equal? result expected)
		(and (%record? result)
		     (%record expected)
		     (equal? (%record->list result) (%record->list expected)))
		(and (number? expected)
		     (number? result)
		     (inexact? expected)
		     (<= (abs (- expected result))
			 (* (abs expected) *accuracy*))))
	    (format stdout-port "     Test ~a failed~%" test)
	    (format stdout-port "          expected = ~s~%" expected)
	    (format stdout-port "            result = ~s~%" result)
	    (set! test-errors (+ test-errors 1))))

(define (CHKQ test result expected)
    (unless (eq? result expected)
	    (format stdout-port "     Test ~a failed~%" test)
	    (format stdout-port "          expected = ~s~%" expected)
	    (format stdout-port "            result = ~s~%" result)
	    (set! test-errors (+ test-errors 1))))
