/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.aelfred2;

import gnu.xml.aelfred2.SAXDriver;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmlParser {
    private static final boolean USE_CHEATS = true;
    private static final int DEFAULT_ATTR_COUNT = 23;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    private static final int ENCODING_EXTERNAL = 0;
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    private static final int ENCODING_ASCII = 9;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_READER = 5;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_PUBID = 256;
    private static final int CONTEXT_NORMAL = 0;
    private static final int CONTEXT_LITERAL = 1;
    static final char[] startDelimComment = new char[]{'<', '!', '-', '-'};
    static final char[] endDelimComment = new char[]{'-', '-'};
    static final char[] startDelimPI = new char[]{'<', '?'};
    static final char[] endDelimPI = new char[]{'?', '>'};
    static final char[] endDelimCDATA = new char[]{']', ']', '>'};
    private SAXDriver handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private Stack inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private InputSource scratch;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private static final int READ_BUFFER_MAX = 16384;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL = 4096;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL = 1024;
    private char[] nameBuffer;
    private int nameBufferPos;
    private boolean docIsStandalone;
    private Hashtable elementInfo;
    private Hashtable entityInfo;
    private Hashtable notationInfo;
    private boolean skippedPE;
    private String currentElement;
    private int currentElementContent;
    private Stack entityStack;
    private boolean inLiteral;
    private boolean expandPE;
    private boolean peIsError;
    private boolean doReport;
    private static final int SYMBOL_TABLE_LENGTH = 1087;
    private Object[][] symbolTable;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;
    private boolean inCDATA;

    XmlParser() {
    }

    void setHandler(SAXDriver sAXDriver) {
        this.handler = sAXDriver;
    }

    void doParse(String string, String string2, Reader reader, InputStream inputStream, String string3) throws Exception {
        block25: {
            IOException iOException3;
            block22: {
                if (this.handler == null) {
                    throw new IllegalStateException("no callback handler");
                }
                this.initializeVariables();
                this.setInternalEntity("amp", "&#38;");
                this.setInternalEntity("lt", "&#60;");
                this.setInternalEntity("gt", "&#62;");
                this.setInternalEntity("apos", "&#39;");
                this.setInternalEntity("quot", "&#34;");
                this.pushURL(false, "[document]", new String[]{string2, string, null}, reader, inputStream, string3, false);
                this.handler.startDocument();
                try {
                    this.parseDocument();
                    Object var7_6 = null;
                    if (reader == null) break block22;
                }
                catch (Throwable throwable) {
                    IOException iOException22;
                    Object var7_7 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (this.is != null) {
                        try {
                            this.is.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    this.scratch = null;
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                    break block25;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                {
                }
            }
        }
        this.scratch = null;
    }

    private void error(String string, String string2, String string3) throws SAXException {
        if (string2 != null) {
            string = string + " (found \"" + string2 + "\")";
        }
        if (string3 != null) {
            string = string + " (expected \"" + string3 + "\")";
        }
        this.handler.fatal(string);
        throw new SAXException(string);
    }

    private void error(String string, char c, String string2) throws SAXException {
        this.error(string, new Character(c).toString(), string2);
    }

    private void error(String string) throws SAXException {
        this.handler.fatal(string);
    }

    private void parseDocument() throws Exception {
        char c;
        try {
            c = this.parseProlog();
            this.require('<');
            this.parseElement(c == '\u0000');
        }
        catch (EOFException eOFException) {
            this.error("premature end of file", "[EOF]", null);
        }
        try {
            this.parseMisc();
            c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void parseComment() throws Exception {
        boolean bl = this.expandPE;
        this.expandPE = false;
        this.parseUntil(endDelimComment);
        this.require('>');
        this.expandPE = bl;
        this.handler.comment(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
    }

    private void parsePI() throws SAXException, IOException {
        boolean bl = this.expandPE;
        this.expandPE = false;
        String string = this.readNmtoken(true);
        if ("xml".equalsIgnoreCase(string)) {
            this.error("Illegal processing instruction target", string, null);
        }
        if (!this.tryRead(endDelimPI)) {
            this.requireWhitespace();
            this.parseUntil(endDelimPI);
        }
        this.expandPE = bl;
        this.handler.processingInstruction(string, this.dataBufferToString());
    }

    private void parseCDSect() throws Exception {
        this.parseUntil(endDelimCDATA);
        this.dataBufferFlush();
    }

    private boolean parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
            return true;
        }
        return false;
    }

    private void checkLegalVersion(String string) throws SAXException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!('0' <= c && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z')) {
                this.error("illegal character in version", string, "1.0");
            }
            ++n2;
        }
    }

    private String parseXMLDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        String string2 = null;
        int n = 112;
        this.require("version");
        this.parseEq();
        String string3 = this.readLiteral(n);
        this.checkLegalVersion(string3);
        if (!string3.equals("1.0")) {
            this.handler.warn("expected XML version 1.0, not: " + string3);
        }
        boolean bl2 = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!bl2) {
                this.error("whitespace required before 'encoding='");
            }
            this.parseEq();
            string = this.readLiteral(n);
            if (!bl) {
                this.setupDecoding(string);
            }
        }
        if (string != null) {
            bl2 = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!bl2) {
                this.error("whitespace required before 'standalone='");
            }
            this.parseEq();
            string2 = this.readLiteral(n);
            if ("yes".equals(string2)) {
                this.docIsStandalone = true;
            } else if (!"no".equals(string2)) {
                this.error("standalone flag must be 'yes' or 'no'");
            }
        }
        this.skipWhitespace();
        this.require("?>");
        return string;
    }

    private String parseTextDecl(boolean bl) throws SAXException, IOException {
        String string = null;
        int n = 112;
        if (this.tryRead("version")) {
            this.parseEq();
            String string2 = this.readLiteral(n);
            this.checkLegalVersion(string2);
            if (!string2.equals("1.0")) {
                this.handler.warn("expected XML version 1.0, not: " + string2);
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        string = this.readLiteral(n);
        if (!bl) {
            this.setupDecoding(string);
        }
        this.skipWhitespace();
        this.require("?>");
        return string;
    }

    private void setupDecoding(String string) throws SAXException, IOException {
        string = string.toUpperCase();
        if (this.encoding == 1 || this.encoding == 0) {
            if (string.equals("ISO-8859-1") || string.equals("8859_1") || string.equals("ISO8859_1")) {
                this.encoding = 2;
                return;
            }
            if (string.equals("US-ASCII") || string.equals("ASCII")) {
                this.encoding = 9;
                return;
            }
            if (string.equals("UTF-8") || string.equals("UTF8")) {
                this.encoding = 1;
                return;
            }
            if (this.encoding != 0) {
                throw new UnsupportedEncodingException(string);
            }
        }
        if (this.encoding == 3 || this.encoding == 4) {
            if (!(string.equals("ISO-10646-UCS-2") || string.equals("UTF-16") || string.equals("UTF-16BE") || string.equals("UTF-16LE"))) {
                this.error("unsupported Unicode encoding", string, "UTF-16");
            }
            return;
        }
        if (this.encoding == 5 || this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
            if (!string.equals("ISO-10646-UCS-4")) {
                this.error("unsupported 32-bit encoding", string, "ISO-10646-UCS-4");
            }
            return;
        }
        if (string.equals("UTF-16BE")) {
            this.encoding = 3;
            return;
        }
        if (string.equals("UTF-16LE")) {
            this.encoding = 4;
            return;
        }
        if (string.equals("UTF-16") || string.equals("ISO-10646-UCS-2")) {
            string = "Unicode";
        }
        this.reader = new InputStreamReader(this.is, string);
        this.sourceType = 5;
    }

    private void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead(startDelimPI)) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead(startDelimComment)) break;
            this.parseComment();
        }
    }

    private void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.skipWhitespace();
        String[] stringArray = this.readExternalIds(false, true);
        this.handler.doctypeDecl(string, stringArray[0], stringArray[1]);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead(']')) break;
                this.expandPE = true;
                this.peIsError = true;
                this.parseMarkupdecl();
                this.expandPE = false;
                this.peIsError = false;
            }
        }
        this.skipWhitespace();
        this.require('>');
        InputSource inputSource = stringArray[1] == null ? this.handler.getExternalSubset(string, this.handler.getSystemId()) : null;
        if (stringArray[1] != null || inputSource != null) {
            this.pushString(null, ">");
            if (stringArray[1] != null) {
                this.pushURL(true, "[dtd]", stringArray, null, null, null, true);
            } else {
                this.handler.warn("modifying document by adding external subset");
                this.pushURL(true, "[dtd]", new String[]{inputSource.getPublicId(), inputSource.getSystemId(), null}, inputSource.getCharacterStream(), inputSource.getByteStream(), inputSource.getEncoding(), false);
            }
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.error("external subset has unmatched '>'");
            }
        }
        this.handler.endDoctype();
        this.expandPE = false;
        this.doReport = true;
    }

    private void parseMarkupdecl() throws Exception {
        if (this.tryRead("<!ELEMENT")) {
            this.parseElementDecl();
        } else if (this.tryRead("<!ATTLIST")) {
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            this.parseNotationDecl();
        } else if (this.tryRead(startDelimPI)) {
            this.parsePI();
        } else if (this.tryRead(startDelimComment)) {
            this.parseComment();
        } else if (this.tryRead("<![")) {
            if (this.inputStack.size() > 0) {
                this.parseConditionalSect();
            } else {
                this.error("conditional sections illegal in internal subset");
            }
        } else {
            this.error("expected markup declaration");
        }
    }

    private void parseElement(boolean bl) throws Exception {
        String string;
        Object object;
        InputSource inputSource;
        int n = this.currentElementContent;
        String string2 = this.currentElement;
        this.tagAttributePos = 0;
        String string3 = this.readNmtoken(true);
        if (bl && (inputSource = this.handler.getExternalSubset(string3, this.handler.getSystemId())) != null) {
            object = inputSource.getPublicId();
            string = inputSource.getSystemId();
            this.handler.warn("modifying document by adding DTD");
            this.handler.doctypeDecl(string3, (String)object, string);
            this.pushString(null, ">");
            this.pushURL(true, "[dtd]", new String[]{object, string, null}, inputSource.getCharacterStream(), inputSource.getByteStream(), inputSource.getEncoding(), false);
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.error("external subset has unmatched '>'");
            }
            this.handler.endDoctype();
        }
        this.currentElement = string3;
        Object[] objectArray = (Object[])this.elementInfo.get(string3);
        this.currentElementContent = this.getContentType(objectArray, 1);
        boolean bl2 = this.tryWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            if (!bl2) {
                this.error("need whitespace between attributes");
            }
            this.parseAttribute(string3);
            bl2 = this.tryWhitespace();
            c = this.readCh();
        }
        object = this.declaredAttributes(objectArray);
        if (object != null) {
            block6: while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                int n2 = 0;
                while (n2 < this.tagAttributePos) {
                    if (this.tagAttributes[n2] == string) continue block6;
                    ++n2;
                }
                String string4 = this.getAttributeDefaultValue(string3, string);
                if (string4 == null) continue;
                this.handler.attribute(string, string4, false);
            }
        }
        switch (c) {
            case '>': {
                this.handler.startElement(string3);
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                this.handler.startElement(string3);
                this.handler.endElement(string3);
            }
        }
        this.currentElement = string2;
        this.currentElementContent = n;
    }

    private void parseAttribute(String string) throws Exception {
        int n = 10;
        String string2 = this.readNmtoken(true);
        String string3 = this.getAttributeType(string, string2);
        this.parseEq();
        String string4 = string3 == "CDATA" || string3 == null ? this.readLiteral(n) : this.readLiteral(n | 4);
        int n2 = 0;
        while (n2 < this.tagAttributePos) {
            if (string2.equals(this.tagAttributes[n2])) {
                this.error("duplicate attribute", string2, null);
            }
            ++n2;
        }
        this.handler.attribute(string2, string4, true);
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] stringArray = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, stringArray, 0, this.tagAttributePos);
            this.tagAttributes = stringArray;
        }
        this.tagAttributes[this.tagAttributePos++] = string2;
    }

    private void parseEq() throws SAXException, IOException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private void parseETag() throws Exception {
        this.require(this.currentElement);
        this.skipWhitespace();
        this.require('>');
        this.handler.endElement(this.currentElement);
    }

    private void parseContent() throws Exception {
        while (true) {
            this.parseCharData();
            char c = this.readCh();
            block0 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                        break;
                    }
                    this.unread(c);
                    this.parseEntityRef(true);
                    break;
                }
                case '<': {
                    this.dataBufferFlush();
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-');
                                    this.parseComment();
                                    break block0;
                                }
                                case '[': {
                                    this.require("CDATA[");
                                    this.handler.startCDATA();
                                    this.inCDATA = true;
                                    this.parseCDSect();
                                    this.inCDATA = false;
                                    this.handler.endCDATA();
                                    break block0;
                                }
                            }
                            this.error("expected comment or CDATA section", c, null);
                            break block0;
                        }
                        case '?': {
                            this.parsePI();
                            break block0;
                        }
                        case '/': {
                            this.parseETag();
                            return;
                        }
                    }
                    this.unread(c);
                    this.parseElement(false);
                }
            }
        }
    }

    private void parseElementDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(string);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseContentspec(String string) throws Exception {
        String string2;
        if (this.tryRead("EMPTY")) {
            this.setElement(string, 2, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(string, "EMPTY");
            }
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(string, 1, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(string, "ANY");
            }
            return;
        }
        this.require('(');
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed();
            string2 = this.dataBufferToString();
            this.setElement(string, 3, string2, null);
        } else {
            this.parseElements();
            string2 = this.dataBufferToString();
            this.setElement(string, 4, string2, null);
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().elementDecl(string, string2);
        }
    }

    private void parseElements() throws Exception {
        char c;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c2 = this.readCh();
        switch (c2) {
            case ')': {
                this.dataBufferAppend(')');
                c2 = this.readCh();
                switch (c2) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c2);
                        break;
                    }
                    default: {
                        this.unread(c2);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                c = c2;
                this.dataBufferAppend(c2);
                break;
            }
            default: {
                this.error("bad separator in content model", c2, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c2 = this.readCh();
            if (c2 == ')') break;
            if (c2 != c) {
                this.error("bad separator in content model", c2, null);
                return;
            }
            this.dataBufferAppend(c2);
        }
        this.dataBufferAppend(')');
        c2 = this.readCh();
        switch (c2) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c2);
                return;
            }
        }
        this.unread(c2);
    }

    private void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements();
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    private void parseMixed() throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.require('*');
        this.dataBufferAppend(")*");
    }

    private void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        boolean bl = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!bl) {
                this.error("whitespace required before attribute definition");
            }
            this.parseAttDef(string);
            bl = this.tryWhitespace();
        }
    }

    private void parseAttDef(String string) throws Exception {
        String string2 = null;
        String string3 = this.readNmtoken(true);
        this.requireWhitespace();
        String string4 = this.readAttType();
        if ("ENUMERATION" == string4 || "NOTATION" == string4) {
            string2 = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(string, string3, string4, string2);
    }

    private String readAttType() throws Exception {
        if (this.tryRead('(')) {
            this.parseEnumeration(false);
            return "ENUMERATION";
        }
        String string = this.readNmtoken(true);
        if ("NOTATION" == string) {
            this.parseNotationType();
            return string;
        }
        if ("CDATA" == string || "ID" == string || "IDREF" == string || "IDREFS" == string || "ENTITY" == string || "ENTITIES" == string || "NMTOKEN" == string || "NMTOKENS" == string) {
            return string;
        }
        this.error("illegal attribute type", string, null);
        return null;
    }

    private void parseEnumeration(boolean bl) throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(bl));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(bl));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    private void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration(true);
    }

    private void parseDefault(String string, String string2, String string3, String string4) throws Exception {
        int n = 31;
        String string5 = null;
        int n2 = 8;
        boolean bl = this.expandPE;
        String string6 = null;
        if (!this.skippedPE) {
            n2 |= 2;
            if ("CDATA" != string3) {
                n2 |= 4;
            }
        }
        this.expandPE = false;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                string6 = "#FIXED";
                n = 34;
                this.requireWhitespace();
                string5 = this.readLiteral(n2);
            } else if (this.tryRead("REQUIRED")) {
                string6 = "#REQUIRED";
                n = 33;
            } else if (this.tryRead("IMPLIED")) {
                string6 = "#IMPLIED";
                n = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            string5 = this.readLiteral(n2);
        }
        this.expandPE = bl;
        this.setAttribute(string, string2, string3, string4, string5, n);
        if ("ENUMERATION" == string3) {
            string3 = string4;
        } else if ("NOTATION" == string3) {
            string3 = "NOTATION " + string4;
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().attributeDecl(string, string2, string3, string6, string5);
        }
    }

    private void parseConditionalSect() throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            boolean bl = true;
            this.expandPE = false;
            int n = 1;
            while (n > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (this.tryRead("![")) {
                            ++n;
                        }
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --n;
                    }
                }
            }
            this.expandPE = true;
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE");
        }
    }

    private void parseCharRef() throws SAXException, IOException {
        int n;
        block18: {
            n = 0;
            if (this.tryRead('x')) {
                while (true) {
                    int n2;
                    char c = this.readCh();
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            n2 = c - 48;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            n2 = c - 97 + 10;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            n2 = c - 65 + 10;
                            break;
                        }
                        case ';': {
                            break block18;
                        }
                        default: {
                            this.error("illegal character in character reference", c, null);
                            break block18;
                        }
                    }
                    n *= 16;
                    n += n2;
                }
            }
            block11: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n *= 10;
                        n += c - 48;
                        continue block11;
                    }
                    case ';': {
                        break block11;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block11;
                    }
                }
                break;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.error("illegal XML character reference U+" + Integer.toHexString(n));
        }
        if (n <= 65535) {
            this.dataBufferAppend((char)n);
        } else if (n <= 0x10FFFF) {
            this.dataBufferAppend((char)(0xD800 | (n -= 65536) >> 10));
            this.dataBufferAppend((char)(0xDC00 | n & 0x3FF));
        } else {
            this.error("character reference " + n + " is too large for UTF-16", new Integer(n).toString(), null);
        }
    }

    private void parseEntityRef(boolean bl) throws SAXException, IOException {
        String string = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 0: {
                if (this.skippedPE) {
                    this.handler.warn("reference to undeclared entity " + string);
                    break;
                }
                this.error("reference to undeclared entity", string, null);
                break;
            }
            case 1: {
                this.pushString(string, this.getEntityValue(string));
                break;
            }
            case 3: {
                if (bl) {
                    this.pushURL(false, string, this.getEntityIds(string), null, null, null, true);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
                break;
            }
            case 2: {
                if (bl) {
                    this.error("unparsed entity reference in content", string, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
            }
        }
    }

    private void parsePEReference() throws SAXException, IOException {
        String string = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 0: {
                this.handler.verror("reference to undeclared parameter entity " + string);
                break;
            }
            case 1: {
                if (this.inLiteral) {
                    this.pushString(string, this.getEntityValue(string));
                    break;
                }
                this.pushString(string, ' ' + this.getEntityValue(string) + ' ');
                break;
            }
            case 3: {
                if (!this.inLiteral) {
                    this.pushString(null, " ");
                }
                this.pushURL(true, string, this.getEntityIds(string), null, null, null, true);
                if (this.inLiteral) break;
                this.pushString(null, " ");
            }
        }
    }

    private void parseEntityDecl() throws Exception {
        boolean bl = false;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            bl = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String string = this.readNmtoken(true);
        if (bl) {
            string = "%" + string;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            String string2 = this.readLiteral(0);
            this.setInternalEntity(string, string2);
        } else {
            String[] stringArray = this.readExternalIds(false, false);
            boolean bl2 = this.tryWhitespace();
            if (!bl && this.tryRead("NDATA")) {
                if (!bl2) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                String string3 = this.readNmtoken(true);
                if (!this.skippedPE) {
                    this.setExternalEntity(string, 2, stringArray, string3);
                    this.handler.unparsedEntityDecl(string, stringArray, string3);
                }
            } else if (!this.skippedPE) {
                this.setExternalEntity(string, 3, stringArray, null);
                this.handler.getDeclHandler().externalEntityDecl(string, stringArray[0], this.handler.resolveURIs() ? this.handler.absolutize(stringArray[2], stringArray[1], false) : stringArray[1]);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        String[] stringArray = this.readExternalIds(true, false);
        this.setNotation(string, stringArray);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseCharData() throws Exception {
        char c;
        int n = 0;
        int n2 = 0;
        int n3 = this.readBufferPos;
        while (n3 < this.readBufferLength) {
            c = this.readBuffer[n3];
            switch (c) {
                case '\n': {
                    ++n;
                    n2 = 0;
                    break;
                }
                case '&': 
                case '<': {
                    int n4 = this.readBufferPos;
                    ++n2;
                    this.readBufferPos = n3;
                    if (n > 0) {
                        this.line += n;
                        this.column = n2;
                    } else {
                        this.column += n2;
                    }
                    this.dataBufferAppend(this.readBuffer, n4, n3 - n4);
                    return;
                }
                case ']': {
                    if (n3 + 2 < this.readBufferLength && this.readBuffer[n3 + 1] == ']' && this.readBuffer[n3 + 2] == '>') {
                        this.error("character data may not contain ']]>'");
                    }
                    ++n2;
                    break;
                }
                default: {
                    if (c < ' ' || c > '\ufffd') {
                        this.error("illegal XML character U+" + Integer.toHexString(c));
                    }
                }
                case '\t': 
                case '\r': {
                    ++n2;
                }
            }
            ++n3;
        }
        while (true) {
            c = this.readCh();
            switch (c) {
                case '&': 
                case '<': {
                    this.unread(c);
                    return;
                }
            }
            this.dataBufferAppend(c);
        }
    }

    private void requireWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace required", c, null);
        }
    }

    private void skipWhitespace() throws SAXException, IOException {
        char c = '\u0000';
        int n = 0;
        int n2 = this.readBufferPos;
        block5: while (n2 < this.readBufferLength) {
            switch (this.readBuffer[n2]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++n;
                    break;
                }
                case '\n': {
                    ++c;
                    n = 0;
                    break;
                }
                case '%': {
                    if (this.expandPE) break block5;
                }
                default: {
                    this.readBufferPos = n2;
                    if (c > '\u0000') {
                        this.line += c;
                        this.column = n;
                    } else {
                        this.column += n;
                    }
                    return;
                }
            }
            ++n2;
        }
        c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    private String readNmtoken(boolean bl) throws SAXException, IOException {
        char c;
        int n = this.readBufferPos;
        block7: while (n < this.readBufferLength) {
            c = this.readBuffer[n];
            switch (c) {
                case '%': {
                    if (this.expandPE) break block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int n2 = this.readBufferPos;
                    if (n == n2) {
                        this.error("name expected", this.readBuffer[n], null);
                    }
                    this.readBufferPos = n;
                    return this.intern(this.readBuffer, n2, n - n2);
                }
                default: {
                    if (n == this.readBufferPos && bl) {
                        if (!Character.isUnicodeIdentifierStart(c) && c != ':' && c != '_') {
                            this.error("Not a name start character, U+" + Integer.toHexString(c));
                        }
                    } else if (!Character.isUnicodeIdentifierPart(c) && c != '-' && c != ':' && c != '_' && c != '.' && !XmlParser.isExtender(c)) {
                        this.error("Not a name character, U+" + Integer.toHexString(c));
                    }
                    ++n;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected");
                    }
                    if (bl && !Character.isUnicodeIdentifierStart(this.nameBuffer[0]) && ":_".indexOf(this.nameBuffer[0]) == -1) {
                        this.error("Not a name start character, U+" + Integer.toHexString(this.nameBuffer[0]));
                    }
                    String string = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return string;
                }
            }
            if (!(this.nameBufferPos == 0 && bl || Character.isUnicodeIdentifierPart(c) || ":-_.".indexOf(c) != -1 || XmlParser.isExtender(c))) {
                this.error("Not a name character, U+" + Integer.toHexString(c));
            }
            if (this.nameBufferPos >= this.nameBuffer.length) {
                this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            }
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLiteral(int n) throws SAXException, IOException {
        int n2 = this.line;
        boolean bl = this.expandPE;
        boolean bl2 = this.doReport;
        char c = this.readCh();
        if (c != '\"' && c != '\'') {
            this.error("expected '\"' or \"'\"", c, null);
            return null;
        }
        this.inLiteral = true;
        if ((n & 0x10) != 0) {
            this.expandPE = false;
        }
        this.doReport = false;
        char[] cArray = this.readBuffer;
        try {
            char c2 = this.readCh();
            block8: while (c2 != c || this.readBuffer != cArray) {
                switch (c2) {
                    case '\n': 
                    case '\r': {
                        if ((n & 0x108) == 0) break;
                        c2 = ' ';
                        break;
                    }
                    case '\t': {
                        if ((n & 8) == 0) break;
                        c2 = ' ';
                        break;
                    }
                    case '&': {
                        c2 = this.readCh();
                        if (c2 == '#') {
                            if ((n & 0x20) != 0) {
                                this.dataBufferAppend('&');
                                break;
                            }
                            this.parseCharRef();
                        } else {
                            this.unread(c2);
                            if ((n & 2) > 0) {
                                this.parseEntityRef(false);
                            } else if ((n & 0x40) != 0) {
                                this.dataBufferAppend('&');
                            } else {
                                String string = this.readNmtoken(true);
                                this.require(';');
                                this.dataBufferAppend('&');
                                this.dataBufferAppend(string);
                                this.dataBufferAppend(';');
                            }
                        }
                        c2 = this.readCh();
                        continue block8;
                    }
                    case '<': {
                        if ((n & 8) == 0) break;
                        this.error("attribute values may not contain '<'");
                    }
                }
                this.dataBufferAppend(c2);
                c2 = this.readCh();
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n2 + ')', null, new Character(c).toString());
        }
        this.inLiteral = false;
        this.expandPE = bl;
        this.doReport = bl2;
        if ((n & 4) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    private String[] readExternalIds(boolean bl, boolean bl2) throws Exception {
        String[] stringArray = new String[3];
        int n = 112;
        if (this.tryRead("PUBLIC")) {
            char c;
            this.requireWhitespace();
            stringArray[0] = this.readLiteral(0x104 | n);
            if (bl) {
                this.skipWhitespace();
                c = this.readCh();
                this.unread(c);
                if (c == '\"' || c == '\'') {
                    stringArray[1] = this.readLiteral(n);
                }
            } else {
                this.requireWhitespace();
                stringArray[1] = this.readLiteral(n);
            }
            int n2 = 0;
            while (n2 < stringArray[0].length()) {
                c = stringArray[0].charAt(n2);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1)) {
                    this.error("illegal PUBLIC id character U+" + Integer.toHexString(c));
                }
                ++n2;
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            stringArray[1] = this.readLiteral(n);
        } else if (!bl2) {
            this.error("missing SYSTEM or PUBLIC keyword");
        }
        if (stringArray[1] != null) {
            if (stringArray[1].indexOf(35) != -1) {
                this.handler.verror("SYSTEM id has a URI fragment: " + stringArray[1]);
            }
            stringArray[2] = this.handler.getSystemId();
            if (stringArray[2] == null) {
                this.handler.warn("No base URI; hope URI is absolute: " + stringArray[1]);
            }
        }
        return stringArray;
    }

    private final boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void dataBufferAppend(char c) {
        if (this.dataBufferPos >= this.dataBuffer.length) {
            this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        }
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    private void dataBufferAppend(String string) {
        this.dataBufferAppend(string.toCharArray(), 0, string.length());
    }

    private void dataBufferAppend(char[] cArray, int n, int n2) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + n2);
        System.arraycopy(cArray, n, this.dataBuffer, this.dataBufferPos, n2);
        this.dataBufferPos += n2;
    }

    private void dataBufferNormalize() {
        int n = 0;
        int n2 = 0;
        int n3 = this.dataBufferPos;
        while (n2 < n3 && this.dataBuffer[n2] == ' ') {
            ++n2;
        }
        while (n3 > n2 && this.dataBuffer[n3 - 1] == ' ') {
            --n3;
        }
        while (n2 < n3) {
            char c;
            if ((c = this.dataBuffer[n2++]) == ' ') {
                while (n2 < n3 && this.dataBuffer[n2++] == ' ') {
                }
                this.dataBuffer[n++] = 32;
                this.dataBuffer[n++] = this.dataBuffer[n2 - 1];
                continue;
            }
            this.dataBuffer[n++] = c;
        }
        this.dataBufferPos = n;
    }

    private String dataBufferToString() {
        String string = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return string;
    }

    private void dataBufferFlush() throws SAXException {
        if (this.currentElementContent == 4 && this.dataBufferPos > 0 && !this.inCDATA) {
            int n = 0;
            while (n < this.dataBufferPos) {
                if (!this.isWhitespace(this.dataBuffer[n])) {
                    this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                    this.dataBufferPos = 0;
                }
                ++n;
            }
            if (this.dataBufferPos > 0) {
                this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
        } else if (this.dataBufferPos > 0) {
            this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
            this.dataBufferPos = 0;
        }
    }

    private void require(String string) throws SAXException, IOException {
        char[] cArray;
        int n = string.length();
        if (n < this.dataBuffer.length) {
            cArray = this.dataBuffer;
            string.getChars(0, n, cArray, 0);
        } else {
            cArray = string.toCharArray();
        }
        if (n <= this.readBufferLength - this.readBufferPos) {
            int n2 = this.readBufferPos;
            int n3 = 0;
            while (n3 < n) {
                if (cArray[n3] != this.readBuffer[n2]) {
                    this.error("required string", null, string);
                }
                ++n3;
                ++n2;
            }
            this.readBufferPos = n2;
        } else {
            int n4 = 0;
            while (n4 < n) {
                this.require(cArray[n4]);
                ++n4;
            }
        }
    }

    private void require(char c) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 != c) {
            this.error("required character", c2, new Character(c).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public String intern(char[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = 0;
            var5_5 = 0;
            var7_6 = var2_2;
            while (var7_6 < var2_2 + var3_3) {
                var5_5 = 31 * var5_5 + var1_1[var7_6];
                ++var7_6;
            }
            var6_7 = this.symbolTable[var5_5 = (var5_5 & 0x7FFFFFFF) % 1087];
            if (var6_7 != null) ** GOTO lbl22
            var6_7 = new Object[8];
            break block5;
            while ((var8_8 = (char[])var6_7[var4_4]) != null) {
                if (((char[])var8_8).length == var3_3) {
                    var9_9 = 0;
                    while (var9_9 < ((Object)var8_8).length) {
                        if (var1_1[var2_2 + var9_9] != var8_8[var9_9]) break;
                        if (var9_9 == var3_3 - 1) {
                            return (String)var6_7[var4_4 + 1];
                        }
                        ++var9_9;
                    }
                }
                var4_4 += 2;
lbl22:
                // 2 sources

                if (var4_4 < var6_7.length) continue;
            }
            var6_7 = (Object[])this.extendArray(var6_7, var6_7.length, var4_4);
        }
        this.symbolTable[var5_5] = var6_7;
        var8_8 = new String(var1_1, var2_2, var3_3).intern();
        var6_7[var4_4] = var8_8.toCharArray();
        var6_7[var4_4 + 1] = var8_8;
        return var8_8;
    }

    private Object extendArray(Object object, int n, int n2) {
        if (n2 < n) {
            return object;
        }
        Object[] objectArray = null;
        int n3 = n * 2;
        if (n3 <= n2) {
            n3 = n2 + 1;
        }
        if (object instanceof char[]) {
            objectArray = new char[n3];
        } else if (object instanceof Object[]) {
            objectArray = new Object[n3];
        } else {
            throw new RuntimeException();
        }
        System.arraycopy(object, 0, objectArray, 0, n);
        return objectArray;
    }

    boolean isStandalone() {
        return this.docIsStandalone;
    }

    private int getContentType(Object[] objectArray, int n) {
        if (objectArray == null) {
            return n;
        }
        int n2 = (Integer)objectArray[0];
        if (n2 == 0) {
            n2 = n;
        }
        return n2;
    }

    public int getElementContentType(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        return this.getContentType(objectArray, 0);
    }

    private void setElement(String string, int n, String string2, Hashtable hashtable) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            objectArray = new Object[]{new Integer(n), string2, hashtable};
            this.elementInfo.put(string, objectArray);
            return;
        }
        if (n != 0) {
            if ((Integer)objectArray[0] == 0) {
                objectArray[0] = new Integer(n);
                objectArray[1] = string2;
            } else {
                this.handler.verror("multiple declarations for element type: " + string);
            }
        } else if (hashtable != null) {
            objectArray[2] = hashtable;
        }
    }

    private Hashtable getElementAttributes(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (Hashtable)objectArray[2];
    }

    private Enumeration declaredAttributes(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)objectArray[2];
        if (hashtable == null) {
            return null;
        }
        return hashtable.keys();
    }

    public Enumeration declaredAttributes(String string) {
        return this.declaredAttributes((Object[])this.elementInfo.get(string));
    }

    public String getAttributeType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[0];
    }

    public String getAttributeEnumeration(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    public String getAttributeDefaultValue(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public int getAttributeDefaultValueType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return 30;
        }
        return (Integer)objectArray[2];
    }

    private void setAttribute(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        if (this.skippedPE) {
            return;
        }
        Hashtable<String, Object[]> hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object[]>();
        }
        if (hashtable.get(string2) != null) {
            return;
        }
        Object[] objectArray = new Object[]{string3, string5, new Integer(n), string4, null};
        hashtable.put(string2, objectArray);
        this.setElement(string, 0, null, hashtable);
    }

    private Object[] getAttribute(String string, String string2) {
        Hashtable hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            return null;
        }
        return (Object[])hashtable.get(string2);
    }

    public int getEntityType(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public String[] getEntityIds(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String[])objectArray[1];
    }

    public String getEntityValue(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    private void setInternalEntity(String string, String string2) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        if (this.entityInfo.get(string) == null) {
            Object[] objectArray = new Object[5];
            objectArray[0] = new Integer(1);
            objectArray[3] = string2;
            this.entityInfo.put(string, objectArray);
        }
        if ("lt" == string || "gt" == string || "quot" == string || "apos" == string || "amp" == string) {
            return;
        }
        this.handler.getDeclHandler().internalEntityDecl(string, string2);
    }

    private void setExternalEntity(String string, int n, String[] stringArray, String string2) {
        if (this.entityInfo.get(string) == null) {
            Object[] objectArray = new Object[5];
            objectArray[0] = new Integer(n);
            objectArray[1] = stringArray;
            objectArray[4] = string2;
            this.entityInfo.put(string, objectArray);
        }
    }

    private void setNotation(String string, String[] stringArray) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        this.handler.notationDecl(string, stringArray);
        if (this.notationInfo.get(string) == null) {
            this.notationInfo.put(string, string);
        } else {
            this.handler.verror("Duplicate notation name decl: " + string);
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    private char readCh() throws SAXException, IOException {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
                default: {
                    this.popInput();
                }
            }
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            if (c != '<') {
                if (c < ' ' && c != '\t' && c != '\r' || c > '\ufffd') {
                    this.error("illegal XML character U+" + Integer.toHexString(c));
                } else if (c == '%' && this.expandPE) {
                    if (this.peIsError) {
                        this.error("PE reference within decl in internal subset.");
                    }
                    this.parsePEReference();
                    return this.readCh();
                }
            }
            ++this.column;
        }
        return c;
    }

    private void unread(char c) throws SAXException {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    private void unread(char[] cArray, int n) throws SAXException {
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == '\n') {
                --this.line;
                this.column = -1;
            }
            ++n2;
        }
        if (n < this.readBufferPos) {
            this.readBufferPos -= n;
        } else {
            this.pushCharArray(null, cArray, 0, n);
        }
    }

    private void pushURL(boolean bl, String string, String[] stringArray, Reader reader, InputStream inputStream, String string2, boolean bl2) throws SAXException, IOException {
        String string3;
        InputSource inputSource;
        boolean bl3 = false;
        if (!bl) {
            this.dataBufferFlush();
        }
        this.scratch.setPublicId(stringArray[0]);
        this.scratch.setSystemId(stringArray[1]);
        if (bl2) {
            inputSource = this.handler.resolveEntity(bl, string, this.scratch, stringArray[2]);
            if (inputSource == null) {
                this.handler.warn("Skipping entity: " + string);
                this.handler.skippedEntity(string);
                if (bl) {
                    this.skippedPE = true;
                }
                return;
            }
            string3 = inputSource.getSystemId();
            if (string3 == null) {
                this.handler.warn("missing system ID, using " + stringArray[1]);
                string3 = stringArray[1];
            }
        } else {
            this.scratch.setCharacterStream(reader);
            this.scratch.setByteStream(inputStream);
            this.scratch.setEncoding(string2);
            inputSource = this.scratch;
            string3 = stringArray[1];
            this.handler.startExternalEntity(string, string3, "[document]" == string);
        }
        if (inputSource.getCharacterStream() != null) {
            if (inputSource.getByteStream() != null) {
                this.error("InputSource has two streams!");
            }
            reader = inputSource.getCharacterStream();
        } else if (inputSource.getByteStream() != null) {
            string2 = inputSource.getEncoding();
            if (string2 == null) {
                inputStream = inputSource.getByteStream();
            } else {
                try {
                    reader = new InputStreamReader(inputSource.getByteStream(), string2);
                }
                catch (IOException iOException) {
                    inputStream = inputSource.getByteStream();
                }
            }
        } else if (string3 == null) {
            this.error("InputSource has no URI!");
        }
        this.scratch.setCharacterStream(null);
        this.scratch.setByteStream(null);
        this.scratch.setEncoding(null);
        this.pushInput(string);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.column = 0;
        this.currentByteCount = 0;
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        this.sourceType = 3;
        if (inputStream != null) {
            this.is = inputStream;
        } else {
            URL uRL = new URL(string3);
            this.externalEntity = uRL.openConnection();
            this.externalEntity.connect();
            this.is = this.externalEntity.getInputStream();
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (string2 == null && this.externalEntity != null && !"file".equals(this.externalEntity.getURL().getProtocol())) {
            string2 = this.externalEntity.getContentType();
            int n = string2 == null ? -1 : string2.indexOf("charset");
            if (n < 0) {
                string2 = null;
            } else {
                n = string2.indexOf(59);
                if (n > 0) {
                    string2 = string2.substring(0, n);
                }
                if ((n = string2.indexOf(61, n + 7)) > 0) {
                    if ((n = (string2 = string2.substring(n + 1)).indexOf(40)) > 0) {
                        string2 = string2.substring(0, n);
                    }
                    if ((n = string2.indexOf(34)) > 0) {
                        string2 = string2.substring(n + 1, string2.indexOf(34, n + 2));
                    }
                    string2.trim();
                } else {
                    this.handler.warn("ignoring illegal MIME attribute: " + string2);
                    string2 = null;
                }
            }
        }
        if (string2 != null) {
            this.encoding = 0;
            this.setupDecoding(string2);
            bl3 = true;
        } else {
            this.detectEncoding();
            bl3 = false;
        }
        try {
            this.tryEncodingDecl(bl3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = unsupportedEncodingException.getMessage();
            try {
                if (this.sourceType != 3) {
                    throw unsupportedEncodingException;
                }
                this.is.reset();
                this.readBufferPos = 0;
                this.readBufferLength = 0;
                this.readBufferOverflow = -1;
                this.line = 1;
                this.column = 0;
                this.currentByteCount = 0;
                this.sourceType = 5;
                this.reader = new InputStreamReader(this.is, string2);
                this.is = null;
                this.tryEncodingDecl(true);
            }
            catch (IOException iOException) {
                this.error("unsupported text encoding", string2, null);
            }
        }
    }

    private String tryEncodingDecl(boolean bl) throws SAXException, IOException {
        if (this.tryRead("<?xml")) {
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    return this.parseTextDecl(bl);
                }
                return this.parseXMLDecl(bl);
            }
            this.unread('l');
            this.unread('m');
            this.unread('x');
            this.unread('?');
            this.unread('<');
        }
        return null;
    }

    private void detectEncoding() throws SAXException, IOException {
        byte[] byArray = new byte[4];
        this.is.mark(4);
        this.is.read(byArray);
        this.is.reset();
        if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (XmlParser.tryEncoding(byArray, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(byArray, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.prefetchASCIIEncodingDecl();
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            this.encoding = 1;
            this.is.read();
            this.is.read();
            this.is.read();
        } else {
            this.encoding = 1;
        }
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2, byte by3, byte by4) {
        return byArray[0] == by && byArray[1] == by2 && byArray[2] == by3 && byArray[3] == by4;
    }

    private static boolean tryEncoding(byte[] byArray, byte by, byte by2) {
        return byArray[0] == by && byArray[1] == by2;
    }

    private void pushString(String string, String string2) throws SAXException {
        char[] cArray = string2.toCharArray();
        this.pushCharArray(string, cArray, 0, cArray.length);
    }

    private void pushCharArray(String string, char[] cArray, int n, int n2) throws SAXException {
        this.pushInput(string);
        if (string != null && this.doReport) {
            this.dataBufferFlush();
            this.handler.startInternalEntity(string);
        }
        this.sourceType = 1;
        this.readBuffer = cArray;
        this.readBufferPos = n;
        this.readBufferLength = n2;
        this.readBufferOverflow = -1;
    }

    private void pushInput(String string) throws SAXException {
        Object[] objectArray;
        if (string != null) {
            objectArray = this.entityStack.elements();
            while (objectArray.hasMoreElements()) {
                String string2 = (String)objectArray.nextElement();
                if (string2 == null || string2 != string) continue;
                this.error("recursive reference to entity", string, null);
            }
        }
        this.entityStack.push(string);
        if (this.sourceType == 0) {
            return;
        }
        objectArray = new Object[]{new Integer(this.sourceType), this.externalEntity, this.readBuffer, new Integer(this.readBufferPos), new Integer(this.readBufferLength), new Integer(this.line), new Integer(this.encoding), new Integer(this.readBufferOverflow), this.is, new Integer(this.currentByteCount), new Integer(this.column), this.reader};
        this.inputStack.push(objectArray);
    }

    private void popInput() throws SAXException, IOException {
        String string = (String)this.entityStack.pop();
        if (string != null && this.doReport) {
            this.dataBufferFlush();
        }
        switch (this.sourceType) {
            case 3: {
                this.handler.endExternalEntity(string);
                this.is.close();
                break;
            }
            case 5: {
                this.handler.endExternalEntity(string);
                this.reader.close();
                break;
            }
            case 1: {
                if (string == null || !this.doReport) break;
                this.handler.endInternalEntity(string);
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("no more input");
        }
        Object[] objectArray = (Object[])this.inputStack.pop();
        this.sourceType = (Integer)objectArray[0];
        this.externalEntity = (URLConnection)objectArray[1];
        this.readBuffer = (char[])objectArray[2];
        this.readBufferPos = (Integer)objectArray[3];
        this.readBufferLength = (Integer)objectArray[4];
        this.line = (Integer)objectArray[5];
        this.encoding = (Integer)objectArray[6];
        this.readBufferOverflow = (Integer)objectArray[7];
        this.is = (InputStream)objectArray[8];
        this.currentByteCount = (Integer)objectArray[9];
        this.column = (Integer)objectArray[10];
        this.reader = (Reader)objectArray[11];
    }

    private boolean tryRead(char c) throws SAXException, IOException {
        char c2 = this.readCh();
        if (c2 == c) {
            return true;
        }
        this.unread(c2);
        return false;
    }

    private boolean tryRead(String string) throws SAXException, IOException {
        return this.tryRead(string.toCharArray());
    }

    private boolean tryRead(char[] cArray) throws SAXException, IOException {
        int n = 0;
        while (n < cArray.length) {
            char c = this.readCh();
            if (c != cArray[n]) {
                this.unread(c);
                if (n != 0) {
                    this.unread(cArray, n);
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean tryWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    private void parseUntil(String string) throws SAXException, IOException {
        this.parseUntil(string.toCharArray());
    }

    private void parseUntil(char[] cArray) throws SAXException, IOException {
        int n = this.line;
        try {
            while (!this.tryRead(cArray)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n + ')', null, new String(cArray));
        }
    }

    private void prefetchASCIIEncodingDecl() throws SAXException, IOException {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        this.is.mark(this.readBuffer.length);
        while (true) {
            int n = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)n;
            switch (n) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("file ends before end of XML or encoding declaration.", null, "?>");
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration");
        }
    }

    private void readDataChunk() throws SAXException, IOException {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            int n = this.reader.read(this.readBuffer, this.readBufferPos, 16384 - this.readBufferPos);
            this.readBufferLength = n < 0 ? this.readBufferPos : this.readBufferPos + n;
            if (this.readBufferLength > 0) {
                this.filterCR(n >= 0);
            }
            this.sawCR = false;
            return;
        }
        int n = this.is.read(this.rawReadBuffer, 0, 16384);
        if (n > 0) {
            switch (this.encoding) {
                case 9: {
                    this.copyIso8859_1ReadBuffer(n, '\u0080');
                    break;
                }
                case 1: {
                    this.copyUtf8ReadBuffer(n);
                    break;
                }
                case 2: {
                    this.copyIso8859_1ReadBuffer(n, '\u0000');
                    break;
                }
                case 3: {
                    this.copyUcs2ReadBuffer(n, 8, 0);
                    break;
                }
                case 4: {
                    this.copyUcs2ReadBuffer(n, 0, 8);
                    break;
                }
                case 5: {
                    this.copyUcs4ReadBuffer(n, 24, 16, 8, 0);
                    break;
                }
                case 6: {
                    this.copyUcs4ReadBuffer(n, 0, 8, 16, 24);
                    break;
                }
                case 7: {
                    this.copyUcs4ReadBuffer(n, 16, 24, 0, 8);
                    break;
                }
                case 8: {
                    this.copyUcs4ReadBuffer(n, 8, 0, 24, 16);
                }
            }
        } else {
            this.readBufferLength = this.readBufferPos;
        }
        this.readBufferPos = 0;
        if (this.sawCR) {
            this.filterCR(n >= 0);
            this.sawCR = false;
            if (this.readBufferLength == 0 && n >= 0) {
                this.readDataChunk();
            }
        }
        if (n > 0) {
            this.currentByteCount += n;
        }
    }

    private void filterCR(boolean bl) {
        int n;
        this.readBufferOverflow = -1;
        int n2 = n = this.readBufferPos;
        block3: while (n < this.readBufferLength) {
            switch (this.readBuffer[n]) {
                case '\r': {
                    if (n == this.readBufferLength - 1) {
                        if (bl) {
                            this.readBufferOverflow = 13;
                            --this.readBufferLength;
                            break block3;
                        }
                        this.readBuffer[n2++] = 10;
                        break block3;
                    }
                    if (this.readBuffer[n + 1] == '\n') {
                        ++n;
                    }
                    this.readBuffer[n2] = 10;
                    break;
                }
                default: {
                    this.readBuffer[n2] = this.readBuffer[n];
                }
            }
            ++n2;
            ++n;
        }
        this.readBufferLength = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyUtf8ReadBuffer(int n) throws SAXException, IOException {
        int n2 = 0;
        int n3 = this.readBufferPos;
        char c = '\u0000';
        while (n2 < n) {
            block9: {
                byte by;
                block10: {
                    block11: {
                        if ((by = this.rawReadBuffer[n2++]) >= 0) break block10;
                        if ((by & 0xE0) != 192) break block11;
                        if ((c = (char)((by & 0x1F) << 6 | this.getNextUtf8Byte(n2++, n))) < '\u0080') {
                            this.encodingError("Illegal two byte UTF-8 sequence", c, 0);
                        }
                        break block9;
                    }
                    if ((by & 0xF0) == 224) {
                        if ((c = (char)((by & 0xF) << 12 | this.getNextUtf8Byte(n2++, n) << 6 | this.getNextUtf8Byte(n2++, n))) < '\u0800' || c >= '\ud800' && c <= '\udfff') {
                            this.encodingError("Illegal three byte UTF-8 sequence", c, 0);
                        }
                        break block9;
                    } else {
                        if ((by & 0xF8) == 240) {
                            int n4 = by & 7;
                            n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n);
                            n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n);
                            if ((n4 = (n4 << 6) + this.getNextUtf8Byte(n2++, n)) <= 65535) {
                                this.encodingError("Illegal four byte UTF-8 sequence", n4, 0);
                                break block9;
                            } else {
                                if (n4 > 0x10FFFF) {
                                    this.encodingError("UTF-8 value out of range for Unicode", n4, 0);
                                }
                                this.readBuffer[n3++] = (char)(0xD800 | (n4 -= 65536) >> 10);
                                this.readBuffer[n3++] = (char)(0xDC00 | n4 & 0x3FF);
                                continue;
                            }
                        }
                        this.encodingError("unsupported five or six byte UTF-8 sequence", 0xFF & by, n2);
                        c = '\u0000';
                    }
                    break block9;
                }
                c = (char)by;
            }
            this.readBuffer[n3++] = c;
            if (c != '\r') continue;
            this.sawCR = true;
        }
        this.readBufferLength = n3;
    }

    private int getNextUtf8Byte(int n, int n2) throws SAXException, IOException {
        int n3;
        if (n < n2) {
            n3 = this.rawReadBuffer[n];
        } else {
            n3 = this.is.read();
            if (n3 == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, n);
            }
        }
        if ((n3 & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", n3, n + 1);
        }
        return n3 & 0x3F;
    }

    private void copyIso8859_1ReadBuffer(int n, char c) throws IOException {
        int n2 = 0;
        int n3 = this.readBufferPos;
        while (n2 < n) {
            char c2 = (char)(this.rawReadBuffer[n2] & 0xFF);
            if ((c2 & c) != 0) {
                throw new CharConversionException("non-ASCII character U+" + Integer.toHexString(c2));
            }
            this.readBuffer[n3] = c2;
            if (c2 == '\r') {
                this.sawCR = true;
            }
            ++n2;
            ++n3;
        }
        this.readBufferLength = n3;
    }

    private void copyUcs2ReadBuffer(int n, int n2, int n3) throws SAXException {
        int n4 = this.readBufferPos;
        if (n > 0 && n % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, n);
        }
        if (n2 == 0) {
            int n5 = 0;
            while (n5 < n) {
                char c = (char)(this.rawReadBuffer[n5 + 1] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[n5]);
                this.readBuffer[n4++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                n5 += 2;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                char c = (char)(this.rawReadBuffer[n6] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[n6 + 1]);
                this.readBuffer[n4++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                n6 += 2;
            }
        }
        this.readBufferLength = n4;
    }

    private void copyUcs4ReadBuffer(int n, int n2, int n3, int n4, int n5) throws SAXException {
        int n6 = this.readBufferPos;
        if (n > 0 && n % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, n);
        }
        int n7 = 0;
        while (n7 < n) {
            int n8 = (this.rawReadBuffer[n7] & 0xFF) << n2 | (this.rawReadBuffer[n7 + 1] & 0xFF) << n3 | (this.rawReadBuffer[n7 + 2] & 0xFF) << n4 | (this.rawReadBuffer[n7 + 3] & 0xFF) << n5;
            if (n8 < 65535) {
                this.readBuffer[n6++] = (char)n8;
                if (n8 == 13) {
                    this.sawCR = true;
                }
            } else if (n8 < 0x10FFFF) {
                this.readBuffer[n6++] = (char)(0xD8 | (n8 -= 65536) >> 10 & 0x3FF);
                this.readBuffer[n6++] = (char)(0xDC | n8 & 0x3FF);
            } else {
                this.encodingError("UCS-4 value out of range for Unicode", n8, n7);
            }
            n7 += 4;
        }
        this.readBufferLength = n6;
    }

    private void encodingError(String string, int n, int n2) throws SAXException {
        if (n != -1) {
            string = string + " (character code: 0x" + Integer.toHexString(n) + ')';
        }
        this.error(string);
    }

    private void initializeVariables() {
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new Hashtable();
        this.entityInfo = new Hashtable();
        this.notationInfo = new Hashtable();
        this.skippedPE = false;
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new Stack();
        this.entityStack = new Stack();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.scratch = new InputSource();
        this.inLiteral = false;
        this.expandPE = false;
        this.peIsError = false;
        this.doReport = false;
        this.inCDATA = false;
        this.symbolTable = new Object[1087][];
    }
}

