/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.publickeystore.InputStorage;
import com.sun.midp.publickeystore.OutputStorage;
import java.io.IOException;

public class PublicKeyInfo {
    static final byte OWNER_TAG = 1;
    static final byte NOT_BEFORE_TAG = 2;
    static final byte NOT_AFTER_TAG = 3;
    static final byte MODULUS_TAG = 4;
    static final byte EXPONENT_TAG = 5;
    static final byte DOMAIN_TAG = 6;
    private String owner;
    private long notBefore;
    private long notAfter;
    private byte[] modulus;
    private byte[] exponent;
    private String domain;

    static PublicKeyInfo getKeyFromStorage(InputStorage storage) throws IOException {
        byte[] tag = new byte[1];
        Object value = storage.readValue(tag);
        if (value == null) {
            return null;
        }
        if (tag[0] != 1) {
            throw new IOException("public key storage corrupted");
        }
        String owner = (String)value;
        value = storage.readValue(tag);
        if (tag[0] != 2) {
            throw new IOException("public key storage corrupted");
        }
        long notBefore = (Long)value;
        value = storage.readValue(tag);
        if (tag[0] != 3) {
            throw new IOException("public key storage corrupted");
        }
        long notAfter = (Long)value;
        value = storage.readValue(tag);
        if (tag[0] != 4) {
            throw new IOException("public key storage corrupted");
        }
        byte[] modulus = (byte[])value;
        value = storage.readValue(tag);
        if (tag[0] != 5) {
            throw new IOException("public key storage corrupted");
        }
        byte[] exponent = (byte[])value;
        value = storage.readValue(tag);
        if (tag[0] != 6) {
            throw new IOException("public key storage corrupted");
        }
        String domain = (String)value;
        return new PublicKeyInfo(owner, notBefore, notAfter, modulus, exponent, domain);
    }

    public PublicKeyInfo(String owner, long notBefore, long notAfter, byte[] modulus, byte[] exponent, String domain) {
        this.owner = owner;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.modulus = modulus;
        this.exponent = exponent;
        this.domain = domain;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public byte[] getModulus() {
        byte[] retVal = new byte[this.modulus.length];
        System.arraycopy(this.modulus, 0, retVal, 0, this.modulus.length);
        return retVal;
    }

    public byte[] getExponent() {
        byte[] retVal = new byte[this.exponent.length];
        System.arraycopy(this.exponent, 0, retVal, 0, this.exponent.length);
        return retVal;
    }

    public String getDomain() {
        if (this.domain == null) {
            return "untrusted";
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        if (domain != null) {
            return;
        }
        this.domain = domain;
    }

    void putKeyInStorage(OutputStorage storage) throws IOException {
        storage.writeValue((byte)1, this.owner);
        storage.writeValue((byte)2, this.notBefore);
        storage.writeValue((byte)3, this.notAfter);
        storage.writeValue((byte)4, this.modulus);
        storage.writeValue((byte)5, this.exponent);
        storage.writeValue((byte)6, this.getDomain());
    }
}

