.TH sane-mustek_pp 5 "21 April 2001"
.IX sane-mustek_pp
.SH NAME
sane-mustek_pp - SANE backend for Mustek parallel port flatbed scanners
.SH DESCRIPTION
The
.B sane-mustek_pp
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Mustek parallel port flatbed scanners.  The
following scanners might work with this backend:
.PP
.RS
Model:               ASIC ID:  CCD Type:  works:
.br
-------------------- --------- ---------- -------
.br
SE 6000 P            1013      00          yes
.br
SM 4800 P            1013/1015 04/01       yes
.br
SE 1200 ED Plus      1015      01          partly
.br
SM 1200 ED Plus      1015      01          partly
.br
SE 12000 P           1505      05          no
.br
SE 600 CP            1015      00          no (*)
.br
SM 600 CP            1015      00          no (*)
.br
600 III EP Plus      1013/1015 00/01       yes
.br
SE 600 SEP           1013      ??          yes
.br
600 II EP            ????      ??          no
.br
MD9848               1015      00          yes
.br
Gallery 4800         ????      ??          yes
.br
Viviscan Compact II  1013      00          yes
.br
MD985x               1015      01/05       no (*)
.br
LT9891               1015      01          no (*)
.RE
.PP
(*) These scanners are currently not supported by the default driver, 
but patches are available; see 
.B CIS 
.BR Scanners .
.PP
Please note that this backend is still under construction. I don't know
which scanners work or which will work in future releases.
.PP
There are two possible reasons a Mustek scanner doesn't work... a) the protcol is still unknown (SE 12000 P) or b) it's a CIS scanner (all the others). See
.B CIS Scanners
for an explaination why.
.PP
Some scanners work faster when 
.B EPP/ECP
is enabled in the BIOS.
.PP
Note that the backend needs to run as root. To allow user access to the scanner
run the backend through the network interface (See saned(1) and sane\-net(5)). Note also that the backend
.I does not
support
.I parport sharing ,
i.e. if you try printing while scanning, your computer may crash. This backend
also conflicts with the
.I sane\-musteka4s2
backend. You can only enable one of them in your dll.conf. However, you have
to enable the backend explicitly in your dll.conf, just remove the hash mark
in the line "mustek_pp".

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I port addr
.RE
.PP
Where
.B addr
is the base address of the port your scanner is attached to. Known ports are
.B 0x378
(lp1)
.B 0x278
(lp2) and
.B 0x3BC
(lp0). Note that if you are using a Kernel 2.2.x or better and you have only one
parallel port this port is named lp0 regardless of the base address. However,
this backend requires the base address of your port. If you are not sure which
port your scanner is connected to, have a look at your /etc/conf.modules.

You can rename any device using the
.PP
.RS
.I name devname
.br
.I model model
.br
.I vendor vendor
.RE
.PP
options. These options aply to the last port option.

.SH CONFIGURATION
Please make sure to edit mustek_pp.conf
.B before
you use the backend.
.PP
The contents of the
.B mustek_pp.conf
file is a list of options and device names that correspond to Mustek
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.
.PP
The nine options supported are
.BR io\-mode ,
.BR wait\-bank ,
.BR strip\-height ,
.BR niceload ,
.BR auth ,
.BR wait-lamp ,
.BR bw ,
.BR use600 ,
and
.BR buffer .

Option
.B io-mode
defines the mode of the sanei_pa4s2 interface. Possible values are
.BR try_mode_uni
and
.BR alt_lock .
This option may appear for each possible value. try_mode_uni allows
the UNI port mode, however this may disable the (better) EPP mode. alt_lock
toggles between two different ways to lock the port for scanner access.
This option must come before any port definition or it won't have the effect
you'd expect.

Option
.B wait-bank
defines the maximal time in msecs the backend waits for the bank to change. The
default value is 700. If this option is given after the port option, only this
device is affected. If this value is to low, you will get wrong colors and
stripes in the scanned image.

Option
.B strip-height
is a option that limits the maximum height of the strip scanned with
a single read command.  The height is specified in lines. If this option is
given after the port option, only this device is affected. A strip\-height of
zero allows to scan as much as fits into the scan buffer.

Option
.B niceload
tries to avoid to heavy load. Note that this reduces scan speed. This is a
global option.

Option
.B auth
turns on user authentification for this scanner. Use this if you want access
control and if you have enabled this at compile time. This option must come
after a port option. At the moment, this option isn't really supported.

Option
.B wait-lamp
allows you to control the time the backend waits for the lamp to warm up. The
time is specified in secs. The default value is 5 secs. Some scanners need
longer to warm up. A value of 0 makes the backend start without waiting. 
However the backend will wait at least 2 secs before turning the lamp off
again. If this option is given after a port option it affects only this
device.

Option
.B bw
defines the maximal color value that is considered black in lineart scans.
The default value is 127. Possible values are between 0 and 255. If this
option is given after a port option it affects only this device.

Option
.B use600
enables the 600 dpi handling code. It's not possible to detect wether a scanner
has an optical resolution of 300x600 dpi or 600x1200 dpi. The default is to
use the 300x600 dpi code. Use this option only if your scanner has an optical
resolution of 600x1200 dpi. This is a local only option.

Option
.B buffer
allows you to change the size of the scan buffer. The size must be specified in
bytes. The default value is 1 megabyte. If this opttion is given after the port
option, only this device is affected. If you have limited the strip\-height,
you only need a scan buffer of
.PP
.RS
.B 8.5 * dpi * 3 * strip\-height bytes.
.RE
.PP

.PP
A sample configuration file is shown below:
.PP
.RS
# GLOBAL #
.br

.br
# enable this option, if you think your scanner
.br
# supports the UNI protocol
.br
# note however that this might disable the better
.br
# EPP protocol
.br
#option io-mode try_mode_uni
.br

.br
# choose between two different ways to lock to port
.br
option io-mode alt_lock
.br

.br
# set the maximal height (in lines) of a strip
.br
# scanned (default: no limit)
.br
#option strip-height 0
.br

.br
# wait n msecs for bank to change (default: 700
.br
# msecs) if this value is to low, stripes my appear
.br
# in the scanned image
.br
#option wait-bank 700
.br

.br
# size (in bytes) of scan buffer (default: 
.br
# 1 megabyte)
.br
#option buffer 1048576
.br

.br
# try to avoid to heavy load. Note that this
.br
# reduces scan speed
.br
option niceload
.br

.br
# Define the time the lamp has to be on before
.br
# scan starts (default 5 secs)
.br
#option wait-lamp 5
.br

.br

.br
# DEVICES #
.br

.br
# specify the port your scanner is connected to.
.br
# Possible are 0x378 (lp1) 0x278 (lp2) and 
.br
# 0x3bc (lp0)
.br
port 0x378
.br

.br
# the following options are local to this scanner
.br

.br
 # scan maximal 16 lines for one sane_read() call
.br
 option strip-height 16
.br

.br
 # we just need 16 * 3 * 300 * 8.5 bytes
.br
 option buffer 122400
.br

.br
 # this scanner needs max 250 msecs to change 
.br
 # the bank
.br
 option wait-bank 250
.br

.br
 # My scanner is a MD9848 from Medion using the
.br
 # Mustek chipset
.br
 name MD9848
.br
 vendor Medion
.br

.br
 # Enable this option, if you want user
.br
 # authentification *and* if it's enabled at
.br
 # compile time
.br
 #option auth
.br

.br
 # Some scanners (especially ASIC 1013) need
.br
 # longer to warm up. This option specifies
.br
 # the time to wait for the lamp to get hot
.br
 #option wait-lamp 15
.br

.br
 # Use this option to define the maximal
.br
 # black value in lineart scans
.br
 #option bw 127
.br

.br
 # Use this option for 600 dpi scanners
.br
 # for example ScanExpress 1200 ED Plus
.br
 #option use600
.br

.RE

.SH CIS Scanners

Some Mustek Scanners use so called contact image sensors (CIS) instead of 
cold cathode devices (CCD). These scanners have a totally different
protocol; they are currently not supported by the default driver. 
.PP
However, patches are available that support most of the CIS type scanners.
Check out the homepage of Eddy De Greef for these patches (see the
.B SEE ALSO
section). 
.PP
These patches have been reported to work on the Mustek 600CP, 1200CP, 
and 1200CP+ models, and various OEM versions (LifeTec/Medion 9350, 9351,
9850, 9851, 9858, 9890, and 9891; Trust Easy Connect 9600 plus; 
Targa Funline TS12EP).
.PP
When installing these patches, 3 additional options are available in the 
.B mustek_pp.conf 
configuration file (see 
.BR CONFIGURATION ): 
.BR cis600 ,
.BR cis1200 ,
.BR cis1200+ .
.PP
These options select the 600CP, 1200CP, or 1200CP+ version of the driver. 
One of them must be set.
.PP
The 600CP has a maximum resolution of 300x600 DPI, whereas the 1200CP
and 1200CP+ have a maximum resolution of 600x1200 DPI. The option must
match your scanner. If unsure, check the manual or the box.
.br
.B Choosing the wrong option could damage your scanner!
.B Especially, using the 1200CP settings on a 600CP can be harmful.
.B If the scanner starts making a loud noice, turn it off immediately !!!
.PP
The 
.B cis...
options cannot be combined with the 
.BR use600
option.
.PP
Currently, when installing the CIS patches, support for CCD type scanners is
disabled. In future versions of the
.B sane-mustek_pp 
backend, the CIS patches will be integrated and support for both types
of scanners will co-exist.
.SH FILES
.TP
.I @CONFIGDIR@/mustek_pp.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-mustek_pp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-mustek_pp.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_MUSTEK_PP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.PP
.RS
level   debug output
.br
------- ------------------------------
.br
 0       nothing
.br
 1       errors
.br
 2       warnings & minor errors
.br
 3       additional information
.br
 4       debug information
.br
 5       code flow (not supported yet)
.br
 6       special debug information
.RE
.PP
.TP
.B SANE_DEBUG_SANEI_PA4S2
This variable sets the debug level for the SANE interface for the Mustek
chipset A4S2. Note that enabling this will spam your terminal with some
million lines of debug output.

.PP
.RS
level   debug output
.br
------- -------------------------------
.br
 0       nothing
.br
 1       errors
.br
 2       warnings
.br
 3       things nice to know
.br
 4       code flow
.br
 5       detailed code flow
.br
 6       everything
.RE
.PP
 
.PP
.SH "SEE ALSO"
sane(7), sane\-mustek(5), sane\-net(5), saned(1)

.TP
Patches for CIS scanner
.I http://home.tiscalinet.be/EddyDeGreef/

.TP
For latest bug fixes and information see
.I http://home.nexgo.de/jochen.eisinger/sane/

.SH AUTHOR
Jochen Eisinger <jochen.eisinger@gmx.net>

.SH BUGS
Too many... please send bug reports to 
.I sane\-devel@mostang.com
(note that you have to subscribe first to the list before you can send
emails... see http://www.mostang.com/sane/mail.html)
.PP
.RS
* 1013 support isn't bullet proofed
.br
* 1505 support isn't even present
.br
* 1015 only works for CCD type 00 & 01 (01 only bw/grayscale)
.RE


.SH BUG REPORTS
If something doesn't work, please contact me. But I need some information about
your scanner to be able to help you...

.TP
.I SANE version
run "scanimage -V" to determine this
.TP
.I the backend version and your scanner hardware
run "SANE_DEBUG_MUSTEK_PP=128 scanimage -L" as root. If you don't get any output
from the mustek_pp backend, make sure a line "mustek_pp" is included into
your @CONFIGDIR@/dll.conf.
If your scanner isn't detected, make sure you've defined the right port address
in your mustek_pp.conf.
.TP
.I the name of your scanner/vendor
also a worthy information. Please also include the optical resolution and lamp type of your scanner, both can be found in the manual of your scanner.
.TP
.I any further comments
if you have comments about the documentation (what could be done better), or you
think I should know something, please include it.
.TP
.I some nice greetings
.
