// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

extern crate glib_sys;
extern crate shell_words;
extern crate tempdir;
use std::env;
use std::error::Error;
use std::path::Path;
use std::mem::{align_of, size_of};
use std::process::Command;
use std::str;
use glib_sys::*;

static PACKAGES: &[&str] = &["glib-2.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Compiler, Box<Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Compiler { args })
    }

    pub fn define<'a, V: Into<Option<&'a str>>>(&mut self, var: &str, val: V) {
        let arg = match val.into() {
            None => format!("-D{}", var),
            Some(val) => format!("-D{}={}", var, val),
        };
        self.args.push(arg);
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}",
                               &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let mut cmd = Command::new("pkg-config");
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}",
                           &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}


#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
    /// Number of tests that failed to compile.
    failed_to_compile: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn record_failed_to_compile(&mut self) {
        self.failed += 1;
        self.failed_to_compile += 1;
    }
    fn summary(&self) -> String {
        format!(
            "{} passed; {} failed (compilation errors: {})",
            self.passed,
            self.failed,
            self.failed_to_compile)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!("1",
               get_c_value(tmpdir.path(), &cc, "1").expect("C constant"),
               "failed to obtain correct constant value for 1");

    let mut results : Results = Default::default();
    for (i, &(name, rust_value)) in RUST_CONSTANTS.iter().enumerate() {
        match get_c_value(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(ref c_value) => {
                if rust_value == c_value {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_value, c_value);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("constants ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!(Layout {size: 1, alignment: 1},
               get_c_layout(tmpdir.path(), &cc, "char").expect("C layout"),
               "failed to obtain correct layout for char type");

    let mut results : Results = Default::default();
    for (i, &(name, rust_layout)) in RUST_LAYOUTS.iter().enumerate() {
        match get_c_layout(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(c_layout) => {
                if rust_layout == c_layout {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_layout, &c_layout);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("layout    ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

fn get_c_layout(dir: &Path, cc: &Compiler, name: &str) -> Result<Layout, Box<Error>> {
    let exe = dir.join("layout");
    let mut cc = cc.clone();
    cc.define("ABI_TYPE_NAME", name);
    cc.compile(Path::new("tests/layout.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    let stdout = str::from_utf8(&output.stdout)?;
    let mut words = stdout.trim().split_whitespace();
    let size = words.next().unwrap().parse().unwrap();
    let alignment = words.next().unwrap().parse().unwrap();
    Ok(Layout {size, alignment})
}

fn get_c_value(dir: &Path, cc: &Compiler, name: &str) -> Result<String, Box<Error>> {
    let exe = dir.join("constant");
    let mut cc = cc.clone();
    cc.define("ABI_CONSTANT_NAME", name);
    cc.compile(Path::new("tests/constant.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    Ok(str::from_utf8(&output.stdout)?.trim().to_owned())
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    ("GArray", Layout {size: size_of::<GArray>(), alignment: align_of::<GArray>()}),
    ("GAsciiType", Layout {size: size_of::<GAsciiType>(), alignment: align_of::<GAsciiType>()}),
    ("GBookmarkFileError", Layout {size: size_of::<GBookmarkFileError>(), alignment: align_of::<GBookmarkFileError>()}),
    ("GByteArray", Layout {size: size_of::<GByteArray>(), alignment: align_of::<GByteArray>()}),
    ("GChecksumType", Layout {size: size_of::<GChecksumType>(), alignment: align_of::<GChecksumType>()}),
    ("GCond", Layout {size: size_of::<GCond>(), alignment: align_of::<GCond>()}),
    ("GConvertError", Layout {size: size_of::<GConvertError>(), alignment: align_of::<GConvertError>()}),
    ("GDateDMY", Layout {size: size_of::<GDateDMY>(), alignment: align_of::<GDateDMY>()}),
    ("GDateDay", Layout {size: size_of::<GDateDay>(), alignment: align_of::<GDateDay>()}),
    ("GDateMonth", Layout {size: size_of::<GDateMonth>(), alignment: align_of::<GDateMonth>()}),
    ("GDateWeekday", Layout {size: size_of::<GDateWeekday>(), alignment: align_of::<GDateWeekday>()}),
    ("GDateYear", Layout {size: size_of::<GDateYear>(), alignment: align_of::<GDateYear>()}),
    ("GDebugKey", Layout {size: size_of::<GDebugKey>(), alignment: align_of::<GDebugKey>()}),
    ("GError", Layout {size: size_of::<GError>(), alignment: align_of::<GError>()}),
    ("GErrorType", Layout {size: size_of::<GErrorType>(), alignment: align_of::<GErrorType>()}),
    ("GFileError", Layout {size: size_of::<GFileError>(), alignment: align_of::<GFileError>()}),
    ("GFileTest", Layout {size: size_of::<GFileTest>(), alignment: align_of::<GFileTest>()}),
    ("GFormatSizeFlags", Layout {size: size_of::<GFormatSizeFlags>(), alignment: align_of::<GFormatSizeFlags>()}),
    ("GHashTableIter", Layout {size: size_of::<GHashTableIter>(), alignment: align_of::<GHashTableIter>()}),
    ("GHook", Layout {size: size_of::<GHook>(), alignment: align_of::<GHook>()}),
    ("GHookFlagMask", Layout {size: size_of::<GHookFlagMask>(), alignment: align_of::<GHookFlagMask>()}),
    ("GHookList", Layout {size: size_of::<GHookList>(), alignment: align_of::<GHookList>()}),
    ("GIConv", Layout {size: size_of::<GIConv>(), alignment: align_of::<GIConv>()}),
    ("GIOChannelError", Layout {size: size_of::<GIOChannelError>(), alignment: align_of::<GIOChannelError>()}),
    ("GIOCondition", Layout {size: size_of::<GIOCondition>(), alignment: align_of::<GIOCondition>()}),
    ("GIOError", Layout {size: size_of::<GIOError>(), alignment: align_of::<GIOError>()}),
    ("GIOFlags", Layout {size: size_of::<GIOFlags>(), alignment: align_of::<GIOFlags>()}),
    ("GIOFuncs", Layout {size: size_of::<GIOFuncs>(), alignment: align_of::<GIOFuncs>()}),
    ("GIOStatus", Layout {size: size_of::<GIOStatus>(), alignment: align_of::<GIOStatus>()}),
    ("GKeyFileError", Layout {size: size_of::<GKeyFileError>(), alignment: align_of::<GKeyFileError>()}),
    ("GKeyFileFlags", Layout {size: size_of::<GKeyFileFlags>(), alignment: align_of::<GKeyFileFlags>()}),
    ("GList", Layout {size: size_of::<GList>(), alignment: align_of::<GList>()}),
    ("GLogField", Layout {size: size_of::<GLogField>(), alignment: align_of::<GLogField>()}),
    ("GLogLevelFlags", Layout {size: size_of::<GLogLevelFlags>(), alignment: align_of::<GLogLevelFlags>()}),
    ("GLogWriterOutput", Layout {size: size_of::<GLogWriterOutput>(), alignment: align_of::<GLogWriterOutput>()}),
    ("GMarkupCollectType", Layout {size: size_of::<GMarkupCollectType>(), alignment: align_of::<GMarkupCollectType>()}),
    ("GMarkupError", Layout {size: size_of::<GMarkupError>(), alignment: align_of::<GMarkupError>()}),
    ("GMarkupParseFlags", Layout {size: size_of::<GMarkupParseFlags>(), alignment: align_of::<GMarkupParseFlags>()}),
    ("GMarkupParser", Layout {size: size_of::<GMarkupParser>(), alignment: align_of::<GMarkupParser>()}),
    ("GMemVTable", Layout {size: size_of::<GMemVTable>(), alignment: align_of::<GMemVTable>()}),
    ("GMutex", Layout {size: size_of::<GMutex>(), alignment: align_of::<GMutex>()}),
    ("GNode", Layout {size: size_of::<GNode>(), alignment: align_of::<GNode>()}),
    ("GNormalizeMode", Layout {size: size_of::<GNormalizeMode>(), alignment: align_of::<GNormalizeMode>()}),
    ("GNumberParserError", Layout {size: size_of::<GNumberParserError>(), alignment: align_of::<GNumberParserError>()}),
    ("GOnce", Layout {size: size_of::<GOnce>(), alignment: align_of::<GOnce>()}),
    ("GOnceStatus", Layout {size: size_of::<GOnceStatus>(), alignment: align_of::<GOnceStatus>()}),
    ("GOptionArg", Layout {size: size_of::<GOptionArg>(), alignment: align_of::<GOptionArg>()}),
    ("GOptionEntry", Layout {size: size_of::<GOptionEntry>(), alignment: align_of::<GOptionEntry>()}),
    ("GOptionError", Layout {size: size_of::<GOptionError>(), alignment: align_of::<GOptionError>()}),
    ("GOptionFlags", Layout {size: size_of::<GOptionFlags>(), alignment: align_of::<GOptionFlags>()}),
    ("GPid", Layout {size: size_of::<GPid>(), alignment: align_of::<GPid>()}),
    ("GPollFD", Layout {size: size_of::<GPollFD>(), alignment: align_of::<GPollFD>()}),
    ("GPrivate", Layout {size: size_of::<GPrivate>(), alignment: align_of::<GPrivate>()}),
    ("GPtrArray", Layout {size: size_of::<GPtrArray>(), alignment: align_of::<GPtrArray>()}),
    ("GQuark", Layout {size: size_of::<GQuark>(), alignment: align_of::<GQuark>()}),
    ("GQueue", Layout {size: size_of::<GQueue>(), alignment: align_of::<GQueue>()}),
    ("GRWLock", Layout {size: size_of::<GRWLock>(), alignment: align_of::<GRWLock>()}),
    ("GRecMutex", Layout {size: size_of::<GRecMutex>(), alignment: align_of::<GRecMutex>()}),
    ("GRegexCompileFlags", Layout {size: size_of::<GRegexCompileFlags>(), alignment: align_of::<GRegexCompileFlags>()}),
    ("GRegexError", Layout {size: size_of::<GRegexError>(), alignment: align_of::<GRegexError>()}),
    ("GRegexMatchFlags", Layout {size: size_of::<GRegexMatchFlags>(), alignment: align_of::<GRegexMatchFlags>()}),
    ("GSList", Layout {size: size_of::<GSList>(), alignment: align_of::<GSList>()}),
    ("GScanner", Layout {size: size_of::<GScanner>(), alignment: align_of::<GScanner>()}),
    ("GSeekType", Layout {size: size_of::<GSeekType>(), alignment: align_of::<GSeekType>()}),
    ("GShellError", Layout {size: size_of::<GShellError>(), alignment: align_of::<GShellError>()}),
    ("GSliceConfig", Layout {size: size_of::<GSliceConfig>(), alignment: align_of::<GSliceConfig>()}),
    ("GSource", Layout {size: size_of::<GSource>(), alignment: align_of::<GSource>()}),
    ("GSourceCallbackFuncs", Layout {size: size_of::<GSourceCallbackFuncs>(), alignment: align_of::<GSourceCallbackFuncs>()}),
    ("GSourceFuncs", Layout {size: size_of::<GSourceFuncs>(), alignment: align_of::<GSourceFuncs>()}),
    ("GSpawnError", Layout {size: size_of::<GSpawnError>(), alignment: align_of::<GSpawnError>()}),
    ("GSpawnFlags", Layout {size: size_of::<GSpawnFlags>(), alignment: align_of::<GSpawnFlags>()}),
    ("GString", Layout {size: size_of::<GString>(), alignment: align_of::<GString>()}),
    ("GStrv", Layout {size: size_of::<GStrv>(), alignment: align_of::<GStrv>()}),
    ("GTestConfig", Layout {size: size_of::<GTestConfig>(), alignment: align_of::<GTestConfig>()}),
    ("GTestFileType", Layout {size: size_of::<GTestFileType>(), alignment: align_of::<GTestFileType>()}),
    ("GTestLogBuffer", Layout {size: size_of::<GTestLogBuffer>(), alignment: align_of::<GTestLogBuffer>()}),
    ("GTestLogMsg", Layout {size: size_of::<GTestLogMsg>(), alignment: align_of::<GTestLogMsg>()}),
    ("GTestLogType", Layout {size: size_of::<GTestLogType>(), alignment: align_of::<GTestLogType>()}),
    ("GTestResult", Layout {size: size_of::<GTestResult>(), alignment: align_of::<GTestResult>()}),
    ("GTestSubprocessFlags", Layout {size: size_of::<GTestSubprocessFlags>(), alignment: align_of::<GTestSubprocessFlags>()}),
    ("GTestTrapFlags", Layout {size: size_of::<GTestTrapFlags>(), alignment: align_of::<GTestTrapFlags>()}),
    ("GThreadError", Layout {size: size_of::<GThreadError>(), alignment: align_of::<GThreadError>()}),
    ("GThreadPool", Layout {size: size_of::<GThreadPool>(), alignment: align_of::<GThreadPool>()}),
    ("GTime", Layout {size: size_of::<GTime>(), alignment: align_of::<GTime>()}),
    ("GTimeSpan", Layout {size: size_of::<GTimeSpan>(), alignment: align_of::<GTimeSpan>()}),
    ("GTimeType", Layout {size: size_of::<GTimeType>(), alignment: align_of::<GTimeType>()}),
    ("GTimeVal", Layout {size: size_of::<GTimeVal>(), alignment: align_of::<GTimeVal>()}),
    ("GTokenType", Layout {size: size_of::<GTokenType>(), alignment: align_of::<GTokenType>()}),
    ("GTokenValue", Layout {size: size_of::<GTokenValue>(), alignment: align_of::<GTokenValue>()}),
    ("GTrashStack", Layout {size: size_of::<GTrashStack>(), alignment: align_of::<GTrashStack>()}),
    ("GTraverseFlags", Layout {size: size_of::<GTraverseFlags>(), alignment: align_of::<GTraverseFlags>()}),
    ("GTraverseType", Layout {size: size_of::<GTraverseType>(), alignment: align_of::<GTraverseType>()}),
    ("GType", Layout {size: size_of::<GType>(), alignment: align_of::<GType>()}),
    ("GUnicodeBreakType", Layout {size: size_of::<GUnicodeBreakType>(), alignment: align_of::<GUnicodeBreakType>()}),
    ("GUnicodeScript", Layout {size: size_of::<GUnicodeScript>(), alignment: align_of::<GUnicodeScript>()}),
    ("GUnicodeType", Layout {size: size_of::<GUnicodeType>(), alignment: align_of::<GUnicodeType>()}),
    ("GUserDirectory", Layout {size: size_of::<GUserDirectory>(), alignment: align_of::<GUserDirectory>()}),
    ("GVariantBuilder", Layout {size: size_of::<GVariantBuilder>(), alignment: align_of::<GVariantBuilder>()}),
    ("GVariantClass", Layout {size: size_of::<GVariantClass>(), alignment: align_of::<GVariantClass>()}),
    ("GVariantDict", Layout {size: size_of::<GVariantDict>(), alignment: align_of::<GVariantDict>()}),
    ("GVariantIter", Layout {size: size_of::<GVariantIter>(), alignment: align_of::<GVariantIter>()}),
    ("GVariantParseError", Layout {size: size_of::<GVariantParseError>(), alignment: align_of::<GVariantParseError>()}),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("GLIB_SYSDEF_AF_INET", "2"),
    ("GLIB_SYSDEF_AF_INET6", "10"),
    ("GLIB_SYSDEF_AF_UNIX", "1"),
    ("GLIB_SYSDEF_MSG_DONTROUTE", "4"),
    ("GLIB_SYSDEF_MSG_OOB", "1"),
    ("GLIB_SYSDEF_MSG_PEEK", "2"),
    ("G_ASCII_ALNUM", "1"),
    ("G_ASCII_ALPHA", "2"),
    ("G_ASCII_CNTRL", "4"),
    ("G_ASCII_DIGIT", "8"),
    ("G_ASCII_DTOSTR_BUF_SIZE", "39"),
    ("G_ASCII_GRAPH", "16"),
    ("G_ASCII_LOWER", "32"),
    ("G_ASCII_PRINT", "64"),
    ("G_ASCII_PUNCT", "128"),
    ("G_ASCII_SPACE", "256"),
    ("G_ASCII_UPPER", "512"),
    ("G_ASCII_XDIGIT", "1024"),
    ("G_BIG_ENDIAN", "4321"),
    ("G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED", "2"),
    ("G_BOOKMARK_FILE_ERROR_FILE_NOT_FOUND", "7"),
    ("G_BOOKMARK_FILE_ERROR_INVALID_URI", "0"),
    ("G_BOOKMARK_FILE_ERROR_INVALID_VALUE", "1"),
    ("G_BOOKMARK_FILE_ERROR_READ", "4"),
    ("G_BOOKMARK_FILE_ERROR_UNKNOWN_ENCODING", "5"),
    ("G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND", "3"),
    ("G_BOOKMARK_FILE_ERROR_WRITE", "6"),
    ("G_CHECKSUM_MD5", "0"),
    ("G_CHECKSUM_SHA1", "1"),
    ("G_CHECKSUM_SHA256", "2"),
    ("G_CHECKSUM_SHA384", "4"),
    ("G_CHECKSUM_SHA512", "3"),
    ("G_CONVERT_ERROR_BAD_URI", "4"),
    ("G_CONVERT_ERROR_EMBEDDED_NUL", "7"),
    ("G_CONVERT_ERROR_FAILED", "2"),
    ("G_CONVERT_ERROR_ILLEGAL_SEQUENCE", "1"),
    ("G_CONVERT_ERROR_NOT_ABSOLUTE_PATH", "5"),
    ("G_CONVERT_ERROR_NO_CONVERSION", "0"),
    ("G_CONVERT_ERROR_NO_MEMORY", "6"),
    ("G_CONVERT_ERROR_PARTIAL_INPUT", "3"),
    ("G_CSET_A_2_Z", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"),
    ("G_CSET_DIGITS", "0123456789"),
    ("G_CSET_a_2_z", "abcdefghijklmnopqrstuvwxyz"),
    ("G_DATALIST_FLAGS_MASK", "3"),
    ("G_DATE_APRIL", "4"),
    ("G_DATE_AUGUST", "8"),
    ("G_DATE_BAD_DAY", "0"),
    ("G_DATE_BAD_JULIAN", "0"),
    ("G_DATE_BAD_MONTH", "0"),
    ("G_DATE_BAD_WEEKDAY", "0"),
    ("G_DATE_BAD_YEAR", "0"),
    ("G_DATE_DAY", "0"),
    ("G_DATE_DECEMBER", "12"),
    ("G_DATE_FEBRUARY", "2"),
    ("G_DATE_FRIDAY", "5"),
    ("G_DATE_JANUARY", "1"),
    ("G_DATE_JULY", "7"),
    ("G_DATE_JUNE", "6"),
    ("G_DATE_MARCH", "3"),
    ("G_DATE_MAY", "5"),
    ("G_DATE_MONDAY", "1"),
    ("G_DATE_MONTH", "1"),
    ("G_DATE_NOVEMBER", "11"),
    ("G_DATE_OCTOBER", "10"),
    ("G_DATE_SATURDAY", "6"),
    ("G_DATE_SEPTEMBER", "9"),
    ("G_DATE_SUNDAY", "7"),
    ("G_DATE_THURSDAY", "4"),
    ("G_DATE_TUESDAY", "2"),
    ("G_DATE_WEDNESDAY", "3"),
    ("G_DATE_YEAR", "2"),
    ("G_E", "2.718282"),
    ("G_ERR_DIGIT_RADIX", "5"),
    ("G_ERR_FLOAT_MALFORMED", "7"),
    ("G_ERR_FLOAT_RADIX", "6"),
    ("G_ERR_NON_DIGIT_IN_CONST", "4"),
    ("G_ERR_UNEXP_EOF", "1"),
    ("G_ERR_UNEXP_EOF_IN_COMMENT", "3"),
    ("G_ERR_UNEXP_EOF_IN_STRING", "2"),
    ("G_ERR_UNKNOWN", "0"),
    ("G_FILE_ERROR_ACCES", "2"),
    ("G_FILE_ERROR_AGAIN", "19"),
    ("G_FILE_ERROR_BADF", "16"),
    ("G_FILE_ERROR_EXIST", "0"),
    ("G_FILE_ERROR_FAILED", "24"),
    ("G_FILE_ERROR_FAULT", "10"),
    ("G_FILE_ERROR_INTR", "20"),
    ("G_FILE_ERROR_INVAL", "17"),
    ("G_FILE_ERROR_IO", "21"),
    ("G_FILE_ERROR_ISDIR", "1"),
    ("G_FILE_ERROR_LOOP", "11"),
    ("G_FILE_ERROR_MFILE", "14"),
    ("G_FILE_ERROR_NAMETOOLONG", "3"),
    ("G_FILE_ERROR_NFILE", "15"),
    ("G_FILE_ERROR_NODEV", "7"),
    ("G_FILE_ERROR_NOENT", "4"),
    ("G_FILE_ERROR_NOMEM", "13"),
    ("G_FILE_ERROR_NOSPC", "12"),
    ("G_FILE_ERROR_NOSYS", "23"),
    ("G_FILE_ERROR_NOTDIR", "5"),
    ("G_FILE_ERROR_NXIO", "6"),
    ("G_FILE_ERROR_PERM", "22"),
    ("G_FILE_ERROR_PIPE", "18"),
    ("G_FILE_ERROR_ROFS", "8"),
    ("G_FILE_ERROR_TXTBSY", "9"),
    ("G_FILE_TEST_EXISTS", "16"),
    ("G_FILE_TEST_IS_DIR", "4"),
    ("G_FILE_TEST_IS_EXECUTABLE", "8"),
    ("G_FILE_TEST_IS_REGULAR", "1"),
    ("G_FILE_TEST_IS_SYMLINK", "2"),
    ("G_FORMAT_SIZE_BITS", "4"),
    ("G_FORMAT_SIZE_DEFAULT", "0"),
    ("G_FORMAT_SIZE_IEC_UNITS", "2"),
    ("G_FORMAT_SIZE_LONG_FORMAT", "1"),
    ("G_HOOK_FLAG_ACTIVE", "1"),
    ("G_HOOK_FLAG_IN_CALL", "2"),
    ("G_HOOK_FLAG_MASK", "15"),
    ("G_HOOK_FLAG_USER_SHIFT", "4"),
    ("G_IEEE754_DOUBLE_BIAS", "1023"),
    ("G_IEEE754_FLOAT_BIAS", "127"),
    ("G_IN_ORDER", "0"),
    ("G_IO_CHANNEL_ERROR_FAILED", "8"),
    ("G_IO_CHANNEL_ERROR_FBIG", "0"),
    ("G_IO_CHANNEL_ERROR_INVAL", "1"),
    ("G_IO_CHANNEL_ERROR_IO", "2"),
    ("G_IO_CHANNEL_ERROR_ISDIR", "3"),
    ("G_IO_CHANNEL_ERROR_NOSPC", "4"),
    ("G_IO_CHANNEL_ERROR_NXIO", "5"),
    ("G_IO_CHANNEL_ERROR_OVERFLOW", "6"),
    ("G_IO_CHANNEL_ERROR_PIPE", "7"),
    ("G_IO_ERR", "8"),
    ("G_IO_ERROR_AGAIN", "1"),
    ("G_IO_ERROR_INVAL", "2"),
    ("G_IO_ERROR_NONE", "0"),
    ("G_IO_ERROR_UNKNOWN", "3"),
    ("G_IO_FLAG_APPEND", "1"),
    ("G_IO_FLAG_GET_MASK", "31"),
    ("G_IO_FLAG_IS_READABLE", "4"),
    ("G_IO_FLAG_IS_SEEKABLE", "16"),
    ("G_IO_FLAG_IS_WRITABLE", "8"),
    ("G_IO_FLAG_IS_WRITEABLE", "8"),
    ("G_IO_FLAG_MASK", "31"),
    ("G_IO_FLAG_NONBLOCK", "2"),
    ("G_IO_FLAG_SET_MASK", "3"),
    ("G_IO_HUP", "16"),
    ("G_IO_IN", "1"),
    ("G_IO_NVAL", "32"),
    ("G_IO_OUT", "4"),
    ("G_IO_PRI", "2"),
    ("G_IO_STATUS_AGAIN", "3"),
    ("G_IO_STATUS_EOF", "2"),
    ("G_IO_STATUS_ERROR", "0"),
    ("G_IO_STATUS_NORMAL", "1"),
    ("G_KEY_FILE_DESKTOP_ACTION_GROUP_PREFIX", "Desktop Action"),
    ("G_KEY_FILE_DESKTOP_GROUP", "Desktop Entry"),
    ("G_KEY_FILE_DESKTOP_KEY_ACTIONS", "Actions"),
    ("G_KEY_FILE_DESKTOP_KEY_CATEGORIES", "Categories"),
    ("G_KEY_FILE_DESKTOP_KEY_COMMENT", "Comment"),
    ("G_KEY_FILE_DESKTOP_KEY_DBUS_ACTIVATABLE", "DBusActivatable"),
    ("G_KEY_FILE_DESKTOP_KEY_EXEC", "Exec"),
    ("G_KEY_FILE_DESKTOP_KEY_FULLNAME", "X-GNOME-FullName"),
    ("G_KEY_FILE_DESKTOP_KEY_GENERIC_NAME", "GenericName"),
    ("G_KEY_FILE_DESKTOP_KEY_GETTEXT_DOMAIN", "X-GNOME-Gettext-Domain"),
    ("G_KEY_FILE_DESKTOP_KEY_HIDDEN", "Hidden"),
    ("G_KEY_FILE_DESKTOP_KEY_ICON", "Icon"),
    ("G_KEY_FILE_DESKTOP_KEY_KEYWORDS", "Keywords"),
    ("G_KEY_FILE_DESKTOP_KEY_MIME_TYPE", "MimeType"),
    ("G_KEY_FILE_DESKTOP_KEY_NAME", "Name"),
    ("G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN", "NotShowIn"),
    ("G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY", "NoDisplay"),
    ("G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN", "OnlyShowIn"),
    ("G_KEY_FILE_DESKTOP_KEY_PATH", "Path"),
    ("G_KEY_FILE_DESKTOP_KEY_STARTUP_NOTIFY", "StartupNotify"),
    ("G_KEY_FILE_DESKTOP_KEY_STARTUP_WM_CLASS", "StartupWMClass"),
    ("G_KEY_FILE_DESKTOP_KEY_TERMINAL", "Terminal"),
    ("G_KEY_FILE_DESKTOP_KEY_TRY_EXEC", "TryExec"),
    ("G_KEY_FILE_DESKTOP_KEY_TYPE", "Type"),
    ("G_KEY_FILE_DESKTOP_KEY_URL", "URL"),
    ("G_KEY_FILE_DESKTOP_KEY_VERSION", "Version"),
    ("G_KEY_FILE_DESKTOP_TYPE_APPLICATION", "Application"),
    ("G_KEY_FILE_DESKTOP_TYPE_DIRECTORY", "Directory"),
    ("G_KEY_FILE_DESKTOP_TYPE_LINK", "Link"),
    ("G_KEY_FILE_ERROR_GROUP_NOT_FOUND", "4"),
    ("G_KEY_FILE_ERROR_INVALID_VALUE", "5"),
    ("G_KEY_FILE_ERROR_KEY_NOT_FOUND", "3"),
    ("G_KEY_FILE_ERROR_NOT_FOUND", "2"),
    ("G_KEY_FILE_ERROR_PARSE", "1"),
    ("G_KEY_FILE_ERROR_UNKNOWN_ENCODING", "0"),
    ("G_KEY_FILE_KEEP_COMMENTS", "1"),
    ("G_KEY_FILE_KEEP_TRANSLATIONS", "2"),
    ("G_KEY_FILE_NONE", "0"),
    ("G_LEVEL_ORDER", "3"),
    ("G_LITTLE_ENDIAN", "1234"),
    ("G_LN10", "2.302585"),
    ("G_LN2", "0.693147"),
    ("G_LOG_2_BASE_10", "0.301030"),
    ("G_LOG_DOMAIN", "0"),
    ("G_LOG_FATAL_MASK", "5"),
    ("G_LOG_FLAG_FATAL", "2"),
    ("G_LOG_FLAG_RECURSION", "1"),
    ("G_LOG_LEVEL_CRITICAL", "8"),
    ("G_LOG_LEVEL_DEBUG", "128"),
    ("G_LOG_LEVEL_ERROR", "4"),
    ("G_LOG_LEVEL_INFO", "64"),
    ("G_LOG_LEVEL_MASK", "-4"),
    ("G_LOG_LEVEL_MESSAGE", "32"),
    ("G_LOG_LEVEL_USER_SHIFT", "8"),
    ("G_LOG_LEVEL_WARNING", "16"),
    ("G_LOG_WRITER_HANDLED", "1"),
    ("G_LOG_WRITER_UNHANDLED", "0"),
    ("G_MARKUP_COLLECT_BOOLEAN", "3"),
    ("G_MARKUP_COLLECT_INVALID", "0"),
    ("G_MARKUP_COLLECT_OPTIONAL", "65536"),
    ("G_MARKUP_COLLECT_STRDUP", "2"),
    ("G_MARKUP_COLLECT_STRING", "1"),
    ("G_MARKUP_COLLECT_TRISTATE", "4"),
    ("G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG", "1"),
    ("G_MARKUP_ERROR_BAD_UTF8", "0"),
    ("G_MARKUP_ERROR_EMPTY", "1"),
    ("G_MARKUP_ERROR_INVALID_CONTENT", "5"),
    ("G_MARKUP_ERROR_MISSING_ATTRIBUTE", "6"),
    ("G_MARKUP_ERROR_PARSE", "2"),
    ("G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE", "4"),
    ("G_MARKUP_ERROR_UNKNOWN_ELEMENT", "3"),
    ("G_MARKUP_IGNORE_QUALIFIED", "8"),
    ("G_MARKUP_PREFIX_ERROR_POSITION", "4"),
    ("G_MARKUP_TREAT_CDATA_AS_TEXT", "2"),
    ("G_NORMALIZE_ALL", "2"),
    ("G_NORMALIZE_ALL_COMPOSE", "3"),
    ("G_NORMALIZE_DEFAULT", "0"),
    ("G_NORMALIZE_DEFAULT_COMPOSE", "1"),
    ("G_NORMALIZE_NFC", "1"),
    ("G_NORMALIZE_NFD", "0"),
    ("G_NORMALIZE_NFKC", "3"),
    ("G_NORMALIZE_NFKD", "2"),
    ("G_NUMBER_PARSER_ERROR_INVALID", "0"),
    ("G_NUMBER_PARSER_ERROR_OUT_OF_BOUNDS", "1"),
    ("G_ONCE_STATUS_NOTCALLED", "0"),
    ("G_ONCE_STATUS_PROGRESS", "1"),
    ("G_ONCE_STATUS_READY", "2"),
    ("G_OPTION_ARG_CALLBACK", "3"),
    ("G_OPTION_ARG_DOUBLE", "7"),
    ("G_OPTION_ARG_FILENAME", "4"),
    ("G_OPTION_ARG_FILENAME_ARRAY", "6"),
    ("G_OPTION_ARG_INT", "2"),
    ("G_OPTION_ARG_INT64", "8"),
    ("G_OPTION_ARG_NONE", "0"),
    ("G_OPTION_ARG_STRING", "1"),
    ("G_OPTION_ARG_STRING_ARRAY", "5"),
    ("G_OPTION_ERROR_BAD_VALUE", "1"),
    ("G_OPTION_ERROR_FAILED", "2"),
    ("G_OPTION_ERROR_UNKNOWN_OPTION", "0"),
    ("G_OPTION_FLAG_FILENAME", "16"),
    ("G_OPTION_FLAG_HIDDEN", "1"),
    ("G_OPTION_FLAG_IN_MAIN", "2"),
    ("G_OPTION_FLAG_NOALIAS", "64"),
    ("G_OPTION_FLAG_NONE", "0"),
    ("G_OPTION_FLAG_NO_ARG", "8"),
    ("G_OPTION_FLAG_OPTIONAL_ARG", "32"),
    ("G_OPTION_FLAG_REVERSE", "4"),
    ("G_OPTION_REMAINING", ""),
    ("G_PDP_ENDIAN", "3412"),
    ("G_PI", "3.141593"),
    ("G_PI_2", "1.570796"),
    ("G_PI_4", "0.785398"),
    ("G_POST_ORDER", "2"),
    ("G_PRE_ORDER", "1"),
    ("G_PRIORITY_DEFAULT", "0"),
    ("G_PRIORITY_DEFAULT_IDLE", "200"),
    ("G_PRIORITY_HIGH", "-100"),
    ("G_PRIORITY_HIGH_IDLE", "100"),
    ("G_PRIORITY_LOW", "300"),
    ("G_REGEX_ANCHORED", "16"),
    ("G_REGEX_BSR_ANYCRLF", "8388608"),
    ("G_REGEX_CASELESS", "1"),
    ("G_REGEX_DOLLAR_ENDONLY", "32"),
    ("G_REGEX_DOTALL", "4"),
    ("G_REGEX_DUPNAMES", "524288"),
    ("G_REGEX_ERROR_ASSERTION_EXPECTED", "128"),
    ("G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_FORBIDDEN", "159"),
    ("G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_REQUIRED", "166"),
    ("G_REGEX_ERROR_CHARACTER_VALUE_TOO_LARGE", "176"),
    ("G_REGEX_ERROR_COMPILE", "0"),
    ("G_REGEX_ERROR_DEFINE_REPETION", "155"),
    ("G_REGEX_ERROR_DUPLICATE_SUBPATTERN_NAME", "143"),
    ("G_REGEX_ERROR_EXPRESSION_TOO_LARGE", "120"),
    ("G_REGEX_ERROR_EXTRA_SUBPATTERN_NAME", "165"),
    ("G_REGEX_ERROR_HEX_CODE_TOO_LARGE", "134"),
    ("G_REGEX_ERROR_INCONSISTENT_NEWLINE_OPTIONS", "156"),
    ("G_REGEX_ERROR_INEXISTENT_SUBPATTERN_REFERENCE", "115"),
    ("G_REGEX_ERROR_INFINITE_LOOP", "140"),
    ("G_REGEX_ERROR_INTERNAL", "4"),
    ("G_REGEX_ERROR_INVALID_CONDITION", "135"),
    ("G_REGEX_ERROR_INVALID_CONTROL_CHAR", "168"),
    ("G_REGEX_ERROR_INVALID_DATA_CHARACTER", "164"),
    ("G_REGEX_ERROR_INVALID_ESCAPE_IN_CHARACTER_CLASS", "107"),
    ("G_REGEX_ERROR_INVALID_OCTAL_VALUE", "151"),
    ("G_REGEX_ERROR_INVALID_RELATIVE_REFERENCE", "158"),
    ("G_REGEX_ERROR_MALFORMED_CONDITION", "126"),
    ("G_REGEX_ERROR_MALFORMED_PROPERTY", "146"),
    ("G_REGEX_ERROR_MATCH", "3"),
    ("G_REGEX_ERROR_MEMORY_ERROR", "121"),
    ("G_REGEX_ERROR_MISSING_BACK_REFERENCE", "157"),
    ("G_REGEX_ERROR_MISSING_CONTROL_CHAR", "102"),
    ("G_REGEX_ERROR_MISSING_DIGIT", "163"),
    ("G_REGEX_ERROR_MISSING_NAME", "169"),
    ("G_REGEX_ERROR_MISSING_SUBPATTERN_NAME", "162"),
    ("G_REGEX_ERROR_MISSING_SUBPATTERN_NAME_TERMINATOR", "142"),
    ("G_REGEX_ERROR_NAME_TOO_LONG", "175"),
    ("G_REGEX_ERROR_NOTHING_TO_REPEAT", "109"),
    ("G_REGEX_ERROR_NOT_SUPPORTED_IN_CLASS", "171"),
    ("G_REGEX_ERROR_NUMBER_TOO_BIG", "161"),
    ("G_REGEX_ERROR_OPTIMIZE", "1"),
    ("G_REGEX_ERROR_POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED", "131"),
    ("G_REGEX_ERROR_POSIX_NAMED_CLASS_OUTSIDE_CLASS", "113"),
    ("G_REGEX_ERROR_QUANTIFIERS_OUT_OF_ORDER", "104"),
    ("G_REGEX_ERROR_QUANTIFIER_TOO_BIG", "105"),
    ("G_REGEX_ERROR_RANGE_OUT_OF_ORDER", "108"),
    ("G_REGEX_ERROR_REPLACE", "2"),
    ("G_REGEX_ERROR_SINGLE_BYTE_MATCH_IN_LOOKBEHIND", "136"),
    ("G_REGEX_ERROR_STRAY_BACKSLASH", "101"),
    ("G_REGEX_ERROR_SUBPATTERN_NAME_TOO_LONG", "148"),
    ("G_REGEX_ERROR_TOO_MANY_BRANCHES_IN_DEFINE", "154"),
    ("G_REGEX_ERROR_TOO_MANY_CONDITIONAL_BRANCHES", "127"),
    ("G_REGEX_ERROR_TOO_MANY_FORWARD_REFERENCES", "172"),
    ("G_REGEX_ERROR_TOO_MANY_SUBPATTERNS", "149"),
    ("G_REGEX_ERROR_UNKNOWN_BACKTRACKING_CONTROL_VERB", "160"),
    ("G_REGEX_ERROR_UNKNOWN_POSIX_CLASS_NAME", "130"),
    ("G_REGEX_ERROR_UNKNOWN_PROPERTY", "147"),
    ("G_REGEX_ERROR_UNMATCHED_PARENTHESIS", "114"),
    ("G_REGEX_ERROR_UNRECOGNIZED_CHARACTER", "112"),
    ("G_REGEX_ERROR_UNRECOGNIZED_ESCAPE", "103"),
    ("G_REGEX_ERROR_UNTERMINATED_CHARACTER_CLASS", "106"),
    ("G_REGEX_ERROR_UNTERMINATED_COMMENT", "118"),
    ("G_REGEX_ERROR_VARIABLE_LENGTH_LOOKBEHIND", "125"),
    ("G_REGEX_EXTENDED", "8"),
    ("G_REGEX_FIRSTLINE", "262144"),
    ("G_REGEX_JAVASCRIPT_COMPAT", "33554432"),
    ("G_REGEX_MATCH_ANCHORED", "16"),
    ("G_REGEX_MATCH_BSR_ANY", "16777216"),
    ("G_REGEX_MATCH_BSR_ANYCRLF", "8388608"),
    ("G_REGEX_MATCH_NEWLINE_ANY", "4194304"),
    ("G_REGEX_MATCH_NEWLINE_ANYCRLF", "5242880"),
    ("G_REGEX_MATCH_NEWLINE_CR", "1048576"),
    ("G_REGEX_MATCH_NEWLINE_CRLF", "3145728"),
    ("G_REGEX_MATCH_NEWLINE_LF", "2097152"),
    ("G_REGEX_MATCH_NOTBOL", "128"),
    ("G_REGEX_MATCH_NOTEMPTY", "1024"),
    ("G_REGEX_MATCH_NOTEMPTY_ATSTART", "268435456"),
    ("G_REGEX_MATCH_NOTEOL", "256"),
    ("G_REGEX_MATCH_PARTIAL", "32768"),
    ("G_REGEX_MATCH_PARTIAL_HARD", "134217728"),
    ("G_REGEX_MATCH_PARTIAL_SOFT", "32768"),
    ("G_REGEX_MULTILINE", "2"),
    ("G_REGEX_NEWLINE_ANYCRLF", "5242880"),
    ("G_REGEX_NEWLINE_CR", "1048576"),
    ("G_REGEX_NEWLINE_CRLF", "3145728"),
    ("G_REGEX_NEWLINE_LF", "2097152"),
    ("G_REGEX_NO_AUTO_CAPTURE", "4096"),
    ("G_REGEX_OPTIMIZE", "8192"),
    ("G_REGEX_RAW", "2048"),
    ("G_REGEX_UNGREEDY", "512"),
    ("G_SEEK_CUR", "0"),
    ("G_SEEK_END", "2"),
    ("G_SEEK_SET", "1"),
    ("G_SHELL_ERROR_BAD_QUOTING", "0"),
    ("G_SHELL_ERROR_EMPTY_STRING", "1"),
    ("G_SHELL_ERROR_FAILED", "2"),
    ("G_SLICE_CONFIG_ALWAYS_MALLOC", "1"),
    ("G_SLICE_CONFIG_BYPASS_MAGAZINES", "2"),
    ("G_SLICE_CONFIG_CHUNK_SIZES", "5"),
    ("G_SLICE_CONFIG_COLOR_INCREMENT", "4"),
    ("G_SLICE_CONFIG_CONTENTION_COUNTER", "6"),
    ("G_SLICE_CONFIG_WORKING_SET_MSECS", "3"),
    ("G_SOURCE_CONTINUE", "1"),
    ("G_SOURCE_REMOVE", "0"),
    ("G_SPAWN_CHILD_INHERITS_STDIN", "32"),
    ("G_SPAWN_CLOEXEC_PIPES", "256"),
    ("G_SPAWN_DEFAULT", "0"),
    ("G_SPAWN_DO_NOT_REAP_CHILD", "2"),
    ("G_SPAWN_ERROR_2BIG", "5"),
    ("G_SPAWN_ERROR_ACCES", "3"),
    ("G_SPAWN_ERROR_CHDIR", "2"),
    ("G_SPAWN_ERROR_FAILED", "19"),
    ("G_SPAWN_ERROR_FORK", "0"),
    ("G_SPAWN_ERROR_INVAL", "16"),
    ("G_SPAWN_ERROR_IO", "13"),
    ("G_SPAWN_ERROR_ISDIR", "17"),
    ("G_SPAWN_ERROR_LIBBAD", "18"),
    ("G_SPAWN_ERROR_LOOP", "11"),
    ("G_SPAWN_ERROR_MFILE", "15"),
    ("G_SPAWN_ERROR_NAMETOOLONG", "7"),
    ("G_SPAWN_ERROR_NFILE", "14"),
    ("G_SPAWN_ERROR_NOENT", "8"),
    ("G_SPAWN_ERROR_NOEXEC", "6"),
    ("G_SPAWN_ERROR_NOMEM", "9"),
    ("G_SPAWN_ERROR_NOTDIR", "10"),
    ("G_SPAWN_ERROR_PERM", "4"),
    ("G_SPAWN_ERROR_READ", "1"),
    ("G_SPAWN_ERROR_TOO_BIG", "5"),
    ("G_SPAWN_ERROR_TXTBUSY", "12"),
    ("G_SPAWN_FILE_AND_ARGV_ZERO", "64"),
    ("G_SPAWN_LEAVE_DESCRIPTORS_OPEN", "1"),
    ("G_SPAWN_SEARCH_PATH", "4"),
    ("G_SPAWN_SEARCH_PATH_FROM_ENVP", "128"),
    ("G_SPAWN_STDERR_TO_DEV_NULL", "16"),
    ("G_SPAWN_STDOUT_TO_DEV_NULL", "8"),
    ("G_SQRT2", "1.414214"),
    ("G_STR_DELIMITERS", "_-|> <."),
    ("G_TEST_BUILT", "1"),
    ("G_TEST_DIST", "0"),
    ("G_TEST_LOG_ERROR", "1"),
    ("G_TEST_LOG_LIST_CASE", "3"),
    ("G_TEST_LOG_MAX_RESULT", "8"),
    ("G_TEST_LOG_MESSAGE", "9"),
    ("G_TEST_LOG_MIN_RESULT", "7"),
    ("G_TEST_LOG_NONE", "0"),
    ("G_TEST_LOG_SKIP_CASE", "4"),
    ("G_TEST_LOG_START_BINARY", "2"),
    ("G_TEST_LOG_START_CASE", "5"),
    ("G_TEST_LOG_START_SUITE", "10"),
    ("G_TEST_LOG_STOP_CASE", "6"),
    ("G_TEST_LOG_STOP_SUITE", "11"),
    ("G_TEST_RUN_FAILURE", "2"),
    ("G_TEST_RUN_INCOMPLETE", "3"),
    ("G_TEST_RUN_SKIPPED", "1"),
    ("G_TEST_RUN_SUCCESS", "0"),
    ("G_TEST_SUBPROCESS_INHERIT_STDERR", "4"),
    ("G_TEST_SUBPROCESS_INHERIT_STDIN", "1"),
    ("G_TEST_SUBPROCESS_INHERIT_STDOUT", "2"),
    ("G_TEST_TRAP_INHERIT_STDIN", "512"),
    ("G_TEST_TRAP_SILENCE_STDERR", "256"),
    ("G_TEST_TRAP_SILENCE_STDOUT", "128"),
    ("G_THREAD_ERROR_AGAIN", "0"),
    ("G_TIME_SPAN_DAY", "86400000000"),
    ("G_TIME_SPAN_HOUR", "3600000000"),
    ("G_TIME_SPAN_MILLISECOND", "1000"),
    ("G_TIME_SPAN_MINUTE", "60000000"),
    ("G_TIME_SPAN_SECOND", "1000000"),
    ("G_TIME_TYPE_DAYLIGHT", "1"),
    ("G_TIME_TYPE_STANDARD", "0"),
    ("G_TIME_TYPE_UNIVERSAL", "2"),
    ("G_TOKEN_BINARY", "259"),
    ("G_TOKEN_CHAR", "258"),
    ("G_TOKEN_COMMA", "44"),
    ("G_TOKEN_COMMENT_MULTI", "269"),
    ("G_TOKEN_COMMENT_SINGLE", "268"),
    ("G_TOKEN_EOF", "0"),
    ("G_TOKEN_EQUAL_SIGN", "61"),
    ("G_TOKEN_ERROR", "257"),
    ("G_TOKEN_FLOAT", "263"),
    ("G_TOKEN_HEX", "262"),
    ("G_TOKEN_IDENTIFIER", "266"),
    ("G_TOKEN_IDENTIFIER_NULL", "267"),
    ("G_TOKEN_INT", "261"),
    ("G_TOKEN_LEFT_BRACE", "91"),
    ("G_TOKEN_LEFT_CURLY", "123"),
    ("G_TOKEN_LEFT_PAREN", "40"),
    ("G_TOKEN_NONE", "256"),
    ("G_TOKEN_OCTAL", "260"),
    ("G_TOKEN_RIGHT_BRACE", "93"),
    ("G_TOKEN_RIGHT_CURLY", "125"),
    ("G_TOKEN_RIGHT_PAREN", "41"),
    ("G_TOKEN_STRING", "264"),
    ("G_TOKEN_SYMBOL", "265"),
    ("G_TRAVERSE_ALL", "3"),
    ("G_TRAVERSE_LEAFS", "1"),
    ("G_TRAVERSE_LEAVES", "1"),
    ("G_TRAVERSE_MASK", "3"),
    ("G_TRAVERSE_NON_LEAFS", "2"),
    ("G_TRAVERSE_NON_LEAVES", "2"),
    ("G_UNICHAR_MAX_DECOMPOSITION_LENGTH", "18"),
    ("G_UNICODE_BREAK_AFTER", "10"),
    ("G_UNICODE_BREAK_ALPHABETIC", "23"),
    ("G_UNICODE_BREAK_AMBIGUOUS", "27"),
    ("G_UNICODE_BREAK_BEFORE", "11"),
    ("G_UNICODE_BREAK_BEFORE_AND_AFTER", "12"),
    ("G_UNICODE_BREAK_CARRIAGE_RETURN", "1"),
    ("G_UNICODE_BREAK_CLOSE_PARANTHESIS", "36"),
    ("G_UNICODE_BREAK_CLOSE_PUNCTUATION", "16"),
    ("G_UNICODE_BREAK_COMBINING_MARK", "3"),
    ("G_UNICODE_BREAK_COMPLEX_CONTEXT", "26"),
    ("G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER", "37"),
    ("G_UNICODE_BREAK_CONTINGENT", "8"),
    ("G_UNICODE_BREAK_EMOJI_BASE", "40"),
    ("G_UNICODE_BREAK_EMOJI_MODIFIER", "41"),
    ("G_UNICODE_BREAK_EXCLAMATION", "18"),
    ("G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE", "35"),
    ("G_UNICODE_BREAK_HANGUL_LV_SYLLABLE", "34"),
    ("G_UNICODE_BREAK_HANGUL_L_JAMO", "31"),
    ("G_UNICODE_BREAK_HANGUL_T_JAMO", "33"),
    ("G_UNICODE_BREAK_HANGUL_V_JAMO", "32"),
    ("G_UNICODE_BREAK_HEBREW_LETTER", "38"),
    ("G_UNICODE_BREAK_HYPHEN", "13"),
    ("G_UNICODE_BREAK_IDEOGRAPHIC", "19"),
    ("G_UNICODE_BREAK_INFIX_SEPARATOR", "21"),
    ("G_UNICODE_BREAK_INSEPARABLE", "6"),
    ("G_UNICODE_BREAK_LINE_FEED", "2"),
    ("G_UNICODE_BREAK_MANDATORY", "0"),
    ("G_UNICODE_BREAK_NEXT_LINE", "29"),
    ("G_UNICODE_BREAK_NON_BREAKING_GLUE", "7"),
    ("G_UNICODE_BREAK_NON_STARTER", "14"),
    ("G_UNICODE_BREAK_NUMERIC", "20"),
    ("G_UNICODE_BREAK_OPEN_PUNCTUATION", "15"),
    ("G_UNICODE_BREAK_POSTFIX", "25"),
    ("G_UNICODE_BREAK_PREFIX", "24"),
    ("G_UNICODE_BREAK_QUOTATION", "17"),
    ("G_UNICODE_BREAK_REGIONAL_INDICATOR", "39"),
    ("G_UNICODE_BREAK_SPACE", "9"),
    ("G_UNICODE_BREAK_SURROGATE", "4"),
    ("G_UNICODE_BREAK_SYMBOL", "22"),
    ("G_UNICODE_BREAK_UNKNOWN", "28"),
    ("G_UNICODE_BREAK_WORD_JOINER", "30"),
    ("G_UNICODE_BREAK_ZERO_WIDTH_JOINER", "42"),
    ("G_UNICODE_BREAK_ZERO_WIDTH_SPACE", "5"),
    ("G_UNICODE_CLOSE_PUNCTUATION", "18"),
    ("G_UNICODE_CONNECT_PUNCTUATION", "16"),
    ("G_UNICODE_CONTROL", "0"),
    ("G_UNICODE_CURRENCY_SYMBOL", "23"),
    ("G_UNICODE_DASH_PUNCTUATION", "17"),
    ("G_UNICODE_DECIMAL_NUMBER", "13"),
    ("G_UNICODE_ENCLOSING_MARK", "11"),
    ("G_UNICODE_FINAL_PUNCTUATION", "19"),
    ("G_UNICODE_FORMAT", "1"),
    ("G_UNICODE_INITIAL_PUNCTUATION", "20"),
    ("G_UNICODE_LETTER_NUMBER", "14"),
    ("G_UNICODE_LINE_SEPARATOR", "27"),
    ("G_UNICODE_LOWERCASE_LETTER", "5"),
    ("G_UNICODE_MATH_SYMBOL", "25"),
    ("G_UNICODE_MODIFIER_LETTER", "6"),
    ("G_UNICODE_MODIFIER_SYMBOL", "24"),
    ("G_UNICODE_NON_SPACING_MARK", "12"),
    ("G_UNICODE_OPEN_PUNCTUATION", "22"),
    ("G_UNICODE_OTHER_LETTER", "7"),
    ("G_UNICODE_OTHER_NUMBER", "15"),
    ("G_UNICODE_OTHER_PUNCTUATION", "21"),
    ("G_UNICODE_OTHER_SYMBOL", "26"),
    ("G_UNICODE_PARAGRAPH_SEPARATOR", "28"),
    ("G_UNICODE_PRIVATE_USE", "3"),
    ("G_UNICODE_SCRIPT_ADLAM", "132"),
    ("G_UNICODE_SCRIPT_AHOM", "126"),
    ("G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS", "127"),
    ("G_UNICODE_SCRIPT_ARABIC", "2"),
    ("G_UNICODE_SCRIPT_ARMENIAN", "3"),
    ("G_UNICODE_SCRIPT_AVESTAN", "78"),
    ("G_UNICODE_SCRIPT_BALINESE", "62"),
    ("G_UNICODE_SCRIPT_BAMUM", "79"),
    ("G_UNICODE_SCRIPT_BASSA_VAH", "103"),
    ("G_UNICODE_SCRIPT_BATAK", "93"),
    ("G_UNICODE_SCRIPT_BENGALI", "4"),
    ("G_UNICODE_SCRIPT_BHAIKSUKI", "133"),
    ("G_UNICODE_SCRIPT_BOPOMOFO", "5"),
    ("G_UNICODE_SCRIPT_BRAHMI", "94"),
    ("G_UNICODE_SCRIPT_BRAILLE", "46"),
    ("G_UNICODE_SCRIPT_BUGINESE", "55"),
    ("G_UNICODE_SCRIPT_BUHID", "44"),
    ("G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL", "40"),
    ("G_UNICODE_SCRIPT_CARIAN", "75"),
    ("G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN", "104"),
    ("G_UNICODE_SCRIPT_CHAKMA", "96"),
    ("G_UNICODE_SCRIPT_CHAM", "72"),
    ("G_UNICODE_SCRIPT_CHEROKEE", "6"),
    ("G_UNICODE_SCRIPT_COMMON", "0"),
    ("G_UNICODE_SCRIPT_COPTIC", "7"),
    ("G_UNICODE_SCRIPT_CUNEIFORM", "63"),
    ("G_UNICODE_SCRIPT_CYPRIOT", "47"),
    ("G_UNICODE_SCRIPT_CYRILLIC", "8"),
    ("G_UNICODE_SCRIPT_DESERET", "9"),
    ("G_UNICODE_SCRIPT_DEVANAGARI", "10"),
    ("G_UNICODE_SCRIPT_DUPLOYAN", "105"),
    ("G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS", "80"),
    ("G_UNICODE_SCRIPT_ELBASAN", "106"),
    ("G_UNICODE_SCRIPT_ETHIOPIC", "11"),
    ("G_UNICODE_SCRIPT_GEORGIAN", "12"),
    ("G_UNICODE_SCRIPT_GLAGOLITIC", "56"),
    ("G_UNICODE_SCRIPT_GOTHIC", "13"),
    ("G_UNICODE_SCRIPT_GRANTHA", "107"),
    ("G_UNICODE_SCRIPT_GREEK", "14"),
    ("G_UNICODE_SCRIPT_GUJARATI", "15"),
    ("G_UNICODE_SCRIPT_GURMUKHI", "16"),
    ("G_UNICODE_SCRIPT_HAN", "17"),
    ("G_UNICODE_SCRIPT_HANGUL", "18"),
    ("G_UNICODE_SCRIPT_HANUNOO", "43"),
    ("G_UNICODE_SCRIPT_HATRAN", "128"),
    ("G_UNICODE_SCRIPT_HEBREW", "19"),
    ("G_UNICODE_SCRIPT_HIRAGANA", "20"),
    ("G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC", "81"),
    ("G_UNICODE_SCRIPT_INHERITED", "1"),
    ("G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI", "82"),
    ("G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN", "83"),
    ("G_UNICODE_SCRIPT_INVALID_CODE", "-1"),
    ("G_UNICODE_SCRIPT_JAVANESE", "84"),
    ("G_UNICODE_SCRIPT_KAITHI", "85"),
    ("G_UNICODE_SCRIPT_KANNADA", "21"),
    ("G_UNICODE_SCRIPT_KATAKANA", "22"),
    ("G_UNICODE_SCRIPT_KAYAH_LI", "67"),
    ("G_UNICODE_SCRIPT_KHAROSHTHI", "60"),
    ("G_UNICODE_SCRIPT_KHMER", "23"),
    ("G_UNICODE_SCRIPT_KHOJKI", "108"),
    ("G_UNICODE_SCRIPT_KHUDAWADI", "109"),
    ("G_UNICODE_SCRIPT_LAO", "24"),
    ("G_UNICODE_SCRIPT_LATIN", "25"),
    ("G_UNICODE_SCRIPT_LEPCHA", "68"),
    ("G_UNICODE_SCRIPT_LIMBU", "48"),
    ("G_UNICODE_SCRIPT_LINEAR_A", "110"),
    ("G_UNICODE_SCRIPT_LINEAR_B", "51"),
    ("G_UNICODE_SCRIPT_LISU", "86"),
    ("G_UNICODE_SCRIPT_LYCIAN", "76"),
    ("G_UNICODE_SCRIPT_LYDIAN", "77"),
    ("G_UNICODE_SCRIPT_MAHAJANI", "111"),
    ("G_UNICODE_SCRIPT_MALAYALAM", "26"),
    ("G_UNICODE_SCRIPT_MANDAIC", "95"),
    ("G_UNICODE_SCRIPT_MANICHAEAN", "112"),
    ("G_UNICODE_SCRIPT_MARCHEN", "134"),
    ("G_UNICODE_SCRIPT_MASARAM_GONDI", "138"),
    ("G_UNICODE_SCRIPT_MEETEI_MAYEK", "87"),
    ("G_UNICODE_SCRIPT_MENDE_KIKAKUI", "113"),
    ("G_UNICODE_SCRIPT_MEROITIC_CURSIVE", "97"),
    ("G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS", "98"),
    ("G_UNICODE_SCRIPT_MIAO", "99"),
    ("G_UNICODE_SCRIPT_MODI", "114"),
    ("G_UNICODE_SCRIPT_MONGOLIAN", "27"),
    ("G_UNICODE_SCRIPT_MRO", "115"),
    ("G_UNICODE_SCRIPT_MULTANI", "129"),
    ("G_UNICODE_SCRIPT_MYANMAR", "28"),
    ("G_UNICODE_SCRIPT_NABATAEAN", "116"),
    ("G_UNICODE_SCRIPT_NEWA", "135"),
    ("G_UNICODE_SCRIPT_NEW_TAI_LUE", "54"),
    ("G_UNICODE_SCRIPT_NKO", "66"),
    ("G_UNICODE_SCRIPT_NUSHU", "139"),
    ("G_UNICODE_SCRIPT_OGHAM", "29"),
    ("G_UNICODE_SCRIPT_OLD_HUNGARIAN", "130"),
    ("G_UNICODE_SCRIPT_OLD_ITALIC", "30"),
    ("G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN", "117"),
    ("G_UNICODE_SCRIPT_OLD_PERMIC", "118"),
    ("G_UNICODE_SCRIPT_OLD_PERSIAN", "59"),
    ("G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN", "88"),
    ("G_UNICODE_SCRIPT_OLD_TURKIC", "89"),
    ("G_UNICODE_SCRIPT_OL_CHIKI", "73"),
    ("G_UNICODE_SCRIPT_ORIYA", "31"),
    ("G_UNICODE_SCRIPT_OSAGE", "136"),
    ("G_UNICODE_SCRIPT_OSMANYA", "49"),
    ("G_UNICODE_SCRIPT_PAHAWH_HMONG", "119"),
    ("G_UNICODE_SCRIPT_PALMYRENE", "120"),
    ("G_UNICODE_SCRIPT_PAU_CIN_HAU", "121"),
    ("G_UNICODE_SCRIPT_PHAGS_PA", "65"),
    ("G_UNICODE_SCRIPT_PHOENICIAN", "64"),
    ("G_UNICODE_SCRIPT_PSALTER_PAHLAVI", "122"),
    ("G_UNICODE_SCRIPT_REJANG", "69"),
    ("G_UNICODE_SCRIPT_RUNIC", "32"),
    ("G_UNICODE_SCRIPT_SAMARITAN", "90"),
    ("G_UNICODE_SCRIPT_SAURASHTRA", "71"),
    ("G_UNICODE_SCRIPT_SHARADA", "100"),
    ("G_UNICODE_SCRIPT_SHAVIAN", "50"),
    ("G_UNICODE_SCRIPT_SIDDHAM", "123"),
    ("G_UNICODE_SCRIPT_SIGNWRITING", "131"),
    ("G_UNICODE_SCRIPT_SINHALA", "33"),
    ("G_UNICODE_SCRIPT_SORA_SOMPENG", "101"),
    ("G_UNICODE_SCRIPT_SOYOMBO", "140"),
    ("G_UNICODE_SCRIPT_SUNDANESE", "70"),
    ("G_UNICODE_SCRIPT_SYLOTI_NAGRI", "58"),
    ("G_UNICODE_SCRIPT_SYRIAC", "34"),
    ("G_UNICODE_SCRIPT_TAGALOG", "42"),
    ("G_UNICODE_SCRIPT_TAGBANWA", "45"),
    ("G_UNICODE_SCRIPT_TAI_LE", "52"),
    ("G_UNICODE_SCRIPT_TAI_THAM", "91"),
    ("G_UNICODE_SCRIPT_TAI_VIET", "92"),
    ("G_UNICODE_SCRIPT_TAKRI", "102"),
    ("G_UNICODE_SCRIPT_TAMIL", "35"),
    ("G_UNICODE_SCRIPT_TANGUT", "137"),
    ("G_UNICODE_SCRIPT_TELUGU", "36"),
    ("G_UNICODE_SCRIPT_THAANA", "37"),
    ("G_UNICODE_SCRIPT_THAI", "38"),
    ("G_UNICODE_SCRIPT_TIBETAN", "39"),
    ("G_UNICODE_SCRIPT_TIFINAGH", "57"),
    ("G_UNICODE_SCRIPT_TIRHUTA", "124"),
    ("G_UNICODE_SCRIPT_UGARITIC", "53"),
    ("G_UNICODE_SCRIPT_UNKNOWN", "61"),
    ("G_UNICODE_SCRIPT_VAI", "74"),
    ("G_UNICODE_SCRIPT_WARANG_CITI", "125"),
    ("G_UNICODE_SCRIPT_YI", "41"),
    ("G_UNICODE_SCRIPT_ZANABAZAR_SQUARE", "141"),
    ("G_UNICODE_SPACE_SEPARATOR", "29"),
    ("G_UNICODE_SPACING_MARK", "10"),
    ("G_UNICODE_SURROGATE", "4"),
    ("G_UNICODE_TITLECASE_LETTER", "8"),
    ("G_UNICODE_UNASSIGNED", "2"),
    ("G_UNICODE_UPPERCASE_LETTER", "9"),
    ("G_URI_RESERVED_CHARS_GENERIC_DELIMITERS", ":/?#[]@"),
    ("G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS", "!$&'()*+,;="),
    ("G_USEC_PER_SEC", "1000000"),
    ("G_USER_DIRECTORY_DESKTOP", "0"),
    ("G_USER_DIRECTORY_DOCUMENTS", "1"),
    ("G_USER_DIRECTORY_DOWNLOAD", "2"),
    ("G_USER_DIRECTORY_MUSIC", "3"),
    ("G_USER_DIRECTORY_PICTURES", "4"),
    ("G_USER_DIRECTORY_PUBLIC_SHARE", "5"),
    ("G_USER_DIRECTORY_TEMPLATES", "6"),
    ("G_USER_DIRECTORY_VIDEOS", "7"),
    ("G_USER_N_DIRECTORIES", "8"),
    ("G_VARIANT_CLASS_ARRAY", "97"),
    ("G_VARIANT_CLASS_BOOLEAN", "98"),
    ("G_VARIANT_CLASS_BYTE", "121"),
    ("G_VARIANT_CLASS_DICT_ENTRY", "123"),
    ("G_VARIANT_CLASS_DOUBLE", "100"),
    ("G_VARIANT_CLASS_HANDLE", "104"),
    ("G_VARIANT_CLASS_INT16", "110"),
    ("G_VARIANT_CLASS_INT32", "105"),
    ("G_VARIANT_CLASS_INT64", "120"),
    ("G_VARIANT_CLASS_MAYBE", "109"),
    ("G_VARIANT_CLASS_OBJECT_PATH", "111"),
    ("G_VARIANT_CLASS_SIGNATURE", "103"),
    ("G_VARIANT_CLASS_STRING", "115"),
    ("G_VARIANT_CLASS_TUPLE", "40"),
    ("G_VARIANT_CLASS_UINT16", "113"),
    ("G_VARIANT_CLASS_UINT32", "117"),
    ("G_VARIANT_CLASS_UINT64", "116"),
    ("G_VARIANT_CLASS_VARIANT", "118"),
    ("G_VARIANT_PARSE_ERROR_BASIC_TYPE_EXPECTED", "1"),
    ("G_VARIANT_PARSE_ERROR_CANNOT_INFER_TYPE", "2"),
    ("G_VARIANT_PARSE_ERROR_DEFINITE_TYPE_EXPECTED", "3"),
    ("G_VARIANT_PARSE_ERROR_FAILED", "0"),
    ("G_VARIANT_PARSE_ERROR_INPUT_NOT_AT_END", "4"),
    ("G_VARIANT_PARSE_ERROR_INVALID_CHARACTER", "5"),
    ("G_VARIANT_PARSE_ERROR_INVALID_FORMAT_STRING", "6"),
    ("G_VARIANT_PARSE_ERROR_INVALID_OBJECT_PATH", "7"),
    ("G_VARIANT_PARSE_ERROR_INVALID_SIGNATURE", "8"),
    ("G_VARIANT_PARSE_ERROR_INVALID_TYPE_STRING", "9"),
    ("G_VARIANT_PARSE_ERROR_NO_COMMON_TYPE", "10"),
    ("G_VARIANT_PARSE_ERROR_NUMBER_OUT_OF_RANGE", "11"),
    ("G_VARIANT_PARSE_ERROR_NUMBER_TOO_BIG", "12"),
    ("G_VARIANT_PARSE_ERROR_TYPE_ERROR", "13"),
    ("G_VARIANT_PARSE_ERROR_UNEXPECTED_TOKEN", "14"),
    ("G_VARIANT_PARSE_ERROR_UNKNOWN_KEYWORD", "15"),
    ("G_VARIANT_PARSE_ERROR_UNTERMINATED_STRING_CONSTANT", "16"),
    ("G_VARIANT_PARSE_ERROR_VALUE_EXPECTED", "17"),
    ("G_WIN32_MSG_HANDLE", "19981206"),
];


