
#line 1 "ragel/i18n/el.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/el.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 21, 22, 23, 24, 25, 
	26, 27, 28, 30, 32, 43, 44, 45, 
	47, 49, 54, 59, 64, 69, 73, 77, 
	79, 80, 81, 82, 83, 84, 85, 86, 
	87, 88, 89, 90, 91, 92, 93, 94, 
	99, 106, 111, 115, 121, 124, 126, 132, 
	143, 144, 145, 146, 147, 148, 149, 151, 
	152, 153, 154, 155, 156, 157, 158, 159, 
	160, 161, 162, 163, 164, 165, 166, 167, 
	170, 173, 176, 179, 182, 185, 188, 189, 
	190, 191, 192, 193, 194, 195, 196, 197, 
	198, 199, 200, 201, 202, 203, 204, 205, 
	206, 207, 208, 216, 222, 224, 226, 228, 
	230, 232, 234, 236, 238, 240, 242, 244, 
	246, 248, 250, 252, 254, 256, 258, 260, 
	271, 273, 275, 277, 279, 281, 283, 285, 
	287, 289, 291, 293, 295, 297, 299, 301, 
	303, 305, 308, 310, 312, 314, 316, 318, 
	320, 322, 324, 326, 328, 330, 332, 334, 
	336, 338, 340, 342, 344, 346, 348, 350, 
	352, 354, 356, 358, 360, 362, 364, 366, 
	368, 370, 372, 374, 376, 378, 380, 382, 
	384, 386, 388, 390, 392, 394, 396, 398, 
	400, 402, 404, 406, 408, 410, 412, 414, 
	416, 418, 420, 422, 424, 427, 429, 431, 
	433, 435, 437, 439, 441, 443, 445, 447, 
	449, 451, 453, 455, 457, 459, 461, 463, 
	465, 467, 469, 471, 473, 475, 477, 479, 
	481, 483, 484, 485, 486, 487, 488, 489, 
	490, 491, 492, 493, 494, 495, 496, 497, 
	498, 499, 500, 501, 502, 503, 504, 506, 
	507, 508, 509, 510, 511, 512, 513, 514, 
	515, 516, 517, 518, 519, 520, 521, 522, 
	523, 524, 525, 526, 527, 528, 529, 536, 
	539, 541, 543, 545, 547, 549, 551, 553, 
	555, 557, 559, 561, 563, 565, 567, 569, 
	571, 573, 575, 577, 579, 581, 583, 585, 
	587, 589, 591, 593, 595, 597, 599, 601, 
	603, 605, 607, 609, 610, 611, 612, 613, 
	614, 615, 616, 617, 618, 619, 620, 621, 
	622, 623, 624, 625, 626, 627, 628, 629, 
	630, 631, 632, 633, 634, 635, 636, 637, 
	638, 639, 640, 641, 642, 643, 652, 660, 
	662, 664, 666, 668, 670, 672, 674, 676, 
	678, 680, 682, 684, 686, 689, 691, 693, 
	695, 697, 699, 701, 703, 705, 707, 709, 
	711, 713, 715, 717, 719, 721, 733, 734, 
	735, 736, 737, 738, 739, 741, 743, 745, 
	747, 749, 751, 753, 755, 757, 759, 761, 
	763, 765, 767, 769, 771, 773, 775, 777, 
	779, 781, 783, 785, 787, 789, 791, 793, 
	795, 797, 799, 801, 803, 805, 807, 809, 
	811, 813, 815, 817, 819, 821, 823, 825, 
	827, 829, 831, 833, 835, 837, 839, 841, 
	843, 845, 847, 849, 851, 853, 855, 857, 
	859, 861, 863, 865, 867, 869, 871, 873, 
	875, 877, 879, 880, 881, 882, 883, 884, 
	885, 886, 887, 888, 889, 890, 892, 893, 
	894, 895, 904, 914, 916, 918, 920, 922, 
	924, 926, 928, 930, 932, 934, 936, 938, 
	940, 943, 945, 947, 949, 951, 953, 955, 
	957, 959, 961, 963, 965, 967, 969, 971, 
	973, 975, 987, 988, 989, 990, 991, 992, 
	993, 995, 997, 999, 1001, 1003, 1005, 1007, 
	1009, 1011, 1013, 1015, 1017, 1019, 1021, 1023, 
	1025, 1027, 1029, 1031, 1033, 1035, 1037, 1039, 
	1041, 1043, 1045, 1047, 1049, 1051, 1053, 1055, 
	1057, 1059, 1061, 1063, 1065, 1067, 1069, 1071, 
	1073, 1075, 1077, 1079, 1081, 1083, 1085, 1087, 
	1089, 1091, 1093, 1095, 1097, 1099, 1101, 1103, 
	1105, 1107, 1109, 1111, 1113, 1115, 1117, 1119, 
	1121, 1123, 1125, 1127, 1129, 1131, 1133, 1135, 
	1137, 1139, 1141, 1143, 1145, 1147, 1149, 1151, 
	1153, 1155, 1157, 1159, 1161, 1163, 1165, 1167, 
	1169, 1171, 1173, 1175, 1177, 1179, 1181, 1183, 
	1185, 1187, 1189, 1191, 1193, 1195, 1197, 1199, 
	1201, 1203, 1205, 1207, 1209, 1211, 1213, 1215, 
	1217, 1219, 1221, 1223, 1224, 1225, 1226, 1227, 
	1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 
	1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 
	1244, 1245, 1246, 1255, 1264, 1266, 1268, 1270, 
	1272, 1274, 1276, 1278, 1280, 1282, 1284, 1286, 
	1288, 1290, 1293, 1295, 1297, 1299, 1301, 1303, 
	1305, 1307, 1309, 1311, 1313, 1315, 1317, 1319, 
	1321, 1323, 1325, 1337, 1338, 1339, 1340, 1341, 
	1342, 1343, 1345, 1347, 1349, 1351, 1353, 1355, 
	1357, 1359, 1361, 1363, 1365, 1367, 1369, 1371, 
	1373, 1375, 1377, 1379, 1381, 1383, 1385, 1387, 
	1389, 1391, 1393, 1395, 1397, 1399, 1401, 1403, 
	1405, 1407, 1409, 1411, 1413, 1415, 1417, 1419, 
	1421, 1423, 1425, 1427, 1429, 1431, 1433, 1435, 
	1437, 1439, 1441, 1443, 1445, 1447, 1449, 1451, 
	1453, 1455, 1457, 1459, 1461, 1463, 1465, 1467, 
	1469, 1471, 1473, 1475, 1477, 1479, 1481, 1483, 
	1485, 1487, 1489, 1491, 1493, 1495, 1497, 1499, 
	1501, 1503, 1505, 1507, 1509, 1511, 1513, 1515, 
	1517, 1519, 1521, 1523, 1525, 1527, 1529, 1531, 
	1533, 1535, 1537, 1539, 1541, 1543, 1545, 1547, 
	1549, 1550, 1551
};

static const char _lexer_trans_keys[] = {
	-50, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -116, -111, -108, -102, 
	-101, -96, -93, -92, -91, -49, -124, -50, 
	-79, -50, -67, 32, 10, 13, 10, 13, 
	-50, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, 34, 34, 10, 13, 10, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 9, 
	13, 10, 32, 9, 13, 10, 13, 10, 
	95, 70, 69, 65, 84, 85, 82, 69, 
	95, 69, 78, 68, 95, 37, 13, 32, 
	64, 9, 10, 9, 10, 13, 32, 64, 
	11, 12, 10, 32, 64, 9, 13, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, -50, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, -50, 
	-69, -50, -69, -50, -84, -50, -49, -75, 
	-50, -76, -50, -65, -50, -68, -50, -83, 
	-50, -67, -50, -65, -49, -123, 32, -49, 
	10, 13, -116, 10, 13, -49, 10, 13, 
	-124, 10, 13, -50, 10, 13, -71, 10, 
	13, 10, 13, 32, -123, -50, -67, -50, 
	-79, -49, -124, -49, -116, -49, -124, -50, 
	-73, -49, -124, -50, -79, 58, 10, 10, 
	-50, 10, 32, 35, 37, 64, 9, 13, 
	-108, -101, -96, -93, -91, 10, -49, 10, 
	-123, 10, -50, 10, -67, 10, -50, 10, 
	-79, 10, -49, 10, -124, 10, -49, 10, 
	-116, 10, -49, 10, -124, 10, -50, 10, 
	-73, 10, -49, 10, -124, 10, -50, 10, 
	-79, 10, 10, 58, -50, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, -50, 
	10, -75, 10, -50, 10, -71, 10, -49, 
	10, -124, 10, -50, 10, -65, 10, -49, 
	10, -123, 10, -49, 10, -127, 10, -50, 
	10, -77, 10, -50, 10, -81, 10, -50, 
	10, -79, -75, 10, -49, 10, -127, 10, 
	-50, 10, -79, 10, -50, 10, -76, 10, 
	-50, 10, -75, 10, -50, 10, -81, 10, 
	-50, 10, -77, 10, -50, 10, -68, 10, 
	-50, 10, -79, 10, -49, 10, -127, 10, 
	-50, 10, -71, 10, -50, 10, -77, 10, 
	-49, 10, -127, 10, -50, 10, -79, 10, 
	-49, 10, -122, 10, -50, 10, -82, 10, 
	10, 32, -50, 10, -93, 10, -50, 10, 
	-75, 10, -50, 10, -67, 10, -50, 10, 
	-79, 10, -49, 10, -127, 10, -50, 10, 
	-81, 10, -50, 10, -65, 10, -49, 10, 
	-123, 10, -50, 10, -75, 10, -50, 10, 
	-67, 10, -50, 10, -84, 10, -49, 10, 
	-127, 10, -50, 10, -71, 10, -50, 10, 
	-79, -65, 10, -49, 10, -128, 10, -49, 
	10, -116, 10, -50, 10, -78, 10, -50, 
	10, -79, 10, -50, 10, -72, 10, -49, 
	10, -127, 10, -50, 10, -65, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -50, -79, -50, -71, -50, 
	-75, -50, -71, -49, -124, -50, -65, -49, 
	-123, -49, -127, -50, -77, -50, -81, -50, 
	-79, -75, -49, -127, -50, -79, -50, -76, 
	-50, -75, -50, -81, -50, -77, -50, -68, 
	-50, -79, -49, -124, -50, -79, 58, 10, 
	10, -50, 10, 32, 35, 124, 9, 13, 
	-108, -101, 10, -49, 10, -123, 10, -50, 
	10, -67, 10, -50, 10, -79, 10, -49, 
	10, -124, 10, -49, 10, -116, 10, -49, 
	10, -124, 10, -50, 10, -73, 10, -49, 
	10, -124, 10, -50, 10, -79, 10, 10, 
	58, -50, 10, -75, 10, -50, 10, -71, 
	10, -49, 10, -124, 10, -50, 10, -65, 
	10, -49, 10, -123, 10, -49, 10, -127, 
	10, -50, 10, -77, 10, -50, 10, -81, 
	10, -49, -127, -50, -71, -50, -77, -49, 
	-127, -50, -79, -49, -122, -50, -82, 32, 
	-50, -93, -50, -75, -50, -67, -50, -79, 
	-49, -127, -50, -81, -50, -65, -49, -123, 
	58, 10, 10, -50, 10, 32, 35, 37, 
	42, 64, 9, 13, -116, -111, -108, -102, 
	-101, -93, -92, 10, -49, 10, -124, 10, 
	-50, 10, -79, 10, -50, 10, -67, 10, 
	10, 32, -50, 10, -69, 10, -50, 10, 
	-69, 10, -50, 10, -84, 10, -50, -49, 
	10, -75, 10, -50, 10, -76, 10, -50, 
	10, -65, 10, -50, 10, -68, 10, -50, 
	10, -83, 10, -50, 10, -67, 10, -50, 
	10, -65, 10, -49, 10, -123, 10, 10, 
	32, -50, -49, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -116, -49, -124, 
	-50, -71, 32, -123, 10, -50, 10, -67, 
	10, -50, 10, -79, 10, -49, 10, -124, 
	10, -49, 10, -116, 10, -49, 10, -124, 
	10, -50, 10, -73, 10, -49, 10, -124, 
	10, -50, 10, -79, 10, 10, 58, -50, 
	10, -79, 10, -50, 10, -71, 10, -50, 
	10, -75, 10, -50, 10, -71, 10, -49, 
	10, -124, 10, -50, 10, -65, 10, -49, 
	10, -123, 10, -49, 10, -127, 10, -50, 
	10, -77, 10, -50, 10, -81, 10, -50, 
	10, -75, 10, -50, 10, -67, 10, -50, 
	10, -84, 10, -49, 10, -127, 10, -50, 
	10, -71, 10, -50, 10, -65, 10, -49, 
	10, -116, 10, -49, 10, -124, 10, -50, 
	10, -75, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, -50, 
	-75, -50, -67, -50, -84, -49, -127, -50, 
	-71, -50, -79, -65, 58, 10, 10, -50, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-116, -111, -108, -102, -101, -96, -93, -92, 
	-91, 10, -49, 10, -124, 10, -50, 10, 
	-79, 10, -50, 10, -67, 10, 10, 32, 
	-50, 10, -69, 10, -50, 10, -69, 10, 
	-50, 10, -84, 10, -50, -49, 10, -75, 
	10, -50, 10, -76, 10, -50, 10, -65, 
	10, -50, 10, -68, 10, -50, 10, -83, 
	10, -50, 10, -67, 10, -50, 10, -65, 
	10, -49, 10, -123, 10, 10, 32, -50, 
	-49, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -116, -49, -124, -50, -71, 
	32, -123, 10, -50, 10, -67, 10, -50, 
	10, -79, 10, -49, 10, -124, 10, -49, 
	10, -116, 10, -49, 10, -124, 10, -50, 
	10, -73, 10, -49, 10, -124, 10, -50, 
	10, -79, 10, 10, 58, -50, 10, -79, 
	10, -50, 10, -71, 10, -50, 10, -75, 
	10, -50, 10, -71, 10, -49, 10, -124, 
	10, -50, 10, -65, 10, -49, 10, -123, 
	10, -49, 10, -127, 10, -50, 10, -77, 
	10, -50, 10, -81, 10, -50, 10, -75, 
	10, -49, 10, -127, 10, -50, 10, -71, 
	10, -50, 10, -77, 10, -49, 10, -127, 
	10, -50, 10, -79, 10, -49, 10, -122, 
	10, -50, 10, -82, 10, 10, 32, -50, 
	10, -93, 10, -50, 10, -75, 10, -50, 
	10, -67, 10, -50, 10, -79, 10, -49, 
	10, -127, 10, -50, 10, -81, 10, -50, 
	10, -65, 10, -49, 10, -123, 10, -50, 
	10, -75, 10, -50, 10, -67, 10, -50, 
	10, -84, 10, -49, 10, -127, 10, -50, 
	10, -71, 10, -50, 10, -65, 10, -49, 
	10, -116, 10, -49, 10, -124, 10, -50, 
	10, -75, 10, -49, 10, -128, 10, -49, 
	10, -116, 10, -50, 10, -78, 10, -50, 
	10, -79, 10, -50, 10, -72, 10, -49, 
	10, -127, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, -49, 
	-116, -49, -124, -50, -75, -49, -128, -49, 
	-116, -50, -78, -50, -79, -50, -72, -49, 
	-127, -50, -65, 58, 10, 10, -50, 10, 
	32, 35, 37, 42, 64, 9, 13, -116, 
	-111, -108, -102, -101, -96, -93, -92, 10, 
	-49, 10, -124, 10, -50, 10, -79, 10, 
	-50, 10, -67, 10, 10, 32, -50, 10, 
	-69, 10, -50, 10, -69, 10, -50, 10, 
	-84, 10, -50, -49, 10, -75, 10, -50, 
	10, -76, 10, -50, 10, -65, 10, -50, 
	10, -68, 10, -50, 10, -83, 10, -50, 
	10, -67, 10, -50, 10, -65, 10, -49, 
	10, -123, 10, 10, 32, -50, -49, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, -116, -49, -124, -50, -71, 32, -123, 
	10, -50, 10, -67, 10, -50, 10, -79, 
	10, -49, 10, -124, 10, -49, 10, -116, 
	10, -49, 10, -124, 10, -50, 10, -73, 
	10, -49, 10, -124, 10, -50, 10, -79, 
	10, 10, 58, -50, 10, -79, 10, -50, 
	10, -71, 10, -50, 10, -75, 10, -50, 
	10, -71, 10, -49, 10, -124, 10, -50, 
	10, -65, 10, -49, 10, -123, 10, -49, 
	10, -127, 10, -50, 10, -77, 10, -50, 
	10, -81, 10, -50, 10, -75, 10, -49, 
	10, -127, 10, -50, 10, -71, 10, -50, 
	10, -77, 10, -49, 10, -127, 10, -50, 
	10, -79, 10, -49, 10, -122, 10, -50, 
	10, -82, 10, 10, 32, -50, 10, -93, 
	10, -50, 10, -75, 10, -50, 10, -67, 
	10, -50, 10, -79, 10, -49, 10, -127, 
	10, -50, 10, -81, 10, -50, 10, -65, 
	10, -49, 10, -123, 10, -50, 10, -75, 
	10, -50, 10, -67, 10, -50, 10, -84, 
	10, -49, 10, -127, 10, -50, 10, -71, 
	10, -50, 10, -65, 10, -49, 10, -116, 
	10, -49, 10, -124, 10, -50, 10, -75, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 9, 1, 1, 1, 1, 1, 
	1, 1, 2, 2, 9, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	5, 3, 2, 4, 3, 2, 4, 9, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	3, 3, 3, 3, 3, 3, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 6, 6, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 9, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 5, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 8, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 10, 1, 1, 
	1, 1, 1, 1, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	1, 7, 10, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 10, 1, 1, 1, 1, 1, 1, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 7, 9, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 10, 1, 1, 1, 1, 1, 
	1, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 1, 0, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 22, 24, 26, 28, 30, 
	32, 34, 36, 39, 42, 53, 55, 57, 
	60, 63, 68, 73, 78, 83, 87, 91, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	110, 112, 114, 116, 118, 120, 122, 124, 
	129, 136, 141, 145, 151, 155, 158, 164, 
	175, 177, 179, 181, 183, 185, 187, 190, 
	192, 194, 196, 198, 200, 202, 204, 206, 
	208, 210, 212, 214, 216, 218, 220, 222, 
	226, 230, 234, 238, 242, 246, 250, 252, 
	254, 256, 258, 260, 262, 264, 266, 268, 
	270, 272, 274, 276, 278, 280, 282, 284, 
	286, 288, 290, 298, 305, 308, 311, 314, 
	317, 320, 323, 326, 329, 332, 335, 338, 
	341, 344, 347, 350, 353, 356, 359, 362, 
	373, 376, 379, 382, 385, 388, 391, 394, 
	397, 400, 403, 406, 409, 412, 415, 418, 
	421, 424, 428, 431, 434, 437, 440, 443, 
	446, 449, 452, 455, 458, 461, 464, 467, 
	470, 473, 476, 479, 482, 485, 488, 491, 
	494, 497, 500, 503, 506, 509, 512, 515, 
	518, 521, 524, 527, 530, 533, 536, 539, 
	542, 545, 548, 551, 554, 557, 560, 563, 
	566, 569, 572, 575, 578, 581, 584, 587, 
	590, 593, 596, 599, 602, 606, 609, 612, 
	615, 618, 621, 624, 627, 630, 633, 636, 
	639, 642, 645, 648, 651, 654, 657, 660, 
	663, 666, 669, 672, 675, 678, 681, 684, 
	687, 690, 692, 694, 696, 698, 700, 702, 
	704, 706, 708, 710, 712, 714, 716, 718, 
	720, 722, 724, 726, 728, 730, 732, 735, 
	737, 739, 741, 743, 745, 747, 749, 751, 
	753, 755, 757, 759, 761, 763, 765, 767, 
	769, 771, 773, 775, 777, 779, 781, 788, 
	792, 795, 798, 801, 804, 807, 810, 813, 
	816, 819, 822, 825, 828, 831, 834, 837, 
	840, 843, 846, 849, 852, 855, 858, 861, 
	864, 867, 870, 873, 876, 879, 882, 885, 
	888, 891, 894, 897, 899, 901, 903, 905, 
	907, 909, 911, 913, 915, 917, 919, 921, 
	923, 925, 927, 929, 931, 933, 935, 937, 
	939, 941, 943, 945, 947, 949, 951, 953, 
	955, 957, 959, 961, 963, 965, 974, 983, 
	986, 989, 992, 995, 998, 1001, 1004, 1007, 
	1010, 1013, 1016, 1019, 1022, 1026, 1029, 1032, 
	1035, 1038, 1041, 1044, 1047, 1050, 1053, 1056, 
	1059, 1062, 1065, 1068, 1071, 1074, 1086, 1088, 
	1090, 1092, 1094, 1096, 1098, 1101, 1104, 1107, 
	1110, 1113, 1116, 1119, 1122, 1125, 1128, 1131, 
	1134, 1137, 1140, 1143, 1146, 1149, 1152, 1155, 
	1158, 1161, 1164, 1167, 1170, 1173, 1176, 1179, 
	1182, 1185, 1188, 1191, 1194, 1197, 1200, 1203, 
	1206, 1209, 1212, 1215, 1218, 1221, 1224, 1227, 
	1230, 1233, 1236, 1239, 1242, 1245, 1248, 1251, 
	1254, 1257, 1260, 1263, 1266, 1269, 1272, 1275, 
	1278, 1281, 1284, 1287, 1290, 1293, 1296, 1299, 
	1302, 1305, 1308, 1310, 1312, 1314, 1316, 1318, 
	1320, 1322, 1324, 1326, 1328, 1330, 1333, 1335, 
	1337, 1339, 1348, 1359, 1362, 1365, 1368, 1371, 
	1374, 1377, 1380, 1383, 1386, 1389, 1392, 1395, 
	1398, 1402, 1405, 1408, 1411, 1414, 1417, 1420, 
	1423, 1426, 1429, 1432, 1435, 1438, 1441, 1444, 
	1447, 1450, 1462, 1464, 1466, 1468, 1470, 1472, 
	1474, 1477, 1480, 1483, 1486, 1489, 1492, 1495, 
	1498, 1501, 1504, 1507, 1510, 1513, 1516, 1519, 
	1522, 1525, 1528, 1531, 1534, 1537, 1540, 1543, 
	1546, 1549, 1552, 1555, 1558, 1561, 1564, 1567, 
	1570, 1573, 1576, 1579, 1582, 1585, 1588, 1591, 
	1594, 1597, 1600, 1603, 1606, 1609, 1612, 1615, 
	1618, 1621, 1624, 1627, 1630, 1633, 1636, 1639, 
	1642, 1645, 1648, 1651, 1654, 1657, 1660, 1663, 
	1666, 1669, 1672, 1675, 1678, 1681, 1684, 1687, 
	1690, 1693, 1696, 1699, 1702, 1705, 1708, 1711, 
	1714, 1717, 1720, 1723, 1726, 1729, 1732, 1735, 
	1738, 1741, 1744, 1747, 1750, 1753, 1756, 1759, 
	1762, 1765, 1768, 1771, 1774, 1777, 1780, 1783, 
	1786, 1789, 1792, 1795, 1798, 1801, 1804, 1807, 
	1810, 1813, 1816, 1819, 1821, 1823, 1825, 1827, 
	1829, 1831, 1833, 1835, 1837, 1839, 1841, 1843, 
	1845, 1847, 1849, 1851, 1853, 1855, 1857, 1859, 
	1861, 1863, 1865, 1874, 1884, 1887, 1890, 1893, 
	1896, 1899, 1902, 1905, 1908, 1911, 1914, 1917, 
	1920, 1923, 1927, 1930, 1933, 1936, 1939, 1942, 
	1945, 1948, 1951, 1954, 1957, 1960, 1963, 1966, 
	1969, 1972, 1975, 1987, 1989, 1991, 1993, 1995, 
	1997, 1999, 2002, 2005, 2008, 2011, 2014, 2017, 
	2020, 2023, 2026, 2029, 2032, 2035, 2038, 2041, 
	2044, 2047, 2050, 2053, 2056, 2059, 2062, 2065, 
	2068, 2071, 2074, 2077, 2080, 2083, 2086, 2089, 
	2092, 2095, 2098, 2101, 2104, 2107, 2110, 2113, 
	2116, 2119, 2122, 2125, 2128, 2131, 2134, 2137, 
	2140, 2143, 2146, 2149, 2152, 2155, 2158, 2161, 
	2164, 2167, 2170, 2173, 2176, 2179, 2182, 2185, 
	2188, 2191, 2194, 2197, 2200, 2203, 2206, 2209, 
	2212, 2215, 2218, 2221, 2224, 2227, 2230, 2233, 
	2236, 2239, 2242, 2245, 2248, 2251, 2254, 2257, 
	2260, 2263, 2266, 2269, 2272, 2275, 2278, 2281, 
	2284, 2287, 2290, 2293, 2296, 2299, 2302, 2305, 
	2308, 2310, 2312
};

static const short _lexer_trans_targs[] = {
	2, 784, 12, 12, 13, 23, 25, 9, 
	39, 42, 12, 0, 3, 48, 54, 225, 
	229, 245, 450, 619, 625, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 12, 24, 11, 12, 
	24, 11, 2, 12, 12, 13, 23, 25, 
	9, 39, 42, 12, 0, 14, 0, 15, 
	0, 17, 16, 16, 17, 16, 16, 18, 
	18, 19, 18, 18, 18, 18, 19, 18, 
	18, 18, 18, 20, 18, 18, 18, 18, 
	21, 18, 18, 12, 22, 22, 0, 12, 
	22, 22, 0, 12, 24, 23, 12, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 31, 0, 32, 0, 33, 0, 
	34, 0, 35, 0, 36, 0, 37, 0, 
	38, 0, 786, 0, 0, 0, 0, 0, 
	40, 41, 12, 41, 41, 39, 40, 40, 
	12, 41, 39, 41, 0, 42, 43, 42, 
	0, 47, 46, 45, 43, 46, 44, 0, 
	45, 43, 44, 0, 45, 44, 47, 46, 
	45, 43, 46, 44, 2, 47, 47, 13, 
	23, 25, 9, 39, 42, 47, 0, 49, 
	0, 50, 0, 51, 0, 52, 0, 53, 
	0, 9, 0, 55, 78, 0, 56, 0, 
	57, 0, 58, 0, 59, 0, 60, 0, 
	61, 0, 62, 0, 63, 0, 64, 0, 
	65, 0, 66, 0, 67, 0, 68, 0, 
	69, 0, 70, 0, 71, 0, 72, 12, 
	24, 11, 73, 12, 24, 11, 74, 12, 
	24, 11, 75, 12, 24, 11, 76, 12, 
	24, 11, 77, 12, 24, 11, 12, 24, 
	10, 11, 79, 0, 80, 0, 81, 0, 
	82, 0, 83, 0, 84, 0, 85, 0, 
	86, 0, 87, 0, 88, 0, 89, 0, 
	90, 0, 91, 0, 92, 0, 93, 0, 
	94, 0, 95, 0, 96, 0, 98, 97, 
	98, 97, 99, 98, 98, 12, 211, 12, 
	98, 97, 100, 120, 136, 185, 197, 98, 
	97, 101, 98, 97, 102, 98, 97, 103, 
	98, 97, 104, 98, 97, 105, 98, 97, 
	106, 98, 97, 107, 98, 97, 108, 98, 
	97, 109, 98, 97, 110, 98, 97, 111, 
	98, 97, 112, 98, 97, 113, 98, 97, 
	114, 98, 97, 115, 98, 97, 116, 98, 
	97, 117, 98, 97, 118, 98, 97, 98, 
	119, 97, 2, 12, 12, 13, 23, 25, 
	9, 39, 42, 12, 0, 121, 98, 97, 
	122, 98, 97, 123, 98, 97, 124, 98, 
	97, 125, 98, 97, 126, 98, 97, 127, 
	98, 97, 128, 98, 97, 129, 98, 97, 
	130, 98, 97, 131, 98, 97, 132, 98, 
	97, 133, 98, 97, 134, 98, 97, 135, 
	98, 97, 116, 98, 97, 137, 98, 97, 
	138, 154, 98, 97, 139, 98, 97, 140, 
	98, 97, 141, 98, 97, 142, 98, 97, 
	143, 98, 97, 144, 98, 97, 145, 98, 
	97, 146, 98, 97, 147, 98, 97, 148, 
	98, 97, 149, 98, 97, 150, 98, 97, 
	151, 98, 97, 152, 98, 97, 153, 98, 
	97, 114, 98, 97, 155, 98, 97, 156, 
	98, 97, 157, 98, 97, 158, 98, 97, 
	159, 98, 97, 160, 98, 97, 161, 98, 
	97, 162, 98, 97, 163, 98, 97, 164, 
	98, 97, 165, 98, 97, 166, 98, 97, 
	167, 98, 97, 168, 98, 97, 98, 169, 
	97, 170, 98, 97, 171, 98, 97, 172, 
	98, 97, 173, 98, 97, 174, 98, 97, 
	175, 98, 97, 176, 98, 97, 177, 98, 
	97, 178, 98, 97, 179, 98, 97, 180, 
	98, 97, 181, 98, 97, 182, 98, 97, 
	183, 98, 97, 184, 98, 97, 118, 98, 
	97, 186, 98, 97, 187, 98, 97, 188, 
	98, 97, 189, 98, 97, 190, 98, 97, 
	191, 98, 97, 192, 98, 97, 193, 98, 
	97, 194, 98, 97, 195, 98, 97, 196, 
	98, 97, 118, 118, 98, 97, 198, 98, 
	97, 199, 98, 97, 200, 98, 97, 201, 
	98, 97, 202, 98, 97, 203, 98, 97, 
	204, 98, 97, 205, 98, 97, 206, 98, 
	97, 207, 98, 97, 208, 98, 97, 209, 
	98, 97, 210, 98, 97, 118, 98, 97, 
	98, 212, 97, 98, 213, 97, 98, 214, 
	97, 98, 215, 97, 98, 216, 97, 98, 
	217, 97, 98, 218, 97, 98, 219, 97, 
	98, 220, 97, 98, 221, 97, 98, 222, 
	97, 98, 223, 97, 98, 224, 97, 98, 
	12, 97, 226, 0, 227, 0, 228, 0, 
	9, 0, 230, 0, 231, 0, 232, 0, 
	233, 0, 234, 0, 235, 0, 236, 0, 
	237, 0, 238, 0, 239, 0, 240, 0, 
	241, 0, 242, 0, 243, 0, 244, 0, 
	93, 0, 246, 0, 247, 307, 0, 248, 
	0, 249, 0, 250, 0, 251, 0, 252, 
	0, 253, 0, 254, 0, 255, 0, 256, 
	0, 257, 0, 258, 0, 259, 0, 260, 
	0, 261, 0, 262, 0, 263, 0, 264, 
	0, 265, 0, 266, 0, 267, 0, 268, 
	0, 270, 269, 270, 269, 271, 270, 270, 
	12, 12, 270, 269, 272, 291, 270, 269, 
	273, 270, 269, 274, 270, 269, 275, 270, 
	269, 276, 270, 269, 277, 270, 269, 278, 
	270, 269, 279, 270, 269, 280, 270, 269, 
	281, 270, 269, 282, 270, 269, 283, 270, 
	269, 284, 270, 269, 285, 270, 269, 286, 
	270, 269, 287, 270, 269, 288, 270, 269, 
	289, 270, 269, 290, 270, 269, 270, 119, 
	269, 292, 270, 269, 293, 270, 269, 294, 
	270, 269, 295, 270, 269, 296, 270, 269, 
	297, 270, 269, 298, 270, 269, 299, 270, 
	269, 300, 270, 269, 301, 270, 269, 302, 
	270, 269, 303, 270, 269, 304, 270, 269, 
	305, 270, 269, 306, 270, 269, 288, 270, 
	269, 308, 0, 309, 0, 310, 0, 311, 
	0, 312, 0, 313, 0, 314, 0, 315, 
	0, 316, 0, 317, 0, 318, 0, 319, 
	0, 320, 0, 321, 0, 322, 0, 323, 
	0, 324, 0, 325, 0, 326, 0, 327, 
	0, 328, 0, 329, 0, 330, 0, 331, 
	0, 332, 0, 333, 0, 334, 0, 335, 
	0, 336, 0, 337, 0, 338, 0, 339, 
	0, 341, 340, 341, 340, 342, 341, 341, 
	12, 436, 349, 12, 341, 340, 343, 350, 
	356, 398, 402, 418, 430, 341, 340, 344, 
	341, 340, 345, 341, 340, 346, 341, 340, 
	347, 341, 340, 348, 341, 340, 349, 341, 
	340, 341, 119, 340, 351, 341, 340, 352, 
	341, 340, 353, 341, 340, 354, 341, 340, 
	355, 341, 340, 349, 341, 340, 357, 380, 
	341, 340, 358, 341, 340, 359, 341, 340, 
	360, 341, 340, 361, 341, 340, 362, 341, 
	340, 363, 341, 340, 364, 341, 340, 365, 
	341, 340, 366, 341, 340, 367, 341, 340, 
	368, 341, 340, 369, 341, 340, 370, 341, 
	340, 371, 341, 340, 372, 341, 340, 341, 
	373, 340, 2, 374, 12, 12, 13, 23, 
	25, 9, 39, 42, 12, 0, 375, 0, 
	376, 0, 377, 0, 378, 0, 379, 0, 
	119, 0, 381, 341, 340, 382, 341, 340, 
	383, 341, 340, 384, 341, 340, 385, 341, 
	340, 386, 341, 340, 387, 341, 340, 388, 
	341, 340, 389, 341, 340, 390, 341, 340, 
	391, 341, 340, 392, 341, 340, 393, 341, 
	340, 394, 341, 340, 395, 341, 340, 396, 
	341, 340, 397, 341, 340, 341, 119, 340, 
	399, 341, 340, 400, 341, 340, 401, 341, 
	340, 349, 341, 340, 403, 341, 340, 404, 
	341, 340, 405, 341, 340, 406, 341, 340, 
	407, 341, 340, 408, 341, 340, 409, 341, 
	340, 410, 341, 340, 411, 341, 340, 412, 
	341, 340, 413, 341, 340, 414, 341, 340, 
	415, 341, 340, 416, 341, 340, 417, 341, 
	340, 395, 341, 340, 419, 341, 340, 420, 
	341, 340, 421, 341, 340, 422, 341, 340, 
	423, 341, 340, 424, 341, 340, 425, 341, 
	340, 426, 341, 340, 427, 341, 340, 428, 
	341, 340, 429, 341, 340, 397, 341, 340, 
	431, 341, 340, 432, 341, 340, 433, 341, 
	340, 434, 341, 340, 435, 341, 340, 349, 
	341, 340, 341, 437, 340, 341, 438, 340, 
	341, 439, 340, 341, 440, 340, 341, 441, 
	340, 341, 442, 340, 341, 443, 340, 341, 
	444, 340, 341, 445, 340, 341, 446, 340, 
	341, 447, 340, 341, 448, 340, 341, 449, 
	340, 341, 12, 340, 451, 0, 452, 0, 
	453, 0, 454, 0, 455, 0, 456, 0, 
	457, 0, 458, 0, 459, 0, 460, 0, 
	461, 0, 267, 462, 0, 463, 0, 465, 
	464, 465, 464, 466, 465, 465, 12, 605, 
	473, 12, 465, 464, 467, 474, 480, 522, 
	526, 542, 575, 587, 593, 465, 464, 468, 
	465, 464, 469, 465, 464, 470, 465, 464, 
	471, 465, 464, 472, 465, 464, 473, 465, 
	464, 465, 119, 464, 475, 465, 464, 476, 
	465, 464, 477, 465, 464, 478, 465, 464, 
	479, 465, 464, 473, 465, 464, 481, 504, 
	465, 464, 482, 465, 464, 483, 465, 464, 
	484, 465, 464, 485, 465, 464, 486, 465, 
	464, 487, 465, 464, 488, 465, 464, 489, 
	465, 464, 490, 465, 464, 491, 465, 464, 
	492, 465, 464, 493, 465, 464, 494, 465, 
	464, 495, 465, 464, 496, 465, 464, 465, 
	497, 464, 2, 498, 12, 12, 13, 23, 
	25, 9, 39, 42, 12, 0, 499, 0, 
	500, 0, 501, 0, 502, 0, 503, 0, 
	119, 0, 505, 465, 464, 506, 465, 464, 
	507, 465, 464, 508, 465, 464, 509, 465, 
	464, 510, 465, 464, 511, 465, 464, 512, 
	465, 464, 513, 465, 464, 514, 465, 464, 
	515, 465, 464, 516, 465, 464, 517, 465, 
	464, 518, 465, 464, 519, 465, 464, 520, 
	465, 464, 521, 465, 464, 465, 119, 464, 
	523, 465, 464, 524, 465, 464, 525, 465, 
	464, 473, 465, 464, 527, 465, 464, 528, 
	465, 464, 529, 465, 464, 530, 465, 464, 
	531, 465, 464, 532, 465, 464, 533, 465, 
	464, 534, 465, 464, 535, 465, 464, 536, 
	465, 464, 537, 465, 464, 538, 465, 464, 
	539, 465, 464, 540, 465, 464, 541, 465, 
	464, 519, 465, 464, 543, 465, 464, 544, 
	465, 464, 545, 465, 464, 546, 465, 464, 
	547, 465, 464, 548, 465, 464, 549, 465, 
	464, 550, 465, 464, 551, 465, 464, 552, 
	465, 464, 553, 465, 464, 554, 465, 464, 
	555, 465, 464, 556, 465, 464, 557, 465, 
	464, 558, 465, 464, 465, 559, 464, 560, 
	465, 464, 561, 465, 464, 562, 465, 464, 
	563, 465, 464, 564, 465, 464, 565, 465, 
	464, 566, 465, 464, 567, 465, 464, 568, 
	465, 464, 569, 465, 464, 570, 465, 464, 
	571, 465, 464, 572, 465, 464, 573, 465, 
	464, 574, 465, 464, 521, 465, 464, 576, 
	465, 464, 577, 465, 464, 578, 465, 464, 
	579, 465, 464, 580, 465, 464, 581, 465, 
	464, 582, 465, 464, 583, 465, 464, 584, 
	465, 464, 585, 465, 464, 586, 465, 464, 
	521, 465, 464, 588, 465, 464, 589, 465, 
	464, 590, 465, 464, 591, 465, 464, 592, 
	465, 464, 473, 465, 464, 594, 465, 464, 
	595, 465, 464, 596, 465, 464, 597, 465, 
	464, 598, 465, 464, 599, 465, 464, 600, 
	465, 464, 601, 465, 464, 602, 465, 464, 
	603, 465, 464, 604, 465, 464, 585, 465, 
	464, 465, 606, 464, 465, 607, 464, 465, 
	608, 464, 465, 609, 464, 465, 610, 464, 
	465, 611, 464, 465, 612, 464, 465, 613, 
	464, 465, 614, 464, 465, 615, 464, 465, 
	616, 464, 465, 617, 464, 465, 618, 464, 
	465, 12, 464, 620, 0, 621, 0, 622, 
	0, 623, 0, 624, 0, 9, 0, 626, 
	0, 627, 0, 628, 0, 629, 0, 630, 
	0, 631, 0, 632, 0, 633, 0, 634, 
	0, 635, 0, 636, 0, 637, 0, 638, 
	0, 639, 0, 640, 0, 642, 641, 642, 
	641, 643, 642, 642, 12, 770, 650, 12, 
	642, 641, 644, 651, 657, 699, 703, 719, 
	752, 764, 642, 641, 645, 642, 641, 646, 
	642, 641, 647, 642, 641, 648, 642, 641, 
	649, 642, 641, 650, 642, 641, 642, 119, 
	641, 652, 642, 641, 653, 642, 641, 654, 
	642, 641, 655, 642, 641, 656, 642, 641, 
	650, 642, 641, 658, 681, 642, 641, 659, 
	642, 641, 660, 642, 641, 661, 642, 641, 
	662, 642, 641, 663, 642, 641, 664, 642, 
	641, 665, 642, 641, 666, 642, 641, 667, 
	642, 641, 668, 642, 641, 669, 642, 641, 
	670, 642, 641, 671, 642, 641, 672, 642, 
	641, 673, 642, 641, 642, 674, 641, 2, 
	675, 12, 12, 13, 23, 25, 9, 39, 
	42, 12, 0, 676, 0, 677, 0, 678, 
	0, 679, 0, 680, 0, 119, 0, 682, 
	642, 641, 683, 642, 641, 684, 642, 641, 
	685, 642, 641, 686, 642, 641, 687, 642, 
	641, 688, 642, 641, 689, 642, 641, 690, 
	642, 641, 691, 642, 641, 692, 642, 641, 
	693, 642, 641, 694, 642, 641, 695, 642, 
	641, 696, 642, 641, 697, 642, 641, 698, 
	642, 641, 642, 119, 641, 700, 642, 641, 
	701, 642, 641, 702, 642, 641, 650, 642, 
	641, 704, 642, 641, 705, 642, 641, 706, 
	642, 641, 707, 642, 641, 708, 642, 641, 
	709, 642, 641, 710, 642, 641, 711, 642, 
	641, 712, 642, 641, 713, 642, 641, 714, 
	642, 641, 715, 642, 641, 716, 642, 641, 
	717, 642, 641, 718, 642, 641, 696, 642, 
	641, 720, 642, 641, 721, 642, 641, 722, 
	642, 641, 723, 642, 641, 724, 642, 641, 
	725, 642, 641, 726, 642, 641, 727, 642, 
	641, 728, 642, 641, 729, 642, 641, 730, 
	642, 641, 731, 642, 641, 732, 642, 641, 
	733, 642, 641, 734, 642, 641, 735, 642, 
	641, 642, 736, 641, 737, 642, 641, 738, 
	642, 641, 739, 642, 641, 740, 642, 641, 
	741, 642, 641, 742, 642, 641, 743, 642, 
	641, 744, 642, 641, 745, 642, 641, 746, 
	642, 641, 747, 642, 641, 748, 642, 641, 
	749, 642, 641, 750, 642, 641, 751, 642, 
	641, 698, 642, 641, 753, 642, 641, 754, 
	642, 641, 755, 642, 641, 756, 642, 641, 
	757, 642, 641, 758, 642, 641, 759, 642, 
	641, 760, 642, 641, 761, 642, 641, 762, 
	642, 641, 763, 642, 641, 698, 642, 641, 
	765, 642, 641, 766, 642, 641, 767, 642, 
	641, 768, 642, 641, 769, 642, 641, 650, 
	642, 641, 642, 771, 641, 642, 772, 641, 
	642, 773, 641, 642, 774, 641, 642, 775, 
	641, 642, 776, 641, 642, 777, 641, 642, 
	778, 641, 642, 779, 641, 642, 780, 641, 
	642, 781, 641, 642, 782, 641, 642, 783, 
	641, 642, 12, 641, 785, 0, 12, 0, 
	0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 149, 126, 57, 110, 
	23, 0, 29, 54, 0, 5, 1, 0, 
	29, 1, 35, 0, 43, 0, 43, 0, 
	43, 139, 48, 9, 106, 11, 0, 134, 
	45, 45, 45, 3, 122, 33, 33, 33, 
	0, 122, 33, 33, 33, 0, 122, 33, 
	0, 33, 0, 102, 7, 7, 43, 54, 
	0, 0, 43, 114, 25, 0, 54, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 43, 43, 43, 43, 
	0, 27, 118, 27, 27, 51, 27, 0, 
	54, 0, 1, 0, 43, 0, 0, 0, 
	43, 54, 37, 37, 87, 37, 37, 43, 
	0, 39, 0, 43, 0, 0, 54, 0, 
	0, 39, 0, 0, 96, 54, 0, 93, 
	90, 41, 96, 90, 99, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 57, 149, 
	126, 57, 0, 110, 23, 0, 0, 110, 
	23, 0, 0, 110, 23, 0, 0, 110, 
	23, 0, 0, 110, 23, 0, 110, 23, 
	0, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 84, 54, 0, 69, 33, 69, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	13, 0, 63, 130, 31, 60, 57, 31, 
	63, 57, 66, 31, 43, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	81, 81, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 21, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	78, 33, 84, 78, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	19, 0, 63, 0, 130, 31, 60, 57, 
	31, 63, 57, 66, 31, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	19, 43, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 19, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 19, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 75, 33, 
	84, 75, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	17, 0, 63, 0, 130, 31, 60, 57, 
	31, 63, 57, 66, 31, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	17, 43, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 17, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 17, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 72, 33, 84, 72, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 15, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 15, 0, 63, 
	0, 130, 31, 60, 57, 31, 63, 57, 
	66, 31, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 15, 43, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 15, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 15, 0, 0, 43, 0, 43, 
	0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 786;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/el.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1581 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/el.c.rl"
    
#line 1588 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/el.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/el.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/el.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/el.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/el.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/el.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/el.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/el.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/el.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/el.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/el.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/el.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/el.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/el.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/el.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/el.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/el.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/el.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/el.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1878 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/el.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1941 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/el.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_el()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "El", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

