# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Dns
  #
  # The DNS Management Client.
  #
  class RecordSets
    include Azure::ARM::Dns::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the RecordSets class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [DnsManagementClient] reference to the DnsManagementClient
    attr_reader :client

    #
    # Updates a record set within a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param parameters [RecordSet] Parameters supplied to the Update operation.
    # @param if_match [String] The etag of the record set. Omit this value to
    # always overwrite the current record set. Specify the last-seen etag value to
    # prevent accidentally overwritting concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecordSet] operation results.
    #
    def update(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match = nil, custom_headers = nil)
      response = update_async(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a record set within a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param parameters [RecordSet] Parameters supplied to the Update operation.
    # @param if_match [String] The etag of the record set. Omit this value to
    # always overwrite the current record set. Specify the last-seen etag value to
    # prevent accidentally overwritting concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match = nil, custom_headers = nil)
      update_async(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match, custom_headers).value!
    end

    #
    # Updates a record set within a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param parameters [RecordSet] Parameters supplied to the Update operation.
    # @param if_match [String] The etag of the record set. Omit this value to
    # always overwrite the current record set. Specify the last-seen etag value to
    # prevent accidentally overwritting concurrent changes.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, 'relative_record_set_name is nil' if relative_record_set_name.nil?
      fail ArgumentError, 'record_type is nil' if record_type.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RecordSet.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'recordType' => record_type,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'relativeRecordSetName' => relative_record_set_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates a record set within a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Record sets of type SOA can be updated but not created (they are created when
    # the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME',
    # 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
    # @param parameters [RecordSet] Parameters supplied to the CreateOrUpdate
    # operation.
    # @param if_match [String] The etag of the record set. Omit this value to
    # always overwrite the current record set. Specify the last-seen etag value to
    # prevent accidentally overwritting any concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new record set to be
    # created, but to prevent updating an existing record set. Other values will be
    # ignored.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecordSet] operation results.
    #
    def create_or_update(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match = nil, if_none_match = nil, custom_headers = nil)
      response = create_or_update_async(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match, if_none_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates a record set within a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Record sets of type SOA can be updated but not created (they are created when
    # the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME',
    # 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
    # @param parameters [RecordSet] Parameters supplied to the CreateOrUpdate
    # operation.
    # @param if_match [String] The etag of the record set. Omit this value to
    # always overwrite the current record set. Specify the last-seen etag value to
    # prevent accidentally overwritting any concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new record set to be
    # created, but to prevent updating an existing record set. Other values will be
    # ignored.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match = nil, if_none_match = nil, custom_headers = nil)
      create_or_update_async(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match, if_none_match, custom_headers).value!
    end

    #
    # Creates or updates a record set within a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Record sets of type SOA can be updated but not created (they are created when
    # the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME',
    # 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
    # @param parameters [RecordSet] Parameters supplied to the CreateOrUpdate
    # operation.
    # @param if_match [String] The etag of the record set. Omit this value to
    # always overwrite the current record set. Specify the last-seen etag value to
    # prevent accidentally overwritting any concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new record set to be
    # created, but to prevent updating an existing record set. Other values will be
    # ignored.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, zone_name, relative_record_set_name, record_type, parameters, if_match = nil, if_none_match = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, 'relative_record_set_name is nil' if relative_record_set_name.nil?
      fail ArgumentError, 'record_type is nil' if record_type.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['If-None-Match'] = if_none_match unless if_none_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RecordSet.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'recordType' => record_type,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'relativeRecordSetName' => relative_record_set_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a record set from a DNS zone. This operation cannot be undone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Record sets of type SOA cannot be deleted (they are deleted when the DNS zone
    # is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS',
    # 'PTR', 'SOA', 'SRV', 'TXT'
    # @param if_match [String] The etag of the record set. Omit this value to
    # always delete the current record set. Specify the last-seen etag value to
    # prevent accidentally deleting any concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, zone_name, relative_record_set_name, record_type, if_match = nil, custom_headers = nil)
      response = delete_async(resource_group_name, zone_name, relative_record_set_name, record_type, if_match, custom_headers).value!
      nil
    end

    #
    # Deletes a record set from a DNS zone. This operation cannot be undone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Record sets of type SOA cannot be deleted (they are deleted when the DNS zone
    # is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS',
    # 'PTR', 'SOA', 'SRV', 'TXT'
    # @param if_match [String] The etag of the record set. Omit this value to
    # always delete the current record set. Specify the last-seen etag value to
    # prevent accidentally deleting any concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, zone_name, relative_record_set_name, record_type, if_match = nil, custom_headers = nil)
      delete_async(resource_group_name, zone_name, relative_record_set_name, record_type, if_match, custom_headers).value!
    end

    #
    # Deletes a record set from a DNS zone. This operation cannot be undone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Record sets of type SOA cannot be deleted (they are deleted when the DNS zone
    # is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS',
    # 'PTR', 'SOA', 'SRV', 'TXT'
    # @param if_match [String] The etag of the record set. Omit this value to
    # always delete the current record set. Specify the last-seen etag value to
    # prevent accidentally deleting any concurrent changes.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, zone_name, relative_record_set_name, record_type, if_match = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, 'relative_record_set_name is nil' if relative_record_set_name.nil?
      fail ArgumentError, 'record_type is nil' if record_type.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'recordType' => record_type,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'relativeRecordSetName' => relative_record_set_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a record set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecordSet] operation results.
    #
    def get(resource_group_name, zone_name, relative_record_set_name, record_type, custom_headers = nil)
      response = get_async(resource_group_name, zone_name, relative_record_set_name, record_type, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a record set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, zone_name, relative_record_set_name, record_type, custom_headers = nil)
      get_async(resource_group_name, zone_name, relative_record_set_name, record_type, custom_headers).value!
    end

    #
    # Gets a record set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param relative_record_set_name [String] The name of the record set, relative
    # to the name of the zone.
    # @param record_type [RecordType] The type of DNS record in this record set.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, zone_name, relative_record_set_name, record_type, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, 'relative_record_set_name is nil' if relative_record_set_name.nil?
      fail ArgumentError, 'record_type is nil' if record_type.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'recordType' => record_type,'subscriptionId' => @client.subscription_id},
          skip_encoding_path_params: {'relativeRecordSetName' => relative_record_set_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the record sets of a specified type in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param record_type [RecordType] The type of record sets to enumerate.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<RecordSet>] operation results.
    #
    def list_by_type(resource_group_name, zone_name, record_type, top = nil, custom_headers = nil)
      first_page = list_by_type_as_lazy(resource_group_name, zone_name, record_type, top, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the record sets of a specified type in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param record_type [RecordType] The type of record sets to enumerate.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_type_with_http_info(resource_group_name, zone_name, record_type, top = nil, custom_headers = nil)
      list_by_type_async(resource_group_name, zone_name, record_type, top, custom_headers).value!
    end

    #
    # Lists the record sets of a specified type in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param record_type [RecordType] The type of record sets to enumerate.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_type_async(resource_group_name, zone_name, record_type, top = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, 'record_type is nil' if record_type.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'recordType' => record_type,'subscriptionId' => @client.subscription_id},
          query_params: {'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all record sets in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<RecordSet>] operation results.
    #
    def list_by_dns_zone(resource_group_name, zone_name, top = nil, custom_headers = nil)
      first_page = list_by_dns_zone_as_lazy(resource_group_name, zone_name, top, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all record sets in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_dns_zone_with_http_info(resource_group_name, zone_name, top = nil, custom_headers = nil)
      list_by_dns_zone_async(resource_group_name, zone_name, top, custom_headers).value!
    end

    #
    # Lists all record sets in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_dns_zone_async(resource_group_name, zone_name, top = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/recordsets'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the record sets of a specified type in a DNS zone.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecordSetListResult] operation results.
    #
    def list_by_type_next(next_page_link, custom_headers = nil)
      response = list_by_type_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the record sets of a specified type in a DNS zone.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_type_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_type_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the record sets of a specified type in a DNS zone.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_type_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all record sets in a DNS zone.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecordSetListResult] operation results.
    #
    def list_by_dns_zone_next(next_page_link, custom_headers = nil)
      response = list_by_dns_zone_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all record sets in a DNS zone.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_dns_zone_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_dns_zone_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all record sets in a DNS zone.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_dns_zone_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecordSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the record sets of a specified type in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param record_type [RecordType] The type of record sets to enumerate.
    # Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA',
    # 'SRV', 'TXT'
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecordSetListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_type_as_lazy(resource_group_name, zone_name, record_type, top = nil, custom_headers = nil)
      response = list_by_type_async(resource_group_name, zone_name, record_type, top, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_type_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists all record sets in a DNS zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecordSetListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_dns_zone_as_lazy(resource_group_name, zone_name, top = nil, custom_headers = nil)
      response = list_by_dns_zone_async(resource_group_name, zone_name, top, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_dns_zone_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
