#!/usr/local/bin/pike
#define UNIX_DEFAULT_FILE "/etc/.roxen_launcherrc"

int exec( string line, mapping (string:string) vars )
{
  array (string) arr, path;
  array (string) options = ({ });
  string prog;

  line = replace( line, "\t", " " );
  while (line[0..0] == " ")
    line = line[1..];
  arr = line / " ";
  prog = arr[0];
  arr = arr[1..];
  if (prog[0..0] != "/")
  {
    path = getenv( "PATH" ) / ":";
    foreach (path, string p)
      if (file_stat( p + "/" + prog ))
      {
        prog = p + "/" + prog;
	break;
      }
    if (prog[0..0] != "/")
    {
      werror( "Couldn't find program " + prog + "\n" );
      return 1;
    }
  }
  for (int c=0; c < sizeof( arr ); c++)
    if (arr[c][0..0] == "\"")
    {
      int c1;
      
      for (c1 = c+1; c1 < sizeof( arr ); c1++)
	if (arr[c1][ sizeof( arr[c1] )-1 .. sizeof( arr[c1] )-1 ] == "\"")
	{
	  options += ({ arr[c..c1] * " " });
	  options[-1] = options[-1][1..sizeof( options[-1] )];
	  c = c1;
	  break;
	}
      if (c1 = sizeof( arr ))
      {
	werror( "Syntax error in .roxen_launcherrc\n" );
	return 1;
      }
    }
    else if (arr[c][0..0] == "$")
      if (!vars[ arr[c][1..] ])
      {
	werror( "Couldn't find variable " + arr[c][1..] + " in application "
		"startup file.\n" );
	return 1;
      }
      else
	options += ({ vars[ arr[c][1..] ] });
    else
      options += ({ arr[c] });
  exece( prog, options );
  werror ("Launch failed: " + prog + " " + options * " " + "\n");
}

int main( int argc, array (string) argv )
{
  string private_file, global_file, data;
  mapping (string:string) vars = ([ ]);
  object obj;
  array arr;
  int private_pass;

  if ((obj = Stdio.File()),
      obj->open( getenv( "HOME" ) + "/.roxen_launcherrc", "r" ))
    private_file = obj->read( 0x7fffffff ) - "\r";
  if ((obj = Stdio.File()), obj->open( UNIX_DEFAULT_FILE, "r" ))
    global_file = obj->read( 0x7fffffff ) - "\r";
  if (!private_file && !global_file)
  {
    werror( "Couldn't find any .roxen_launcherrc file\n" );
    return 1;
  }

  if (argc == 2 && (obj = Stdio.File( argv[1], "r" )))
    data = obj->read( 0x7fffffff );
  else
    data = Stdio.File( "stdin" )->read( 0x7fffffff );

  foreach (data / "\n", string line)
  {
    string i, v;
    
    if (sscanf( line, "%s=%s", i, v ) == 2)
      vars[ i ] = v;
  }
  if (!vars[ "nfs" ] || !vars[ "content-type" ])
  {
    werror( "The application startup file didn't contain any nfs nor "
	    "content-type variable." );
    return 1;
  }

  if (private_file)
  {
    arr = private_file / "\n";
    private_pass = 1;
  }
  else
    arr = global_file / "\n";
  for (int c = 0; c < sizeof( arr ); c++)
  {
    string i, line;

    line = arr[c];
    if (line == "default" && private_pass)
    {
      arr = global_file ? global_file / "\n" : ({ });
      c = 0;
      private_pass = 0;
      continue;
    }
    i = (replace( line, "\t", " " ) / " ")[0];
    if (i == vars[ "content-type" ]
	|| i == (vars[ "content-type" ] / "/")[0] + "/*"
	|| i == "*/*")
      return exec( line[ strlen( i ).. ], vars );
  }
  return 1;
}
