// The outlined box module, Copyright  1996 - 2000, Roxen IS.
//
// Fredrik Noring et al
//
// Several modifications by Francesco Chemolli.


constant cvs_version = "$Id: obox.pike,v 1.34 2001/02/20 09:48:13 kuntri Exp $";
constant thread_safe=1;

#include <module.h>
inherit "module";

TAGDOCUMENTATION
#ifdef manual
constant tagdoc=([
"obox": ([
  "standard":#"<desc cont='cont'><p><short>
 This tag creates an outlined box.</short>
</p></desc>

<attr name='align' value='left|right'><p>
 Vertical alignment of the box.</p>
</attr>

<attr name='bgcolor' value='color'><p>
 Color of the background and title label.</p>
</attr>

<attr name='fixedleft' value='number'><p>
 Fixed length of line on the left side of the title. The unit is the
 approximate width of a character.</p>
</attr>

<attr name='fixedright' value='number'><p>
 Fixed length of line on the right side of the title. The unit is the
 approximate width of a character.</p>
</attr>

<attr name='left' value='number'><p>
 Length of the line on the left of the title.</p>
</attr>

<attr name='outlinecolor' value='color'><p>
 Color of the outline.</p>
</attr>

<attr name='outlinewidth' value='number'><p>
 Width, in pixels, of the outline.</p>
</attr>

<attr name='right' value='number'><p>
 Length of the line on the right of the title.</p>
</attr>

<attr name='spacing' value='number'><p>
 Width, in pixels, of the space in the box.</p>
</attr>

<attr name='style' value='caption|groupbox'><p>
 Style of the box. Groupbox is default.</p>
</attr>

<attr name='textcolor' value='color'><p>
 Color of the text inside the box.</p>
</attr>

<attr name='title' value='string'><p>
 Sets the title of the obox.</p>
</attr>

<attr name='titlecolor' value='color'><p>
 Color of the title text.</p>
</attr>

<attr name='width' value='number'><p>
 Width, in pixels, of the box.</p>


 <p>Note that the left and right attributes are constrained by the width
 argument. If the title is not specified in the argument list, you can
 put it in a <tag>title</tag> container in the obox contents.</p>

<ex><obox align='left' outlinewidth='5' outlinecolor='green' width='200'>
<title>Sample box</title>

This is just a sample box.

</obox>
</ex>

</attr>",


  "svenska":#"<desc cont='cont'><p><short>
 Denna tagg skapar en ramlda runt dess innehll.</short>
</p></desc>

<attr name='align' value='left|right'><p>
 Ramldans vertikala position.</p>
</attr>

<attr name='bgcolor' value='frg'><p>
 Frgen p bakgrunden samt titeln.</p>
</attr>

<attr name='fixedleft' value='nummer'><p>
 Lngden p linjen till vnster om titeln. Vrdet p 1 'nummer' r den
 ungefrliga bredden av ett tecken.</p>
</attr>

<attr name='fixedright' value='nummer'><p>
 Lngden p linjen till vnster om titeln. Vrdet p 1 'nummer' r den
 ungefrliga bredden av ett tecken.</p>
</attr>

<attr name='left' value='nummer'><p>
 Lngden p linjen till vnster om titeln.</p>
</attr>

<attr name='outlinecolor' value='frg'><p>
 Frgen p ramen.</p>
</attr>

<attr name='outlinewidth' value='nummer'><p>
 Ramens bredd, i antal pixlar.</p>
</attr>

<attr name='right' value='nummer'><p>
 Lngden p linjen till hger om titeln.</p>
</attr>

<attr name='spacing' value='nummer'><p>
 Vidden p utrymmet i ramldan, i antal pixlar.</p>
</attr>

<attr name='style' value='caption|groupbox'><p>
 Ramldans stil. Groupbox r standardvrde.</p>
</attr>

<attr name='textcolor' value='frg'><p>
 Frgen p texten inuti ldan.</p>
</attr>

<attr name='title' value='textstrng'><p>
 Ramldans titel.</p>
</attr>

<attr name='titlecolor' value='frg'><p>
 Frgen p titeltexten.</p>
 </attr>

<attr name='width' value='nummer'><p>
 Bredden p ldan, i antal pixlar.</p>

 <p>Tnk p att <att>left</att> och <att>right</att> attributen begrnsas
 av vrdet p <att>width</att> attributet. Om titeln inte r satt i
 taggen, finns mjligheten att stta den inuti en <tag>title</tag>
 tagg och placera denna i ramldans innehll.</p>

<ex><obox align='left' outlinewidth='5' outlinecolor='green' width='200'>
<title>Ramlda</title>

Detta r innehllet.

</obox>
</ex>

</attr>"]) ]);
#endif

constant unit_gif = "/internal-roxen-unit";

static string img_placeholder (mapping args)
{
  int width=((int)args->outlinewidth)||1;

  return sprintf("<img src=\"%s\" alt=\"\" width=\"%d\" height=\"%d\"%s>",
		 unit_gif, width, width, (args->noxml?"":" /"));
}

static string handle_title(string name, mapping junk_args,
			   string contents, mapping args)
{
  args->title=contents;
  return "";
}

static string horiz_line(mapping args)
{
  args->fixedleft="";
  return sprintf("<tr><td colspan=\"5\" bgcolor=\"%s\">\n"
		 "%s</td></tr>\n",
		 args->outlinecolor,
		 img_placeholder(args));
}

static string title(mapping args)
{
  if (!args->title)
    return horiz_line(args);
  string empty=img_placeholder(args);
  if (!args->left && !args->fixedleft)
    if (args->width && !args->fixedright)
      args->fixedleft = "7";
    else
      args->left = "20";
  if (!args->right && !args->fixedright)
    args->right = args->width || "20";
  switch (args->style) {
   case "groupbox":
    return sprintf("<tr><td colspan=\"2\"><font size=\"-3\">&nbsp;</font></td>\n"
		   "<td rowspan=\"3\"%s nowrap=\"nowrap\">&nbsp;<b>"		/* bgcolor */
		   "%s%s%s"                 /* titlecolor, title, titlecolor */
		   "</b>&nbsp;</td>\n"
		   "<td colspan=\"2\"><font size=\"-3\">&nbsp;</font></td></tr>\n"
		   "<tr%s>"				/* bgcolor */
		   "<td bgcolor=\"%s\" colspan=\"2\">\n"	/* outlinecolor */
		   "%s</td>\n"				/* empty */
		   "<td bgcolor=\"%s\" colspan=\"2\">\n"
		   "%s</td></tr>\n"			/* empty */

		   "<tr%s><td bgcolor=\"%s\">"      /* bgcolor, outlinecolor */
		   "%s</td>\n"				/* empty */
		   "<td%s><font size=\"-3\">%s</font></td>" /* left, fixedleft */
		   "<td%s><font size=\"-3\">%s</font></td>\n" /* right, fixedright */
		   "<td bgcolor=\"%s\">"		/* outlinecolor */
		   "%s</td></tr>\n"			/* empty */
		   ,
		   args->bgcolor ? " bgcolor=\""+args->bgcolor+"\"" : "",
		   args->titlecolor ? "<font color=\""+args->titlecolor+"\">" : "",
		   args->title,
		   args->titlecolor ? "</font>" : "",
		   args->bgcolor ? " bgcolor=\""+args->bgcolor+"\"" : "",
		   args->outlinecolor,
		   empty,
		   args->outlinecolor,
		   empty,
		   args->bgcolor ? " bgcolor=\""+args->bgcolor+"\"" : "",
		   args->outlinecolor,
		   empty,
		   args->left ? " width=\""+args->left+"\"" : "",
		   (args->fixedleft ?
		    String.strmult ("&nbsp;", (int) args->fixedleft) : "&nbsp;"),
		   args->right ? " width=\""+args->right+"\"" : "",
		   (args->fixedright ?
		    String.strmult ("&nbsp;", (int) args->fixedright) : "&nbsp;"),
		   args->outlinecolor,
		   empty);
   case "caption":
    return sprintf("<tr%s><td colspan=\"2\"><font size=\"-3\">&nbsp;</font></td>\n"
		   "<td rowspan=\"3\" nowrap=\"nowrap\">&nbsp;<b>"		/* bgcolor */
		   "%s%s%s"                 /* titlecolor, title, titlecolor */
		   "</b>&nbsp;</td>\n"
		   "<td colspan=\"2\"><font size=\"-3\">&nbsp;</font></td></tr>\n"
		   "<tr bgcolor=\"%s\">"		/* outlinecolor */
		   "<td colspan=\"2\">\n"	
		   "%s</td>\n"				/* empty */
		   "<td colspan=\"2\">\n"
		   "%s</td></tr>\n"			/* empty */

		   "<tr bgcolor=\"%s\"><td>"      /*  outlinecolor */
		   "%s</td>\n"				/* empty */
		   "<td%s><font size=\"-3\">%s</font></td>" /* left, fixedleft */
		   "<td%s><font size=\"-3\">%s</font></td>\n" /* right, fixedright */
		   "<td bgcolor=\"%s\">"		/* outlinecolor */
		   "%s</td></tr>\n"			/* empty */
		   ,
		   args->outlinecolor ? " bgcolor=\""+args->outlinecolor+"\"" : "",
		   args->titlecolor ? "<font color=\""+args->titlecolor+"\">" : "",
		   args->title,
		   args->titlecolor ? "</font>" : "",
		   args->outlinecolor,
		   empty,
		   empty,
		   args->outlinecolor,
		   empty,
		   args->left ? " width=\""+args->left+"\"" : "",
		   (args->fixedleft ?
		    String.strmult ("&nbsp;", (int) args->fixedleft) : "&nbsp;"),
		   args->right ? " width=\""+args->right+"\"" : "",
		   (args->fixedright ?
		    String.strmult ("&nbsp;", (int) args->fixedright) : "&nbsp;"),
		   args->outlinecolor,
		   empty);
  }
}

string simpletag_obox(string name, mapping args, string contents)
{
  string s;

  // Set the defaults...
  args->outlinecolor = args->outlinecolor || "#000000";
  args->style = args->style || "groupbox";
  if (!args->title) {
    contents=parse_html(contents,([]),(["title":handle_title,]),args);
  }

  s = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"" +
    (args->align?" align=\""+args->align+"\"":"") +
    (args->width ? " width=" + args->width : "") +
    (args->hspace ? " hspace=" + args->hspace : "") +
    (args->vspace ? " vspace=" + args->vspace : "") +  ">\n" +
    title(args) +
    "<tr" +
    (args->bgcolor?" bgcolor=\""+args->bgcolor+"\"":"") +
    "><td bgcolor=\"" + args->outlinecolor + "\">" +
    img_placeholder(args) + "</td>\n"
    "<td" + (args->width && !args->fixedleft && !args->fixedright ? " width=\"1\"" : "") +
    (args->aligncontents ? " align=" + args->aligncontents : "") + " colspan=\"3\"" + ">\n"
    "<table border=\"0\" cellspacing=\"0\" cellpadding=\"" + (args->padding || "5") + "\""+
    (!args->spacing && args->width?" width=\""+(string)((int)args->width-((int)args->outlinewidth*2||2))+"\"":"")+
    (args->spacing?" width=\""+(string)args->spacing+"\"":"")+">"
    "<tr><td>\n";

    if (args->textcolor)
      s += "<font color=\""+args->textcolor+"\">" + contents + "</font>";
    else
      s += contents;

    s += "</td></tr></table>\n"
      "</td><td bgcolor=\"" + args->outlinecolor + "\">" +
      img_placeholder(args) + "</td></tr>\n" +
      horiz_line(args) + "</table>\n";

  return s;
}

constant module_type = MODULE_TAG;
constant module_name =
    ([
      "standard":"Outlined box",
      "svenska":"Ramlda",
    ]);
constant module_doc =
    ([
      "standard":
      "This module provides the <tt>&lt;obox&gt;</tt> tag that draws outlined "
      "boxes.",
      "svenska":
      "<tt>&lt;obox&gt;&lt;/obox&gt;</tt> r en tag som ramar "
      "in det som str i den.",
    ]);
