/*
 * Decompiled with CFR 0.152.
 */
package com.roxen.servlet;

import com.roxen.servlet.ServletResponse;
import java.io.IOException;
import javax.servlet.ServletOutputStream;

class HTTPOutputStream
extends ServletOutputStream {
    final int id;
    protected boolean isCommitted = false;
    protected int bufused = 0;
    protected int bufsize = 1024;
    protected byte[] buf = new byte[this.bufsize];
    protected ServletResponse response;

    HTTPOutputStream(int n) {
        this.id = n;
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.low_close();
    }

    protected void finalize() throws Throwable {
        this.forgetfd();
        super.finalize();
    }

    public synchronized void flush() throws IOException {
        int n = this.bufused;
        this.bufused = 0;
        if (!this.isCommitted) {
            this.isCommitted = true;
            byte[] byArray = this.buf;
            this.buf = new byte[this.bufsize == 0 ? 1 : this.bufsize];
            this.response.commitRequest(this);
            this.flush();
            this.buf = byArray;
        }
        if (n > 0) {
            this.low_write(this.buf, 0, n);
        }
        if (this.bufsize > 0 && this.buf.length > this.bufsize) {
            this.buf = new byte[this.bufsize == 0 ? 1 : this.bufsize];
        }
    }

    private native void forgetfd();

    int getBufferSize() {
        return this.bufsize;
    }

    boolean isCommitted() {
        return this.isCommitted;
    }

    private native void low_close() throws IOException;

    private native void low_write(byte[] var1, int var2, int var3) throws IOException;

    synchronized void reset() {
        if (this.isCommitted) {
            throw new IllegalStateException();
        }
        this.bufused = 0;
    }

    synchronized void setBufferSize(int n) {
        if (n < 0) {
            return;
        }
        if (this.bufused == 0) {
            this.buf = new byte[this.bufsize == 0 ? 1 : this.bufsize];
            return;
        }
        if (n > this.bufsize) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.bufused);
            this.buf = byArray;
        } else {
            this.bufsize = n;
        }
    }

    void setResponse(ServletResponse servletResponse) {
        this.response = servletResponse;
    }

    public synchronized void write(int n) throws IOException {
        this.buf[this.bufused++] = (byte)n;
        if (this.bufused >= this.bufsize) {
            this.flush();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (n2 >= this.bufsize) {
            this.flush();
            this.low_write(byArray, n, n2);
        } else if (this.bufused + n2 > this.bufsize) {
            int n3 = this.bufsize - this.bufused;
            if (n3 > 0) {
                System.arraycopy(byArray, n, this.buf, this.bufused, n3);
                this.bufused += n3;
            } else {
                n3 = 0;
            }
            this.flush();
            this.bufused = n2 - n3;
            System.arraycopy(byArray, n + n3, this.buf, 0, this.bufused);
            if (this.bufused >= this.bufsize) {
                this.flush();
            }
        } else {
            System.arraycopy(byArray, n, this.buf, this.bufused, n2);
            if ((this.bufused += n2) >= this.bufsize) {
                this.flush();
            }
        }
    }
}

