/* -*- Mode: C; c-file-style: "k&r"; -*-*/

/* ddt.c
 *    sample program testing ddt's needs
 *
 * $Id: ddt.c,v 1.7 2001/03/27 23:00:46 remi Exp $
 *
 * Copyright (C) 2000,
 *     Remi Lefebvre <remi@debian.org>
 *     Antoine Lefebvre <antoine.lefebvre@polymtl.ca>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#include <stdlib.h>
#include <string.h>
#include "gpcp.h"

struct hostentry
{
     char *hostaddr;
     unsigned int serverport;
     unsigned int clientport;
     char *interface;
     int accountid;
     char *password;
     short encrypt;
};


Options ddt_options[] = {
     {"debug",       BOOLEAN, NULL},
     {"hostentry",   PARENT,  NULL},
     {"hostaddr",    STRING,  "hostentry"},
     {"serverport",  INTEGER, "hostentry"},
     {"clientport",  INTEGER, "hostentry"},
     {"interface",   STRING,  "hostentry"},
     {"accountid",   INTEGER, "hostentry"},
     {"password",    STRING,  "hostentry"},
     {"encrypt",     BOOLEAN, "hostentry"},
     {NULL,          0,       NULL}
};

void fill_struct(struct hostentry *hosts, int nbr_hosts);

int main(int argc, char **argv)
{
     int n;
     Data *data;
     short debug;
     struct hostentry *hosts;

     
     GPCP_RegisterOptions(ddt_options);
     GPCP_ReadFile("ddt.conf", &data);

     GPCP_PrintData(data);

     if (GPCP_GetValue("debug", &debug) != 0)
     {
         printf ("can't get debug value\n");
     }

//     printf("debug : %s\n", (debug) ? "true" : "false");

     
     if ((n = GPCP_NumParent("hostentry")) == 0)
     { 
          printf ("no hostentry available\n");
     }

          
     hosts = (struct hostentry *) malloc (sizeof (struct hostentry) * n); 
     bzero(hosts, (sizeof (struct hostentry) * n));

     
     fill_struct(hosts, n);
     
     free(hosts);
     GPCP_FreeData(&data);
     
     return 0;
}

void fill_struct(struct hostentry *hosts, int nbr_hosts)
{
     int i;
     
     for (i = 0; i < nbr_hosts; i++)
     {
         if (GPCP_EnterLevel ("hostentry", i) == -1)
              printf ("failed to enter sublevel\n");
         
         GPCP_GetValue ("hostaddr", &hosts[i].hostaddr);
         GPCP_GetValue ("serverport", &hosts[i].serverport);
         GPCP_GetValue ("clientport", &hosts[i].clientport);
         GPCP_GetValue ("interface", &hosts[i].interface);
         GPCP_GetValue ("accountid", &hosts[i].accountid);
         GPCP_GetValue ("password", &hosts[i].password);
         GPCP_GetValue ("encrypt", &hosts[i].encrypt);

         if (GPCP_ExitLevel () == -1)
              printf ("failed to leave sublevel\n");
         
     }
}
