<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:zeerex="http://explain.z3950.org/dtd/2.1/"
  xmlns:srw="http://www.loc.gov/zing/srw/"
  xmlns:diag="http://www.loc.gov/zing/srw/diagnostic/"
  xmlns:risx="http://refdb.sourceforge.net/ns/risx/"
                version="1.0">

  <!-- provides an element-level representation of MODS and risx records -->
  <xsl:import href="mods.xsl"/>

  <!-- provides pretty-printed risx output -->
  <xsl:import href="risx.xsl"/>

  <xsl:output method="html" indent="yes"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>RefDB SRU Results</title>
        <link type="text/css" rel="stylesheet" href="/styles/refdbsru.css"/>
      </head>
      <body>
        <div id="head">
          <h1>RefDB SRU Results</h1>
        </div>
        <xsl:apply-templates/>
        <div id="foot">
          <xsl:call-template name="nextByNumber"/>
        </div>
      </body>
    </html>
  </xsl:template>

  <!-- searchRetrieve templates -->

  <xsl:template match="srw:searchRetrieveResponse">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="srw:numberOfRecords">
    <p>Your query matched <xsl:apply-templates/> records.</p>
  </xsl:template>

  <xsl:template match="srw:version|srw:recordPacking|srw:recordSchema|srw:echoedSearchRetrieveRequest|srw:extraResponseData|srw:nextRecordPosition">
    <!-- suppress info -->
  </xsl:template>

  <xsl:template match="srw:records">
    <xsl:apply-templates/>
  </xsl:template>


  <xsl:template match="srw:record">
    <hr />
    <h2>Record <xsl:value-of select="srw:recordPosition"/></h2>
    <xsl:apply-templates select="srw:recordData"/>
  </xsl:template>

  <xsl:template match="srw:recordData">
    <xsl:apply-templates/>
  </xsl:template>

  
  <!-- scan templates -->

  <xsl:template match="srw:scanResponse">
    <xsl:apply-templates select="srw:diagnostics|srw:terms"/>
  </xsl:template>

  <xsl:template match="srw:terms">
    <table rules="all">
      <thead>
        <tr>
          <td class="key">Term</td>
          <td class="value">Matching records</td>
        </tr>
      </thead>
      <tbody>
        <xsl:apply-templates/>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="srw:term">
    <tr>
      <td><xsl:value-of select="srw:value"/></td>
      <td><xsl:value-of select="srw:numberOfRecords"/></td>
    </tr>
  </xsl:template>

  <!-- explain templates -->

  <xsl:template match="zeerex:explain">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="zeerex:serverInfo">
    <h2>Server Information</h2>
    <table>
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tr>
        <td class="key">Protocol</td>
        <td class="value"><xsl:value-of select="@protocol"/> via <xsl:value-of select="@transport"/></td>
      </tr>
      <tr>
        <td class="key">Protocol version</td>
        <td class="value"><xsl:value-of select="@version"/></td>
      </tr>
      <tr>
        <td class="key">URL</td>
        <td class="value"><a href="{zeerex:host/zeerex:database}"><xsl:value-of select="zeerex:host"/>/<xsl:value-of select="zeerex:database"/></a></td>
      </tr>
      <tr>
        <td class="key">Port</td>
        <td class="value"><xsl:value-of select="zeerex:port"/></td>
      </tr>
      <tr>
        <td class="key">Username</td>
        <td class="value"><xsl:value-of select="zeerex:authentication/zeerex:user"/></td>
      </tr>
      <tr>
        <td class="key">Password</td>
        <td class="value"><xsl:value-of select="zeerex:authentication/zeerex:password"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="zeerex:databaseInfo">
    <h2>Database Information</h2>
    <table>
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tr>
        <td class="key">Title</td>
        <td class="value"><xsl:value-of select="zeerex:title"/></td>
      </tr>
      <tr>
        <td class="key">Description</td>
        <td class="value"><xsl:value-of select="zeerex:description"/></td>
      </tr>
      <tr>
        <td class="key">Available records as of <xsl:value-of select="//zeerex:database/@lastUpdate"/></td>
        <td class="value"><xsl:value-of select="//zeerex:database/@numRecs"/></td>
      </tr>
      <tr>
        <td class="key">Maintainer</td>
        <td class="value"><xsl:value-of select="zeerex:author"/></td>
      </tr>
      <tr>
        <td class="key">Contact</td>
        <td class="value"><xsl:value-of select="zeerex:contact"/></td>
      </tr>
      <tr>
        <td class="key">Language usage</td>
        <td class="value"><xsl:value-of select="zeerex:langUsage"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="zeerex:metaInfo">
    <h2>Meta Information</h2>
    <table>
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tr>
        <td class="key">Explain information last updated at</td>
        <td class="value"><xsl:value-of select="zeerex:dateModified"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="zeerex:indexInfo">
    <h2>Index Information</h2>
    <p>Available index sets: <xsl:apply-templates select="zeerex:set"/></p>
    <h3>Indexes</h3>
    <xsl:apply-templates select="zeerex:index"/>
  </xsl:template>

  <xsl:template match="zeerex:set">
    <span><xsl:value-of select="@name"/>, </span>
  </xsl:template>

  <xsl:template match="zeerex:index">
    <h4><xsl:value-of select="zeerex:title"/></h4>
    <table>
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tr>
        <td class="key">Operations</td>
        <td class="value">
          <xsl:if test="@search = 'true'">
            <xsl:text>search </xsl:text>
          </xsl:if>
          <xsl:if test="@scan = 'true'">
            <xsl:text>scan </xsl:text>
          </xsl:if>
        </td>
      </tr>
      <xsl:apply-templates select="zeerex:map/zeerex:name"/>
    </table>
  </xsl:template>

  <xsl:template match="zeerex:name">
    <tr>
      <td class="key"><xsl:value-of select="@set"/></td>
      <td class="value"><xsl:apply-templates/></td>
    </tr>
  </xsl:template>

  <xsl:template match="zeerex:schemaInfo">
    <h2>Schema Information</h2>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="zeerex:schema">
    <h3><xsl:value-of select="zeerex:title"/></h3>
    <table>
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tr>
        <td class="key">Identifier</td>
        <td class="value"><xsl:value-of select="@identifier"/></td>
      </tr>
      <tr>
        <td class="key">Location</td>
        <td class="value"><a href="{@location}"><xsl:value-of select="@location"/></a></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="zeerex:configInfo">
    <h2>Configuration Information</h2>
    <table>
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tr>
        <td class="key">Supported relations</td>
        <td class="value"><xsl:apply-templates select="zeerex:supports[@type='relation']"/></td>
      </tr>
      <tr>
        <td class="key">Supported masking characters</td>
        <td class="value"><xsl:apply-templates select="zeerex:supports[@type='maskingCharacter']"/></td>
      </tr>
      <tr>
        <td class="key">Supported operations</td>
        <td class="value"><xsl:apply-templates select="zeerex:supports[@type='scan']"/></td>
      </tr>
      <tr>
        <td class="key">Settings</td>
        <td class="value"><xsl:apply-templates select="zeerex:setting"/></td>
      </tr>
      <tr>
        <td class="key">Defaults</td>
        <td class="value"><xsl:apply-templates select="zeerex:default"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="zeerex:supports|zeerex:maskingCharacter">
    <span><xsl:apply-templates/>, </span>
  </xsl:template>

  <xsl:template match="zeerex:supports[@type='scan']">
    <span>scan, </span>
  </xsl:template>

  <xsl:template match="zeerex:setting|zeerex:default">
    <span><xsl:value-of select="@type"/>=<xsl:apply-templates/>, </span>
  </xsl:template>

  <!-- diagnostic templates -->

  <xsl:template match="srw:diagnostics">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="diag:diagnostic">
    <xsl:apply-templates select="diag:message"/>
  </xsl:template>

  <xsl:template match="diag:message">
    <p class="diag"><xsl:value-of select="text()"/> (<xsl:value-of select="../diag:uri"/>)</p>
  </xsl:template>

  <!-- borrowed from a similar stylesheet found at
       http://herbie.bl.uk:9080/ -->
  <xsl:template name="nextByNumber">
    <xsl:variable name="maxrec"><xsl:value-of select="//srw:records/srw:record[last()]/srw:recordPosition" /></xsl:variable>
    <xsl:if test="$maxrec &lt; //srw:numberOfRecords">
      <xsl:variable name="moreURL">
        <xsl:value-of select="//databaseURI" />?version=1.1&amp;operation=searchRetrieve&amp;query=<xsl:value-of select="//srw:echoedSearchRetrieveRequest/srw:query" />&amp;startRecord=<xsl:value-of select="$maxrec + 1" />&amp;maximumRecords=<xsl:value-of select="//srw:echoedSearchRetrieveRequest/srw:maximumRecords" />&amp;recordSchema=<xsl:value-of select="//srw:echoedSearchRetrieveRequest/srw:recordSchema" />&amp;<xsl:apply-templates select="//srw:extraRequestData/*" mode="URL"/>
      </xsl:variable>
      ... 
      <a>
        <xsl:attribute name="href"> 
        <xsl:value-of select="$moreURL" />
        </xsl:attribute>
        <xsl:attribute name="title">Click here to see more records found by this search</xsl:attribute>
        More Records
      </a>
     </xsl:if>
   </xsl:template>
   
 </xsl:stylesheet>
