// $Id: DataStructs.cpp 1625 2011-01-13 04:22:56Z glandrum $
//
// Copyright (c) 2001-2006 greg Landrum and Rational Discovery LLC
//
//  @@ All Rights Reserved @@
//  This file is part of the RDKit.
//  The contents are covered by the terms of the BSD license
//  which is included in the file license.txt, found at the root
//  of the RDKit source tree.
//

#include <boost/python.hpp>
#include <RDBoost/Wrap.h>
#include "DataStructs.h"

namespace python = boost::python;

void wrap_SBV();
void wrap_EBV();
void wrap_BitOps();
void wrap_Utils();
void wrap_discreteValVect();
void wrap_sparseIntVect();


BOOST_PYTHON_MODULE(cDataStructs)
{
  python::scope().attr("__doc__") =
    "Module containing an assortment of functionality for basic data structures.\n"
    "\n"
    "At the moment the data structures defined are:\n"
    "  Bit Vector classes (for storing signatures, fingerprints and the like:\n"
    "    - ExplicitBitVect: class for relatively small (10s of thousands of bits) or\n"
    "                       dense bit vectors.\n"
    "    - SparseBitVect:   class for large, sparse bit vectors\n"
    "  DiscreteValueVect:   class for storing vectors of integers\n"
    "  SparseIntVect:       class for storing sparse vectors of integers\n"
    ;
  
  python::register_exception_translator<IndexErrorException>(&translate_index_error);
  python::register_exception_translator<ValueErrorException>(&translate_value_error);
  wrap_Utils();
  wrap_SBV();
  wrap_EBV();
  wrap_BitOps();
  wrap_discreteValVect();
  wrap_sparseIntVect();
}
