% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_detect_4.R
\name{stri_detect}
\alias{stri_detect}
\alias{stri_detect_charclass}
\alias{stri_detect_coll}
\alias{stri_detect_fixed}
\alias{stri_detect_regex}
\title{Detect a Pattern Match}
\usage{
stri_detect(str, ..., regex, fixed, coll, charclass)

stri_detect_fixed(str, pattern, negate = FALSE, ..., opts_fixed = NULL)

stri_detect_charclass(str, pattern, negate = FALSE)

stri_detect_coll(str, pattern, negate = FALSE, ..., opts_collator = NULL)

stri_detect_regex(str, pattern, negate = FALSE, ..., opts_regex = NULL)
}
\arguments{
\item{str}{character vector with strings to search in}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_regex},
\code{opts_fixed}, and so on}

\item{pattern, regex, fixed, coll, charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{negate}{single logical value; whether a no-match is rather of interest}

\item{opts_collator, opts_fixed, opts_regex}{a named list used to tune up
a search engine's settings; see
\code{\link{stri_opts_collator}}, \code{\link{stri_opts_fixed}},
and \code{\link{stri_opts_regex}}, respectively; \code{NULL}
for default settings;}
}
\value{
Each function returns a logical vector.
}
\description{
These functions determine, for each string in \code{str},
if there is at least one match to a corresponding \code{pattern}.
}
\details{
Vectorized over \code{str} and \code{pattern}.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.

\code{stri_detect} is a convenience function.
It calls either \code{stri_detect_regex},
\code{stri_detect_fixed}, \code{stri_detect_coll},
or \code{stri_detect_charclass}, depending on the argument used.
Relying on these underlying functions will make your code run slightly
faster.

See also \code{\link{stri_startswith}} and \code{\link{stri_endswith}}
for testing whether a string starts or ends with a given pattern
match, respectively. Moreover, see \code{\link{stri_subset}}
for a character vector subsetting.
}
\examples{
stri_detect_fixed(c("stringi R", "REXAMINE", "123"), c('i', 'R', '0'))
stri_detect_fixed(c("stringi R", "REXAMINE", "123"), 'R')

stri_detect_charclass(c("stRRRingi","REXAMINE", "123"),
   c("\\\\p{Ll}", "\\\\p{Lu}", "\\\\p{Zs}"))

stri_detect_regex(c("stringi R", "REXAMINE", "123"), 'R.')
stri_detect_regex(c("stringi R", "REXAMINE", "123"), '[[:alpha:]]*?')
stri_detect_regex(c("stringi R", "REXAMINE", "123"), '[a-zC1]')
stri_detect_regex(c("stringi R", "REXAMINE", "123"), '( R|RE)')
stri_detect_regex("stringi", "STRING.", case_insensitive=TRUE)

}
\seealso{
Other search_detect: \code{\link{stri_startswith}},
  \code{\link{stringi-search}}
}

