/***************************************************************************
 *            tools.c
 *
 *  Sun Sep 24 12:14:07 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/** @file tools.c
	@author Copyright 2006, 2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Robert Lissner, Jay MacDonald,
	@author Copyright 1999  Sam Phillips Keith Wesolowski.
 */
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "config.h"

#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <gtkextra/gtksheet.h>
#include "types.h"
#include "main.h"
#include "tools.h"
#include "dialog_initial.h"

#define ROW_IS_VISIBLE(trow) (tab->view->sheet->row [trow].is_visible)

static GtkWidget *match_entry, *case_sensitive_check;

static gboolean G_GNUC_UNUSED
tools_find_text (QlTabData * tab, gchar * search)
{
	gchar *entry;
	gchar *low_entry = NULL;
	gboolean doing_nocase;
	gint32 i, j;
	gint32 start_selection = tab->view->sheet->range.row0;

	if (!search)
		return FALSE;

	if ((doing_nocase = !gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON (case_sensitive_check))))
		g_strdown (search);

	for (i = 1; i <= tab->file->last_row; i++)
		for (j = 0; j <= tab->file->last_field; j++)
		{
			entry = g_strdup (gtk_sheet_cell_get_text 
				(tab->view->sheet, 
				(start_selection + i) % tab->file->last_row, j));
			if (entry)
			{
				if (doing_nocase)
					g_strdown (low_entry = g_strdup (entry));
				if (strstr ((doing_nocase ? low_entry : entry), search)
					&& ROW_IS_VISIBLE ((start_selection + i)
						% (tab->file->last_row)))
				{
					gtk_sheet_select_row (tab->view->sheet,
						(start_selection + i) % (tab->file->last_row));
					gtk_sheet_moveto (tab->view->sheet,
						tab->view->sheet->range.row0, 0, 0.0, 0.0);
					if (doing_nocase)
						g_free (low_entry);
					return TRUE;
				}
				if (doing_nocase)
					g_free (low_entry);
				g_free (entry);
			}
		}
	return FALSE;
}

static void G_GNUC_UNUSED
tools_match_text (QlTabData * tab, gchar * search)
{
	gchar *entry, *low_entry = NULL;
	gint32 i, j;
	gboolean doing_nocase;

	if ((doing_nocase = !gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON (case_sensitive_check))))
		g_strdown (search);

	/* We don't want to match against already-filtered records */
	big_draw_start (tab);

	for (i = 0; i < tab->file->last_row; i++)
		gtk_sheet_row_set_visibility (tab->view->sheet, i, TRUE);
	tab->file->filter_ptr = NULL;

	gtk_sheet_unselect_range (tab->view->sheet);

	for (i = 0; i < tab->file->last_row; i++)
	{
		gtk_sheet_row_set_visibility (tab->view->sheet, i, FALSE);
		for (j = 0; j <= tab->file->last_field; j++)
		{
			entry = g_strdup (gtk_sheet_cell_get_text (
				tab->view->sheet, i, j));
			if (entry)
			{
				if (doing_nocase)
					g_strdown (low_entry = g_strdup (entry));
				if (strstr (doing_nocase ? low_entry : entry, search))
					gtk_sheet_row_set_visibility (tab->view->sheet,
						i, TRUE);
				g_free (low_entry);
			}
		}
	}
	big_draw_end (tab);
}

/** \bug This is our basic action handler for match and find (credits 
actions are handled by the level1 functions). Old QL relied on widget 
names to indicate what we should do. This will not work. */
static void
tools_button_clicked (GtkAction G_GNUC_UNUSED * w, gpointer G_GNUC_UNUSED data)
{
/*	QlContext * qlc;
	QlTabData * tab;

	qlc = ql_get_context (GTK_WIDGET(data));
	tab = ql_get_tabdata (qlc);

	if (!strcmp ("Find OK", gtk_widget_get_name (w)))
	{
		gchar *match_string = g_strdup (gtk_entry_get_text
			(GTK_ENTRY (match_entry)));
		if (tab->view->current_compare)
			g_free (tab->view->current_compare);
		tab->view->current_compare = match_string;
		if (!tools_find_text (match_string))
			level2_error (_("Nothing found."));
	}
	else if (!strcmp ("Match OK", gtk_widget_get_name (w)))
	{
		gchar *match_string = g_strdup (gtk_entry_get_text
			(GTK_ENTRY (match_entry)));
		if (tab->view->current_compare)
			g_free (tab->view->current_compare);
		tab->view->current_compare = match_string;
		tools_match_text (tab, match_string);
//		cancel_level1 ((GtkWidget *) data, NULL, NULL);
	}
	else if (!strcmp ("Match Reset", gtk_widget_get_name (w)))
	{
		tools_match_text ("");
//		cancel_level1 ((GtkWidget *) data, NULL, NULL);
	}
*/
}

void
tools_find (GtkAction G_GNUC_UNUSED * w, gpointer data)
{
	GtkWidget *find_dialog, *ok_button, *cancel_button, *hbox;
	QlContext * qlc;
	QlTabData * tab;

	qlc = ql_get_context (GTK_WIDGET(data));
	tab = ql_get_tabdata (qlc);
	CHECK_CHANGED(tab);

	/* Manipulates some globals to give us a unified dialog box */
	find_dialog = gtk_dialog_new ();
	gtk_window_set_modal (GTK_WINDOW (find_dialog), TRUE);
	gtk_window_set_position (GTK_WINDOW (find_dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_resizable (GTK_WINDOW (find_dialog), TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (find_dialog), 5);

	gtk_window_set_title (GTK_WINDOW (find_dialog), _("Find next"));
	g_signal_connect_object (GTK_OBJECT (find_dialog), "destroy",
		G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (find_dialog),
		G_CONNECT_AFTER);

	ok_button = gtk_button_new_from_stock (GTK_STOCK_OK);
	/* names are just for the code, not users. Don't translate */
	gtk_widget_set_name (ok_button, "Find OK");
	g_signal_connect (GTK_OBJECT (ok_button), "clicked",
		G_CALLBACK (tools_button_clicked), find_dialog);

	cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	g_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
		G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (find_dialog),
		G_CONNECT_AFTER);

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (find_dialog)->action_area),
		ok_button, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (find_dialog)->action_area),
		cancel_button, FALSE, FALSE, 0);

	gtk_widget_show (ok_button);
	gtk_widget_show (cancel_button);

	match_entry = gtk_entry_new ();
	gtk_widget_set_name (match_entry, "Find OK");
	g_signal_connect (GTK_OBJECT (match_entry), "activate",
		G_CALLBACK (tools_button_clicked), NULL);
	gtk_widget_show (match_entry);

	if (tab->view->current_compare)
		gtk_entry_set_text (GTK_ENTRY (match_entry),
			tab->view->current_compare);

	case_sensitive_check = gtk_check_button_new_with_label
		(_("Case sensitive"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (case_sensitive_check),
		FALSE);
	gtk_widget_set_sensitive (case_sensitive_check, TRUE);
	gtk_widget_show (case_sensitive_check);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), match_entry, TRUE, TRUE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), case_sensitive_check,
		TRUE, TRUE, 5);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (find_dialog)->vbox), hbox,
		TRUE, TRUE, 5);

	gtk_widget_grab_focus (match_entry);
	gtk_widget_show (find_dialog);
}

void
tools_match (GtkAction G_GNUC_UNUSED * w, gpointer data)
{
	GtkWidget *match_dialog,
		*ok_button, *cancel_button, *reset_button, *hbox;
	gchar *tmp;
	QlContext * qlc;
	QlTabData * tab;

	qlc = ql_get_context (GTK_WIDGET(data));
	tab = ql_get_tabdata (qlc);
	CHECK_CHANGED(tab);
	match_dialog = gtk_dialog_new ();
	gtk_window_set_modal (GTK_WINDOW (match_dialog), TRUE);
	gtk_window_set_position (GTK_WINDOW (match_dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_resizable (GTK_WINDOW (match_dialog), TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (match_dialog), 5);

	gtk_window_set_title (GTK_WINDOW (match_dialog), _("Match with"));
	g_signal_connect_object (GTK_OBJECT (match_dialog), "destroy",
		G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (match_dialog),
		G_CONNECT_AFTER);

	ok_button = gtk_button_new_from_stock (GTK_STOCK_OK);
	gtk_widget_set_name (ok_button, "Match OK");
	g_signal_connect (GTK_OBJECT (ok_button), "clicked",
		G_CALLBACK (tools_button_clicked), match_dialog);

	cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	g_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
		G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (match_dialog),
		G_CONNECT_AFTER);
	tmp = g_strconcat ("  ", _("Show All"), "  ", NULL);
	reset_button = gtk_button_new_with_label (tmp);

	gtk_widget_set_name (reset_button, "Match Reset");
	g_signal_connect (GTK_OBJECT (reset_button), "clicked",
		G_CALLBACK (tools_button_clicked), match_dialog);

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->action_area),
		ok_button, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->action_area),
		reset_button, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->action_area),
		cancel_button, FALSE, FALSE, 0);

	gtk_widget_show (ok_button);
	gtk_widget_show (reset_button);
	gtk_widget_show (cancel_button);

	match_entry = gtk_entry_new ();
	gtk_widget_set_name (match_entry, "Match OK");
	g_signal_connect (GTK_OBJECT (match_entry), "activate",
		G_CALLBACK (tools_button_clicked), match_dialog);
	gtk_widget_show (match_entry);

	if (tab->view->current_compare)
		gtk_entry_set_text (GTK_ENTRY (match_entry),
			tab->view->current_compare);

	case_sensitive_check = gtk_check_button_new_with_label
		(_("Case sensitive"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (case_sensitive_check),
		FALSE);
	gtk_widget_set_sensitive (case_sensitive_check, TRUE);
	gtk_widget_show (case_sensitive_check);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), match_entry, TRUE, TRUE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), case_sensitive_check, TRUE, TRUE,
		5);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->vbox), hbox,
		TRUE, TRUE, 5);

	gtk_widget_grab_focus (match_entry);
	gtk_widget_show (match_dialog);
}
