/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse spice_parse
#define yylex   spice_lex
#define yyerror spice_error
#define yylval  spice_lval
#define yychar  spice_char
#define yydebug spice_debug
#define yynerrs spice_nerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TitleLine = 258,
     InvalidCharacter = 259,
     End = 260,
     Eol = 261,
     Identifier = 262,
     Digits = 263,
     Floats = 264,
     Nodes = 265,
     Options = 266,
     Function = 267,
     SUBCKT_Action = 268,
     ENDS_Action = 269,
     AC_Action = 270,
     OP_Action = 271,
     I_Source = 272,
     SAVE_Action = 273,
     RLC_Device = 274,
     L_Device = 275,
     K_Device = 276,
     IV_Source = 277,
     GE_Source = 278,
     FH_Source = 279,
     V_Source = 280,
     Diode_Device = 281,
     Bipolar_Device = 282,
     JFET_Device = 283,
     MOSFET_Device = 284,
     MESFET_Device = 285,
     MODEL_Action = 286,
     MODEL_Spec = 287,
     TRAN_Action = 288,
     PLOT_Action = 289,
     VoltFunc = 290,
     CurrFunc = 291,
     DC_Action = 292,
     PRINT_Action = 293,
     OPTIONS_Action = 294,
     WIDTH_Action = 295,
     NOISE_Action = 296,
     PZ_Action = 297,
     CurVol = 298,
     PoleZero = 299,
     ALL_Special = 300,
     X_Device = 301,
     O_Device = 302,
     ModelProps = 303,
     OFF_Special = 304,
     IC_Special = 305,
     SIM_Type = 306,
     TEMP_Special = 307,
     MOS_Special = 308,
     B_Source = 309,
     DISTO_Action = 310,
     INCLUDE_Action = 311,
     File = 312,
     BranchFunc = 313,
     NODESET_Action = 314,
     T_Device = 315,
     U_Device = 316,
     S_Device = 317,
     W_Device = 318,
     ON_Special = 319,
     TF_Action = 320,
     SENS_Action = 321,
     FOUR_Action = 322,
     OpFunc = 323,
     GE_Type = 324,
     TC_Special = 325,
     TEMP_Action = 326
   };
#endif
/* Tokens.  */
#define TitleLine 258
#define InvalidCharacter 259
#define End 260
#define Eol 261
#define Identifier 262
#define Digits 263
#define Floats 264
#define Nodes 265
#define Options 266
#define Function 267
#define SUBCKT_Action 268
#define ENDS_Action 269
#define AC_Action 270
#define OP_Action 271
#define I_Source 272
#define SAVE_Action 273
#define RLC_Device 274
#define L_Device 275
#define K_Device 276
#define IV_Source 277
#define GE_Source 278
#define FH_Source 279
#define V_Source 280
#define Diode_Device 281
#define Bipolar_Device 282
#define JFET_Device 283
#define MOSFET_Device 284
#define MESFET_Device 285
#define MODEL_Action 286
#define MODEL_Spec 287
#define TRAN_Action 288
#define PLOT_Action 289
#define VoltFunc 290
#define CurrFunc 291
#define DC_Action 292
#define PRINT_Action 293
#define OPTIONS_Action 294
#define WIDTH_Action 295
#define NOISE_Action 296
#define PZ_Action 297
#define CurVol 298
#define PoleZero 299
#define ALL_Special 300
#define X_Device 301
#define O_Device 302
#define ModelProps 303
#define OFF_Special 304
#define IC_Special 305
#define SIM_Type 306
#define TEMP_Special 307
#define MOS_Special 308
#define B_Source 309
#define DISTO_Action 310
#define INCLUDE_Action 311
#define File 312
#define BranchFunc 313
#define NODESET_Action 314
#define T_Device 315
#define U_Device 316
#define S_Device 317
#define W_Device 318
#define ON_Special 319
#define TF_Action 320
#define SENS_Action 321
#define FOUR_Action 322
#define OpFunc 323
#define GE_Type 324
#define TC_Special 325
#define TEMP_Action 326




/* Copy the first part of user declarations.  */
#line 3 "parse_spice.y"

/*
 * parse_spice.y - parser for a Spice netlist
 *
 * Copyright (C) 2004, 2005, 2006, 2007 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: parse_spice.y,v 1.20 2007/03/25 08:10:57 ela Exp $
 *
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define YYERROR_VERBOSE 42
#define YYDEBUG 1
#define YYMAXDEPTH 1000000

#include "check_spice.h"

// Converts the given string into upper case.
static char * spice_toupper (char * str) {
  for (unsigned int i = 0; i < strlen (str); i++) str[i] = toupper (str[i]);
  return str;
}

// Creates a device instance.
static struct definition_t * spice_create_device (char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_COMPONENT;
  def->instance = spice_toupper (instance);
  def->type = (char *) calloc (2, 1);
  def->type[0] = def->instance[0];
  def->line = spice_lineno;
  return def;
}

// Creates an action instance.
static struct definition_t * spice_create_action (char * type,
						  char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_ACTION;
  def->instance = spice_toupper (instance);
  def->type = spice_toupper (type);
  def->line = spice_lineno;
  return def;
}

// Create a string value.
static struct value_t * spice_create_str_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = spice_toupper (value);
  val->hint |= hint;
  return val;
}

// Create a real value.
static struct value_t * spice_create_val_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = value;
  val->value = strtod (value, NULL);
  val->hint |= hint;
  return val;
}

// Create a key/value pair.
static struct value_t * spice_create_par_value (char * key, char * value) {
  struct value_t * val = spice_create_str_value (key, HINT_PAIR);
  val->unit = value;
  return val;
}

// Append a string value to the definition.
static void spice_append_str_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a string value to the given values.
static struct value_t * spice_append_str_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  return netlist_append_values (values, val);
}

// Append a real value to the definition.
static void spice_append_val_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a real value to the given values.
static struct value_t * spice_append_val_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  return netlist_append_values (values, val);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 140 "parse_spice.y"
{
  char * ident;
  char * str;
  double d;
  struct definition_t * definition;
  struct definition_t * subcircuit;
  struct value_t * value;
}
/* Line 187 of yacc.c.  */
#line 377 "parse_spice.cpp"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 390 "parse_spice.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  111
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   720

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  72
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  40
/* YYNRULES -- Number of rules.  */
#define YYNRULES  141
/* YYNRULES -- Number of states.  */
#define YYNSTATES  342

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   326

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     6,    10,    12,    15,    16,    19,    21,
      23,    25,    32,    40,    47,    54,    61,    68,    74,    80,
      87,    95,   101,   109,   116,   122,   128,   135,   142,   150,
     158,   165,   169,   174,   178,   181,   185,   190,   195,   199,
     204,   208,   212,   216,   222,   231,   235,   244,   252,   260,
     268,   276,   285,   288,   291,   294,   297,   300,   303,   307,
     311,   315,   318,   322,   325,   329,   334,   340,   343,   345,
     348,   352,   354,   356,   359,   361,   363,   364,   367,   371,
     374,   378,   379,   381,   383,   384,   387,   390,   391,   394,
     398,   399,   402,   406,   407,   412,   413,   417,   420,   423,
     426,   427,   431,   434,   437,   440,   444,   445,   449,   453,
     456,   459,   462,   464,   466,   471,   473,   475,   477,   479,
     481,   482,   486,   487,   490,   491,   494,   497,   498,   501,
     504,   505,   508,   512,   517,   518,   521,   523,   525,   528,
     530,   532
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      73,     0,    -1,    74,     5,    -1,     3,    74,     5,    -1,
      74,    -1,     3,    74,    -1,    -1,    75,    74,    -1,   106,
      -1,    76,    -1,     6,    -1,    19,    99,    99,    98,   100,
       6,    -1,    19,    99,    99,    98,    96,   100,     6,    -1,
      19,    99,    99,    96,    98,     6,    -1,    19,    99,    99,
      96,   100,     6,    -1,    19,    99,    99,    98,    77,     6,
      -1,    19,    99,    99,    98,    78,     6,    -1,    21,    20,
      20,    98,     6,    -1,    22,    99,    99,   105,     6,    -1,
      22,    99,    99,    98,   105,     6,    -1,    23,    99,    99,
      69,     8,   102,     6,    -1,    23,    99,    99,    69,     6,
      -1,    23,    99,    99,    99,    99,    98,     6,    -1,    24,
      99,    99,    25,    98,     6,    -1,    31,    96,    32,    91,
       6,    -1,    26,    99,    99,    96,    93,    -1,    28,    99,
      99,    99,    96,    94,    -1,    27,    99,    99,    99,    96,
      94,    -1,    27,    99,    99,    99,    99,    96,    94,    -1,
      29,    99,    99,    99,    99,    96,    95,    -1,    30,    99,
      99,    99,    96,    94,    -1,    33,   101,     6,    -1,    34,
      51,    87,     6,    -1,    15,   104,     6,    -1,    37,     6,
      -1,    37,    97,     6,    -1,    37,    97,    97,     6,    -1,
      38,    51,    89,     6,    -1,    38,    89,     6,    -1,    38,
      51,    45,     6,    -1,    39,    90,     6,    -1,    71,   101,
       6,    -1,    40,   100,     6,    -1,    41,    84,    85,   104,
       6,    -1,    42,    99,    99,    99,    99,    43,    44,     6,
      -1,    46,   103,     6,    -1,    62,    99,    99,    99,    99,
      96,    88,     6,    -1,    63,    99,    99,    25,    96,    88,
       6,    -1,    47,    99,    99,    99,    99,    96,     6,    -1,
      61,    99,    99,    99,    96,   100,     6,    -1,    60,    99,
      99,    99,    99,   100,     6,    -1,    60,    99,    99,    99,
      99,   100,    82,     6,    -1,    16,     6,    -1,    18,     6,
      -1,    66,     6,    -1,    65,     6,    -1,    67,     6,    -1,
      54,     6,    -1,    55,   104,     6,    -1,    56,    57,     6,
      -1,    59,    92,     6,    -1,    70,    98,    -1,    70,    98,
      98,    -1,    50,    98,    -1,    50,    98,    98,    -1,    50,
      98,    98,    98,    -1,    50,    98,    98,    98,    98,    -1,
      98,    98,    -1,    99,    -1,    35,    99,    -1,    35,    99,
      99,    -1,    17,    -1,    25,    -1,    36,    25,    -1,    58,
      -1,    68,    -1,    -1,    84,    87,    -1,    84,    83,    87,
      -1,    86,    87,    -1,    86,    83,    87,    -1,    -1,    64,
      -1,    49,    -1,    -1,    84,    87,    -1,    86,    87,    -1,
      -1,    11,    90,    -1,     7,    98,    90,    -1,    -1,    48,
      91,    -1,     7,    98,    91,    -1,    -1,    35,    99,    98,
      92,    -1,    -1,    52,    98,    93,    -1,    98,    93,    -1,
      49,    93,    -1,    79,    93,    -1,    -1,    52,    98,    94,
      -1,    98,    94,    -1,    49,    94,    -1,    80,    94,    -1,
      53,    98,    94,    -1,    -1,    52,    98,    95,    -1,    53,
      98,    95,    -1,    98,    95,    -1,    49,    95,    -1,    81,
      95,    -1,     7,    -1,    32,    -1,    85,    98,    98,    98,
      -1,     8,    -1,     9,    -1,     8,    -1,    10,    -1,     7,
      -1,    -1,     7,    98,   100,    -1,    -1,    98,   101,    -1,
      -1,    99,   102,    -1,     9,   102,    -1,    -1,    99,   103,
      -1,    12,   101,    -1,    -1,   104,   105,    -1,   107,   108,
     110,    -1,    13,   109,   103,     6,    -1,    -1,   111,   108,
      -1,     7,    -1,    14,    -1,    14,   109,    -1,    76,    -1,
     106,    -1,     6,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   174,   174,   176,   179,   182,   188,   189,   193,   198,
     205,   209,   217,   226,   234,   242,   250,   258,   265,   272,
     280,   285,   290,   299,   307,   314,   322,   331,   340,   350,
     360,   369,   374,   380,   385,   389,   394,   399,   405,   410,
     416,   421,   426,   431,   438,   448,   454,   464,   473,   482,
     491,   500,   510,   514,   518,   522,   526,   530,   534,   539,
     547,   555,   562,   570,   578,   586,   596,   607,   615,   621,
     627,   637,   637,   640,   646,   652,   660,   661,   664,   668,
     671,   677,   678,   681,   686,   687,   690,   695,   696,   700,
     706,   707,   711,   717,   718,   727,   728,   732,   736,   740,
     745,   746,   750,   754,   758,   761,   767,   768,   772,   776,
     780,   784,   789,   789,   792,   802,   802,   804,   804,   804,
     806,   807,   813,   814,   820,   821,   825,   831,   832,   839,
     846,   847,   853,   861,   867,   868,   879,   882,   883,   887,
     893,   894
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "TitleLine", "InvalidCharacter", "End",
  "Eol", "Identifier", "Digits", "Floats", "Nodes", "Options", "Function",
  "SUBCKT_Action", "ENDS_Action", "AC_Action", "OP_Action", "I_Source",
  "SAVE_Action", "RLC_Device", "L_Device", "K_Device", "IV_Source",
  "GE_Source", "FH_Source", "V_Source", "Diode_Device", "Bipolar_Device",
  "JFET_Device", "MOSFET_Device", "MESFET_Device", "MODEL_Action",
  "MODEL_Spec", "TRAN_Action", "PLOT_Action", "VoltFunc", "CurrFunc",
  "DC_Action", "PRINT_Action", "OPTIONS_Action", "WIDTH_Action",
  "NOISE_Action", "PZ_Action", "CurVol", "PoleZero", "ALL_Special",
  "X_Device", "O_Device", "ModelProps", "OFF_Special", "IC_Special",
  "SIM_Type", "TEMP_Special", "MOS_Special", "B_Source", "DISTO_Action",
  "INCLUDE_Action", "File", "BranchFunc", "NODESET_Action", "T_Device",
  "U_Device", "S_Device", "W_Device", "ON_Special", "TF_Action",
  "SENS_Action", "FOUR_Action", "OpFunc", "GE_Type", "TC_Special",
  "TEMP_Action", "$accept", "Input", "InputList", "InputLine",
  "DefinitionLine", "TC_Value_1", "TC_Value_2", "IC_Condition_1",
  "IC_Condition_2", "IC_Condition_3", "IC_Condition_4", "Output_Range",
  "VOLTAGE_Output", "IV_Reference", "CURRENT_Output", "PLOT_List",
  "SWITCH_State", "PRINT_List", "OPTIONS_List", "MODEL_List",
  "NODESET_List", "DEVICE_List_1", "DEVICE_List_2", "DEVICE_List_3",
  "MODEL_Ident", "DC_List", "Value", "Node", "PairList", "ValueList",
  "NodeValueList", "NodeList", "Expr", "ExprList", "Subcircuit",
  "BeginSub", "SubBody", "SubCkt_Ident", "EndSub", "SubBodyLine", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    72,    73,    73,    73,    73,    74,    74,    75,    75,
      75,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    84,
      84,    85,    85,    86,    86,    86,    87,    87,    87,    87,
      87,    88,    88,    88,    89,    89,    89,    90,    90,    90,
      91,    91,    91,    92,    92,    93,    93,    93,    93,    93,
      94,    94,    94,    94,    94,    94,    95,    95,    95,    95,
      95,    95,    96,    96,    97,    98,    98,    99,    99,    99,
     100,   100,   101,   101,   102,   102,   102,   103,   103,   104,
     105,   105,   106,   107,   108,   108,   109,   110,   110,   111,
     111,   111
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     3,     1,     2,     0,     2,     1,     1,
       1,     6,     7,     6,     6,     6,     6,     5,     5,     6,
       7,     5,     7,     6,     5,     5,     6,     6,     7,     7,
       6,     3,     4,     3,     2,     3,     4,     4,     3,     4,
       3,     3,     3,     5,     8,     3,     8,     7,     7,     7,
       7,     8,     2,     2,     2,     2,     2,     2,     3,     3,
       3,     2,     3,     2,     3,     4,     5,     2,     1,     2,
       3,     1,     1,     2,     1,     1,     0,     2,     3,     2,
       3,     0,     1,     1,     0,     2,     2,     0,     2,     3,
       0,     2,     3,     0,     4,     0,     3,     2,     2,     2,
       0,     3,     2,     2,     2,     3,     0,     3,     3,     2,
       2,     2,     1,     1,     4,     1,     1,     1,     1,     1,
       0,     3,     0,     2,     0,     2,     2,     0,     2,     2,
       0,     2,     3,     4,     0,     2,     1,     1,     2,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       6,     6,    10,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   122,     0,
       0,    84,    87,   120,     0,     0,   127,     0,     0,     0,
       0,    93,     0,     0,     0,     0,     0,     0,     0,   122,
       0,     4,     6,     9,     8,   134,     5,   136,   127,   122,
       0,    52,    53,   119,   117,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   112,   113,     0,   115,
     116,   122,     0,    76,    34,    71,    72,     0,     0,     0,
       0,    84,    74,    75,    76,    76,     0,    68,     0,    87,
       0,     0,     0,     0,     0,   127,     0,     0,    57,     0,
       0,     0,     0,     0,     0,     0,     0,    55,    54,    56,
       0,     1,     2,     7,   141,   139,   140,     0,   134,     3,
       0,   129,    33,     0,     0,   130,     0,     0,     0,     0,
       0,     0,     0,    90,   123,    31,    76,    76,     0,     0,
      35,     0,    69,    73,     0,     0,    85,    86,    38,    87,
      88,    40,   120,    42,     0,     0,   128,    45,     0,    58,
      59,     0,    60,     0,     0,     0,     0,    41,   137,   132,
     135,   133,   120,   120,     0,   130,   130,     0,     0,     0,
       0,    95,     0,     0,     0,     0,     0,    90,     0,   117,
      76,    77,     0,    76,    79,    32,     0,    36,    70,    39,
      37,    89,   121,     0,     0,     0,    93,     0,     0,     0,
       0,   138,     0,     0,   112,     0,     0,     0,   120,     0,
      17,     0,   131,    18,    21,   124,     0,     0,    95,     0,
       0,    95,    25,    95,   112,   100,     0,   100,     0,   100,
      90,    91,    24,    78,    67,    80,   114,    43,     0,     0,
      94,   120,   120,     0,    81,    13,    14,    61,    15,    16,
       0,    11,    19,   124,   124,     0,     0,    23,    98,    63,
      95,    99,    97,   100,     0,     0,     0,   100,    27,   100,
     100,    26,   106,    30,    92,     0,     0,     0,     0,    81,
      83,    82,     0,    62,    12,   126,   125,    20,    22,    96,
     103,     0,   100,   100,   104,   102,    28,   106,     0,     0,
       0,   106,    29,   106,     0,    48,    50,     0,     0,    49,
       0,    47,    64,   101,   105,   110,     0,   106,   106,   111,
     109,    44,     0,    51,    46,     0,   107,   108,     0,    65,
       0,    66
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    40,    41,    42,    43,   216,   217,   231,   277,   311,
     318,   190,   136,    77,   137,   138,   292,    86,    90,   188,
     102,   232,   278,   312,    68,    78,   279,    87,    92,    72,
     265,    96,   176,   177,    44,    45,   117,    48,   169,   118
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -180
static const yytype_int16 yypact[] =
{
     525,   587,  -180,    13,    25,    37,    40,   192,    64,   192,
     192,   192,   192,   192,   192,   192,   192,    67,   152,    45,
     116,   130,   146,    81,    22,   192,   192,   192,   105,    25,
      59,    90,   192,   192,   192,   192,   125,   133,   143,   152,
     164,   170,   587,  -180,  -180,   649,   188,  -180,   192,   152,
     176,  -180,  -180,  -180,  -180,  -180,   192,   167,   192,   192,
     192,   192,   192,   192,   192,   192,  -180,  -180,   169,  -180,
    -180,   152,   198,   148,  -180,  -180,  -180,   152,   142,   192,
     189,     9,  -180,  -180,   148,   148,   215,  -180,   152,   146,
     216,   152,   219,    11,   192,   192,   220,   192,  -180,   221,
     222,   192,   223,   192,   192,   192,   192,  -180,  -180,  -180,
     224,  -180,  -180,  -180,  -180,  -180,  -180,   217,   649,  -180,
     226,  -180,  -180,   162,   152,    39,     3,   208,    67,   192,
     192,   192,   192,    33,  -180,  -180,   137,   137,   228,   152,
    -180,   229,   192,  -180,   230,   231,  -180,  -180,  -180,   146,
    -180,  -180,    81,  -180,    25,   192,  -180,  -180,   192,  -180,
    -180,   152,  -180,   192,   192,   192,   213,  -180,    13,  -180,
    -180,  -180,    95,     1,   234,    25,    25,   235,   144,   192,
     152,    41,    31,    67,   192,    67,   152,    33,   236,   177,
     148,  -180,   152,   148,  -180,  -180,   152,  -180,  -180,  -180,
    -180,  -180,  -180,   237,   192,   192,    90,   192,    67,   192,
      67,  -180,   238,   239,   152,   152,   240,   241,    81,   242,
    -180,   243,  -180,  -180,  -180,   182,   152,   244,    41,   152,
     152,    41,  -180,    41,    76,    77,    67,    77,    67,    77,
      33,  -180,  -180,  -180,  -180,  -180,  -180,  -180,   210,    67,
    -180,    81,    81,    67,   -22,  -180,  -180,   152,  -180,  -180,
     245,  -180,  -180,   182,   182,   248,   249,  -180,  -180,  -180,
      41,  -180,  -180,    77,   152,   152,   152,    77,  -180,    77,
      77,  -180,   127,  -180,  -180,   218,   253,    18,   254,   -22,
    -180,  -180,   255,  -180,  -180,  -180,  -180,  -180,  -180,  -180,
    -180,   152,    77,    77,  -180,  -180,  -180,   127,   152,   152,
     152,   127,  -180,   127,   257,  -180,  -180,   152,   259,  -180,
     260,  -180,  -180,  -180,  -180,  -180,   152,   127,   127,  -180,
    -180,  -180,   152,  -180,  -180,   152,  -180,  -180,   152,  -180,
     152,  -180
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -180,  -180,    24,  -180,   -40,  -180,  -180,  -180,  -180,  -180,
    -180,   131,   -12,   174,    -6,   -81,   -20,   190,   -67,  -164,
      66,  -136,  -179,  -104,  -121,   195,   -18,   314,  -138,    71,
     -46,   -30,    -3,    44,   -39,  -180,   156,   102,  -180,  -180
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -120
static const yytype_int16 yytable[] =
{
      71,    50,   172,   146,   147,   115,   116,   181,   214,    84,
      53,    54,    93,    55,   202,    85,    53,    54,   120,    55,
      47,    71,   150,   241,   316,    46,    99,   290,    75,    53,
      54,    71,    55,    67,   213,   219,    76,    49,   234,    54,
     186,    55,   291,    51,    79,    80,    52,    69,    70,    69,
      70,    49,   218,    71,   144,   191,   194,    79,   281,   139,
     283,   235,   237,    67,   239,   156,   113,    82,   317,    84,
     149,   215,   178,   152,    66,    85,   284,    83,   115,   116,
     260,   187,   201,  -119,    57,    69,    70,   252,    91,   254,
     228,   229,   268,   230,   300,   271,    73,   272,   304,    67,
     305,   306,    91,    69,    70,   173,   174,   175,  -119,   243,
     110,    98,   245,   287,   288,   280,   100,   282,   192,   192,
     121,   196,    74,   323,   324,   101,   273,   274,   286,   275,
     276,   107,   289,    75,   299,    69,    70,    53,    54,   108,
      55,    76,   134,   206,    53,   189,    70,    55,   140,   109,
     224,   203,   225,    88,   212,    53,    54,    89,    55,    75,
      69,    70,   227,   233,   111,    79,    80,    76,   240,    66,
      69,    70,    79,    80,   244,   112,   307,   308,   246,   309,
     310,    81,   122,    79,    80,  -115,  -115,   124,    82,    53,
      54,   263,    55,   119,    67,    82,   152,   257,    83,    53,
      54,   133,    55,   325,   135,    83,    82,   329,   266,   330,
     233,   269,   270,   233,   143,   233,    83,   295,   296,   221,
     222,   148,   151,   336,   337,   153,   157,   159,   160,   162,
     167,   168,   171,   180,   195,   197,   199,   200,   210,   293,
     220,   223,   242,   247,   255,   256,   258,   259,   261,   262,
     267,   294,   233,   285,   297,   298,   301,   302,   303,   315,
     319,   321,   314,   331,   313,   333,   334,   154,   193,   320,
     211,   145,   250,   141,   170,     0,     0,     0,     0,     0,
       0,     0,     0,   322,     0,     0,     0,     0,     0,   313,
     326,   327,   328,   313,     0,   313,     0,     0,     0,   332,
       0,     0,     0,     0,     0,     0,     0,     0,   335,   313,
     313,     0,     0,     0,   338,     0,     0,   339,     0,     0,
     340,    56,   341,    58,    59,    60,    61,    62,    63,    64,
      65,     0,     0,     0,     0,     0,     0,     0,     0,    94,
      95,    97,     0,     0,     0,     0,   103,   104,   105,   106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    95,     0,     0,     0,     0,     0,     0,     0,
     123,     0,   125,   126,   127,   128,   129,   130,   131,   132,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,    95,
       0,   158,     0,     0,     0,   161,     0,   163,   164,   165,
     166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     179,     0,     0,   182,   183,   184,   185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
       0,     0,   205,     0,     0,     0,     0,   207,   208,   209,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,   236,     0,   238,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   248,   249,
       0,   251,     0,   253,     0,     0,     0,     0,     1,     0,
       0,     2,     0,     0,     0,     0,     0,     0,     3,   264,
       4,     5,     0,     6,     7,     0,     8,     9,    10,    11,
       0,    12,    13,    14,    15,    16,    17,     0,    18,    19,
       0,     0,    20,    21,    22,    23,    24,    25,     0,     0,
       0,    26,    27,     0,     0,     0,     0,   264,   264,    28,
      29,    30,     0,     0,    31,    32,    33,    34,    35,     0,
      36,    37,    38,     2,     0,     0,    39,     0,     0,     0,
       3,     0,     4,     5,     0,     6,     7,     0,     8,     9,
      10,    11,     0,    12,    13,    14,    15,    16,    17,     0,
      18,    19,     0,     0,    20,    21,    22,    23,    24,    25,
       0,     0,     0,    26,    27,     0,     0,     0,     0,     0,
       0,    28,    29,    30,     0,     0,    31,    32,    33,    34,
      35,     0,    36,    37,    38,   114,     0,     0,    39,     0,
       0,     0,     3,     0,     4,     5,     0,     6,     7,     0,
       8,     9,    10,    11,     0,    12,    13,    14,    15,    16,
      17,     0,    18,    19,     0,     0,    20,    21,    22,    23,
      24,    25,     0,     0,     0,    26,    27,     0,     0,     0,
       0,     0,     0,    28,    29,    30,     0,     0,    31,    32,
      33,    34,    35,     0,    36,    37,    38,     0,     0,     0,
      39
};

static const yytype_int16 yycheck[] =
{
      18,     4,   123,    84,    85,    45,    45,   128,     7,    21,
       7,     8,    24,    10,   152,    21,     7,     8,    48,    10,
       7,    39,    89,   187,     6,     1,    29,    49,    17,     7,
       8,    49,    10,    32,   172,   173,    25,    12,     7,     8,
       7,    10,    64,     6,    35,    36,     6,     8,     9,     8,
       9,    12,   173,    71,    45,   136,   137,    35,   237,    77,
     239,   182,   183,    32,   185,    95,    42,    58,    50,    81,
      88,    70,    69,    91,     7,    81,   240,    68,   118,   118,
     218,    48,   149,     7,    20,     8,     9,   208,     7,   210,
      49,    50,   228,    52,   273,   231,    51,   233,   277,    32,
     279,   280,     7,     8,     9,   123,   124,   125,    32,   190,
      39,     6,   193,   251,   252,   236,    57,   238,   136,   137,
      49,   139,     6,   302,   303,    35,    49,    50,   249,    52,
      53,     6,   253,    17,   270,     8,     9,     7,     8,     6,
      10,    25,    71,   161,     7,     8,     9,    10,     6,     6,
       6,   154,     8,     7,   172,     7,     8,    11,    10,    17,
       8,     9,   180,   181,     0,    35,    36,    25,   186,     7,
       8,     9,    35,    36,   192,     5,    49,    50,   196,    52,
      53,    51,     6,    35,    36,     8,     9,    20,    58,     7,
       8,     9,    10,     5,    32,    58,   214,   215,    68,     7,
       8,    32,    10,   307,     6,    68,    58,   311,   226,   313,
     228,   229,   230,   231,    25,   233,    68,   263,   264,   175,
     176,     6,     6,   327,   328,     6,     6,     6,     6,     6,
       6,    14,     6,    25,     6,     6,     6,     6,    25,   257,
       6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
       6,     6,   270,    43,     6,     6,   274,   275,   276,     6,
       6,     6,    44,     6,   282,     6,     6,    93,   137,   289,
     168,    81,   206,    78,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   301,    -1,    -1,    -1,    -1,    -1,   307,
     308,   309,   310,   311,    -1,   313,    -1,    -1,    -1,   317,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,    -1,    -1,   332,    -1,    -1,   335,    -1,    -1,
     338,     7,   340,     9,    10,    11,    12,    13,    14,    15,
      16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,
      26,    27,    -1,    -1,    -1,    -1,    32,    33,    34,    35,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      56,    -1,    58,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      -1,    97,    -1,    -1,    -1,   101,    -1,   103,   104,   105,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     126,    -1,    -1,   129,   130,   131,   132,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   155,
      -1,    -1,   158,    -1,    -1,    -1,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   179,    -1,    -1,   182,    -1,   184,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   204,   205,
      -1,   207,    -1,   209,    -1,    -1,    -1,    -1,     3,    -1,
      -1,     6,    -1,    -1,    -1,    -1,    -1,    -1,    13,   225,
      15,    16,    -1,    18,    19,    -1,    21,    22,    23,    24,
      -1,    26,    27,    28,    29,    30,    31,    -1,    33,    34,
      -1,    -1,    37,    38,    39,    40,    41,    42,    -1,    -1,
      -1,    46,    47,    -1,    -1,    -1,    -1,   263,   264,    54,
      55,    56,    -1,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    67,     6,    -1,    -1,    71,    -1,    -1,    -1,
      13,    -1,    15,    16,    -1,    18,    19,    -1,    21,    22,
      23,    24,    -1,    26,    27,    28,    29,    30,    31,    -1,
      33,    34,    -1,    -1,    37,    38,    39,    40,    41,    42,
      -1,    -1,    -1,    46,    47,    -1,    -1,    -1,    -1,    -1,
      -1,    54,    55,    56,    -1,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    67,     6,    -1,    -1,    71,    -1,
      -1,    -1,    13,    -1,    15,    16,    -1,    18,    19,    -1,
      21,    22,    23,    24,    -1,    26,    27,    28,    29,    30,
      31,    -1,    33,    34,    -1,    -1,    37,    38,    39,    40,
      41,    42,    -1,    -1,    -1,    46,    47,    -1,    -1,    -1,
      -1,    -1,    -1,    54,    55,    56,    -1,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    67,    -1,    -1,    -1,
      71
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     6,    13,    15,    16,    18,    19,    21,    22,
      23,    24,    26,    27,    28,    29,    30,    31,    33,    34,
      37,    38,    39,    40,    41,    42,    46,    47,    54,    55,
      56,    59,    60,    61,    62,    63,    65,    66,    67,    71,
      73,    74,    75,    76,   106,   107,    74,     7,   109,    12,
     104,     6,     6,     7,     8,    10,    99,    20,    99,    99,
      99,    99,    99,    99,    99,    99,     7,    32,    96,     8,
       9,    98,   101,    51,     6,    17,    25,    85,    97,    35,
      36,    51,    58,    68,    84,    86,    89,    99,     7,    11,
      90,     7,   100,    84,    99,    99,   103,    99,     6,   104,
      57,    35,    92,    99,    99,    99,    99,     6,     6,     6,
     101,     0,     5,    74,     6,    76,   106,   108,   111,     5,
     103,   101,     6,    99,    20,    99,    99,    99,    99,    99,
      99,    99,    99,    32,   101,     6,    84,    86,    87,    98,
       6,    97,    99,    25,    45,    89,    87,    87,     6,    98,
      90,     6,    98,     6,    85,    99,   103,     6,    99,     6,
       6,    99,     6,    99,    99,    99,    99,     6,    14,   110,
     108,     6,    96,    98,    98,    98,   104,   105,    69,    99,
      25,    96,    99,    99,    99,    99,     7,    48,    91,     8,
      83,    87,    98,    83,    87,     6,    98,     6,    99,     6,
       6,    90,   100,   104,    99,    99,    98,    99,    99,    99,
      25,   109,    98,   100,     7,    70,    77,    78,    96,   100,
       6,   105,   105,     6,     6,     8,    99,    98,    49,    50,
      52,    79,    93,    98,     7,    96,    99,    96,    99,    96,
      98,    91,     6,    87,    98,    87,    98,     6,    99,    99,
      92,    99,    96,    99,    96,     6,     6,    98,     6,     6,
     100,     6,     6,     9,    99,   102,    98,     6,    93,    98,
      98,    93,    93,    49,    50,    52,    53,    80,    94,    98,
      96,    94,    96,    94,    91,    43,    96,   100,   100,    96,
      49,    64,    88,    98,     6,   102,   102,     6,     6,    93,
      94,    98,    98,    98,    94,    94,    94,    49,    50,    52,
      53,    81,    95,    98,    44,     6,     6,    50,    82,     6,
      88,     6,    98,    94,    94,    95,    98,    98,    98,    95,
      95,     6,    98,     6,     6,    98,    95,    95,    98,    98,
      98,    98
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 174 "parse_spice.y"
    {
  }
    break;

  case 3:
#line 176 "parse_spice.y"
    {
    spice_title = (yyvsp[(1) - (3)].str);
  }
    break;

  case 4:
#line 179 "parse_spice.y"
    {
    fprintf (stderr, "spice notice, no .END directive found, continuing\n");
  }
    break;

  case 5:
#line 182 "parse_spice.y"
    {
    spice_title = (yyvsp[(1) - (2)].str);
    fprintf (stderr, "spice notice, no .END directive found, continuing\n");
  }
    break;

  case 8:
#line 193 "parse_spice.y"
    {
    /* chain definition root */
    (yyvsp[(1) - (1)].definition)->next = definition_root;
    definition_root = (yyvsp[(1) - (1)].definition);
  }
    break;

  case 9:
#line 198 "parse_spice.y"
    {
    /* chain definition root */
    if ((yyvsp[(1) - (1)].definition)) {
      (yyvsp[(1) - (1)].definition)->next = definition_root;
      definition_root = (yyvsp[(1) - (1)].definition);
    }
  }
    break;

  case 10:
#line 205 "parse_spice.y"
    { /* nothing to do here */ }
    break;

  case 11:
#line 209 "parse_spice.y"
    {
    /* R, L and C definitions */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 12:
#line 217 "parse_spice.y"
    {
    /* R, L and C definitions specified by a Model */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 13:
#line 226 "parse_spice.y"
    {
    /* R, L and C definitions specified by a Model, a variant */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NAME);
  }
    break;

  case 14:
#line 234 "parse_spice.y"
    {
    /* R definitions specified by a Model, yet another variant */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 15:
#line 242 "parse_spice.y"
    {
    /* R definitions including TC1 */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 16:
#line 250 "parse_spice.y"
    {
    /* R definitions including TC1/TC2 */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 17:
#line 258 "parse_spice.y"
    {
    /* Mutual inductors */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (5)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NAME);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (5)].ident), HINT_NUMBER);
  }
    break;

  case 18:
#line 265 "parse_spice.y"
    {
    /* independent current/voltage sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (5)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(4) - (5)].value));
  }
    break;

  case 19:
#line 272 "parse_spice.y"
    {
    /* independent current/voltage sources given the value */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (6)].value));
  }
    break;

  case 20:
#line 280 "parse_spice.y"
    {
    /* voltage controlled source POLY */
    fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[(1) - (7)].ident));
    (yyval.definition) = NULL;
  }
    break;

  case 21:
#line 285 "parse_spice.y"
    {
    /* voltage controlled sources OTHER behavioural */
    fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[(1) - (5)].ident));
    (yyval.definition) = NULL;
  }
    break;

  case 22:
#line 290 "parse_spice.y"
    {
    /* voltage controlled sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NUMBER);
  }
    break;

  case 23:
#line 299 "parse_spice.y"
    {
    /* current controlled sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NAME);
    spice_append_val_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NUMBER);
  }
    break;

  case 24:
#line 307 "parse_spice.y"
    {
    /* device specification */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (5)].ident), (yyvsp[(2) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NAME | HINT_MSTART);
    spice_add_last_hint ((yyvsp[(4) - (5)].value), HINT_MSTOP);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(4) - (5)].value));
  }
    break;

  case 25:
#line 314 "parse_spice.y"
    {
    /* diode */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (5)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (5)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (5)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(5) - (5)].value));
  }
    break;

  case 26:
#line 322 "parse_spice.y"
    {
    /* JFET */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (6)].value));
  }
    break;

  case 27:
#line 331 "parse_spice.y"
    {
    /* 3 node BJT */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (6)].value));
  }
    break;

  case 28:
#line 340 "parse_spice.y"
    {
    /* 4 node BJT */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (7)].value));
  }
    break;

  case 29:
#line 350 "parse_spice.y"
    {
    /* MOS */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (7)].value));
  }
    break;

  case 30:
#line 360 "parse_spice.y"
    {
    /* MES */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (6)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (6)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (6)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (6)].value));
  }
    break;

  case 31:
#line 369 "parse_spice.y"
    {
    /* transient analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 32:
#line 374 "parse_spice.y"
    {
    /* plotting */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), strdup ((yyvsp[(1) - (4)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (4)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(3) - (4)].value));
  }
    break;

  case 33:
#line 380 "parse_spice.y"
    {
    /* AC analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 34:
#line 385 "parse_spice.y"
    {
    /* single DC analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 35:
#line 389 "parse_spice.y"
    {
    /* DC analysis first order */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 36:
#line 394 "parse_spice.y"
    {
    /* DC analysis second order */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), strdup ((yyvsp[(1) - (4)].ident)));
    (yyval.definition)->values = netlist_append_values ((yyvsp[(2) - (4)].value), (yyvsp[(3) - (4)].value));
  }
    break;

  case 37:
#line 399 "parse_spice.y"
    {
    /* printing specifying the analysis type */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), strdup ((yyvsp[(1) - (4)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (4)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(3) - (4)].value));
  }
    break;

  case 38:
#line 405 "parse_spice.y"
    {
    /* printing */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 39:
#line 410 "parse_spice.y"
    {
    /* printing */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), strdup ((yyvsp[(1) - (4)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (4)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (4)].ident), HINT_NAME);
  }
    break;

  case 40:
#line 416 "parse_spice.y"
    {
    /* general analysis options */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 41:
#line 421 "parse_spice.y"
    {
    /* temperatur analysis (Spice 2g6) */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 42:
#line 426 "parse_spice.y"
    {
    /* TODO: default width of ??? */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 43:
#line 431 "parse_spice.y"
    {
    /* noise analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (5)].ident), strdup ((yyvsp[(1) - (5)].ident)));
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(2) - (5)].value));
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (5)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(4) - (5)].value));
  }
    break;

  case 44:
#line 438 "parse_spice.y"
    {
    /* pole-zero analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (8)].ident), strdup ((yyvsp[(1) - (8)].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (8)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(7) - (8)].ident), HINT_NAME);
  }
    break;

  case 45:
#line 448 "parse_spice.y"
    {
    /* subcircuit call */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (3)].ident));
    spice_set_last_hint ((yyvsp[(2) - (3)].value), HINT_NAME);
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 46:
#line 454 "parse_spice.y"
    {
    /* voltage controlled switch */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (8)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (8)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (8)].value));
  }
    break;

  case 47:
#line 464 "parse_spice.y"
    {
    /* current controlled switch */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 48:
#line 473 "parse_spice.y"
    {
    /* lossy transline */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(6) - (7)].ident), HINT_NAME);
  }
    break;

  case 49:
#line 482 "parse_spice.y"
    {
    /* distributed lossy transline */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 50:
#line 491 "parse_spice.y"
    {
    /* lossless transline */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (7)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (7)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (7)].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (7)].value));
  }
    break;

  case 51:
#line 500 "parse_spice.y"
    {
    /* lossless transline and initial condition */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (8)].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[(2) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(3) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(4) - (8)].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[(5) - (8)].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(6) - (8)].value));
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[(7) - (8)].value));
  }
    break;

  case 52:
#line 510 "parse_spice.y"
    {
    /* operating point analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 53:
#line 514 "parse_spice.y"
    {
    /* saving action */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 54:
#line 518 "parse_spice.y"
    {
    /* sensitivity analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 55:
#line 522 "parse_spice.y"
    {
    /* transfer function analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 56:
#line 526 "parse_spice.y"
    {
    /* fourier analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (2)].ident), strdup ((yyvsp[(1) - (2)].ident)));
  }
    break;

  case 57:
#line 530 "parse_spice.y"
    {
    /* non-linear dependent sources */
    (yyval.definition) = spice_create_device ((yyvsp[(1) - (2)].ident));
  }
    break;

  case 58:
#line 534 "parse_spice.y"
    {
    /* distortion analysis */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 59:
#line 539 "parse_spice.y"
    {
    /* file include */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    struct value_t * file = create_value ();
    file->ident = (yyvsp[(2) - (3)].ident);
    file->hint = HINT_NAME;
    (yyval.definition)->values = file;
  }
    break;

  case 60:
#line 547 "parse_spice.y"
    {
    /* nodeset functionality */
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (3)].ident), strdup ((yyvsp[(1) - (3)].ident)));
    (yyval.definition)->values = (yyvsp[(2) - (3)].value);
  }
    break;

  case 61:
#line 555 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (2)].ident), (yyvsp[(2) - (2)].ident));
  }
    break;

  case 62:
#line 562 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (3)].ident), HINT_NUMBER);
  }
    break;

  case 63:
#line 570 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NUMBER);
  }
    break;

  case 64:
#line 578 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (3)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (3)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (3)].ident), HINT_NUMBER);
  }
    break;

  case 65:
#line 586 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (4)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(4) - (4)].ident), HINT_NUMBER);
  }
    break;

  case 66:
#line 596 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (5)].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (5)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (5)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(4) - (5)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(5) - (5)].ident), HINT_NUMBER);
  }
    break;

  case 67:
#line 607 "parse_spice.y"
    { /* range specification during plotting */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NUMBER);
  }
    break;

  case 68:
#line 615 "parse_spice.y"
    {
    /* print/plot specification of node voltage */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), strdup ("V"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (1)].ident), HINT_NODE | HINT_MSTOP);
  }
    break;

  case 69:
#line 621 "parse_spice.y"
    {
    /* print/plot specification of node voltage */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NODE | HINT_MSTOP);
  }
    break;

  case 70:
#line 627 "parse_spice.y"
    {
    /* print/plot specification of differential node voltages */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (3)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (3)].ident), HINT_NODE);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(3) - (3)].ident), HINT_NODE | HINT_MSTOP);    
  }
    break;

  case 73:
#line 640 "parse_spice.y"
    {
    /* print/plot specification of branch current */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (2)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (2)].ident), HINT_NAME | HINT_MSTOP);
  }
    break;

  case 74:
#line 646 "parse_spice.y"
    {
    /* print/plot specification of branch current */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), strdup ("I"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (1)].ident), HINT_NAME | HINT_MSTOP);
  }
    break;

  case 75:
#line 652 "parse_spice.y"
    {
    /* print/plot specification of operating point */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), strdup ("OP"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (1)].ident), HINT_NAME | HINT_MSTOP);
  }
    break;

  case 76:
#line 660 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 77:
#line 661 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 78:
#line 664 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (3)].value), (yyvsp[(2) - (3)].value));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 79:
#line 668 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 80:
#line 671 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (3)].value), (yyvsp[(2) - (3)].value));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 81:
#line 677 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 82:
#line 678 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (1)].ident), HINT_NAME);
  }
    break;

  case 83:
#line 681 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (1)].ident), HINT_NAME);
  }
    break;

  case 84:
#line 686 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 85:
#line 687 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 86:
#line 690 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 87:
#line 695 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 88:
#line 696 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 89:
#line 700 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 90:
#line 706 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 91:
#line 707 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 92:
#line 711 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 93:
#line 717 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 94:
#line 718 "parse_spice.y"
    {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (4)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(2) - (4)].ident), HINT_NODE | HINT_MSTOP);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(3) - (4)].ident), HINT_NUMBER);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(4) - (4)].value));
  }
    break;

  case 95:
#line 727 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 96:
#line 728 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 97:
#line 732 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value (strdup ("Area"), (yyvsp[(1) - (2)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 98:
#line 736 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 99:
#line 740 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 100:
#line 745 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 101:
#line 746 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 102:
#line 750 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value (strdup ("Area"), (yyvsp[(1) - (2)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 103:
#line 754 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 104:
#line 758 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 105:
#line 761 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 106:
#line 767 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 107:
#line 768 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 108:
#line 772 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(3) - (3)].value));
  }
    break;

  case 109:
#line 776 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 110:
#line 780 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 111:
#line 784 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 114:
#line 792 "parse_spice.y"
    {
    /* identification of a DC sweep */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[(1) - (4)].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(2) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(3) - (4)].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[(4) - (4)].ident), HINT_NUMBER | HINT_MSTOP);
  }
    break;

  case 120:
#line 806 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 121:
#line 807 "parse_spice.y"
    {
    (yyval.value) = spice_create_par_value ((yyvsp[(1) - (3)].ident), (yyvsp[(2) - (3)].ident));
    (yyval.value)->next = (yyvsp[(3) - (3)].value);
  }
    break;

  case 122:
#line 813 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 123:
#line 814 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 124:
#line 820 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 125:
#line 821 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NODE);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 126:
#line 825 "parse_spice.y"
    {
    (yyval.value) = spice_create_val_value ((yyvsp[(1) - (2)].ident), HINT_NUMBER);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 127:
#line 831 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 128:
#line 832 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NODE);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 129:
#line 839 "parse_spice.y"
    {
    (yyval.value) = spice_create_str_value ((yyvsp[(1) - (2)].ident), HINT_NAME | HINT_MSTART);
    spice_add_last_hint ((yyvsp[(2) - (2)].value), HINT_MSTOP);
    (yyval.value)->next = (yyvsp[(2) - (2)].value);
  }
    break;

  case 130:
#line 846 "parse_spice.y"
    { (yyval.value) = NULL; }
    break;

  case 131:
#line 847 "parse_spice.y"
    {
    (yyval.value) = netlist_append_values ((yyvsp[(1) - (2)].value), (yyvsp[(2) - (2)].value));
  }
    break;

  case 132:
#line 853 "parse_spice.y"
    {
    (yyvsp[(1) - (3)].definition)->sub = (yyvsp[(2) - (3)].definition);
    (yyval.definition) = (yyvsp[(1) - (3)].definition);
    (yyvsp[(2) - (3)].definition) = NULL;
  }
    break;

  case 133:
#line 861 "parse_spice.y"
    {
    (yyval.definition) = spice_create_action ((yyvsp[(1) - (4)].ident), (yyvsp[(2) - (4)].ident));
    (yyval.definition)->values = (yyvsp[(3) - (4)].value);
  }
    break;

  case 134:
#line 867 "parse_spice.y"
    { (yyval.definition) = NULL; }
    break;

  case 135:
#line 868 "parse_spice.y"
    { /* chain definitions here */
    if ((yyvsp[(1) - (2)].definition)) {
      (yyvsp[(1) - (2)].definition)->next = (yyvsp[(2) - (2)].definition);
      (yyval.definition) = (yyvsp[(1) - (2)].definition);
    }
    else {
      (yyval.definition) = (yyvsp[(2) - (2)].definition);
    }
  }
    break;

  case 137:
#line 882 "parse_spice.y"
    { /* nothing to do */ }
    break;

  case 138:
#line 883 "parse_spice.y"
    { free ((yyvsp[(2) - (2)].ident)); /* nothing to do */ }
    break;

  case 139:
#line 887 "parse_spice.y"
    { /* chain definitions here */
    if ((yyvsp[(1) - (1)].definition)) {
      (yyvsp[(1) - (1)].definition)->next = (yyval.definition);
      (yyval.definition) = (yyvsp[(1) - (1)].definition);
    }
  }
    break;

  case 140:
#line 893 "parse_spice.y"
    { /* do nothing here, see subcircuit rule */ }
    break;

  case 141:
#line 894 "parse_spice.y"
    {
    (yyval.definition) = NULL;
  }
    break;


/* Line 1267 of yacc.c.  */
#line 3105 "parse_spice.cpp"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 899 "parse_spice.y"


int spice_error (char * error) {
  fprintf (stderr, "line %d: %s\n", spice_lineno, error);
  return 0;
}

