

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/
/*! \file bsmoperator.hpp
    \brief differential operator for Black-Scholes-Merton equation

    \fullpath
    ql/FiniteDifferences/%bsmoperator.hpp
*/

// $Id: bsmoperator.hpp,v 1.9 2002/01/16 14:43:25 nando Exp $

#ifndef quantlib_bsm_operator_h
#define quantlib_bsm_operator_h

#include <ql/FiniteDifferences/tridiagonaloperator.hpp>

namespace QuantLib {

    namespace FiniteDifferences {

        //! Black-Scholes-Merton differential operator
        class BSMOperator : public TridiagonalOperator {
          public:
            BSMOperator() {}
            BSMOperator(Size size,
                        double dx,
                        double r,
                        double q,
                        double sigma);
        };

    }

}


#endif
