=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: european_with_dividends.rb,v 1.5 2002/01/16 15:17:06 nando Exp $

require 'QuantLib'
require 'runit/testcase'
require 'runit/testsuite'
require 'runit/cui/testrunner'

def relErr(x1,x2,reference)
    if reference != 0.0
        (x1-x2).abs/reference
    else
        1.0e+10
    end
end

class FdDividendEuropeanOptionTest < RUNIT::TestCase
    def name
        "Testing European option pricer with dividends..."
    end
    def test
        pricer = QuantLib::FdDividendEuropeanOption
        nstp = 150
        ngrd = nstp+1
        div   = [3.92,  4.21]
        dates = [0.333, 0.667]

        # errors allowed for Greeks
        error = { 'delta' => 1.0e-4,
                  'gamma' => 1.0e-4,
                  'theta' => 1.0e-4,
                  'rho'   => 1.0e-4,
                  'vega'  => 1.0e-4
                }

        ['Call','Put','Straddle'].each   { |type|
        [100].each                       { |under|
        [0.0, 0.05,0.15].each            { |qRate|
        [1.0,2.0].each                   { |resTime|
        [0.01,0.1,0.3].each              { |rRate|
        [50, 99.5, 100, 100.5, 150].each { |strike|
        [0.04,0.2,0.7].each              { |vol|

            #Check Greeks
            dS = under/10000.0
            dT = resTime/nstp
            dVol = vol/10000.0
            dR = rRate/10000.0
            opt = pricer.new(type, under, strike, qRate, rRate, resTime,
                             vol, div, dates)
            opt_val = opt.value
            if opt_val > 1.0e-5*under
                optPs = pricer.new(type, under+dS, strike, qRate,
                                   rRate   , resTime   , vol,      div, dates)
                optMs = pricer.new(type, under-dS, strike, qRate,
                                   rRate   , resTime   , vol,      div, dates)
                optPt = pricer.new(type, under   , strike, qRate,
                                   rRate   , resTime+dT, vol,      div,
                                   dates.map { |t| t+dT })
                optMt = pricer.new(type, under   , strike, qRate,
                                   rRate   , resTime-dT, vol,      div,
                                   dates.map { |t| t-dT })
                optPr = pricer.new(type, under   , strike, qRate,
                                   rRate+dR, resTime   , vol,      div, dates)
                optMr = pricer.new(type, under   , strike, qRate,
                                   rRate-dR, resTime   , vol,      div, dates)
                optPv = pricer.new(type, under   , strike, qRate,
                                   rRate   , resTime   , vol+dVol, div, dates)
                optMv = pricer.new(type, under   , strike, qRate,
                                   rRate   , resTime   , vol-dVol, div, dates)

                # numeric values
                results = {
                    'delta' =>  (optPs.value - optMs.value)/(2*dS),
                    'gamma' =>  (optPs.delta - optMs.delta)/(2*dS),
                    'theta' => -(optPt.value - optMt.value)/(2*dT),
                    'rho'   =>  (optPr.value - optMr.value)/(2*dR),
                    'vega' =>   (optPv.value - optMv.value)/(2*dVol)
                }

                ['delta','gamma','theta','rho','vega'].each { |greek|
                    unless relErr(opt.send(greek),results[greek],under) <= error[greek]
                        assert_fail(<<-MESSAGE

    Option details: #{type} #{under} #{strike} #{qRate} #{rRate} #{resTime} #{vol}
        value  = #{opt_val}
        #{greek} = #{opt.send(greek)}, #{greek}Num = #{results[greek]}

                            MESSAGE
                        )
                    end
                }
            end
        }}}}}}}
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(FdDividendEuropeanOptionTest.suite)
end
