
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: RandomNumbers.i,v 1.9 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_random_numbers_i
#define quantlib_random_numbers_i

%include Types.i

%{
using QuantLib::RandomNumbers::UniformRandomGenerator;
using QuantLib::RandomNumbers::GaussianRandomGenerator;
using QuantLib::RandomNumbers::LecuyerUniformRng;
using QuantLib::RandomNumbers::KnuthUniformRng;
typedef QuantLib::MonteCarlo::Sample<double> SampleNumber;
%}

class SampleNumber {
  public:
    ~SampleNumber();
    double value;
    double weight;
  private:
    SampleNumber();
};

class UniformRandomGenerator {
  public:
    UniformRandomGenerator(long seed=0);
    ~UniformRandomGenerator();
    SampleNumber next() const;
};

class GaussianRandomGenerator {
  public:
    GaussianRandomGenerator(long seed=0);
    ~GaussianRandomGenerator();
    SampleNumber next() const;
};

class LecuyerUniformRng {
  public:
    LecuyerUniformRng(long seed=0);
    ~LecuyerUniformRng();
    SampleNumber next() const;
};

class KnuthUniformRng {
  public:
    KnuthUniformRng(long seed=0);
    ~KnuthUniformRng();
    SampleNumber next() const;
};


#endif
