
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Functions.i,v 1.7 2002/01/16 14:50:51 nando Exp $


#ifndef quantlib_functions_i
#define quantlib_functions_i

// Python function
%typemap(python,in) PyObject* pyFunction {
	$target = $source;
}

// different C++ wrappers

%{
class PyUnaryFunction {
  public:
	PyUnaryFunction(PyObject* pyFunction) : pyFunction_(pyFunction) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyUnaryFunction(const PyUnaryFunction& f) : pyFunction_(f.pyFunction_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyUnaryFunction& operator=(const PyUnaryFunction& f) {
        if ((this != &f) && (pyFunction_ != f.pyFunction_)) {
            Py_XDECREF(pyFunction_);
            pyFunction_ = f.pyFunction_;
    	    Py_XINCREF(pyFunction_);
        }
        return *this;
    }
    ~PyUnaryFunction() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyFunction_);
    }
	double operator()(double x) const {
		PyObject* pyResult = PyObject_CallFunction(pyFunction_,"d",x);
		QL_ENSURE(pyResult != NULL, "failed to call Python function");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
  private:
	PyObject* pyFunction_;
};

class PyBinaryFunction {
  public:
	PyBinaryFunction(PyObject* pyFunction) : pyFunction_(pyFunction) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyBinaryFunction(const PyBinaryFunction& f)
    : pyFunction_(f.pyFunction_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyBinaryFunction& operator=(const PyBinaryFunction& f) {
        if ((this != &f) && (pyFunction_ != f.pyFunction_)) {
            Py_XDECREF(pyFunction_);
            pyFunction_ = f.pyFunction_;
    	    Py_XINCREF(pyFunction_);
        }
        return *this;
    }
    ~PyBinaryFunction() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyFunction_);
    }
	double operator()(double x, double y) const {
		PyObject* pyResult = PyObject_CallFunction(pyFunction_,"dd",x,y);
		QL_ENSURE(pyResult != NULL, "failed to call Python function");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
  private:
	PyObject* pyFunction_;
};


using QuantLib::ObjectiveFunction;

class PyObjectiveFunction : public ObjectiveFunction {
  public:
	PyObjectiveFunction(PyObject* pyFunction) : pyFunction_(pyFunction) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyObjectiveFunction(const PyObjectiveFunction& f)
    : pyFunction_(f.pyFunction_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyObjectiveFunction& operator=(const PyObjectiveFunction& f) {
        if ((this != &f) && (pyFunction_ != f.pyFunction_)) {
            Py_XDECREF(pyFunction_);
            pyFunction_ = f.pyFunction_;
    	    Py_XINCREF(pyFunction_);
        }
        return *this;
    }
    ~PyObjectiveFunction() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyFunction_);
    }
	double operator()(double x) const {
		PyObject* pyResult = PyObject_CallFunction(pyFunction_,"d",x);
		QL_ENSURE(pyResult != NULL, "failed to call Python function");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
	double derivative(double x) const {
		PyObject* pyResult =
		  PyObject_CallMethod(pyFunction_,"derivative","d",x);
		QL_ENSURE(pyResult != NULL,
		  "failed to call derivative() on Python object");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
  private:
	PyObject* pyFunction_;
};
%}


#endif
