
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Currencies.i,v 1.9 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_currencies_i
#define quantlib_currencies_i

%{
using QuantLib::Currency;
using QuantLib::EUR;
using QuantLib::USD;
using QuantLib::GBP;
using QuantLib::DEM;
using QuantLib::ITL;
using QuantLib::CHF;
using QuantLib::AUD;
using QuantLib::CAD;
using QuantLib::DKK;
using QuantLib::JPY;
using QuantLib::PLZ;
using QuantLib::SEK;
using QuantLib::CZK;
using QuantLib::EEK;
using QuantLib::ISK;
using QuantLib::NOK;
using QuantLib::SKK;
using QuantLib::HKD;
using QuantLib::NZD;
using QuantLib::SGD;
using QuantLib::GRD;
using QuantLib::HUF;
using QuantLib::LVL;
using QuantLib::ROL;
using QuantLib::BGL;
using QuantLib::CYP;
using QuantLib::LTL;
using QuantLib::MTL;
using QuantLib::TRL;
using QuantLib::ZAR;
using QuantLib::SIT;
using QuantLib::KRW;
using QuantLib::StringFormatter;
using QuantLib::CurrencyFormatter;
%}

%typemap(python,in) Currency (Currency temp), const Currency & (Currency temp) {
    if (PyString_Check($source)) {
        std::string s(PyString_AsString($source));
        s = StringFormatter::toUppercase(s);
        if (s == "EUR")      temp = EUR;
        else if (s == "USD") temp = USD;
        else if (s == "GBP") temp = GBP;
        else if (s == "DEM") temp = DEM;
        else if (s == "ITL") temp = ITL;
        else if (s == "CHF") temp = CHF;
        else if (s == "AUD") temp = AUD;
        else if (s == "CAD") temp = CAD;
        else if (s == "DKK") temp = DKK;
        else if (s == "JPY") temp = JPY;
        else if (s == "PLZ") temp = PLZ;
        else if (s == "SEK") temp = SEK;
        else if (s == "CZK") temp = CZK;
        else if (s == "EEK") temp = EEK;
        else if (s == "ISK") temp = ISK;
        else if (s == "NOK") temp = NOK;
        else if (s == "SKK") temp = SKK;
        else if (s == "HKD") temp = HKD;
        else if (s == "NZD") temp = NZD;
        else if (s == "SGD") temp = SGD;
        else if (s == "GRD") temp = GRD;
        else if (s == "HUF") temp = HUF;
        else if (s == "LVL") temp = LVL;
        else if (s == "ROL") temp = ROL;
        else if (s == "BGL") temp = BGL;
        else if (s == "CYP") temp = CYP;
        else if (s == "LTL") temp = LTL;
        else if (s == "MTL") temp = MTL;
        else if (s == "TRL") temp = TRL;
        else if (s == "ZAR") temp = ZAR;
        else if (s == "SIT") temp = SIT;
        else if (s == "KRW") temp = KRW;
        else {
            PyErr_SetString(PyExc_TypeError,"not a currency");
            return NULL;
        }
    } else {
        PyErr_SetString(PyExc_TypeError,"not a currency");
        return NULL;
    }
    $target = &temp;
};

%typemap(python,out) Currency, const Currency & {
    $target = PyString_FromString(
        CurrencyFormatter::toString(*$source).c_str());
};

%typemap(python,ret) Currency {
    delete $source;
}


#endif
