/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE. 
 */

#ifndef _GNU_SOURCE
# define _GNU_SOURCE
#endif /* _GNU_SOURCE */
#include <stdlib.h>
#include <stdio.h>
#include "wrap.h"

/* Temporary allocation before things are started sufficiently to call 	*/
/* the real malloc. 							*/
#define BUF_SZ 4*1024

typedef long long dword;

static dword buffer[BUF_SZ];

static dword * current = buffer;

static void *
temp_alloc(size_t lb)
{
  size_t size = (lb + sizeof (dword) - 1)/sizeof(dword);
  dword * next = current + size;

  if (next <= buffer + BUF_SZ)
    {
      void * result = current;
      current = next;
      return result;
    }
  else
    {
      fprintf(stderr, "Ran out of temporary malloc space\n");
      return 0;
    }
}

void no_op(void * p) {}

#define pre_malloc(sz) \
	size_t size = sz;

#define post_malloc(res) \
	fprintf(stderr, "malloc(%lu) returned %p\n", (unsigned long)size, res);

#define pre_free(p) \
	if ((dword *)p >= buffer && (dword *)p < buffer + BUF_SZ) return; \
        fprintf(stderr, "deallocating %p\n", p);

#define post_free()

PRELOAD_WRAP1(void *, size_t, malloc, "libc.so.6", pre_malloc, post_malloc, temp_alloc)

PRELOAD_WRAP1V(void *, free, "libc.so.6", pre_free, post_free, no_op);

/* FIXME - This would be more meaningful if we also traced some other	*/
/* related functions, notably calloc and realloc.			*/


