/***************************************************************************
                          qgridview.cpp  -   QGrid
                             -------------------
    begin                : Fri Jan 12 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "qgridview.h"
#include "qgridglobal.h"
#include <qmessagebox.h>
#include <qlabel.h>
#include <qwmatrix.h>
#include "configfile.h"
#include <qlineedit.h>

#include <ctype.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "icons/compass.xpm"
#include "icons/arrow.xpm"

QgridView::QgridView(QWidget *parent, const char *name ) : central (parent,name)
{
	
	compassPix=QPixmap(compass);
	arrowPix=QPixmap(arrow);
	clear();
	drawCompass();
	
}

QgridView::~QgridView()
{
}

void QgridView::saveConfiguration()
{
	configFile.setOption("HomeQTH",locHome->text());
	configFile.saveFile();
}
void QgridView::clear()
{
  locHome->setText(configFile.readOption("HomeQTH"));
  locRemote->setText("");
  latHomeDegrees->setText("");
  latHomeMinutes->setText("");
  latHomeSeconds->setText("");
  latRemoteDegrees->setText("");
  latRemoteMinutes->setText("");
  latRemoteSeconds->setText("");

  longHomeDegrees->setText("");
  longHomeMinutes->setText("");
  longHomeSeconds->setText("");
  longRemoteDegrees->setText("");
  longRemoteMinutes->setText("");
  longRemoteSeconds->setText("");
	degrees=0;
  distance->setText("");
  bearing->setText("");
}


void QgridView::strup(char *st)
{
  uint i;
  for (i=0;i<strlen(st);i++)
    {
      st[i]=toupper(st[i]);
    }
}

void QgridView::calculateToLL()
{
    char tempa[255];
    char tempb[255];
    int  d,m,s;
    float latHome,longHome;
    float latRemote,longRemote;
    float dist,be;

    strcpy(tempa,locHome->text());
    strup(tempa);
    if (strlen(tempa)>0)
      {
	if (!validateLocator(tempa))
	  {
	    QMessageBox::warning( this, "Parse Error","Wrong entry for Locator A", "Quit");
	  }
	else
	  {
	    //calculate lat/long
	    calcLatLong(tempa,latHome, longHome);
	    convertToDMS(latHome,d,m,s);
	    setInt(latHomeDegrees,d);
	    setInt(latHomeMinutes,(m>0?m:-m));
 	    setInt(latHomeSeconds,(s>0?s:-s));
	
	    convertToDMS(longHome,d,m,s);
	    setInt(longHomeDegrees,d);
	    setInt(longHomeMinutes,(m>0?m:-m));
 	    setInt(longHomeSeconds,(s>0?s:-s));     	
	  }
      }

    strcpy(tempb,locRemote->text());
    strup(tempb);

    if (strlen(tempb)>0)
	    {
	    if (!validateLocator(tempb))
	      {
		QMessageBox::warning( this, "Parse Error","Wrong entry for Locator B", "Quit");
	      }
	    else
	      {
					//calculate lat/long
					calcLatLong(tempb,latRemote, longRemote);
					convertToDMS(latRemote,d,m,s);
					setInt(latRemoteDegrees,d);
					setInt(latRemoteMinutes,(m>0?m:-m));
					setInt(latRemoteSeconds,(s>0?s:-s));
		
		convertToDMS(longRemote,d,m,s);
		setInt(longRemoteDegrees,d);
		setInt(longRemoteMinutes,(m>0?m:-m));
		setInt(longRemoteSeconds,(s>0?s:-s));
	      }
	    }
    if ((strlen(tempa)>0) && (strlen(tempb)>0))
      {
				dist=calcDistance(latRemote,longRemote,latHome,longHome,be);
				setInt(distance,(int)(dist+0.5));
				setInt(bearing,(int)(be+0.5));
				degrees=(int)(be+0.5);
				drawCompass();	
      }
}

void QgridView::calculateFromLL()
{
  char tem[7];
  tem[6]=0;
  float latRemote,latHome,longHome,longRemote;
  int dla,mla,sla,dlb,mlb,slb,dea,mea,sea,deb,meb,seb;
  dla=atoi(latHomeDegrees->text());
  mla=atoi(latHomeMinutes->text());
  sla=atoi(latHomeSeconds->text());
  if(dla<0)
    {
      mla=-mla; sla=-sla;
    }
  dlb=atoi(latRemoteDegrees->text());
  mlb=atoi(latRemoteMinutes->text());
  slb=atoi(latRemoteSeconds->text());
  if(dlb<0)
    {
      mlb=-mlb; slb=-slb;
    }
  dea=atoi(longHomeDegrees->text());
  mea=atoi(longHomeMinutes->text());
  sea=atoi(longHomeSeconds->text());
  if(dea<0)
    {
      mea=-mea; sea=-sea;
    }
  deb=atoi(longRemoteDegrees->text());
  meb=atoi(longRemoteMinutes->text());
  seb=atoi(longRemoteSeconds->text());
  if(deb<0)
    {
      meb=-meb; seb=-seb;
    }
  latHome=convertFromDMS(dla,mla,sla);
  latRemote=convertFromDMS(dlb,mlb,slb);

  longHome=convertFromDMS(dea,mea,sea);
  longRemote=convertFromDMS(deb,meb,seb);

  calcLocator(tem,latHome,longHome);
  locHome->setText(tem);

  calcLocator(tem,latRemote,longRemote);
  locRemote->setText(tem);

	float be,dist;
	dist=calcDistance(latRemote,longRemote,latHome,longHome,be);
	setInt(distance,(int)(dist+0.5));
	setInt(bearing,(int)(be+0.5));
	degrees=(int)(be+0.5);
	drawCompass();	

}

void QgridView::convertToDMS(float x, int &d,int &m, int &s)
{
  float st;
  st=(x>0 ? x+1./7200. : x -1./7200.); // round 1/2 of 1/3600
  d=(int)st;
  st=60*(st-(float)d);
  m=(int)st;

  st=60*(st-(float)m);
  s=(int)st;
}

float QgridView::convertFromDMS(int d,int m, int s)
{
  return((float)d+(float)m/60.+(float)s/3600.);		
}

void QgridView::setInt(QLineEdit *ql,int x)
{
  char stemp[30];
  sprintf(stemp,"%d",x);
  ql->setText(stemp);
}

void QgridView::calcLatLong(char *st,float &lat,float &lon)
{
  if (st[4]!=0)
    {
      lon= (20.*((float)st[0]-65.) + 2.*((float)st[2]-48.) + 5.*((float)st[4]-65.)/60.)  - 180.;
      lat= (10.*((float)st[1]-65.) +   ((float)st[3]-48.) + 5.*(st[5]-65.)/120.) - 90.;
    }
  else
    {
      lon= (20.*((float)st[0]-65.) + 2.*((float)st[2]-48.))  - 180.;
      lat= (10.*((float)st[1]-65.) +   ((float)st[3]-48.))  - 90.;
    }
}

void QgridView::calcLocator(char *st,float n,float e)
{
  int t1;
  e=e+180.;
  t1=(int)(e/20);
  st[0]=t1+'A';
  e-=(float)t1*20.;
  t1=(int)e/2;
  st[2]=t1+'0';
  e-=(float)t1*2;
  st[4]=(int)(e*12.+0.5)+'A';

  n=n+90.;
  t1=(int)(n/10.);
  st[1]=t1+'A';
  n-=(float)t1*10.;
  st[3]=(int)n+'0';
  n-=(int)n;
  n*=24; // convert to 24 division
  st[5]=(int)(n+0.5)+'A';
}

float QgridView::calcDistance(float latHome,float longHome,float latRemote,float longRemote,float &be)
{
    // convert to radians
    latHome*=(2.*M_PI)/360.;
    longHome*=(2.*M_PI)/360.;
    latRemote*=(2.*M_PI)/360.;
    longRemote*=(2.*M_PI)/360.;

    float co = cos(longRemote-longHome)*cos(latRemote)*cos(latHome) + sin(latRemote)*sin(latHome);
    float ca = acos(co);
    float dx = 6367.*ca;
    if(calculateInMiles)
      {
	dx/=1.609344;
      }

    // If the distance is reasonable, calculate the
    // bearing. Otherwise return it as zero.
    if (dx > 1e-3)
      {	
	float si = sin(longHome-longRemote)*cos(latHome)*cos(latRemote);
	co = sin(latHome) - sin(latRemote)*cos(ca);
	be = atan2((si > 0 ? si : -si), (co > 0 ? co : -co));
	if (co < 0) be = M_PI - be;
	if (si < 0)	 be = -be;
	if (be < 0) be = be + 2*M_PI;
	be *= 360/(2*M_PI);
      }
    else
      {
	be = 0;
      }
    return dx;
}

bool  QgridView::validateLocator(const char *st)
{

  if ((st[0]>='A')&&(st[0]<='R')&&(st[1]>='A')&&(st[1]<='R'))
    {
      if(isdigit(st[2])&&isdigit(st[3]))
	{
	  if (st[4]==0)
	    {
	      return TRUE;
	    }
	  else if ((st[4]>='A')&&(st[4]<='X')&&(st[5]>='A')&&(st[5]<='X'))
	    {
	      return TRUE;
	    }
	}
    }
  return FALSE;
}


void QgridView::drawCompass()
{
	// combine both compass and arrow
	QWMatrix m;
  m.rotate(degrees);
	QPixmap comboPix =arrowPix.xForm(m);		// off-screen drawing pixmap
	int offset=(comboPix.width()-arrowPix.width())/2;
	QPixmap cptmp;
	cptmp=compassPix;
	bitBlt(&cptmp,QPoint(0,0),&comboPix,QRect(offset,offset,comboPix.width(),comboPix.height()),CopyROP);
	compassLabel->setPixmap(cptmp);
}




