/***************************************************************************
                          qgrid.cpp  -   QGrid
                             -------------------
    begin                : Fri Jan 12 13:46:56 CET 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qaccel.h>
#include "qgridglobal.h"
#include "qlineedit.h"
#include "qgrid.h"
#include "helper.h"
#include "configdiag.h"

bool calculateInMiles;

QgridApp::QgridApp()
{
  setCaption("Qgrid " VERSION);

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initActions();
  initMenuBar();
	initView();
  selectKmMiles->setOn(calculateInMiles);
}

QgridApp::~QgridApp()
{
}

/** initializes all QActions of the application */
void QgridApp::initActions(){
  fileQuit = new QAction("Exit", "E&xit", QAccel::stringToKey("Ctrl+Q"), this);
  fileQuit->setStatusTip("Quits the application");
  fileQuit->setWhatsThis("Exit\n\nQuits the application");
  connect(fileQuit, SIGNAL(activated()), this, SLOT(slotFileQuit()));

	selectKmMiles = new QAction("Miles", "&Miles", 0, this, 0, true);
  selectKmMiles->setStatusTip("Changes the default to miles");
  selectKmMiles->setWhatsThis("Km - Miles\n\nIf selected then distances are in miles");
  connect(selectKmMiles, SIGNAL(toggled(bool)), this, SLOT(slotSelectKmMiles(bool)));


  helpContents= new QAction("Contents", "&Contents", 0, this);
	helpContents->setStatusTip("Documentation");
	helpContents->setWhatsThis("Let's you access the documentation");
	connect(helpContents, SIGNAL(activated()), this, SLOT(slotHelpContents()));
	
	helpLocation= new QAction("Help Path", "Helpfile &Path...", 0, this);
	helpLocation->setStatusTip("Set path to helpfiles");
	helpLocation->setWhatsThis("Let's you set the path to the helpfiles");
	connect(helpLocation, SIGNAL(activated()), this, SLOT(slotHelpLocation()));
		
  helpAboutApp = new QAction("About", "&About...", 0, this);
  helpAboutApp->setStatusTip("About the application");
  helpAboutApp->setWhatsThis("About\n\nAbout the application");
  connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

}

void QgridApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR
	fileMenu=new QPopupMenu();	
  fileQuit->addTo(fileMenu);
	optionMenu=new QPopupMenu();
	selectKmMiles->addTo(optionMenu);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  helpMenu=new QPopupMenu();
	helpContents->addTo(helpMenu);
	helpLocation->addTo(helpMenu);
  helpAboutApp->addTo(helpMenu);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  menuBar()->insertItem("&File", fileMenu);
  menuBar()->insertItem("&Options", optionMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem("&Help", helpMenu);

}




void QgridApp::initView()
{
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  view=new QgridView(this);
  setCentralWidget(view);
}

bool QgridApp::queryExit()
{
  int exit=QMessageBox::information(this, "Quit...",
                                    "Do your really want to quit?",
                                    QMessageBox::Ok, QMessageBox::Cancel);

 return (exit==1);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


void QgridApp::slotFileQuit()
{

	if(queryExit())
    {
      view->saveConfiguration();
      qApp->quit();
    }

}


void QgridApp::slotHelpContents()
{

	QString home=QString(configFile.readOption("PathToHelpFiles"))+"/index.html";
	
	
	QFileInfo finfo(home);
	if (finfo.isReadable())
		{
			HelpWindow *help = new HelpWindow(home, ".", 0, "help viewer");	
 			if ( QApplication::desktop()->width() > 400
	 				&& QApplication::desktop()->height() > 500 )
				{
					help->show();
				}
			else
				{
					help->showMaximized();
				}
		}
	else
		{
	QMessageBox::warning(this,"Contents...",
                      "the file:\n" + home + "\nwas not found\n"
                      + "Change the file " PACKAGE ".conf");		
		}
}


void QgridApp::slotHelpLocation()
{
	configDialog diag(0,0,TRUE);
	diag.helpFilePath->setText(configFile.readOption("PathToHelpFiles"));
	if(diag.exec())
	{
		configFile.setOption("PathToHelpFiles",diag.helpFilePath->text());
	}
}



void QgridApp::slotHelpAbout()
{
  QMessageBox::about(this,"About...",
                      "Qgrid\nVersion " VERSION "\n(c) 2001 by Johan Maes - ON1MH"
                      "\n e-mail: on1mh@pandora.be" );
}



/** Selection of Km or Miles for distance calculation */
void QgridApp::slotSelectKmMiles(bool toggle)
{
  if (toggle == false)
  {
    calculateInMiles=FALSE;
  }
  else
  {
    calculateInMiles=TRUE;
  }
  configFile.setOption("UseMiles",(int)calculateInMiles);
  view->calculateToLL();
}
