/*
 * QSceneTreeRenderer.h
 * $Id: QSceneTreeRenderer.h,v 1.7 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 2001 Richard Guenther, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Definition of the QSceneTreeRenderer class 
//  Purpose     :
//

#ifndef __QSCENETREERENDERER_H
#define __QSCENETREERENDERER_H

#include "QSceneTreeNode.h"
#include "QGLViewer.h"

class QTimer;

#define SELECT_BUF_SIZE 1024


/* Renderer object that is itself the scene tree root node
 * which only has to handle requestUpdate() requests itself.
 */

class QSceneTreeRenderer : public QObject, public QSceneTreeNode {
   Q_OBJECT

public:
   /* Default constructor. */
   QSceneTreeRenderer(QGLViewer *pViewer);
   /* Destructor. */
   ~QSceneTreeRenderer();

   /*
    * QSceneTreeNode part.
    */

  /** Requests an update from the QGLViewer, i.e. emit PaintGL.
    * Update requests come up the scene tree and should be queued
    * and periodically satisfied. */
   virtual void requestUpdate();

   /*
    * QGLViewer interaction part.
    */

public slots:
  //////////////////
  // PUBLIC SLOTS //
  //////////////////

  /** Manages the select events in selection mode. */
  virtual void sltManageSelection(QMouseEvent *pqEvent);

  /** Manages the release events in selection mode. */
  virtual void sltManageRelease(QMouseEvent *pqEvent);

  /** Manages the move events in selection mode. */
  virtual void sltManageMove(QMouseEvent *pqEvent);

  /** Initializes GL state - a sane default is provided. */
  virtual void sltInitializeGL();

  /** Renders the scenetree in depth first order (children in
   * their natural list order). You usually dont want to
   * override this. */
  virtual void sltPaintGL();


protected slots:
  /* A m_fNeedUpdate polling timer handler. */
  virtual void sltPollUpdate();

protected:
  /////////////////////
  // PRIVATE METHODS //
  /////////////////////

  /** processHits prints out the contents of the selection array. */
  virtual GLuint processHits(GLint hits, GLuint buffer[]);

  /** the recursion for the tree traversal. */
  void traverseTree(int &nId, QSceneTreeNode *node);

  /////////////////////
  // PRIVATE MEMBERS //
  /////////////////////

  QGLViewer * const m_pViewer;
  bool m_fNeedUpdate;
  QTimer *m_pTimer;

  bool m_fLeftButtonPressed,
    m_fMiddleButtonPressed,
    m_fRightButtonPressed;
  int m_nMousePosX, m_nMousePosY;
  unsigned int m_nChosen;
};


#endif
