/*
 * CQuat.h
 * $Id: CQuat.h,v 1.3 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 R. Klein, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

#ifndef CQUAT_H
#define CQUAT_H

#include <math.h>
#include "GeoGeneric.h"


class CV4D;
class CV3D;
class CMat4D;


/** This class provides a interface to quaterions 
  *
  * @author R. Klein, Michael Meissner
  */
class CQuat
{ 
   friend class CMat4D;
   double w,x,y,z;
public:
   // Konstruktoren
   CQuat(CMat4D &mat);
   CQuat(double qW,double qX, double qY,double qZ);
   CQuat(double qW,CV3D &vec);
   CQuat(void);

   void setQuat(double qW,double qX, double qY,double qZ) { w=qW; x=qX; y=qY; z=qZ; }

   // Initialisierung
   CQuat(const CQuat& );

   // Zuweisung
   void operator=(const CQuat& );

   // Addition-Operatoren
   CQuat operator+(CQuat&);
   CQuat operator-(CQuat&);
   CQuat operator-();
   
   // Multiplikation
   CQuat operator*(CQuat&);
   CQuat operator*(double&);
   friend CQuat operator*(double a,CQuat& q)
   { CQuat r; r.w=a*q.w; r.x=a*q.x;r.y=a*q.y;r.z=a*q.z; return r; }

   // Konjugation
   CQuat conj();
   CQuat inv();
 
   // Skalarprodukt
   double operator|(CQuat&);

   // Norm bzw. Normalisierung von Quaternionen
   double norm();
   CQuat normalize();
 
   // Zugriff auf Real- bzw. Imaginaerteil
   double re();
   CV3D im();

   double xv() const;
   double yv() const;
   double zv() const;
   double wv() const;

   // Beschleunigte Berechnung von Rotationen
   CQuat QVQ(CQuat&);

   CV3D rotate(CV3D& vec);

   
   // Ausgabe
   void print();
   /*
   Mat getRotMat();
   Mat3D getRotMat3D() const;
   */
};

inline 
double 
CQuat :: xv () const
{
   return x;
}

inline 
double 
CQuat :: yv () const
{
   return y;
}

inline 
double 
CQuat :: zv () const
{
   return z;
}

inline 
double 
CQuat :: wv () const
{
   return w;
}

#endif
