/* KInterbasDB Python Package - Header File for Central Concurrency Facilities
**
** Version 3.1
**
** The following contributors hold Copyright (C) over their respective
** portions of code (see license.txt for details):
**
** [Original Author (maintained through version 2.0-0.3.1):]
**   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
** [Maintainers (after version 2.0-0.3.1):]
**   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
**   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
** [Contributors:]
**   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
**   2001-2002 [janez] Janez Jere            <janez.jere@void.si>
*/

#ifndef _KILOCK_H
#define _KILOCK_H

#include "_kinterbasdb.h"

#define LEAVE_PYTHON_WITHOUT_ENTERING_DB   Py_BEGIN_ALLOW_THREADS
#define ENTER_PYTHON_WITHOUT_LEAVING_DB    Py_END_ALLOW_THREADS

#if SHOULD_MANAGE_GIL
  /* #define _DEBUG_LOCKS */

  #include "pythread.h"

  /* module_thread_lock is defined in _kinterbasdb.c */
  extern PyThread_type_lock module_thread_lock;

  #define ENTER_DB \
    { \
      Py_BEGIN_ALLOW_THREADS; \
      ENTER_DB_WITHOUT_LEAVING_PYTHON

  #define LEAVE_DB \
      LEAVE_DB_WITHOUT_ENTERING_PYTHON \
      Py_END_ALLOW_THREADS; \
    }

  #ifndef _DEBUG_LOCKS
    #define ENTER_DB_WITHOUT_LEAVING_PYTHON \
        PyThread_acquire_lock(module_thread_lock, WAIT_LOCK);

    #define LEAVE_DB_WITHOUT_ENTERING_PYTHON \
        PyThread_release_lock(module_thread_lock);
  #else
    #define ENTER_DB_WITHOUT_LEAVING_PYTHON \
        printf("LOCK-> ?ACQUIRE: %d file %s line %ld\n", PyThread_get_thread_ident(), __FILE__, __LINE__); \
        PyThread_acquire_lock(module_thread_lock, WAIT_LOCK); \
        printf("LOCK-> !!ACQUIRED: %d file %s line %ld\n", PyThread_get_thread_ident(), __FILE__, __LINE__);

    #define LEAVE_DB_WITHOUT_ENTERING_PYTHON \
        PyThread_release_lock(module_thread_lock); \
        printf("LOCK-> !RELEASED: %d file %s line %ld\n", PyThread_get_thread_ident(), __FILE__, __LINE__);
  #endif /* _DEBUG_LOCK */

  #define LEAVE_DB_WITHOUT_ENDING_CODE_BLOCK \
    /* Relies on knowledge of an implementation detail of Py_BEGIN_ALLOW_THREADS \
    ** (that it saves its thread state in a variable called _save). */ \
    LEAVE_DB_WITHOUT_ENTERING_PYTHON \
    PyEval_RestoreThread(_save);

#else /* not SHOULD_MANAGE_GIL */

  #define ENTER_DB
  #define LEAVE_DB
  #define ENTER_DB_WITHOUT_LEAVING_PYTHON
  #define LEAVE_DB_WITHOUT_ENTERING_PYTHON
  #define LEAVE_DB_WITHOUT_ENDING_CODE_BLOCK

#endif /* SHOULD_MANAGE_GIL */


#endif /* not def _KILOCK_H */
