# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExecutionStatistics(Model):
    """Description about the errors happen while performing migration validation.

    :param execution_count: No. of query executions
    :type execution_count: long
    :param cpu_time_ms: CPU Time in millisecond(s) for the query execution
    :type cpu_time_ms: float
    :param elapsed_time_ms: Time taken in millisecond(s) for executing the
     query
    :type elapsed_time_ms: float
    :param wait_stats: Dictionary of sql query execution wait types and the
     respective statistics
    :type wait_stats: dict[str,
     ~azure.mgmt.datamigration.models.WaitStatistics]
    :param has_errors: Indicates whether the query resulted in an error
    :type has_errors: bool
    :param sql_errors: List of sql Errors
    :type sql_errors: list[str]
    """

    _attribute_map = {
        'execution_count': {'key': 'executionCount', 'type': 'long'},
        'cpu_time_ms': {'key': 'cpuTimeMs', 'type': 'float'},
        'elapsed_time_ms': {'key': 'elapsedTimeMs', 'type': 'float'},
        'wait_stats': {'key': 'waitStats', 'type': '{WaitStatistics}'},
        'has_errors': {'key': 'hasErrors', 'type': 'bool'},
        'sql_errors': {'key': 'sqlErrors', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ExecutionStatistics, self).__init__(**kwargs)
        self.execution_count = kwargs.get('execution_count', None)
        self.cpu_time_ms = kwargs.get('cpu_time_ms', None)
        self.elapsed_time_ms = kwargs.get('elapsed_time_ms', None)
        self.wait_stats = kwargs.get('wait_stats', None)
        self.has_errors = kwargs.get('has_errors', None)
        self.sql_errors = kwargs.get('sql_errors', None)
