# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeSetup(Model):
    """Use this to prepare the VM. NOTE: The volumes specified in mountVolumes are
    mounted first and then the setupTask is run. Therefore the setup task can
    use local mountPaths in its execution.

    :param setup_task: Specifies a setup task which can be used to customize
     the compute nodes of the cluster. The NodeSetup task runs everytime a VM
     is rebooted. For that reason the task code needs to be idempotent.
     Generally it is used to either download static data that is required for
     all jobs that run on the cluster VMs or to download/install software.
    :type setup_task: ~azure.mgmt.batchai.models.SetupTask
    :param mount_volumes: Information on shared volumes to be used by jobs.
     Specified mount volumes will be available to all jobs executing on the
     cluster. The volumes will be mounted at location specified by
     $AZ_BATCHAI_MOUNT_ROOT environment variable.
    :type mount_volumes: ~azure.mgmt.batchai.models.MountVolumes
    :param performance_counters_settings: Specifies settings for performance
     counters collecting and uploading.
    :type performance_counters_settings:
     ~azure.mgmt.batchai.models.PerformanceCountersSettings
    """

    _attribute_map = {
        'setup_task': {'key': 'setupTask', 'type': 'SetupTask'},
        'mount_volumes': {'key': 'mountVolumes', 'type': 'MountVolumes'},
        'performance_counters_settings': {'key': 'performanceCountersSettings', 'type': 'PerformanceCountersSettings'},
    }

    def __init__(self, **kwargs):
        super(NodeSetup, self).__init__(**kwargs)
        self.setup_task = kwargs.get('setup_task', None)
        self.mount_volumes = kwargs.get('mount_volumes', None)
        self.performance_counters_settings = kwargs.get('performance_counters_settings', None)
