# testsuite.py - load modules and do the tests
#
# Copyright (C) 2001 Federico Di Gregorio  <fog@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# -*- Mode: pyhton -*-

ID = "$Id: testsuite.py,v 1.5 2001/03/30 10:44:44 fog Exp $"
VERSION = "0.1"


import sys, getopt


# the lists of tests, in sorted order
DBAPI_20_TESTS = ['dbinit.py', 'types.py', 'dbcleanup.py',]

# the database connection string, can be overriden by commad line args
# (note that the database should already exists, table are dropped
# before test start and after test end using the dbinit and dbclean tests
DSN = "dbname=test"
BACKEND = ''
MODULE = ''

# the table used to do the major part of the tests, we split it
# in two arrays, column names and types, please add the right types
# for other database backends
TABLE = "test"
TABLE_COLUMNS = ('ANID',        # an unique id 
                 'AFIELD',     # an 8 char text field (char(8))
                 'ASTRING',    # a variable length (max 40) string
                 'ANUMBER',    # a floating point number
                 'ABINARY',    # a string of binary data (png image)
                 'ATIME',      # just the time
                 'ADATE',      # just the date
                 'ATIMESTAMP', # both time and date
                 'NEVERNULL',  # an integer that can't be null
                 'ANULL',      # a string that will be null
                 'ANOID'       # rowid or something similar
                 )

# two functions used to keep track of passed tests
OK = 0
KO = 0

def ok(msg):
    global OK
    OK = OK + 1
    print msg
    
def ko(msg):
    global KO
    KO = KO + 1
    print msg
    
# print banner
print "Paco, the Python DBAPI-2.0 compliance testsuite"
print "Version %s [%s]" % (VERSION, ID)
print "Copyright (C) 2001 Federico Di Gregorio <fog@debian.org>"
print

# parse options and load backend specific data
options, args = getopt.getopt(sys.argv[1:], 'm:b:d:',
                              ['module=', 'backend=', 'dsn='])

for opt in options:
    if opt[0] == '-m' or opt[0] == '--module':
        MODULE = opt[1]
    elif opt[0] == '-b' or opt[0] == '--backend':
        BACKEND = opt[1]
    elif opt[0] == '-d' or opt[0] == '--dsn':
        DSN = opt[1]
if not BACKEND or not MODULE:
    print "Usage: %s --module=MODULE --backend=BACKEND [--dsn=DSN]" % sys.argv[0]
    sys.exit(1)

print "Loading %s backend..." % BACKEND,
try:
    execfile('tables.'+BACKEND)
except StandardError, err:
    print "\nError: backend data loading failed:", err
    sys.exit(2)
print "done"

print "Loading %s module..." % MODULE,
try:
    dba = __import__(MODULE)
except StandardError, err:
    print "\nError: module loading failed:", err
print "done"

# here we try to open a connection (then every test will open its own
# connection, we just want to fail here if the DSN is not valid)
print "Opening DB connection using DSN '%s'..." % DSN,
try:
    o = dba.connect(DSN)
except StandardError, err:
    print "\nError: can't open connection to DB:", err
print "done"
del o

# this is the real start of the tests: we simply walk throug the list
# loading and executing the modules as we encounter them (we need a list
# only because we want to execute the modules in a given order)

print
print "**** DBAPI-2.0 tests"
for i in range(len(DBAPI_20_TESTS)):
    print '  %d. %s --' % (i+1, DBAPI_20_TESTS[i]),
    execfile('tests/'+DBAPI_20_TESTS[i])
print

print "**** END of tests"
print

print "RESULT:", MODULE, "passed", OK, "tests on", OK+KO
