#ifdef	DEBUG_IP

/*
#define	DEBUG_SNEAKER
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#ifdef linux
#include <net/if_arp.h>
#if !defined(ETHERTYPE_IP) && defined(ETH_P_IP)
#define	ETHERTYPE_IP	ETH_P_IP
#endif
#else
#include <netinet/in_systm.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#endif

#include <config.h>
#include <support.h>
#include <osdep.h>

#include "option.h"
#include "ipsupport.h"

static FILE *debugFp;

void
DebugOpen()
{
#ifdef	DEBUG_SNEAKER
    extern char *ifName;
    u_int32_t type=0;

    if (debugFp) fclose(debugFp);
    if ((debugFp = fopen("debugip.pkt", "w")) != NULL) {
	fwrite(ifName, 16, 1, debugFp);
	fwrite(&type, sizeof(type), 1, debugFp);
	fflush(debugFp);
    }
#else
#if 1
    debugFp = fopen("debug.ip", "w");
#else
    debugFp = stderr;
#endif
#endif
}

void
ExplainIp(char *name, bool_t trans, ipv4_hdr *iphp, int len)
{
#ifdef	DEBUG_SNEAKER
    u_int32_t tmp;
    int ret;

    tmp = htonl(len);
    ret = fwrite(&tmp, sizeof(len), 1, debugFp);
    tmp = htonl(trans ? 10000:0);
    ret = fwrite(&tmp, sizeof(tmp), 1, debugFp);
    tmp = htonl(time(0));
    ret = fwrite(&tmp, sizeof(tmp), 1, debugFp);
    fwrite(iphp, len, 1, debugFp);
#else
    struct in_addr in;
    tcp_hdr *tp;
    bool_t port=FALSE;
    char *proto=NULL;
#ifdef	ALIGNED_ACCESS
    static u_char buf[2048];
    tcp_hdr aab_tp;
    tp = &aab_tp;

    memcpy(buf, iphp, len);
    iphp = (ipv4_hdr *)buf;
#endif

    in.s_addr = GET_U32(&(iphp->ip_src.s_addr));

    if (iphp->ip_p == IPPROTO_ICMP) proto = "ICMP";
    else {
	if (iphp->ip_p == IPPROTO_TCP) proto = "TCP";
	else if (iphp->ip_p == IPPROTO_UDP) proto = "UDP";
	port = TRUE;
    }

#ifdef	ALIGNED_ACCESS
    memcpy(tp, (char *)iphp + (iphp->ip_hl << 2), sizeof(*tp));
#else
    tp = (tcp_hdr *)((char *)iphp + (iphp->ip_hl << 2));
#endif

    fprintf(debugFp, "[%c%c](%02d) %13.13s", trans ? 'X': ' ',
	    *name, len, inet_ntoa(in));
    if (port)
	fprintf(debugFp, ":%4d->", ntohs(tp->th_sport));
    else
	fprintf(debugFp, "     ->");
    in.s_addr = iphp->ip_dst.s_addr;
    fprintf(debugFp, "%13.13s", inet_ntoa(in));
    if (port)
	fprintf(debugFp, ":%4d ", ntohs(tp->th_dport));
    else
	fprintf(debugFp, "      ");

    fprintf(debugFp, "%s ", proto);
    if (iphp->ip_p == IPPROTO_TCP) {
	/*      fprintf(debugFp, "(%d)", tp->th_off);*/
      if (tp->th_flags & TH_FIN) fprintf(debugFp, "F");
      if (tp->th_flags & TH_SYN) fprintf(debugFp, "S");
      if (tp->th_flags & TH_RST) fprintf(debugFp, "R");
      if (tp->th_flags & TH_PUSH) fprintf(debugFp, "P");
      if (tp->th_flags & TH_ACK) fprintf(debugFp, "A");
      if (tp->th_flags & TH_URG) fprintf(debugFp, "U");
      fprintf(debugFp, " %8lx/%8lx",
	      ntohl(GET_U32(&tp->th_seq)) & 0xffffffff,
	      ntohl(GET_U32(&tp->th_ack)) & 0xffffffff);
    }

    fprintf(debugFp, "\n");
    fflush(debugFp);
#endif
}

#endif
