#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Vendor.h>
#include <stdio.h>
#include "PartsP.h"

#define sDisp      XtDisplay(pw)
#define sScreen    XtScreen(pw)
#define sRoot      XRootWindowOfScreen(XtScreen(pw))
#define sWidth     pw->core.width
#define sHeight    pw->core.height
#define sOnPixmap  pw->parts.on_pixmap
#define sOffPixmap pw->parts.off_pixmap
#define sOnAttr    pw->parts.on_attr
#define sOffAttr   pw->parts.off_attr

#define offset(field) XtOffsetOf(PartsRec, field)
static XtResource resources[] = {
  { XtNstate, XtCState, XtRBoolean, sizeof(Boolean),
            offset(parts.state), XtRImmediate, (XtPointer)FALSE },
  { XtNonPixmapData, XtCPixmapData, XtRPointer, sizeof(XtPointer),
            offset(parts.on_pixmap_data), XtRPointer, NULL },
  { XtNoffPixmapData, XtCPixmapData, XtRPointer, sizeof(XtPointer),
            offset(parts.off_pixmap_data), XtRPointer, NULL },
};
#undef offset

static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void Destroy();
static XtGeometryResult QueryGeometry();

static char defaultTranslation[] = "";
static XtActionsRec actions[] = {{NULL, NULL}};

PartsClassRec partsClassRec = {
  {
  /* superclass             */ (WidgetClass) &coreClassRec,
  /* class_name             */ "Parts",
  /* widget_size            */ sizeof(PartsRec),
  /* class_initialize       */ NULL,
  /* class_part_initialize  */ NULL,
  /* class_inited           */ FALSE,
  /* initialize             */ Initialize,
  /* initialize_hook        */ NULL,
  /* realize                */ XtInheritRealize,
  /* actions                */ actions,
  /* num_actions            */ XtNumber(actions),
  /* resources              */ resources,
  /* num_resourece          */ XtNumber(resources),
  /* xrm_class              */ NULLQUARK,
  /* compress_motion        */ TRUE,
  /* compress_exposure      */ TRUE,
  /* compress_enterleave    */ TRUE,
  /* visible_interest       */ FALSE,
  /* destroy                */ Destroy,
  /* resize                 */ Resize,
  /* expose                 */ Redisplay,
  /* set_values             */ SetValues,
  /* set_values_hook        */ NULL,
  /* set_values_almoset     */ XtInheritSetValuesAlmost,
  /* get_values_hook        */ NULL,
  /* accept_focus           */ NULL,
  /* version                */ XtVersion,
  /* callback_private       */ NULL,
  /* tm_table               */ defaultTranslation,
  /* query_geometry         */ QueryGeometry,
  /* display_accelator      */ XtInheritDisplayAccelerator,
  /* extention              */ NULL
  },{
  /* foo                    */ 0
  }
};
WidgetClass partsWidgetClass = (WidgetClass)&partsClassRec;

static void
Initialize(Widget wreq, Widget wnew)
{
        PartsWidget pw = (PartsWidget) wnew;
        Pixmap Mask;
        int rst;

        sOnAttr.valuemask = XpmReturnInfos 
                          | XpmReturnAllocPixels
                          | XpmReturnExtensions;
        rst = XpmCreatePixmapFromData(sDisp, sRoot, pw->parts.on_pixmap_data, 
                            &sOnPixmap, &Mask, &sOnAttr);
        if (rst != 0) XpmError(rst);
        if (Mask) XFreePixmap(sDisp, Mask);

        sOffAttr.valuemask = XpmReturnInfos 
                           | XpmReturnAllocPixels
                           | XpmReturnExtensions;
        rst = XpmCreatePixmapFromData(sDisp, sRoot, pw->parts.off_pixmap_data, 
                            &sOffPixmap, &Mask, &sOffAttr);
        if (rst != 0) XpmError(rst);
        if (Mask) XFreePixmap(sDisp, Mask);

        if (sWidth == 0) {
                sWidth = sOffAttr.width;
        }
        if (sHeight == 0) {
                sHeight = sOffAttr.height;
        }
        if (pw->parts.state) {
                XtVaSetValues((Widget)pw,
                              XtNbackgroundPixmap, sOnPixmap, NULL);
        } else {
                XtVaSetValues((Widget)pw,
                              XtNbackgroundPixmap, sOffPixmap, NULL);
        }
}

static void
Redisplay(Widget w, XExposeEvent *event)
{
        PartsWidget pw = (PartsWidget) w;

        return;
}

static Boolean
SetValues(Widget wcur, Widget wreq, Widget wnew)
{
        PartsWidget cur = (PartsWidget) wcur;
        PartsWidget pw  = (PartsWidget) wnew;
        Boolean redraw = False;

        if (cur->parts.state != pw->parts.state) {
                if (pw->parts.state) {
                        XtVaSetValues((Widget)pw,
                                      XtNbackgroundPixmap, sOnPixmap,NULL);
                } else {
                        XtVaSetValues((Widget)pw,
                                      XtNbackgroundPixmap, sOffPixmap,NULL);
                }
        }
        return redraw;
}

static
void Destroy(Widget w)
{
        PartsWidget pw = (PartsWidget) w;
        Colormap cmap;

        cmap=DefaultColormapOfScreen(sScreen);
        if (sOnPixmap)
                XFreePixmap(sDisp, sOnPixmap);
        XFreeColors(sDisp, cmap,
                    sOnAttr.alloc_pixels,
                    sOnAttr.nalloc_pixels, 0);
        XpmFreeAttributes(&sOnAttr);

        if (sOffPixmap)
                XFreePixmap(sDisp, sOffPixmap);
        XFreeColors(sDisp, cmap,
                    sOffAttr.alloc_pixels,
                    sOffAttr.nalloc_pixels, 0);
        XpmFreeAttributes(&sOffAttr);

}

static void
Resize(Widget w)
{
        PartsWidget pw = (PartsWidget) w;

        return;
}

static XtGeometryResult
QueryGeometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
        PartsWidget pw = (PartsWidget) w;

        answer->request_mode = CWWidth | CWHeight;
        answer->width  = sWidth;
        answer->height = sHeight;
        return XtGeometryAlmost;
}
