#
#
#
#

proc term:input {s} {
    global PPxP
    if {$s != ""} {
	$PPxP input $s
    }
}

option add PPxPTerm*closeButton.text "Close"

proc term:create {w} {
    toplevel $w -class PPxPTerm
    wm withdraw $w
    wm title $w "PPxP Terminal"

    frame $w.term
    text $w.term.text -width 80 -height 16 \
	-yscrollcommand "$w.term.yscroll set"
    scrollbar $w.term.yscroll -command "$w.term.text yview"
    pack $w.term.text -side left -fill both -expand yes
    pack $w.term.yscroll -side right -fill y

    frame $w.buttons
    button $w.buttons.closeButton -command [list term:hide $w]
    pack $w.buttons.closeButton -side left

    pack $w.term    -side top -fill both -expand yes
    pack $w.buttons -side top -fill both -expand yes

    set crlf "\r\n"
    bind $w.term.text <Key> [list eval "term:input %A; break"]
    bind $w.term.text <Key-Return> \
	[list eval "term:input {$crlf}; break"]

    PPxP:MessageWidget $w [list term:output $w.term.text]
}

proc term:output {w} {
    global PPxPMessage

    set s $PPxPMessage
    regsub -all "\r" $s "" s
    $w insert end $s
    $w see end
}

proc term:hide {w} {
    wm withdraw $w
}

proc term:show {w} {
    global PPxPVar PPxPStatus

    if {![PPxP:Dialing]} {
	return
    }
    if {
	(![info exists PPxPVar(AUTH.PROTO)] ||
	$PPxPVar(AUTH.PROTO) == "none" || $PPxPVar(AUTH.PROTO) == "") &&
	(![info exists PPxPVar(CHAT)] ||
	$PPxPVar(CHAT) == "none" || $PPxPVar(CHAT) == "")
    } {
	if {![winfo exists $w]} {
	    term:create $w
	}
	wm deiconify $w
	focus $w.term.text
    }
}

PPxP:RegisterUpdateStatus {term:show .ppxpTerminal}
