/* property.c
 *
 * Copyright (C) 1999-2000 Yurika.
 *
 * Copyright (C) 2000 Takuo Kitame <kitame@northeye.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "all.h"

GQuark configname_quark = 0;
GQuark always_load_config_on_startup_quark = 0;
GQuark quickendisconnect_quark = 0;

static void
property_changed_cb(GtkWidget *w, gpointer data)
{
    gnome_property_box_changed(GNOME_PROPERTY_BOX(data));

    return;
}

static void
property_help(GnomePropertyBox *gpb, gint page, gpointer data)
{
    return;
}

static void
dynamic_menu_update(GtkWidget *menu, GList *list, gint skip)
{
    GtkWidget *old_active_item;
    static GQuark user_data_quark = 0;
    gint c, t;
    GtkWidget *menuitem;
    gchar *str;
    GList *items;
    GList *itemstmp;
    GList *add;
    GList *remove;
    
    old_active_item = gtk_menu_get_active(GTK_MENU(menu));
    if (!user_data_quark)
        user_data_quark = g_quark_from_static_string ("user_data");
    
    c = 1;
    add = NULL;
    remove = NULL;
    items = GTK_MENU_SHELL (menu)->children;
    items = g_list_first (items);
    items = g_list_nth (items, skip);
    while (list) {
        if (!items) {
            str = g_strdup(list->data);
            menuitem = gtk_menu_item_new_with_label (str);
            gtk_object_set_data_by_id_full (GTK_OBJECT (menuitem),
                                            user_data_quark, str,
                                            (GtkDestroyNotify) g_free);
            gtk_widget_show (menuitem);
            add = g_list_append (add, (gpointer) - 1);
            add = g_list_append (add, menuitem);
            c++;
        } else
            if (strcmp ((gchar *) gtk_object_get_data_by_id (GTK_OBJECT (items->data),
                                                             user_data_quark), list->data) != 0) {
                itemstmp = g_list_next (items);
                t = FALSE;
                while (itemstmp && itemstmp->data) {
                    if (strcmp ((gchar *) gtk_object_get_data_by_id (GTK_OBJECT (itemstmp->data), user_data_quark), list->data) == 0) {
                        t = TRUE;
                        break;
                    }
                    itemstmp = g_list_next (itemstmp);
                }
                if (t) {
                    while (items != itemstmp) {
                        remove = g_list_append (remove, items->data);
                        items = g_list_next (items);
                    }
                    items = g_list_next (items);
                } else {
                    str = g_strdup(list->data);
                    menuitem = gtk_menu_item_new_with_label (str);
                    gtk_object_set_data_by_id_full (GTK_OBJECT (menuitem),
                                                    user_data_quark, str,
                                                    (GtkDestroyNotify) g_free);
                    gtk_widget_show (menuitem);
                    add = g_list_append (add, (gpointer) c);
                    add = g_list_append (add, menuitem);
                    c++;
                }
            } else	{
                items = g_list_next (items);
                c++;
            }
        list = g_list_next (list);
    }

    while (items) {
        remove = g_list_append (remove, items->data);
        items = g_list_next (items);
    }

    itemstmp = add;
    while (add) {
        t = (gint) add->data;
        add = g_list_next (add);
        gtk_menu_insert (GTK_MENU (menu), add->data, t);
        add = g_list_next (add);
    }
    g_list_free (itemstmp);
    
    itemstmp = remove;
    while (remove) {
        if(remove->data == old_active_item)
            gtk_menu_set_active(GTK_MENU(menu), 0);
        
        gtk_container_remove (GTK_CONTAINER (menu), remove->data);
        remove = g_list_next (remove);
    }
    g_list_free (itemstmp);
    
    gtk_menu_reposition (GTK_MENU (menu));
}

static gint
configname_map(GtkWidget *menu, gpointer data)
{
    DIR *dp;
    struct direct *dir;
    gchar *str;
    GList *files;
    GList *tmplist;
    gchar buf[BUFSIZ];
    
    buf[0] = '\0';
    strncpy (buf, getenv ("HOME"), BUFSIZ);
    strncat (buf, "/.ppxp/conf", BUFSIZ);
    g_return_val_if_fail ((dp = opendir (buf)) != NULL, FALSE);
    
    files = NULL;
    
    while ((dir = readdir (dp)) != NULL) {
        if (dir->d_ino == 0)
            continue;
        
      if (strncmp (".", dir->d_name, 1) == 0)
          continue;
      
      str = g_malloc (strlen (dir->d_name) + 1);
      strcpy (str, dir->d_name);
      files = g_list_append (files, str);
    }
    closedir (dp);

    dynamic_menu_update(menu, files, 1);
    
    tmplist = files;
    while(tmplist) {
        g_free(tmplist->data);
        tmplist = g_list_next(tmplist);
    }
  
    g_list_free(files);
    
    return FALSE;
}

static GtkWidget *
property_page1(GtkWidget *applet, GtkWidget *gpb, Ppxp *ppxp)
{
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *label;
    GtkWidget *configname;
    GtkWidget *configname_menu;
    GtkWidget *glade_menuitem;
    GtkWidget *quickendisconnect;
    gchar *configname_str, *str;
    
    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER(vbox), 10);
    
    hbox = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    
    label = gtk_label_new (_("Configuration Name:"));
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    
    configname = gtk_option_menu_new ();
    gtk_object_set_data(GTK_OBJECT(gpb), "configname", configname);
    gtk_box_pack_start (GTK_BOX (hbox), configname, TRUE, TRUE, 0);
    
    configname_menu = gtk_menu_new ();
    glade_menuitem = gtk_menu_item_new_with_label (_("None"));
    gtk_object_set_data(GTK_OBJECT(glade_menuitem), "user_data", "");
    gtk_menu_append (GTK_MENU (configname_menu), glade_menuitem);
    gtk_signal_connect(GTK_OBJECT(configname_menu), "selection_done",
                       property_changed_cb, gpb);
    gtk_signal_connect(GTK_OBJECT(configname_menu),"map",
                       GTK_SIGNAL_FUNC(configname_map), NULL);
    gtk_option_menu_set_menu (GTK_OPTION_MENU (configname), configname_menu);
    
    configname_str = gtk_object_get_data(GTK_OBJECT(applet), "configname");
    if(configname_str[0] != '\0') {
        str = g_strdup (configname_str);
        glade_menuitem = gtk_menu_item_new_with_label (str);
        gtk_object_set_data(GTK_OBJECT(glade_menuitem), "user_data", str);
        gtk_menu_append (GTK_MENU (configname_menu), glade_menuitem);

        gtk_option_menu_set_history(GTK_OPTION_MENU(configname), 1);
    } else
        gtk_option_menu_set_history(GTK_OPTION_MENU(configname), 0);
  
    quickendisconnect = gtk_check_button_new_with_label (_("quicken disconnect"));
    gtk_object_set_data(GTK_OBJECT(gpb), "quickendisconnect", quickendisconnect);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(quickendisconnect),
                                 (gboolean)gtk_object_get_data(GTK_OBJECT(applet),
                                                               "quickendisconnect"));
    gtk_signal_connect(GTK_OBJECT(quickendisconnect), "toggled",
                       property_changed_cb, gpb);
    gtk_box_pack_start(GTK_BOX (vbox), quickendisconnect, FALSE, TRUE, 0);

    gtk_widget_show_all(vbox);
    
    return vbox;
}

static void
property_apply(GnomePropertyBox *gpb, gint page, gpointer data)
{
    Ppxp *ppxp = (Ppxp *)data;
    GtkWidget *tmp;
    GtkWidget *applet;
    gchar *configname,*buf;
    gboolean quickendisconnect;

    if (page < 0) return;
    
    applet = gtk_object_get_data(GTK_OBJECT(gpb), "applet");
    
    tmp = gtk_object_get_data(GTK_OBJECT(gpb), "quickendisconnect");
    quickendisconnect = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tmp));
    gtk_object_set_data(GTK_OBJECT(applet),
                        "quickendisconnect",
                        (gpointer)quickendisconnect);
    
    tmp = gtk_object_get_data(GTK_OBJECT(gpb), "configname");
    tmp = GTK_OPTION_MENU(tmp)->menu_item;
    buf = gtk_object_get_data(GTK_OBJECT(tmp), "user_data");
    configname = g_strdup (buf);
    gtk_object_set_data_full(GTK_OBJECT(applet), "configname",
                             configname,(GtkDestroyNotify)g_free);
    if(configname[0] != '\0'){
        ppxp_source(ppxp, configname);
    }
}

static void
newconfig_write (GtkWidget *button,  gpointer data)
{
    GtkWidget *property = data;
    GtkWidget *w;
    gchar *p,*p2;
    gchar *loginname,*passwd;
    gchar buf[BUFSIZ];
    FILE *fp;
    Ppxp *ppxp;
  
    ppxp = gtk_object_get_data(GTK_OBJECT(property), "ppxp");
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_configname");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] == '\0') {
        gnome_error_dialog(_("File name isn't input."));
        return;
    }
  
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_phonenumber");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] == '\0') {
        gnome_error_dialog(_("Phone number isn't input."));
        return;
    }
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_loginname");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] == '\0') {
      gnome_error_dialog(_("Login name isn't input."));
      return;
    }
    loginname = p;
  
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_password1");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_password2");
    p2 = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] == '\0' || strcmp(p, p2) != 0) {
        gnome_error_dialog(_("Password isn't input properly."));
        w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_password1");
        gtk_entry_set_text(GTK_ENTRY(w), "");
        w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_password2");
        gtk_entry_set_text(GTK_ENTRY(w), "");
        return;
    }
    passwd = p;
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_configname");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    buf[0] = '\0';
    strncpy (buf, getenv ("HOME"), BUFSIZ);
    strncat (buf, "/.ppxp/conf/", BUFSIZ);
    strncat (buf, p, BUFSIZ);
    fp = fopen(buf, "w");
    if(fp == NULL) {
        gnome_error_dialog(_("Couldn't open file to write."));
        return;
    }
    
    ppxp_passwd(ppxp, p, loginname, passwd);
    
    fprintf(fp, "source qdial\n");
    fprintf(fp, "set AUTH.PASSWD %s\n", p);
    fprintf(fp, "set LOG.FILE %s.log\n", p);
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_pppmode");
    p = gtk_object_get_data(GTK_OBJECT(GTK_OPTION_MENU(w)->menu_item),
                            "user_data");
    if(p[0] != '\0')
        fprintf(fp, "set MODE %s\n", p);
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_devicename");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] != '\0')
        fprintf(fp, "set LINE %s\n", p);
    else
        fprintf(fp, "set LINE %s\n", "/dev/modem");
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_modemtype");
    p = gtk_object_get_data(GTK_OBJECT(GTK_OPTION_MENU(w)->menu_item),
                            "user_data");
    if(p[0] != '\0')
        fprintf(fp, "set SERIAL.MODEM %s\n", p);
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_phonenumber");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    fprintf(fp, "set DIAL.LIST %s\n", p);
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_dialtype");
    p = gtk_object_get_data(GTK_OBJECT(GTK_OPTION_MENU(w)->menu_item),
                            "user_data");
    if(p[0] != '\0')
        fprintf(fp, "set DIAL.TYPE %s\n", p);
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_authprotocol");
    p = gtk_object_get_data(GTK_OBJECT(GTK_OPTION_MENU(w)->menu_item),
                          "user_data");
    if(p[0] != '\0')
        fprintf(fp, "set AUTH.PROTO %s\n", p);
  
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_idletime");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] != '\0')
        fprintf(fp, "set IDLE.INIT %s\n", p);
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_vjcomp");
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
        fprintf(fp, "set IP.VJ yes\n");
    else
        fprintf(fp, "set IP.VJ no\n");
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_createresolv");
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
        fprintf(fp, "set IP.RESOLV yes\n");
    else
        fprintf(fp, "set IP.RESOLV no\n");
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_ipmasq");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] != '\0')
        fprintf(fp, "filter ip +mO -S %s\n", p);
    
    w = gtk_object_get_data(GTK_OBJECT(property), "newconfig_dns");
    p = gtk_entry_get_text(GTK_ENTRY(w));
    if(p[0] != '\0')
        fprintf(fp, "set IP.DNS %s\n", p);
    
    fclose(fp);
    
    gnome_ok_dialog(_("Succeeded."));
}

static void
newconfig_clear (GtkButton *button, gpointer data)
{
    GtkWidget *property = data;
    GtkWidget *widget;
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_configname");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_devicename");
    gtk_entry_set_text(GTK_ENTRY(widget), "/dev/modem");
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_phonenumber");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
  
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_loginname");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_password1");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_password2");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_dialtype");
    gtk_option_menu_set_history(GTK_OPTION_MENU(widget), 0);
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_authprotocol");
    gtk_option_menu_set_history(GTK_OPTION_MENU(widget), 0);
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_pppmode");
    gtk_option_menu_set_history(GTK_OPTION_MENU(widget), 0);
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_idletime");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_ipmasq");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_dns");
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_vjcomp");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    
    widget = gtk_object_get_data(GTK_OBJECT(property), "newconfig_createresolv");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
}

static gint
modemtype_map(GtkWidget *menu, gpointer data)
{
    DIR *dp;
    struct direct *dir;
    gchar *str;
    GList *files;
    GList *tmplist;
    gchar buf[BUFSIZ];
    
    buf[0] = '\0';
    strncpy (buf, PPXP_SYSCONFDIR, BUFSIZ);
    strncat (buf, "/ppxp/modem", BUFSIZ);
    g_return_val_if_fail ((dp = opendir (buf)) != NULL, FALSE);
    
    files = NULL;
    
    while ((dir = readdir (dp)) != NULL) {
        if (dir->d_ino == 0)
            continue;
        
        if (strncmp (".", dir->d_name, 1) == 0)
            continue;
        
        str = g_malloc (strlen (dir->d_name) + 2);
        strcpy (str, "/");
        strcat (str, dir->d_name);
        files = g_list_append (files, str);
    }
    closedir (dp);
    
    dynamic_menu_update(menu, files, 0);
    
    tmplist = files;
    while(tmplist){
        g_free(tmplist->data);
        tmplist = g_list_next(tmplist);
    }
    
    g_list_free(files);
    
    return FALSE;
}

static GtkWidget *
config_create_page(Ppxp *ppxp)
{
    GtkWidget *vbox;
    GtkWidget *notebook;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *tab;

    GtkWidget *obj;
    GtkWidget *menu;
    GtkWidget *opmenu;
    
    GtkWidget *hbuttonbox;
    
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_object_set_data(GTK_OBJECT (vbox), "ppxp", ppxp);
    
    notebook = gtk_notebook_new ();
    gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
    
    table = gtk_table_new (6, 2, FALSE);
    gtk_container_add (GTK_CONTAINER (notebook), table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 10);
    gtk_table_set_row_spacings (GTK_TABLE (table), 3);
    gtk_table_set_col_spacings (GTK_TABLE (table), 3);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT(vbox), "newconfig_devicename", obj);
    
    gtk_table_attach(GTK_TABLE(table), obj, 1, 2, 1, 2,
                     GTK_EXPAND | GTK_FILL, (GtkAttachOptions)0, 0, 0);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT(vbox), "newconfig_phonenumber", obj);
    
    gtk_table_attach(GTK_TABLE(table), obj, 1, 2, 3, 4,
                     GTK_EXPAND | GTK_FILL, (GtkAttachOptions)0, 0, 0);
    
    label = gtk_label_new (_("Dial Type:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
                      GTK_FILL, (GtkAttachOptions)0, 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("Device Name:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                      GTK_FILL, (GtkAttachOptions)0, 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("Phone Number(s):"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
                      GTK_FILL,(GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    opmenu = gtk_option_menu_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_dialtype", opmenu);
    gtk_table_attach (GTK_TABLE (table), opmenu, 1, 2, 2, 3,
                      GTK_FILL, (GtkAttachOptions)0, 0, 0);
    
    menu = gtk_menu_new ();

    obj = gtk_menu_item_new_with_label (_("Default"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("PIAFS"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "Piafs");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("ISDN"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "Isdn");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label(_("Pulse"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "Pulse");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("Tone"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "Tone");
    gtk_menu_append(GTK_MENU(menu), obj);

    gtk_option_menu_set_menu(GTK_OPTION_MENU(opmenu), menu);
    
    label = gtk_label_new (_("Login Name:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 4, 5,
                      GTK_FILL, (GtkAttachOptions)0, 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_loginname", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 4, 5,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions)0, 0, 0);
    
    label = gtk_label_new (_("Login Password:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 5, 6,
                      GTK_FILL, (GtkAttachOptions)0, 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("Password(confirm):"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 6, 7,
                      GTK_FILL, (GtkAttachOptions)0, 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_password1", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 5, 6,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions)0, 0, 0);
    gtk_entry_set_visibility(GTK_ENTRY(obj), FALSE);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_password2", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 6, 7,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions)0, 0, 0);
    gtk_entry_set_visibility (GTK_ENTRY (obj), FALSE);
    
    label = gtk_label_new (_("File Name:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
                      GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_configname", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 0, 1,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions)0, 0, 0);
    
    tab = gtk_label_new (_("Basic"));
    gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
                                gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), tab);

    /* */
    table = gtk_table_new (8, 2, FALSE);
    gtk_container_add (GTK_CONTAINER (notebook), table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 10);
    gtk_table_set_row_spacings (GTK_TABLE (table), 3);
    gtk_table_set_col_spacings (GTK_TABLE (table), 3);
    
    label = gtk_label_new (_("IP Masquerade:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 4, 5,
                      GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("Authentication Protocol:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
                      GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("PPP Mode:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                    GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("Modem Type:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
                      GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("Idle time:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
                    GTK_FILL,(GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    label = gtk_label_new (_("DNS Servers:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 7, 8,
                      GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
    
    opmenu = gtk_option_menu_new ();
    gtk_object_set_data (GTK_OBJECT (vbox), "newconfig_authprotocol", obj);
    gtk_table_attach (GTK_TABLE (table), opmenu, 1, 2, 0, 1,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);

    menu = gtk_menu_new ();
    obj = gtk_menu_item_new_with_label (_("PAP CHAP/MD5 CHAP/MS"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "PAP CHAP/MD5 CHAP/MS");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("PAP"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "PAP");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("CHAP/MD5"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "CHAP/MD5");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("CHAP/MS"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "CHAP/MS");
    gtk_menu_append(GTK_MENU(menu), obj);

    gtk_option_menu_set_menu(GTK_OPTION_MENU(opmenu), menu);
    
    opmenu = gtk_option_menu_new ();
    gtk_object_set_data (GTK_OBJECT (vbox), "newconfig_pppmode", opmenu);
    gtk_table_attach (GTK_TABLE (table), opmenu, 1, 2, 1, 2,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    
    menu = gtk_menu_new ();
    obj = gtk_menu_item_new_with_label (_("active"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "active");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("kick"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "kick");
    gtk_menu_append(GTK_MENU(menu), obj);

    obj = gtk_menu_item_new_with_label (_("passive"));
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "passive");
    gtk_menu_append(GTK_MENU(menu), obj);

    gtk_option_menu_set_menu(GTK_OPTION_MENU(opmenu), menu);
    
    opmenu = gtk_option_menu_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_modemtype", opmenu);
    gtk_table_attach (GTK_TABLE (table), opmenu, 1, 2, 2, 3,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);

    menu = gtk_menu_new ();
    obj = gtk_menu_item_new_with_label ("/generic");
    gtk_object_set_data(GTK_OBJECT(obj), "user_data", "/generic");
    gtk_menu_append(GTK_MENU(menu), obj);

    gtk_option_menu_set_menu(GTK_OPTION_MENU(opmenu), menu);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_idletime", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 3, 4,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_ipmasq", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 4, 5,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    
    obj = gtk_entry_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_dns", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 7, 8,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    
    obj = gtk_check_button_new_with_label (_("VJ compression"));
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_vjcomp", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 5, 6,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);

    obj = gtk_check_button_new_with_label (_("Create resolv.conf"));
    gtk_object_set_data(GTK_OBJECT (vbox), "newconfig_createresolv", obj);
    gtk_table_attach (GTK_TABLE (table), obj, 1, 2, 6, 7,
                      GTK_EXPAND | GTK_FILL, (GtkAttachOptions) (0), 0, 0);
    
    tab = gtk_label_new (_("Advanced"));
    gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), tab);

    hbuttonbox = gtk_hbutton_box_new ();
    gtk_object_set_data(GTK_OBJECT (vbox), "hbuttonbox", hbuttonbox);
    gtk_box_pack_start (GTK_BOX (vbox), hbuttonbox, TRUE, TRUE, 0);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox), 0);
    
    obj = gtk_button_new_with_label (_("Write"));
    gtk_container_add (GTK_CONTAINER (hbuttonbox), obj);
    GTK_WIDGET_SET_FLAGS (obj, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT (obj), "clicked", newconfig_write, vbox);

    obj = gtk_button_new_with_label (_("Clear"));
    gtk_container_add (GTK_CONTAINER (hbuttonbox), obj);
    GTK_WIDGET_SET_FLAGS (obj, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(obj), "clicked", newconfig_clear, vbox);

    return vbox;
}

void
save_property(GtkWidget *widget, gchar *privcfgpath, gchar *globcfgpath)
{
    gnome_config_push_prefix(privcfgpath);
    
    if(!configname_quark)
        configname_quark = g_quark_from_string("configname");
    if(!always_load_config_on_startup_quark)
        always_load_config_on_startup_quark 
            = g_quark_from_string("always_load_config_on_startup");
    if(!quickendisconnect_quark)
        quickendisconnect_quark = g_quark_from_string("quickendisconnect");
    
    gnome_config_set_string("ppxp/configname",
                            gtk_object_get_data_by_id(GTK_OBJECT(widget),
                                                      configname_quark));
    
    gnome_config_set_string("ppxp/always_load_config_on_startup",
                            gtk_object_get_data_by_id(GTK_OBJECT(widget),
                                                      always_load_config_on_startup_quark));
    
    gnome_config_set_bool("ppxp/quicken_disconnect",
                          (gboolean)gtk_object_get_data_by_id(GTK_OBJECT(widget),quickendisconnect_quark));
    
    gnome_config_sync();
    
    gnome_config_pop_prefix();
}

void
load_property (GtkWidget *widget, gchar *privcfgpath, gchar *globcfgpath)
{
    gchar *str;
    gboolean always_load_config_on_startup;
    gboolean quicken_disconnect;
    
    if (!configname_quark)
        configname_quark = g_quark_from_string("configname");
    if (!always_load_config_on_startup_quark)
        always_load_config_on_startup_quark 
            = g_quark_from_string("always_load_config_on_startup");
    if (!quickendisconnect_quark)
        quickendisconnect_quark = g_quark_from_string("quickendisconnect");
    
    gnome_config_push_prefix(privcfgpath);
    
    str = gnome_config_get_string("ppxp/configname=");
    gtk_object_set_data_by_id_full(GTK_OBJECT(widget), configname_quark,str,
                                   (GtkDestroyNotify)g_free);
    
    always_load_config_on_startup
        = gnome_config_get_bool ("ppxp/always_load_config_on_startup=FALSE");
    gtk_object_set_data_by_id(GTK_OBJECT(widget),always_load_config_on_startup_quark,
                              (gpointer)always_load_config_on_startup);
    
    quicken_disconnect = gnome_config_get_bool("ppxp/quicken_disconnect=FALSE");
    gtk_object_set_data_by_id(GTK_OBJECT(widget),quickendisconnect_quark,
                              (gpointer)quicken_disconnect);
    
    gnome_config_pop_prefix();
}

void
property_dialog (AppletWidget *applet, gpointer data)
{
    Ppxp *ppxp = (Ppxp *)data;
    GtkWidget *dialog;
    GtkWidget *page;
    GtkWidget *label;
    
    dialog = gnome_property_box_new ();
    
    gtk_object_set_data(GTK_OBJECT(dialog), "applet", applet);
    
    page = property_page1(GTK_WIDGET(applet), dialog, ppxp);
    label = gtk_label_new (_("PPxP"));
    gnome_property_box_append_page (GNOME_PROPERTY_BOX(dialog),
                                    page, label);

    label = gtk_label_new (_("New Setting"));
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   config_create_page(ppxp), label);
    
    gtk_signal_connect (GTK_OBJECT(dialog), "apply",
                        GTK_SIGNAL_FUNC(property_apply), ppxp);
    gtk_signal_connect (GTK_OBJECT(dialog), "help",
                        GTK_SIGNAL_FUNC(property_help),  ppxp);
    
    gtk_widget_show_all (dialog);
}
