/*
 *  $Id: pcitweaks.c,v 1.8 2001/09/18 11:47:32 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <config.h>
#include <string.h>
/* for readdir/stat and friends */
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <assert.h>

#include <powertweak.h>
#include "pci.h"
#include "PCILIB/pciutils.h"

#include <tree.h>

extern int xmlDoValidityCheckingDefaultValue;

struct pci_access *pacc;

static void load_xml_recursive (char *path)
{
	DIR *dir;
	struct dirent *di;
	char *filebuf;		

	dir = opendir (path);
	if (dir == NULL) {
		printf ("xml datadir for PCI not found \n");
		return;
	}
	di = readdir (dir);
	while (di != NULL) {
		int stringlen;
		struct stat statbuf;
		
		stringlen=strlen(path)+strlen(di->d_name)+4;
			/* 4: 1 for the "/", 1 for the \0 and 2 to make sure */
			
		filebuf = calloc(stringlen,1); assert(filebuf!=NULL);

		strncpy (filebuf, path, stringlen);
		strncat (filebuf, "/",stringlen-1-strlen(filebuf));
		strncat (filebuf, di->d_name, stringlen - strlen (filebuf)-1);

		if (strstr (filebuf, ".xml") != NULL)
			load_PCI_xmlfile (filebuf);

		if ((strcmp (di->d_name, ".") != 0) && (strcmp (di->d_name, "..") != 0)) {
			stat (filebuf, &statbuf);
			if (S_ISDIR (statbuf.st_mode))
				load_xml_recursive (filebuf);
		}


		di = readdir (dir);
		free(filebuf);
	}

	closedir (dir);

}


int ClosePCIBackend (void)
{
	pci_cleanup (pacc);
	pacc = NULL;

	return TRUE;
}


/* Initialise PCI access routines. */
int InitPlugin (int showinfo)
{
	LIBXML_TEST_VERSION
	
	if (!fileexists("/proc/bus/pci"))
		return FALSE;

	pacc = pci_alloc ();
	pacc->error = die;
	pci_init (pacc);
	pci_scan_bus (pacc);

	build_PCI_tree (showinfo);
	load_xml_recursive (PT_DATADIR "/pci");

	pci_free_name_list(pacc);

	RegisterShutdownCallback(&ClosePCIBackend);
	
	return TRUE;
}
