#include "prefs.h"

void close_prefs(GtkWidget *widget, gpointer *data)
{
	GtkWidget *win = gtk_widget_get_toplevel(widget);
	gtk_widget_destroy(win);
}

void save_prefs(GtkWidget *widget, gpointer *data)
{
	GtkWidget *win, *ckbx, *entry;
	picwindow *pwindow = (picwindow*) data;
	gchar *text;

	win = gtk_widget_get_toplevel(widget);
	ckbx = (GtkWidget*) gtk_object_get_data(GTK_OBJECT(win), "ckbx");
	entry = (GtkWidget*) gtk_object_get_data(GTK_OBJECT(win), "entry");
	
	pwindow->use_external_viewer = GTK_TOGGLE_BUTTON(ckbx)->active;	

	text = gtk_editable_get_chars(GTK_EDITABLE(entry), 0, -1);
	strcpy(pwindow->viewer, text);
	g_free(text);

	close_prefs(win, NULL);
}

void write_prefs(picwindow *pwindow)
{
	FILE *fh = NULL;
	gchar *filename = g_strconcat(getenv("HOME"), "/.picviewrc", NULL);

	fh = fopen(filename, "w+");
	if (fh)
	{
		fprintf(fh, "%i %i %i %s\n", pwindow->fullscreen,
				pwindow->largesize,
				pwindow->use_external_viewer,
				pwindow->viewer);

		fclose(fh);
	}
	g_free(filename);
}

void read_prefs(picwindow *pwindow)
{
	FILE *fh = NULL;

	gchar *filename = g_strconcat(getenv("HOME"), "/.picviewrc", NULL);
	int fullscreen, largesize, use_external_viewer;

	fh = fopen(filename, "r");
	if (fh)
	{
		fscanf(fh, "%i %i %i %s\n", &pwindow->fullscreen,
				&pwindow->largesize,
				&pwindow->use_external_viewer,
				pwindow->viewer);

	//	pwindow->fullscreen = fullscreen;
	//	pwindow->largesize = largesize;
	//	pwindow->use_external_viewer = use_external_viewer;
		fclose(fh);
	}
	g_free(filename);
}

void show_prefs(picwindow *pwindow)
{
	GtkWidget *prefs_win, *label, *vbox, *hbox, *entry, *ckbx, *button;

    	prefs_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(prefs_win), vbox);
	gtk_container_set_border_width(GTK_CONTAINER(prefs_win), 5);

	label = gtk_label_new("Select image viewing program");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(vbox), label, 0, 0, 3);

	ckbx = gtk_check_button_new_with_label("Use external viewer");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ckbx), pwindow->use_external_viewer);
	gtk_object_set_data(GTK_OBJECT(prefs_win), "ckbx", (gpointer)ckbx);

	gtk_widget_show(ckbx);
	gtk_box_pack_start(GTK_BOX(vbox), ckbx, 0, 0, 3);

	hbox = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, 0, 0, 3);

	label = gtk_label_new("Program: ");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, 0, 0, 3);

	entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), entry, 0, 0, 3);
	gtk_entry_set_text(GTK_ENTRY(entry), pwindow->viewer);
	gtk_widget_show(entry);
	gtk_object_set_data(GTK_OBJECT(prefs_win), "entry", (gpointer)entry);

	hbox = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, 0, 0, 3);

	button = gtk_button_new_with_label("Cancel");
	gtk_widget_show(button);
	gtk_box_pack_end(GTK_BOX(hbox), button, 0, 0, 3);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(close_prefs), NULL);
	
	button = gtk_button_new_with_label("OK");
	gtk_widget_show(button);
	gtk_box_pack_end(GTK_BOX(hbox), button, 0, 0, 3);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(save_prefs), pwindow);
	
	gtk_signal_connect(GTK_OBJECT(prefs_win), "delete_event", GTK_SIGNAL_FUNC(close_prefs), NULL);
	gtk_widget_show(prefs_win);
}
