function [varargout] = pfs_read_rgb( fileName )
% Read hdr image file (formats accepted by pfsin) and return R, G,
% and B color channels or a single 3D matrix.
%
% [R G B] = pfs_read_rgb( fileName )
% img = pfs_read_rgb( fileName )
%
% R, G, B - red, green and blue color channels, given as linear response
% img - 3D matrix image, where img(:,:,1:3) represents red, blue and green
%       color channels

  %Check if file exists
  fid = fopen( fileName, 'rb' );
  if( fid == -1 ) 
    error( 'pfs_read_rgb: File "%s" does not exist', fileName );
  end
  fclose( fid );

  fid = pfspopen( sprintf( '%spfsin ''%s''%s', pfs_shell(), fileName, pfs_shell( 1 ) ), 'r' );
  pin = pfsopen( fid );
  pin = pfsget( pin );

  [R G B] = pfs_transform_colorspace( 'XYZ', pin.channels.X, pin.channels.Y, pin.channels.Z, 'RGB' );    
  
  if( nargout == 3 )
      varargout{1} = R;
      varargout{2} = G;
      varargout{3} = B;
  elseif( nargout  == 1 )
      varargout{1}(:,:,1) = R;
      varargout{1}(:,:,2) = G;
      varargout{1}(:,:,3) = B;
  else
      error( 'pfs_read_rgb: wrong number of output arguments' );
  end
  
  pfsclose( pin );
  % TODO: Check why crashes on windows
  if ~ispc()
      pfspclose( fid );
  end
end
