#ifndef _PFE_OPTION_EXT_H
#define _PFE_OPTION_EXT_H 1002653677
/* generated 2001-1009-2054 ../../../pfe/../mk/Make-H.pl ../../../pfe/option-ext.c */

#include <pfe/incl-ext.h>

/** 
 * -- Almost-Non-Volatile Environment Options
 * 
 *  Copyright (C) Tektronix, Inc. 2001 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE              @(#) %derived_by: guidod %
 *  @version %version: bln_mpt1!1.22 %
 *    (%date_modified: Tue Oct 02 15:04:16 2001 %)
 *
 *  @description
 *       the openfirmware standard specifies some means to add
 *       options to a non-volatile ram-area (nvram) that are used
 *       in the bootup sequence of the forth-based bootsystem.
 *       Here we add an internal API for looking for bootup options,
 *       an internal API to add bootup options through commandline
 *       processing, and an external API to change the bootup options
 *       for a => COLD reboot or an => APPLICATION specific sequence.
 *       The external API will try to follow openfirmware as closely
 *       as possible without having a real non-volatile ram-area.
 *       Instead there is a session-struct that can be changed and
 *       from which multiple forth-threads can be instantiated
 *       later using those options. The forth-instantion processing
 *       is not supposed to scan for commandline options, which is
 *       a mere necessity in embedded enviroments where option
 *       transferal is done in a completly different way and where
 *       the forth thread is never killed but just stopped or
 *       restarted for various reasons. Even that there is no real
 *       nvram we add a cold-options reboot-area in this wordset.
 *       The option-ram is organized just along a normal dictionary
 *       just need to add a wordlist-handlestruct to find the
 *       definitions in this dictlike ram-portion.
 */

#ifdef __cplusplus
extern "C" {
#endif


typedef p4_Session p4_Options;


extern P4_CODE (p4_string_RT);

_extern  p4xt p4_search_option (const p4char* nm, int l, p4_Options* opt) ; /*{*/

_extern  p4xt p4_create_option (const p4char* name, int len, int size, p4_Options* opt) ; /*{*/

_extern  p4cell p4_search_option_value (const p4char* nm, int l, p4cell defval, p4_Options* opt) ; /*{*/

_extern  p4cell p4_create_option_value (const p4char* nm, int l, p4cell defval, p4_Options* opt) ; /*{*/

_extern  p4xt p4_change_option_value (const p4char* nm, int l, p4cell defval, p4_Options* opt) ; /*{*/

_extern  const p4char* p4_search_option_string (const p4char* nm, int l, const p4char* defval, p4_Options* opt) ; /*{*/

_extern  const p4char* p4_create_option_string (const p4char* nm, int l, const p4char* defval, p4_Options* opt) ; /*{*/

_extern  p4xt p4_change_option_string (const p4char* nm, int l, const p4char* defval, p4_Options* opt) ; /*{*/

_extern  p4ucell p4_convsize (const char* s, p4ucell elemsize) ; /*{*/

#ifdef __cplusplus
} /* extern "C" */
#endif


#endif
