

if ($#ARGV < 0)
{
    print STDERR 
	" $$: $0  @ARGV
 DESCRIPTION
  the input stream is searched for: ITEMCDEF,ITEMXDOC
  
  Each of these ITEMCDEF will get a number for later reference,
  whereas the number is being put as <ITEMPFELIST$i>.
";
    exit(0);
}

use strict;

my %o;

sub c2x_cdefs_list
{
    my ($in,$xml) = @_;
    my $i = 10;
    my $F;
    my $fulltext = "";
    my $f;
    
    $in =~  s{ <(ITEMCDEF\d*|ITEMXDOC\d*)> ((?:.(?!</?\1>))*.?) (</\1>) }
             {   ++$i;
                 $fulltext .= "<ITEMPFELIST$i>".$f."</ITEMPFELIST$i>\n\n";
                 $1.$2.$3
             }gsex;

    print STDERR "<",$i-10," defs>";
    
    return $in;
}

my $T = "";
for (@ARGV)
{
    if (/^-$/) { $T .= join ("",<STDIN>); }
    elsif (/^-([\w-]+)=(.*)/) { $o{$1} = $2; }
    elsif (/^-([\w-]+)/) { $o{$1} = ""; }
    else {
	my $F = $_; 
	if (open F, "<$F") { $T .= join("",<F>); close F; }
	else { die "could not open $F", $1; }
    }
}

if (length $T)
{
    print c2x_cdefs_list($T);
}

