#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>

#include "nptext.h"

NP_Text::~NP_Text()
{
   if ( text != NULL )
   {
      free( text );
      text = NULL;
   }

   iso8859_1_headers();
   iso8859_1_body();

   if ( server != NULL )
      free( server );

   if ( group != NULL )
      free( group );

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.current_article", home );
   remove( buffer );

   strcat( buffer, "_origin" );
   remove( buffer );

   snprintf( buffer, sizeof buffer, "%s/.nptext:pid", home );
   remove( buffer );

   if ( compose_pid )
      kill( SIGTERM, compose_pid );
   
   if ( input_id >= 0 )
      gdk_input_remove( input_id );

   snprintf( buffer, sizeof buffer, "%s/.nptext:font", home );
   FILE *font_file;
   if (( font_file = fopen( buffer, "w" )) != NULL )
   {
      int i = 1;
      if ( item == first_item )
         i = 0;
      else if ( item == second_item )
         i = 1;
      else if ( item == third_item )
         i = 2;
      else if ( item == fourth_item )
         i = 3;
      else if ( item == fifth_item )
         i = 4;
      else if ( item == sixth_item )
         i = 5;

      fprintf( font_file, "%d\n", i );
      fclose( font_file );
   }

   save_size();

   return;
}
