#include <signal.h>
#include "nptext.h"

extern void *text_p;

void SIGUSR1_handler( int signo )
{
   NP_Text *text = ( NP_Text *)text_p;

   if ( text->reading )
      return;

   text->reading = 1;

   if ( text->server != NULL )
   {
      free( text->server );
      text->server = NULL;
   }

   if ( text->group != NULL )
   {
      free( text->group );
      text->group = NULL;
   }

   if ( text->text != NULL )
   {
      free( text->text );
      text->text = NULL;
   }
   
   text->offset = text->size = -1;

   text->requested = text->header = text->header_shown = -2;

   int len = gtk_text_get_length( GTK_TEXT( text->text_widget ));
   if ( len > 0 ) 
   {
      gtk_text_freeze( GTK_TEXT( text->text_widget ));
      gtk_text_set_point( GTK_TEXT( text->text_widget ), 0 );
      gtk_text_forward_delete( GTK_TEXT( text->text_widget ), len );
      gtk_text_thaw( GTK_TEXT( text->text_widget ));
      gtk_widget_show( text->text_widget );

      gtk_label_set( GTK_LABEL( text->subject_label ), "" );
      gtk_label_set( GTK_LABEL( text->from_label ), "" );
      gtk_label_set( GTK_LABEL( text->date_label ), "" );
   }
   
   text->reading = 0;

   signal( SIGUSR1, SIGUSR1_handler );

   return;
}
