#include <stdlib.h>
#include <stdio.h>

#include "npthreads.h"

void NP_Threads::clear()
{
   np_thread_node_t *pointer = threads, *temp;

   while( pointer != NULL )
   {
      if ( pointer->subject != NULL )
         free( pointer->subject );

      if ( pointer->date != NULL )
         free( pointer->date );

      if ( pointer->from != NULL )
         free( pointer->from );

      if ( pointer->message_id != NULL )
         free( pointer->message_id );

      struct np_ref_node_t *refs = pointer->references, *temp_refs;

      while( refs != NULL )
      {
         if ( refs->reference != NULL )
            free( refs->reference );

         temp_refs = refs;
         refs = refs->next;
         free( temp_refs );
      }

      temp = pointer;
      pointer = pointer->next;
      free( temp );
   }

   if ( server != NULL )
   {
      free( server );
      server = NULL;
   }
   
   if ( group != NULL )
   {
      free( group );
      group = NULL;
   }
   
   threads = NULL;

   total = unseen = headers = requested = 0;

   return;
}

void NP_Threads::assign( np_thread_node_t *node )
{
   threads = node;
   return;
}
