#include "npconfig.h"

void NP_Config::show_message( char *message, int local_stop )
{
   if ( message == NULL )
      return;

   stop = 0;
   message_label = gtk_label_new( message );
   gtk_widget_show( message_label );

   // window
   
   message_window = gtk_window_new( GTK_WINDOW_DIALOG );
   gtk_window_position( GTK_WINDOW( message_window ), GTK_WIN_POS_MOUSE );
   gtk_container_border_width( GTK_CONTAINER( message_window ), 10 );
   gtk_window_set_title( GTK_WINDOW( message_window ), "Message" );

   // vbox

   GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( message_window ), vbox );
   gtk_box_pack_start( GTK_BOX( vbox ), message_label, TRUE, TRUE, 5 );
   
   // separator

   GtkWidget *separator = gtk_hseparator_new();
   gtk_widget_show( separator );
   gtk_box_pack_start( GTK_BOX( vbox ), separator, TRUE, TRUE, 10 );

   // hbox 

   GtkWidget *bbox = gtk_hbutton_box_new();
   gtk_widget_show( bbox );
   gtk_box_pack_start( GTK_BOX( vbox ), bbox, TRUE, TRUE, 0 );

   // button label

   char *button_text;
   if ( local_stop < 0 )
      button_text = "OK";
   else if ( local_stop )
      button_text = "Stop";
   else 
      button_text = "Close Dialog";

   GtkWidget *button_label = gtk_label_new( button_text );
   gtk_widget_show( button_label );
   
   // button

   message_button = gtk_button_new();
   gtk_widget_show( message_button );
   gtk_container_add( GTK_CONTAINER( message_button ), button_label );
   gtk_object_set_data( GTK_OBJECT( message_button ), "stop",
                        ( local_stop ? ( gpointer )1 : ( gpointer ) 0 ));
   GTK_WIDGET_SET_FLAGS( message_button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX( bbox ), message_button, TRUE, TRUE, 0 );
   gtk_widget_grab_default( message_button );
   gtk_signal_connect( GTK_OBJECT( message_button ), "clicked",
                       GTK_SIGNAL_FUNC( message_callback ), this );

   GtkWidget *button = NULL;
   if ( local_stop < 0 )
   {
      button = gtk_button_new_with_label( "Cancel");
      gtk_widget_show( button );
      GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
      gtk_object_set_data( GTK_OBJECT( button ), "stop", 0 );
      gtk_box_pack_start( GTK_BOX( bbox ), button, TRUE, TRUE, 0 );
      gtk_signal_connect( GTK_OBJECT( button ), "clicked",
            GTK_SIGNAL_FUNC( message_callback ), this );
   }

   gtk_grab_add( message_window );
   gtk_widget_show( message_window );

   return;
}
