#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

const char *NP_Subscription::get_article_no( int i, int j )
{
   if ( i < 0 || i >= total )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_article_no(): server index %d out of range.", i );
      return NULL;
   }

   int groups = get_total_groups( i );
   if ( groups <= 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_article_no(): %s",
                group_list[ i ].group_names->get_error() );
      return NULL;
   }

   NP_Stringarray &nos_array = *group_list[ i ].article_nos;
   const char *result = nos_array[ j ];

   if ( result == NULL )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_article_no(): %s",
                group_list[ i ].article_nos->get_error() );
      return NULL;
   }

   return result;
}
