#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "npserver.h"

int NP_Server::getlist( char *name )
{
   char buffer[ 1024 ], temp_path[ 1024 ], path[ 1024 ];
   FILE *list_file;

   snprintf( path, sizeof path, "%s/.peruser_spool/%s-LIST",
             home, name );
   snprintf( temp_path, sizeof temp_path, "%s.tmp", path );
   
   if (( list_file = fopen( temp_path, "w" )) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "get_list_file: could not open file: %s.",
                temp_path );
      return -1;
   }

   np_fputs( "list\r\n" );

   if ( np_fgets( buffer, sizeof buffer ))
   {
      fclose( list_file );
      remove( temp_path );
      return -1;
   }

   if ( strncmp( buffer, "215", 3 ))
   {
      snprintf( error_message, sizeof error_message,
                "get_list_file: server response: %s.", buffer );
      fclose( list_file );
      return -1;
   }

   int count = 0;
   
   for( ; ; )
   {
      if ( np_fgets( buffer, sizeof buffer ))
      {
         fclose( list_file );
         remove( temp_path );
         
         if ( errno == ETIMEDOUT )
            return -1;

         strcpy( error_message,
                 "get_list_file: connected terminated prematurely." );
         return -1;
      }

      if ( buffer[ 0 ] == '.' && buffer[ 1 ] != '.' )
         break;

      if ( !strncmp( buffer, "junk", 4 ) ||
           !strncmp( buffer, "control", 7 ))
         continue;

      ++count;
      
      if ( !( count % 100 ) && busy_callback != NULL )
         if ( busy_callback( busy_callback_data, -1, count ))
            break;
      
      fprintf( list_file, "%s", strtok( buffer, " " ));
      strtok( NULL, " " );
      long x = atol( strtok( NULL, " " ));
      fprintf( list_file, ": %ld\n", x );
   }

   fclose( list_file );

   rename( temp_path, path );
   
   if ( write_timestamp( name ) )
      return -1;

   if ( !count )
      return 2;
   
   return 0;
}
