#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::get_group_stats( char *node, char *group, int *messagesp,
                              int *unseenp, int *requestedp, int *headersp )
{
   if ( node == NULL )
   {
      strcpy( error_message, "NP_Tree: get_group_stats(): NULL node name "
              "passed as argument." );
      return 1;
   }

   if ( group == NULL )
   {
      strcpy( error_message, "NP_Tree: get_group_stats(): NULL group name "
              "passed as argument." );
      return 1;
   }
   
   NP_Node **pointer = nodes;
   int i;
   for( i = 0; i < total_nodes; ++i )
   {
      if ( !strcmp( ( *pointer )->get_name(), node ))
         break;
      ++pointer;
   }

   if ( i == total_nodes )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Tree: get_group_stats(): no such node has"
                " been added to this tree object: %s.", node );
      return 1;
   }

   int messages, unseen, requested, headers;
   if (( *pointer )->get_group_stats( group, &messages, &unseen,
                                         &requested, &headers ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: "
                "get_group_stats(): %s", ( *pointer )->get_error());
      return 1;
   }

   if ( messagesp != NULL )
      *messagesp = messages;

   if ( unseenp != NULL )
      *unseenp = unseen;

   if ( requestedp != NULL )
      *requestedp = requested;

   if ( headersp != NULL )
      *headersp = headers;
   
   return 0;
}
